/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.dsl.scoping;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.franca.deploymodel.dsl.fDeploy.FDSpecification;

@Singleton
public class DeploySpecProvider {
    public static final String DEPLOY_SPEC_PROVIDER_EXTENSION = "org.franca.deploymodel.dsl.deploySpecProvider";
    public static final String DEPLOY_SPEC_PROVIDER_ATTRIB_RESOURCE = "resource";
    public static final String DEPLOY_SPEC_PROVIDER_ATTRIB_ALIAS = "alias";
    public static final String DEPLOY_SPEC_PROVIDER_ATTRIB_FDSPECIFICATION = "FDSpecification";
    protected Map<String, DeploySpecEntry> deploySpecEntries = new HashMap<String, DeploySpecEntry>();
    @Inject
    IQualifiedNameProvider qnProvider;
    IRegistryEventListener registryEventListener = null;

    protected DeploySpecEntry putDeploySpecEntry(String contributorName, String alias, String resource, String fdSpec) {
        return this.deploySpecEntries.put(alias, new DeploySpecEntry(contributorName, alias, resource, fdSpec));
    }

    public Set<String> getAliases() {
        if (this.deploySpecEntries.isEmpty()) {
            this.readDeploySpecEntries();
        }
        return this.deploySpecEntries.keySet();
    }

    public Collection<DeploySpecEntry> getEntries() {
        if (this.deploySpecEntries.isEmpty()) {
            this.readDeploySpecEntries();
        }
        return this.deploySpecEntries.values();
    }

    public DeploySpecEntry getEntry(String alias) {
        if (this.deploySpecEntries.isEmpty()) {
            this.readDeploySpecEntries();
        }
        return this.deploySpecEntries.get(alias);
    }

    public void readDeploySpecEntries() {
        IConfigurationElement[] extensions;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = extensions = extensionRegistry.getConfigurationElementsFor(DEPLOY_SPEC_PROVIDER_EXTENSION);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            this.putDeploySpecEntry(e.getContributor().getName(), e.getAttribute(DEPLOY_SPEC_PROVIDER_ATTRIB_ALIAS), e.getAttribute(DEPLOY_SPEC_PROVIDER_ATTRIB_RESOURCE), e.getAttribute(DEPLOY_SPEC_PROVIDER_ATTRIB_FDSPECIFICATION));
            ++n2;
        }
        if (this.registryEventListener == null) {
            this.registryEventListener = new IRegistryEventListener(){

                public void removed(IExtensionPoint[] eps) {
                    DeploySpecProvider.this.deploySpecEntries.clear();
                }

                public void removed(IExtension[] es) {
                    DeploySpecProvider.this.deploySpecEntries.clear();
                }

                public void added(IExtensionPoint[] eps) {
                    DeploySpecProvider.this.deploySpecEntries.clear();
                }

                public void added(IExtension[] es) {
                    DeploySpecProvider.this.deploySpecEntries.clear();
                }
            };
            extensionRegistry.addListener(this.registryEventListener, DEPLOY_SPEC_PROVIDER_EXTENSION);
        }
    }

    public class DeploySpecEntry {
        public String alias;
        public String resourceId;
        public String fdSpec;
        public String contributorName;
        protected Resource lazyResource;
        protected FDSpecification lazyFDSpec;

        public DeploySpecEntry(String contributorName, String alias, String resourceId, String fdSpec) {
            this.alias = alias;
            this.resourceId = resourceId;
            this.fdSpec = fdSpec;
            this.contributorName = contributorName;
        }

        public String toString() {
            return "DeploySpecEntry[" + this.contributorName + "','" + this.alias + "','" + this.fdSpec + "','" + this.resourceId + "']";
        }

        protected FDSpecification getFDSpecification() {
            Resource resource;
            if (this.lazyFDSpec == null && (resource = this.getResource()) != null) {
                TreeIterator allIt = resource.getAllContents();
                while (allIt.hasNext()) {
                    QualifiedName fqn;
                    EObject eObject = (EObject)allIt.next();
                    if (!(eObject instanceof FDSpecification) || (fqn = DeploySpecProvider.this.qnProvider.getFullyQualifiedName(eObject)) == null || !fqn.toString().equals(this.fdSpec)) continue;
                    this.lazyFDSpec = (FDSpecification)eObject;
                    break;
                }
            }
            return this.lazyFDSpec;
        }

        protected Resource getResource() {
            if (this.lazyResource == null) {
                URI uri = URI.createPlatformPluginURI((String)(String.valueOf(this.contributorName) + "/" + this.resourceId), (boolean)true);
                this.lazyResource = new ResourceSetImpl().getResource(uri, true);
            }
            return this.lazyResource;
        }
    }
}

