/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.dsl.scoping;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.impl.AbstractScope;
import org.eclipse.xtext.scoping.impl.ImportUriGlobalScopeProvider;
import org.franca.core.franca.FModel;
import org.franca.core.franca.FTypeCollection;
import org.franca.deploymodel.dsl.fDeploy.FDModel;
import org.franca.deploymodel.dsl.fDeploy.Import;

public class FTypeCollectionScope
extends AbstractScope {
    private ImportUriGlobalScopeProvider importUriGlobalScopeProvider;
    private Resource resource;
    private IQualifiedNameProvider qualifiedNameProvider;
    private FDModel deploymentModel;
    private Set<URI> imports;

    protected FTypeCollectionScope(IScope parent, boolean ignoreCase, ImportUriGlobalScopeProvider importUriGlobalScopeProvider, Resource resource, IQualifiedNameProvider qualifiedNameProvider) {
        super(parent, ignoreCase);
        this.importUriGlobalScopeProvider = importUriGlobalScopeProvider;
        this.resource = resource;
        this.qualifiedNameProvider = qualifiedNameProvider;
        this.deploymentModel = (FDModel)resource.getContents().get(0);
        this.imports = this.initializeImports();
    }

    protected Iterable<IEObjectDescription> getAllLocalElements() {
        ArrayList<IEObjectDescription> result = new ArrayList<IEObjectDescription>();
        for (IResourceDescription description : this.importUriGlobalScopeProvider.getResourceDescriptions(this.resource, this.imports).getAllResourceDescriptions()) {
            for (IEObjectDescription objDescription : description.getExportedObjects()) {
                EObject obj = objDescription.getEObjectOrProxy();
                if (!(obj instanceof FModel)) continue;
                FModel model = (FModel)this.resolve(obj, this.resource);
                for (FTypeCollection collection : model.getTypeCollections()) {
                    result.add((IEObjectDescription)new EObjectDescription(collection.getName() == null || collection.getName().isEmpty() ? this.qualifiedNameProvider.getFullyQualifiedName((EObject)model) : this.qualifiedNameProvider.getFullyQualifiedName((EObject)collection), (EObject)collection, null));
                }
            }
        }
        return result;
    }

    private EObject resolve(EObject proxy, Resource context) {
        if (proxy.eIsProxy()) {
            return EcoreUtil.resolve((EObject)proxy, (Resource)context);
        }
        return proxy;
    }

    private Set<URI> initializeImports() {
        HashSet<URI> uris = new HashSet<URI>();
        for (Import i : this.deploymentModel.getImports()) {
            uris.add(URI.createURI((String)i.getImportURI()));
        }
        return uris;
    }
}

