/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.dsl.validation;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckMode;
import org.franca.core.FrancaModelExtensions;
import org.franca.core.franca.FArgument;
import org.franca.core.franca.FArrayType;
import org.franca.core.franca.FAttribute;
import org.franca.core.franca.FBroadcast;
import org.franca.core.franca.FEnumerationType;
import org.franca.core.franca.FEnumerator;
import org.franca.core.franca.FField;
import org.franca.core.franca.FInterface;
import org.franca.core.franca.FMapType;
import org.franca.core.franca.FMethod;
import org.franca.core.franca.FStructType;
import org.franca.core.franca.FType;
import org.franca.core.franca.FTypeDef;
import org.franca.core.franca.FUnionType;
import org.franca.deploymodel.core.FDModelUtils;
import org.franca.deploymodel.core.FDPropertyHost;
import org.franca.deploymodel.core.PropertyMappings;
import org.franca.deploymodel.dsl.FDMapper;
import org.franca.deploymodel.dsl.FDSpecificationExtender;
import org.franca.deploymodel.dsl.fDeploy.FDAbstractExtensionElement;
import org.franca.deploymodel.dsl.fDeploy.FDArgument;
import org.franca.deploymodel.dsl.fDeploy.FDArgumentList;
import org.franca.deploymodel.dsl.fDeploy.FDArray;
import org.franca.deploymodel.dsl.fDeploy.FDAttribute;
import org.franca.deploymodel.dsl.fDeploy.FDBoolean;
import org.franca.deploymodel.dsl.fDeploy.FDBroadcast;
import org.franca.deploymodel.dsl.fDeploy.FDBuiltInPropertyHost;
import org.franca.deploymodel.dsl.fDeploy.FDComplexValue;
import org.franca.deploymodel.dsl.fDeploy.FDDeclaration;
import org.franca.deploymodel.dsl.fDeploy.FDElement;
import org.franca.deploymodel.dsl.fDeploy.FDEnumType;
import org.franca.deploymodel.dsl.fDeploy.FDEnumValue;
import org.franca.deploymodel.dsl.fDeploy.FDEnumeration;
import org.franca.deploymodel.dsl.fDeploy.FDEnumerationOverwrites;
import org.franca.deploymodel.dsl.fDeploy.FDExtensionElement;
import org.franca.deploymodel.dsl.fDeploy.FDExtensionRoot;
import org.franca.deploymodel.dsl.fDeploy.FDExtensionType;
import org.franca.deploymodel.dsl.fDeploy.FDField;
import org.franca.deploymodel.dsl.fDeploy.FDInteger;
import org.franca.deploymodel.dsl.fDeploy.FDInterface;
import org.franca.deploymodel.dsl.fDeploy.FDInterfaceRef;
import org.franca.deploymodel.dsl.fDeploy.FDMap;
import org.franca.deploymodel.dsl.fDeploy.FDMapKey;
import org.franca.deploymodel.dsl.fDeploy.FDMapValue;
import org.franca.deploymodel.dsl.fDeploy.FDMethod;
import org.franca.deploymodel.dsl.fDeploy.FDModel;
import org.franca.deploymodel.dsl.fDeploy.FDOverwriteElement;
import org.franca.deploymodel.dsl.fDeploy.FDPlainTypeOverwrites;
import org.franca.deploymodel.dsl.fDeploy.FDProperty;
import org.franca.deploymodel.dsl.fDeploy.FDPropertyDecl;
import org.franca.deploymodel.dsl.fDeploy.FDPropertyFlag;
import org.franca.deploymodel.dsl.fDeploy.FDPropertySet;
import org.franca.deploymodel.dsl.fDeploy.FDRootElement;
import org.franca.deploymodel.dsl.fDeploy.FDSpecification;
import org.franca.deploymodel.dsl.fDeploy.FDString;
import org.franca.deploymodel.dsl.fDeploy.FDStruct;
import org.franca.deploymodel.dsl.fDeploy.FDStructOverwrites;
import org.franca.deploymodel.dsl.fDeploy.FDType;
import org.franca.deploymodel.dsl.fDeploy.FDTypeOverwrites;
import org.franca.deploymodel.dsl.fDeploy.FDTypeRef;
import org.franca.deploymodel.dsl.fDeploy.FDTypedef;
import org.franca.deploymodel.dsl.fDeploy.FDTypes;
import org.franca.deploymodel.dsl.fDeploy.FDUnion;
import org.franca.deploymodel.dsl.fDeploy.FDUnionOverwrites;
import org.franca.deploymodel.dsl.fDeploy.FDValue;
import org.franca.deploymodel.dsl.fDeploy.FDValueArray;
import org.franca.deploymodel.dsl.fDeploy.FDeployPackage;
import org.franca.deploymodel.dsl.validation.AbstractFDeployValidator;
import org.franca.deploymodel.dsl.validation.FDeployValidatorAux;
import org.franca.deploymodel.dsl.validation.FrancaQuickFixConstants;
import org.franca.deploymodel.dsl.validation.IFDeployExternalValidator;
import org.franca.deploymodel.dsl.validation.PropertyDefChecker;
import org.franca.deploymodel.dsl.validation.ValidationHelpers;
import org.franca.deploymodel.dsl.validation.ValidationMessageReporter;
import org.franca.deploymodel.dsl.validation.internal.ValidatorRegistry;
import org.franca.deploymodel.extensions.ExtensionRegistry;
import org.franca.deploymodel.extensions.IFDeployExtension;

public class FDeployValidator
extends AbstractFDeployValidator
implements ValidationMessageReporter {
    public static final String UPPERCASE_PROPERTYNAME_QUICKFIX = "UPPERCASE_PROPERTYNAME_QUICKFIX";
    public static final String METHOD_ARGUMENT_QUICKFIX = "METHOD_ARGUMENT_QUICKFIX";
    public static final String METHOD_ARGUMENT_QUICKFIX_MESSAGE = "Method argument is missing for method ";
    public static final String BROADCAST_ARGUMENT_QUICKFIX = "BROADCAST_ARGUMENT_QUICKFIX";
    public static final String BROADCAST_ARGUMENT_QUICKFIX_MESSAGE = "Broadcast argument is missing for broadcast ";
    public static final String COMPOUND_FIELD_QUICKFIX = "COMPOUND_FIELD_QUICKFIX";
    public static final String COMPOUND_FIELD_QUICKFIX_MESSAGE = "Field is missing for compound ";
    public static final String ENUMERATOR_ENUM_QUICKFIX = "ENUMERATOR_ENUM_QUICKFIX";
    public static final String ENUMERATOR_ENUM_QUICKFIX_MESSAGE = "Enumerator element is missing for enum ";
    public static final String MAP_KEY_QUICKFIX = "MAP_KEY_QUICKFIX";
    public static final String MAP_KEY_QUICKFIX_MESSAGE = "Map key section is missing for map ";
    public static final String MAP_VALUE_QUICKFIX = "MAP_VALUE_QUICKFIX";
    public static final String MAP_VALUE_QUICKFIX_MESSAGE = "Map value section is missing for map ";
    public static final String MANDATORY_PROPERTY_QUICKFIX = "MANDATORY_PROPERTIES_QUICKFIX";
    public static final String MANDATORY_PROPERTY_QUICKFIX_MESSAGE = "Mandatory properties are missing for element ";
    public static final String DEPLOYMENT_ELEMENT_QUICKFIX = "DEPLOYMENT_ELEMENT_QUICKFIX";
    public static final String DEPLOYMENT_ELEMENT_QUICKFIX_MESSAGE = "Missing specification element ";
    public static final String DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX = "DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX";
    public static final String DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX_MESSAGE = "There are multiple issues with element ";
    FDeployValidatorAux deployValidator = new FDeployValidatorAux(this);

    @Check
    public void checkExtensionValidators(FDModel model) {
        CheckMode mode = this.getCheckMode();
        Collection _get = ValidatorRegistry.getValidatorMap().get((Object)mode);
        for (IFDeployExternalValidator validator : _get) {
            validator.validateModel(model, this.getMessageAcceptor());
        }
    }

    @Check
    public void checkSpecNamesUnique(FDModel model) {
        ValidationHelpers.checkDuplicates((ValidationMessageReporter)this, model.getSpecifications(), (EStructuralFeature)FDeployPackage.Literals.FD_SPECIFICATION__NAME, "specification name");
    }

    @Check
    public void checkPropertyHosts(FDDeclaration decl) {
        boolean _tripleEquals;
        FDPropertyHost host = decl.getHost();
        FDBuiltInPropertyHost _builtIn = host.getBuiltIn();
        boolean bl = _tripleEquals = _builtIn == null;
        if (_tripleEquals) {
            boolean _tripleEquals_1;
            IFDeployExtension.Host _findHost = ExtensionRegistry.findHost(host.getName());
            boolean bl2 = _tripleEquals_1 = _findHost == null;
            if (_tripleEquals_1) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Invalid property host '");
                String _name = host.getName();
                _builder.append(_name);
                _builder.append("'");
                this.error(_builder.toString(), decl, (EStructuralFeature)FDeployPackage.Literals.FD_DECLARATION__HOST, -1);
            }
        }
    }

    @Check
    public void checkExtensionRootAvailable(FDExtensionRoot root) {
        String tag = root.getTag();
        IFDeployExtension.RootDef rootDef = ExtensionRegistry.findRoot(tag);
        if (rootDef == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Invalid root '");
            _builder.append(tag);
            _builder.append("', no matching deployment extension has been configured");
            this.error(_builder.toString(), root, (EStructuralFeature)FDeployPackage.Literals.FD_ABSTRACT_EXTENSION_ELEMENT__TAG, -1);
        } else {
            if (root.getName() != null && !rootDef.mayHaveName()) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Root '");
                _builder_1.append(tag);
                _builder_1.append("' must not have a name");
                this.error(_builder_1.toString(), root, (EStructuralFeature)FDeployPackage.Literals.FD_ROOT_ELEMENT__NAME, -1);
            }
            if (rootDef.mustHaveName() && root.getName() == null) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("Root '");
                _builder_2.append(tag);
                _builder_2.append("' must have a name");
                this.error(_builder_2.toString(), root, (EStructuralFeature)FDeployPackage.Literals.FD_ABSTRACT_EXTENSION_ELEMENT__TAG, -1);
            }
        }
    }

    @Check
    public void checkExtensionElementHierarchy(FDExtensionElement elem) {
        boolean _not;
        String tag = elem.getTag();
        EObject _eContainer = elem.eContainer();
        FDAbstractExtensionElement parent = (FDAbstractExtensionElement)_eContainer;
        IFDeployExtension.AbstractElementDef parentDef = ExtensionRegistry.getElement(parent);
        boolean _hasChild = this.hasChild(parentDef, tag);
        boolean bl = _not = !_hasChild;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Invalid element tag '");
            _builder.append(tag);
            _builder.append("' for parent '");
            String _tag = parentDef.getTag();
            _builder.append(_tag);
            _builder.append("'");
            this.error(_builder.toString(), elem, (EStructuralFeature)FDeployPackage.Literals.FD_ABSTRACT_EXTENSION_ELEMENT__TAG, -1);
            return;
        }
        IFDeployExtension.AbstractElementDef elemDef = ExtensionRegistry.getElement(elem);
        if (elem.getName() != null && !elemDef.mayHaveName()) {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Element '");
            _builder_1.append(tag);
            _builder_1.append("' must not have a name");
            this.error(_builder_1.toString(), elem, (EStructuralFeature)FDeployPackage.Literals.FD_EXTENSION_ELEMENT__NAME, -1);
        }
        if (elemDef.mustHaveName() && elem.getName() == null) {
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("Element '");
            _builder_2.append(tag);
            _builder_2.append("' must have a name");
            this.error(_builder_2.toString(), elem, (EStructuralFeature)FDeployPackage.Literals.FD_ABSTRACT_EXTENSION_ELEMENT__TAG, -1);
        }
    }

    private boolean hasChild(IFDeployExtension.AbstractElementDef elemDef, String tag) {
        Collection<IFDeployExtension.ElementDef> _children = elemDef.getChildren();
        for (IFDeployExtension.AbstractElementDef abstractElementDef : _children) {
            boolean _equals = abstractElementDef.getTag().equals(tag);
            if (!_equals) continue;
            return true;
        }
        return false;
    }

    @Check
    public void checkRootElementNamesUnique(FDModel model) {
        ValidationHelpers.checkDuplicates((ValidationMessageReporter)this, model.getDeployments(), (EStructuralFeature)FDeployPackage.Literals.FD_ROOT_ELEMENT__NAME, "definition name");
    }

    @Check
    public void checkRootElement(FDRootElement elem) {
        this.deployValidator.checkRootElement(elem);
    }

    @Check
    public void checkMethodArgs(FDMethod method) {
        FDArgumentList _outArguments;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        FDArgumentList _inArguments = method.getInArguments();
        boolean bl = _tripleNotEquals = _inArguments != null;
        if (_tripleNotEquals) {
            EList<FDArgument> _arguments = method.getInArguments().getArguments();
            for (FDArgument arg : _arguments) {
                boolean _not;
                boolean _contains = method.getTarget().getInArgs().contains((Object)arg.getTarget());
                boolean bl2 = _not = !_contains;
                if (!_not) continue;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Invalid input argument '");
                String _name = arg.getTarget().getName();
                _builder.append(_name);
                _builder.append("'");
                this.error(_builder.toString(), arg, (EStructuralFeature)FDeployPackage.Literals.FD_ARGUMENT__TARGET, -1);
            }
        }
        boolean bl3 = _tripleNotEquals_1 = (_outArguments = method.getOutArguments()) != null;
        if (_tripleNotEquals_1) {
            EList<FDArgument> _arguments_1 = method.getOutArguments().getArguments();
            for (FDArgument arg_1 : _arguments_1) {
                boolean _not_1;
                boolean _contains_1 = method.getTarget().getOutArgs().contains((Object)arg_1.getTarget());
                boolean bl4 = _not_1 = !_contains_1;
                if (!_not_1) continue;
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("Invalid output argument '");
                String _name_1 = arg_1.getTarget().getName();
                _builder_1.append(_name_1);
                _builder_1.append("'");
                this.error(_builder_1.toString(), arg_1, (EStructuralFeature)FDeployPackage.Literals.FD_ARGUMENT__TARGET, -1);
            }
        }
    }

    @Check
    public void checkBroadcastArgs(FDBroadcast broadcast) {
        boolean _tripleNotEquals;
        FDArgumentList _outArguments = broadcast.getOutArguments();
        boolean bl = _tripleNotEquals = _outArguments != null;
        if (_tripleNotEquals) {
            EList<FDArgument> _arguments = broadcast.getOutArguments().getArguments();
            for (FDArgument arg : _arguments) {
                boolean _not;
                boolean _contains = broadcast.getTarget().getOutArgs().contains((Object)arg.getTarget());
                boolean bl2 = _not = !_contains;
                if (!_not) continue;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Invalid output argument '");
                String _name = arg.getTarget().getName();
                _builder.append(_name);
                _builder.append("'");
                this.error(_builder.toString(), arg, (EStructuralFeature)FDeployPackage.Literals.FD_ARGUMENT__TARGET, -1);
            }
        }
    }

    @Check
    public void checkDuplicateProperties(FDPropertySet properties) {
        ValidationHelpers.NameList names = ValidationHelpers.createNameList();
        EList<FDProperty> _items = properties.getItems();
        for (FDProperty p : _items) {
            boolean _eIsProxy = p.getDecl().eIsProxy();
            if (_eIsProxy) continue;
            names.add(p, p.getDecl().getName());
        }
        ValidationHelpers.checkDuplicates((ValidationMessageReporter)this, names, (EStructuralFeature)FDeployPackage.Literals.FD_PROPERTY__DECL, "property");
    }

    @Check
    public void checkPropertyName(FDPropertyDecl prop) {
        boolean _not;
        boolean _isUpperCase = Character.isUpperCase(prop.getName().charAt(0));
        boolean bl = _not = !_isUpperCase;
        if (_not) {
            this.error("Property names must begin with an uppercase character", (EStructuralFeature)FDeployPackage.Literals.FD_PROPERTY_DECL__NAME, UPPERCASE_PROPERTYNAME_QUICKFIX, new String[]{prop.getName()});
        }
    }

    @Check
    public void checkClashingProperties(FDSpecification spec) {
        this.deployValidator.checkClashingProperties(spec);
    }

    @Check
    public void checkBaseSpec(FDSpecification spec) {
        FDSpecification cycleSpec = this.deployValidator.getCyclicBaseSpec(spec);
        if (cycleSpec != null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Inheritance cycle for specification ");
            String _name = cycleSpec.getName();
            _builder.append(_name);
            this.error(_builder.toString(), cycleSpec, (EStructuralFeature)FDeployPackage.Literals.FD_SPECIFICATION__BASE, -1);
            return;
        }
    }

    @Check
    public void checkPropertiesComplete(FDExtensionRoot elem) {
        FDSpecification spec = FDModelUtils.getRootElement(elem).getSpec();
        this.checkSpecificationElementProperties(spec, elem, (EStructuralFeature)FDeployPackage.Literals.FD_ROOT_ELEMENT__NAME, spec.getName());
        EList _elements = elem.getElements();
        for (FDExtensionElement child : _elements) {
            this.checkExtensionElementProperties(spec, child);
        }
    }

    private void checkExtensionElementProperties(FDSpecification spec, FDExtensionElement elem) {
        this.checkSpecificationElementProperties(spec, elem, (EStructuralFeature)FDeployPackage.Literals.FD_ABSTRACT_EXTENSION_ELEMENT__TAG, spec.getName());
        EList _elements = elem.getElements();
        for (FDExtensionElement child : _elements) {
            this.checkExtensionElementProperties(spec, child);
        }
    }

    @Check
    public void checkPropertiesComplete(FDTypes elem) {
        FDSpecification spec = FDModelUtils.getRootElement(elem).getSpec();
        this.checkSpecificationElementProperties(spec, elem, (EStructuralFeature)FDeployPackage.Literals.FD_TYPES__TARGET, spec.getName());
        FDSpecificationExtender specHelper = new FDSpecificationExtender(spec);
        PropertyDefChecker checker = new PropertyDefChecker(specHelper);
        FDMapper mapper = new FDMapper(elem);
        EList targetTypes = elem.getTarget().getTypes();
        this.checkLocalTypes((List<FType>)targetTypes, specHelper, checker, mapper, spec, (EStructuralFeature)FDeployPackage.Literals.FD_TYPES__TARGET);
        this.deployValidator.checkUsedTypes(elem, (List<FType>)targetTypes, checker);
    }

    @Check
    public void checkPropertiesComplete(FDInterface elem) {
        boolean _checkUsedTypes;
        StringConcatenation _builder_2;
        int lowerLevelErrors = 0;
        FDSpecification spec = FDModelUtils.getRootElement(elem).getSpec();
        boolean _checkSpecificationElementProperties = this.checkSpecificationElementProperties(spec, elem, (EStructuralFeature)FDeployPackage.Literals.FD_INTERFACE__TARGET, spec.getName());
        if (_checkSpecificationElementProperties) {
            ++lowerLevelErrors;
        }
        FDSpecificationExtender specHelper = new FDSpecificationExtender(spec);
        PropertyDefChecker checker = new PropertyDefChecker(specHelper);
        FDMapper mapper = new FDMapper(elem);
        FInterface target = elem.getTarget();
        EList _attributes = target.getAttributes();
        for (FAttribute tc : _attributes) {
            FDElement _fDElement = mapper.getFDElement((EObject)tc);
            FDAttribute c = (FDAttribute)_fDElement;
            if (c == null) {
                boolean _mustBeDefined = checker.mustBeDefined(tc);
                if (!_mustBeDefined) continue;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(DEPLOYMENT_ELEMENT_QUICKFIX_MESSAGE);
                _builder.append("'");
                String _name = tc.getName();
                _builder.append(_name);
                _builder.append("'");
                this.error(_builder.toString(), (EStructuralFeature)FDeployPackage.Literals.FD_INTERFACE__TARGET, DEPLOYMENT_ELEMENT_QUICKFIX, new String[]{tc.getName(), FrancaQuickFixConstants.ATTRIBUTE.toString()});
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append(DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX_MESSAGE);
                _builder_1.append("'");
                String _name_1 = tc.getName();
                _builder_1.append(_name_1);
                _builder_1.append("'");
                this.error(_builder_1.toString(), (EStructuralFeature)FDeployPackage.Literals.FD_INTERFACE__TARGET, DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX, new String[]{tc.getName(), FrancaQuickFixConstants.ATTRIBUTE.toString()});
                ++lowerLevelErrors;
                continue;
            }
            boolean _checkSpecificationElementProperties_1 = this.checkSpecificationElementProperties(spec, c, (EStructuralFeature)FDeployPackage.Literals.FD_ATTRIBUTE__TARGET, tc.getName());
            if (!_checkSpecificationElementProperties_1) continue;
            ++lowerLevelErrors;
        }
        EList _methods = target.getMethods();
        for (FMethod tc_1 : _methods) {
            FDElement _fDElement = mapper.getFDElement((EObject)tc_1);
            FDMethod c = (FDMethod)_fDElement;
            if (c == null) {
                boolean _mustBeDefined = checker.mustBeDefined(tc_1);
                if (!_mustBeDefined) continue;
                String name = FrancaModelExtensions.getUniqueName((FMethod)tc_1);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(DEPLOYMENT_ELEMENT_QUICKFIX_MESSAGE);
                _builder.append("'");
                _builder.append(name);
                _builder.append("'");
                this.error(_builder.toString(), (EStructuralFeature)FDeployPackage.Literals.FD_INTERFACE__TARGET, DEPLOYMENT_ELEMENT_QUICKFIX, new String[]{name, FrancaQuickFixConstants.METHOD.toString()});
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append(DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX_MESSAGE);
                _builder_1.append("'");
                _builder_1.append(name);
                _builder_1.append("'");
                this.error(_builder_1.toString(), (EStructuralFeature)FDeployPackage.Literals.FD_INTERFACE__TARGET, DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX, new String[]{name, FrancaQuickFixConstants.METHOD.toString()});
                ++lowerLevelErrors;
                continue;
            }
            String name_1 = FrancaModelExtensions.getUniqueName((FMethod)tc_1);
            boolean _checkSpecificationElementProperties_1 = this.checkSpecificationElementProperties(spec, c, (EStructuralFeature)FDeployPackage.Literals.FD_METHOD__TARGET, name_1);
            if (_checkSpecificationElementProperties_1) {
                ++lowerLevelErrors;
            }
            boolean checkIn = this.checkArgumentList(specHelper, checker, mapper, spec, (List<FArgument>)tc_1.getInArgs(), c, "Input", (EStructuralFeature)FDeployPackage.Literals.FD_METHOD__TARGET);
            boolean checkOut = this.checkArgumentList(specHelper, checker, mapper, spec, (List<FArgument>)tc_1.getOutArgs(), c, "Output", (EStructuralFeature)FDeployPackage.Literals.FD_METHOD__TARGET);
            if (!checkIn && !checkOut) continue;
            _builder_2 = new StringConcatenation();
            _builder_2.append(DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX_MESSAGE);
            _builder_2.append("'");
            _builder_2.append(name_1);
            _builder_2.append("'");
            this.error(_builder_2.toString(), c, (EStructuralFeature)FDeployPackage.Literals.FD_METHOD__TARGET, DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX, new String[]{name_1, FrancaQuickFixConstants.METHOD.toString()});
            ++lowerLevelErrors;
        }
        EList _broadcasts = target.getBroadcasts();
        for (FBroadcast tc_2 : _broadcasts) {
            boolean _checkArgumentList;
            FDElement _fDElement = mapper.getFDElement((EObject)tc_2);
            FDBroadcast c = (FDBroadcast)_fDElement;
            if (c == null) {
                boolean _mustBeDefined = checker.mustBeDefined(tc_2);
                if (!_mustBeDefined) continue;
                String name = FrancaModelExtensions.getUniqueName((FBroadcast)tc_2);
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(DEPLOYMENT_ELEMENT_QUICKFIX_MESSAGE);
                _builder.append("'");
                _builder.append(name);
                _builder.append("'");
                this.error(_builder.toString(), (EStructuralFeature)FDeployPackage.Literals.FD_INTERFACE__TARGET, DEPLOYMENT_ELEMENT_QUICKFIX, new String[]{name, FrancaQuickFixConstants.BROADCAST.toString()});
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append(DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX_MESSAGE);
                _builder_1.append("'");
                _builder_1.append(name);
                _builder_1.append("'");
                this.error(_builder_1.toString(), (EStructuralFeature)FDeployPackage.Literals.FD_INTERFACE__TARGET, DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX, new String[]{name, FrancaQuickFixConstants.BROADCAST.toString()});
                ++lowerLevelErrors;
                continue;
            }
            String name_1 = FrancaModelExtensions.getUniqueName((FBroadcast)tc_2);
            boolean _checkSpecificationElementProperties_1 = this.checkSpecificationElementProperties(spec, c, (EStructuralFeature)FDeployPackage.Literals.FD_BROADCAST__TARGET, name_1);
            if (_checkSpecificationElementProperties_1) {
                ++lowerLevelErrors;
            }
            if (!(_checkArgumentList = this.checkArgumentList(specHelper, checker, mapper, spec, (List<FArgument>)tc_2.getOutArgs(), c, "Output", (EStructuralFeature)FDeployPackage.Literals.FD_BROADCAST__TARGET))) continue;
            _builder_2 = new StringConcatenation();
            _builder_2.append(DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX_MESSAGE);
            _builder_2.append("'");
            _builder_2.append(name_1);
            _builder_2.append("'");
            this.error(_builder_2.toString(), c, (EStructuralFeature)FDeployPackage.Literals.FD_BROADCAST__TARGET, DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX, new String[]{name_1, FrancaQuickFixConstants.BROADCAST.toString()});
            ++lowerLevelErrors;
        }
        boolean _checkLocalTypes = this.checkLocalTypes((List<FType>)target.getTypes(), specHelper, checker, mapper, spec, (EStructuralFeature)FDeployPackage.Literals.FD_INTERFACE__TARGET);
        if (_checkLocalTypes) {
            ++lowerLevelErrors;
        }
        if (_checkUsedTypes = this.deployValidator.checkUsedTypes(elem, (List<FType>)target.getTypes(), checker)) {
            ++lowerLevelErrors;
        }
        if (lowerLevelErrors > 0) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX_MESSAGE);
            _builder.append("'");
            String _name = spec.getName();
            _builder.append(_name);
            _builder.append("'");
            this.error(_builder.toString(), elem, (EStructuralFeature)FDeployPackage.Literals.FD_INTERFACE__TARGET, DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX, new String[]{spec.getName(), FrancaQuickFixConstants.INTERFACE.toString()});
        }
    }

    private boolean checkLocalTypes(List<FType> types, FDSpecificationExtender specHelper, PropertyDefChecker checker, FDMapper mapper, FDSpecification spec, EStructuralFeature parentFeature) {
        boolean hasError = false;
        for (FType tc : types) {
            if (tc instanceof FArrayType) {
                FDElement _fDElement = mapper.getFDElement((EObject)tc);
                FDArray c = (FDArray)_fDElement;
                if (c == null) {
                    boolean _mustBeDefined = checker.mustBeDefined((FArrayType)tc);
                    if (!_mustBeDefined) continue;
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append(DEPLOYMENT_ELEMENT_QUICKFIX_MESSAGE);
                    _builder.append("'");
                    String _name = ((FArrayType)tc).getName();
                    _builder.append(_name);
                    _builder.append("'");
                    this.error(_builder.toString(), parentFeature, DEPLOYMENT_ELEMENT_QUICKFIX, new String[]{((FArrayType)tc).getName(), FrancaQuickFixConstants.ARRAY.toString()});
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append(DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX_MESSAGE);
                    _builder_1.append("'");
                    String _name_1 = ((FArrayType)tc).getName();
                    _builder_1.append(_name_1);
                    _builder_1.append("'");
                    this.error(_builder_1.toString(), parentFeature, DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX, new String[]{((FArrayType)tc).getName(), FrancaQuickFixConstants.ARRAY.toString()});
                    hasError = true;
                    continue;
                }
                boolean _checkSpecificationElementProperties = this.checkSpecificationElementProperties(spec, c, (EStructuralFeature)FDeployPackage.Literals.FD_ARRAY__TARGET, ((FArrayType)tc).getName());
                if (!_checkSpecificationElementProperties) continue;
                hasError = true;
                continue;
            }
            if (tc instanceof FStructType) {
                boolean _checkFieldsList;
                FDElement _fDElement_1 = mapper.getFDElement((EObject)tc);
                FDStruct c_1 = (FDStruct)_fDElement_1;
                if (c_1 == null) {
                    boolean _mustBeDefined_1 = checker.mustBeDefined((FStructType)tc);
                    if (!_mustBeDefined_1) continue;
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append(DEPLOYMENT_ELEMENT_QUICKFIX_MESSAGE);
                    _builder_2.append("'");
                    String _name_2 = ((FStructType)tc).getName();
                    _builder_2.append(_name_2);
                    _builder_2.append("'");
                    this.error(_builder_2.toString(), parentFeature, DEPLOYMENT_ELEMENT_QUICKFIX, new String[]{((FStructType)tc).getName(), FrancaQuickFixConstants.STRUCT.toString()});
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append(DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX_MESSAGE);
                    _builder_3.append("'");
                    String _name_3 = ((FStructType)tc).getName();
                    _builder_3.append(_name_3);
                    _builder_3.append("'");
                    this.error(_builder_3.toString(), parentFeature, DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX, new String[]{((FStructType)tc).getName(), FrancaQuickFixConstants.STRUCT.toString()});
                    hasError = true;
                    continue;
                }
                boolean _checkSpecificationElementProperties_1 = this.checkSpecificationElementProperties(spec, c_1, (EStructuralFeature)FDeployPackage.Literals.FD_STRUCT__TARGET, ((FStructType)tc).getName());
                if (_checkSpecificationElementProperties_1) {
                    hasError = true;
                }
                if (!(_checkFieldsList = this.checkFieldsList(specHelper, checker, mapper, spec, (List<FField>)((FStructType)tc).getElements(), c_1, (EStructuralFeature)FDeployPackage.Literals.FD_STRUCT__TARGET, "Struct"))) continue;
                StringConcatenation _builder_4 = new StringConcatenation();
                _builder_4.append(DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX_MESSAGE);
                _builder_4.append("'");
                String _name_4 = ((FStructType)tc).getName();
                _builder_4.append(_name_4);
                _builder_4.append("'");
                this.error(_builder_4.toString(), c_1, (EStructuralFeature)FDeployPackage.Literals.FD_STRUCT__TARGET, DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX, new String[]{((FStructType)tc).getName(), FrancaQuickFixConstants.STRUCT.toString()});
                hasError = true;
                continue;
            }
            if (tc instanceof FUnionType) {
                boolean _checkFieldsList_1;
                FDElement _fDElement_2 = mapper.getFDElement((EObject)tc);
                FDUnion c_2 = (FDUnion)_fDElement_2;
                if (c_2 == null) {
                    boolean _mustBeDefined_2 = checker.mustBeDefined((FUnionType)tc);
                    if (!_mustBeDefined_2) continue;
                    StringConcatenation _builder_5 = new StringConcatenation();
                    _builder_5.append(DEPLOYMENT_ELEMENT_QUICKFIX_MESSAGE);
                    _builder_5.append("'");
                    String _name_5 = ((FUnionType)tc).getName();
                    _builder_5.append(_name_5);
                    _builder_5.append("'");
                    this.error(_builder_5.toString(), parentFeature, DEPLOYMENT_ELEMENT_QUICKFIX, new String[]{((FUnionType)tc).getName(), FrancaQuickFixConstants.UNION.toString()});
                    StringConcatenation _builder_6 = new StringConcatenation();
                    _builder_6.append(DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX_MESSAGE);
                    _builder_6.append("'");
                    String _name_6 = ((FUnionType)tc).getName();
                    _builder_6.append(_name_6);
                    _builder_6.append("'");
                    this.error(_builder_6.toString(), parentFeature, DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX, new String[]{((FUnionType)tc).getName(), FrancaQuickFixConstants.UNION.toString()});
                    hasError = true;
                    continue;
                }
                boolean _checkSpecificationElementProperties_2 = this.checkSpecificationElementProperties(spec, c_2, (EStructuralFeature)FDeployPackage.Literals.FD_UNION__TARGET, ((FUnionType)tc).getName());
                if (_checkSpecificationElementProperties_2) {
                    hasError = true;
                }
                if (!(_checkFieldsList_1 = this.checkFieldsList(specHelper, checker, mapper, spec, (List<FField>)((FUnionType)tc).getElements(), c_2, (EStructuralFeature)FDeployPackage.Literals.FD_UNION__TARGET, "Union"))) continue;
                StringConcatenation _builder_7 = new StringConcatenation();
                _builder_7.append(DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX_MESSAGE);
                _builder_7.append("'");
                String _name_7 = ((FUnionType)tc).getName();
                _builder_7.append(_name_7);
                _builder_7.append("'");
                this.error(_builder_7.toString(), c_2, (EStructuralFeature)FDeployPackage.Literals.FD_UNION__TARGET, DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX, new String[]{((FUnionType)tc).getName(), FrancaQuickFixConstants.UNION.toString()});
                hasError = true;
                continue;
            }
            if (tc instanceof FEnumerationType) {
                boolean _checkEnumeratorsList;
                FDElement _fDElement_3 = mapper.getFDElement((EObject)tc);
                FDEnumeration c_3 = (FDEnumeration)_fDElement_3;
                if (c_3 == null) {
                    boolean _mustBeDefined_3 = checker.mustBeDefined((FEnumerationType)tc);
                    if (!_mustBeDefined_3) continue;
                    StringConcatenation _builder_8 = new StringConcatenation();
                    _builder_8.append(DEPLOYMENT_ELEMENT_QUICKFIX_MESSAGE);
                    _builder_8.append("'");
                    String _name_8 = ((FEnumerationType)tc).getName();
                    _builder_8.append(_name_8);
                    _builder_8.append("'");
                    this.error(_builder_8.toString(), parentFeature, DEPLOYMENT_ELEMENT_QUICKFIX, new String[]{((FEnumerationType)tc).getName(), FrancaQuickFixConstants.ENUMERATION.toString()});
                    StringConcatenation _builder_9 = new StringConcatenation();
                    _builder_9.append(DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX_MESSAGE);
                    _builder_9.append("'");
                    String _name_9 = ((FEnumerationType)tc).getName();
                    _builder_9.append(_name_9);
                    _builder_9.append("'");
                    this.error(_builder_9.toString(), parentFeature, DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX, new String[]{((FEnumerationType)tc).getName(), FrancaQuickFixConstants.ENUMERATION.toString()});
                    hasError = true;
                    continue;
                }
                boolean _checkSpecificationElementProperties_3 = this.checkSpecificationElementProperties(spec, c_3, (EStructuralFeature)FDeployPackage.Literals.FD_ENUMERATION__TARGET, ((FEnumerationType)tc).getName());
                if (_checkSpecificationElementProperties_3) {
                    hasError = true;
                }
                if (!(_checkEnumeratorsList = this.checkEnumeratorsList(specHelper, mapper, spec, (List<FEnumerator>)((FEnumerationType)tc).getEnumerators(), c_3, (EStructuralFeature)FDeployPackage.Literals.FD_ENUMERATION__TARGET))) continue;
                StringConcatenation _builder_10 = new StringConcatenation();
                _builder_10.append(DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX_MESSAGE);
                _builder_10.append("'");
                String _name_10 = ((FEnumerationType)tc).getName();
                _builder_10.append(_name_10);
                _builder_10.append("'");
                this.error(_builder_10.toString(), c_3, (EStructuralFeature)FDeployPackage.Literals.FD_ENUMERATION__TARGET, DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX, new String[]{((FEnumerationType)tc).getName(), FrancaQuickFixConstants.ENUMERATION.toString()});
                hasError = true;
                continue;
            }
            if (tc instanceof FMapType) {
                boolean _mustBeDefined_6;
                FDElement _fDElement_4 = mapper.getFDElement((EObject)tc);
                FDMap c_4 = (FDMap)_fDElement_4;
                if (c_4 == null) {
                    boolean _mustBeDefined_4 = checker.mustBeDefined((FMapType)tc);
                    if (!_mustBeDefined_4) continue;
                    StringConcatenation _builder_11 = new StringConcatenation();
                    _builder_11.append(DEPLOYMENT_ELEMENT_QUICKFIX_MESSAGE);
                    _builder_11.append("'");
                    String _name_11 = ((FMapType)tc).getName();
                    _builder_11.append(_name_11);
                    _builder_11.append("'");
                    this.error(_builder_11.toString(), parentFeature, DEPLOYMENT_ELEMENT_QUICKFIX, new String[]{((FMapType)tc).getName(), FrancaQuickFixConstants.MAP.toString()});
                    StringConcatenation _builder_12 = new StringConcatenation();
                    _builder_12.append(DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX_MESSAGE);
                    _builder_12.append("'");
                    String _name_12 = ((FMapType)tc).getName();
                    _builder_12.append(_name_12);
                    _builder_12.append("'");
                    this.error(_builder_12.toString(), parentFeature, DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX, new String[]{((FMapType)tc).getName(), FrancaQuickFixConstants.MAP.toString()});
                    hasError = true;
                    continue;
                }
                boolean _checkSpecificationElementProperties_4 = this.checkSpecificationElementProperties(spec, c_4, (EStructuralFeature)FDeployPackage.Literals.FD_MAP__TARGET, ((FMapType)tc).getName());
                if (_checkSpecificationElementProperties_4) {
                    hasError = true;
                }
                boolean contentError = false;
                boolean _mustBeDefined_5 = checker.mustBeDefined(((FMapType)tc).getKeyType());
                if (_mustBeDefined_5) {
                    boolean _tripleEquals;
                    FDMapKey _key = c_4.getKey();
                    boolean bl = _tripleEquals = _key == null;
                    if (_tripleEquals) {
                        StringConcatenation _builder_13 = new StringConcatenation();
                        _builder_13.append(MAP_KEY_QUICKFIX_MESSAGE);
                        _builder_13.append("'");
                        String _name_13 = ((FMapType)tc).getName();
                        _builder_13.append(_name_13);
                        _builder_13.append("'");
                        this.error(_builder_13.toString(), c_4, (EStructuralFeature)FDeployPackage.Literals.FD_MAP__TARGET, MAP_KEY_QUICKFIX, new String[]{((FMapType)tc).getName(), FrancaQuickFixConstants.MAP_KEY.toString()});
                        contentError = true;
                    } else {
                        boolean _not;
                        List<String> missing = this.collectMissingProperties(spec, c_4.getKey());
                        boolean _isEmpty = missing.isEmpty();
                        boolean bl2 = _not = !_isEmpty;
                        if (_not) {
                            StringConcatenation _builder_14 = new StringConcatenation();
                            _builder_14.append(MANDATORY_PROPERTY_QUICKFIX_MESSAGE);
                            _builder_14.append("'");
                            String _name_14 = ((FMapType)tc).getName();
                            _builder_14.append(_name_14);
                            _builder_14.append(" key type'");
                            this.error(_builder_14.toString(), c_4, (EStructuralFeature)FDeployPackage.Literals.FD_MAP__KEY, -1, MANDATORY_PROPERTY_QUICKFIX, new String[]{((FMapType)tc).getName(), FrancaQuickFixConstants.MAP_KEY.toString()});
                            hasError = true;
                        }
                    }
                }
                if (_mustBeDefined_6 = checker.mustBeDefined(((FMapType)tc).getValueType())) {
                    boolean _tripleEquals_1;
                    FDMapValue _value = c_4.getValue();
                    boolean bl = _tripleEquals_1 = _value == null;
                    if (_tripleEquals_1) {
                        StringConcatenation _builder_15 = new StringConcatenation();
                        _builder_15.append(MAP_VALUE_QUICKFIX_MESSAGE);
                        _builder_15.append("'");
                        String _name_15 = ((FMapType)tc).getName();
                        _builder_15.append(_name_15);
                        _builder_15.append("'");
                        this.error(_builder_15.toString(), c_4, (EStructuralFeature)FDeployPackage.Literals.FD_MAP__TARGET, MAP_VALUE_QUICKFIX, new String[]{((FMapType)tc).getName(), FrancaQuickFixConstants.MAP_VALUE.toString()});
                        contentError = true;
                    } else {
                        boolean _not_1;
                        List<String> missing_1 = this.collectMissingProperties(spec, c_4.getValue());
                        boolean _isEmpty_1 = missing_1.isEmpty();
                        boolean bl3 = _not_1 = !_isEmpty_1;
                        if (_not_1) {
                            StringConcatenation _builder_16 = new StringConcatenation();
                            _builder_16.append(MANDATORY_PROPERTY_QUICKFIX_MESSAGE);
                            _builder_16.append("'");
                            String _name_16 = ((FMapType)tc).getName();
                            _builder_16.append(_name_16);
                            _builder_16.append(" value type'");
                            this.error(_builder_16.toString(), c_4, (EStructuralFeature)FDeployPackage.Literals.FD_MAP__VALUE, -1, MANDATORY_PROPERTY_QUICKFIX, new String[]{((FMapType)tc).getName(), FrancaQuickFixConstants.MAP_VALUE.toString()});
                            hasError = true;
                        }
                    }
                }
                if (!contentError) continue;
                StringConcatenation _builder_17 = new StringConcatenation();
                _builder_17.append(DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX_MESSAGE);
                _builder_17.append("'");
                String _name_17 = ((FMapType)tc).getName();
                _builder_17.append(_name_17);
                _builder_17.append("'");
                this.error(_builder_17.toString(), c_4, (EStructuralFeature)FDeployPackage.Literals.FD_MAP__TARGET, DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX, new String[]{((FMapType)tc).getName(), FrancaQuickFixConstants.MAP.toString()});
                continue;
            }
            if (!(tc instanceof FTypeDef)) continue;
            FDElement _fDElement_5 = mapper.getFDElement((EObject)tc);
            FDTypedef c_5 = (FDTypedef)_fDElement_5;
            if (c_5 == null) {
                boolean _mustBeDefined_7 = checker.mustBeDefined((FTypeDef)tc);
                if (!_mustBeDefined_7) continue;
                StringConcatenation _builder_18 = new StringConcatenation();
                _builder_18.append(DEPLOYMENT_ELEMENT_QUICKFIX_MESSAGE);
                _builder_18.append("'");
                String _name_18 = ((FTypeDef)tc).getName();
                _builder_18.append(_name_18);
                _builder_18.append("'");
                this.error(_builder_18.toString(), parentFeature, DEPLOYMENT_ELEMENT_QUICKFIX, new String[]{((FTypeDef)tc).getName(), FrancaQuickFixConstants.TYPEDEF.toString()});
                StringConcatenation _builder_19 = new StringConcatenation();
                _builder_19.append(DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX_MESSAGE);
                _builder_19.append("'");
                String _name_19 = ((FTypeDef)tc).getName();
                _builder_19.append(_name_19);
                _builder_19.append("'");
                this.error(_builder_19.toString(), parentFeature, DEPLOYMENT_ELEMENT_RECURSIVE_QUICKFIX, new String[]{((FTypeDef)tc).getName(), FrancaQuickFixConstants.TYPEDEF.toString()});
                hasError = true;
                continue;
            }
            boolean _checkSpecificationElementProperties_5 = this.checkSpecificationElementProperties(spec, c_5, (EStructuralFeature)FDeployPackage.Literals.FD_TYPEDEF__TARGET, ((FTypeDef)tc).getName());
            if (!_checkSpecificationElementProperties_5) continue;
            hasError = true;
        }
        return hasError;
    }

    private boolean checkArgumentList(FDSpecificationExtender specHelper, PropertyDefChecker checker, FDMapper mapper, FDSpecification spec, List<FArgument> args, FDElement parent, String tag, EStructuralFeature feature) {
        boolean hasError = false;
        for (FArgument tc : args) {
            FDElement _fDElement = mapper.getFDElement((EObject)tc);
            FDArgument c = (FDArgument)_fDElement;
            if (c == null) {
                boolean _mustBeDefined = checker.mustBeDefined(tc);
                if (!_mustBeDefined) continue;
                String opName = "";
                String opType = "";
                String quickfix = "";
                boolean _matched = false;
                if (parent instanceof FDMethod) {
                    _matched = true;
                    opName = FrancaModelExtensions.getUniqueName((FMethod)((FDMethod)parent).getTarget());
                    opType = "method";
                    quickfix = METHOD_ARGUMENT_QUICKFIX;
                }
                if (!_matched && parent instanceof FDBroadcast) {
                    _matched = true;
                    opName = FrancaModelExtensions.getUniqueName((FBroadcast)((FDBroadcast)parent).getTarget());
                    opType = "broadcast";
                    quickfix = BROADCAST_ARGUMENT_QUICKFIX;
                }
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Mandatory argument '");
                String _name = tc.getName();
                _builder.append(_name);
                _builder.append("' is missing for ");
                _builder.append(opType);
                _builder.append(" '");
                _builder.append(opName);
                _builder.append("'");
                this.error(_builder.toString(), parent, feature, -1, quickfix, new String[]{opName, tc.getName()});
                hasError = true;
                continue;
            }
            boolean _checkSpecificationElementProperties = this.checkSpecificationElementProperties(spec, c, (EStructuralFeature)FDeployPackage.Literals.FD_ARGUMENT__TARGET, tc.getName());
            if (!_checkSpecificationElementProperties) continue;
            hasError = true;
        }
        return hasError;
    }

    private boolean checkFieldsList(FDSpecificationExtender specHelper, PropertyDefChecker checker, FDMapper mapper, FDSpecification spec, List<FField> fields, FDElement parent, EStructuralFeature feature, String tag) {
        boolean hasError = false;
        for (FField tc : fields) {
            FDElement _fDElement = mapper.getFDElement((EObject)tc);
            FDField c = (FDField)_fDElement;
            if (c == null) {
                boolean _mustBeDefined = checker.mustBeDefined(tc);
                if (!_mustBeDefined) continue;
                String name = "";
                if (parent instanceof FDUnion) {
                    name = ((FDUnion)parent).getTarget().getName();
                } else if (parent instanceof FDStruct) {
                    name = ((FDStruct)parent).getTarget().getName();
                }
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Mandatory field '");
                String _name = tc.getName();
                _builder.append(_name);
                _builder.append("' is missing for compound '");
                _builder.append(name);
                _builder.append("'");
                this.error(_builder.toString(), parent, feature, -1, COMPOUND_FIELD_QUICKFIX, new String[]{name, tc.getName()});
                hasError = true;
                continue;
            }
            boolean _checkSpecificationElementProperties = this.checkSpecificationElementProperties(spec, c, (EStructuralFeature)FDeployPackage.Literals.FD_FIELD__TARGET, tc.getName());
            if (!_checkSpecificationElementProperties) continue;
            hasError = true;
        }
        return hasError;
    }

    private boolean checkEnumeratorsList(FDSpecificationExtender specHelper, FDMapper mapper, FDSpecification spec, List<FEnumerator> enumerators, FDElement parent, EStructuralFeature feature) {
        boolean hasError = false;
        for (FEnumerator tc : enumerators) {
            FDElement _fDElement = mapper.getFDElement((EObject)tc);
            FDEnumValue c = (FDEnumValue)_fDElement;
            if (c == null) {
                boolean _isMandatory = specHelper.isMandatory(FDPropertyHost.builtIn(FDBuiltInPropertyHost.ENUMERATORS));
                if (!_isMandatory) continue;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Mandatory enumerator '");
                String _name = tc.getName();
                _builder.append(_name);
                _builder.append("' is missing for enumeration '");
                String _name_1 = ((FDEnumeration)parent).getTarget().getName();
                _builder.append(_name_1);
                _builder.append("'");
                this.error(_builder.toString(), parent, feature, -1, ENUMERATOR_ENUM_QUICKFIX, new String[]{((FDEnumeration)parent).getTarget().getName(), tc.getName()});
                hasError = true;
                continue;
            }
            boolean _checkSpecificationElementProperties = this.checkSpecificationElementProperties(spec, c, (EStructuralFeature)FDeployPackage.Literals.FD_ENUM_VALUE__TARGET, tc.getName());
            if (!_checkSpecificationElementProperties) continue;
            hasError = true;
        }
        return hasError;
    }

    protected boolean checkSpecificationElementProperties(FDSpecification spec, FDElement elem, EStructuralFeature feature, String elementName) {
        boolean _not;
        List<String> missing = this.collectMissingProperties(spec, elem);
        boolean _isEmpty = missing.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(MANDATORY_PROPERTY_QUICKFIX_MESSAGE);
            _builder.append("'");
            _builder.append(elementName);
            _builder.append("'");
            this.error(_builder.toString(), elem, feature, -1, MANDATORY_PROPERTY_QUICKFIX, new String[]{elementName});
            return true;
        }
        return false;
    }

    private List<String> collectMissingProperties(FDSpecification spec, FDElement elem) {
        List<FDPropertyDecl> decls = PropertyMappings.getAllPropertyDecls(spec, elem);
        ArrayList missing = Lists.newArrayList();
        for (FDPropertyDecl decl : decls) {
            boolean _not;
            boolean _isMandatory = PropertyMappings.isMandatory(decl);
            if (!_isMandatory) continue;
            boolean _contains = this.contains((List<FDProperty>)elem.getProperties().getItems(), decl);
            boolean bl = _not = !_contains;
            if (!_not) continue;
            missing.add(decl.getName());
        }
        return missing;
    }

    private boolean contains(List<FDProperty> properties, FDPropertyDecl decl) {
        for (FDProperty p : properties) {
            boolean _tripleEquals;
            FDPropertyDecl _decl = p.getDecl();
            boolean bl = _tripleEquals = _decl == decl;
            if (!_tripleEquals) continue;
            return true;
        }
        return false;
    }

    @Check
    public void checkOverwriteSections(FDTypeOverwrites elem) {
        EObject parent = elem.eContainer();
        if (parent instanceof FDOverwriteElement) {
            FType targetType = FDModelUtils.getOverwriteTargetType((FDOverwriteElement)parent);
            if (targetType == null) {
                this.error("Cannot determine target type of overwrite section", parent, (EStructuralFeature)FDeployPackage.Literals.FD_OVERWRITE_ELEMENT__OVERWRITES);
            } else if (!(elem instanceof FDPlainTypeOverwrites)) {
                if (targetType instanceof FStructType) {
                    if (!(elem instanceof FDStructOverwrites)) {
                        this.error("Invalid overwrite tag, use '#struct'", parent, (EStructuralFeature)FDeployPackage.Literals.FD_OVERWRITE_ELEMENT__OVERWRITES);
                    }
                } else if (targetType instanceof FUnionType) {
                    if (!(elem instanceof FDUnionOverwrites)) {
                        this.error("Invalid overwrite tag, use '#union'", parent, (EStructuralFeature)FDeployPackage.Literals.FD_OVERWRITE_ELEMENT__OVERWRITES);
                    }
                } else if (targetType instanceof FEnumerationType && !(elem instanceof FDEnumerationOverwrites)) {
                    this.error("Invalid overwrite tag, use '#enumeration'", parent, (EStructuralFeature)FDeployPackage.Literals.FD_OVERWRITE_ELEMENT__OVERWRITES);
                }
            }
        }
    }

    @Check
    public void checkExtensionType(FDExtensionType type) {
        String name = type.getName();
        IFDeployExtension.TypeDef typeDef = ExtensionRegistry.findType(name);
        if (typeDef == null) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Invalid type '");
            _builder.append(name);
            _builder.append("', no matching deployment extension has been configured");
            this.error(_builder.toString(), type, (EStructuralFeature)FDeployPackage.Literals.FD_EXTENSION_TYPE__NAME, -1);
        }
    }

    @Check
    public void checkPropertyFlagType(FDPropertyFlag flag) {
        boolean _tripleNotEquals;
        boolean _tripleEquals;
        FDComplexValue _default = flag.getDefault();
        boolean bl = _tripleEquals = _default == null;
        if (_tripleEquals) {
            return;
        }
        EObject _eContainer = flag.eContainer();
        FDPropertyDecl decl = (FDPropertyDecl)_eContainer;
        FDTypeRef typeRef = decl.getType();
        FDComplexValue value = flag.getDefault();
        FDValue _single = value.getSingle();
        boolean bl2 = _tripleNotEquals = _single != null;
        if (_tripleNotEquals) {
            boolean _tripleNotEquals_1;
            String _array = typeRef.getArray();
            boolean bl3 = _tripleNotEquals_1 = _array != null;
            if (_tripleNotEquals_1) {
                this.error("Default must be an array!", (EStructuralFeature)FDeployPackage.Literals.FD_PROPERTY_FLAG__DEFAULT);
            } else {
                this.checkValueType(typeRef, value.getSingle(), flag, FDeployPackage.Literals.FD_PROPERTY_FLAG__DEFAULT, -1);
            }
        } else {
            boolean _tripleNotEquals_2;
            FDValueArray _array_1 = value.getArray();
            boolean bl4 = _tripleNotEquals_2 = _array_1 != null;
            if (_tripleNotEquals_2) {
                boolean _tripleEquals_1;
                String _array_2 = typeRef.getArray();
                boolean bl5 = _tripleEquals_1 = _array_2 == null;
                if (_tripleEquals_1) {
                    this.error("Default must be a single type, not an array!", (EStructuralFeature)FDeployPackage.Literals.FD_PROPERTY_FLAG__DEFAULT);
                } else {
                    this.checkValueArrayType(typeRef, value.getArray());
                }
            }
        }
    }

    @Check
    public void checkPropertyValueType(FDProperty prop) {
        boolean _tripleNotEquals;
        FDTypeRef typeRef = prop.getDecl().getType();
        FDComplexValue value = prop.getValue();
        FDValue _single = value.getSingle();
        boolean bl = _tripleNotEquals = _single != null;
        if (_tripleNotEquals) {
            boolean _tripleNotEquals_1;
            String _array = typeRef.getArray();
            boolean bl2 = _tripleNotEquals_1 = _array != null;
            if (_tripleNotEquals_1) {
                this.error("Invalid type, expected array!", (EStructuralFeature)FDeployPackage.Literals.FD_PROPERTY__VALUE);
            } else {
                this.checkValueType(typeRef, value.getSingle(), prop, FDeployPackage.Literals.FD_PROPERTY__VALUE, -1);
            }
        } else {
            boolean _tripleNotEquals_2;
            FDValueArray _array_1 = value.getArray();
            boolean bl3 = _tripleNotEquals_2 = _array_1 != null;
            if (_tripleNotEquals_2) {
                boolean _tripleEquals;
                String _array_2 = typeRef.getArray();
                boolean bl4 = _tripleEquals = _array_2 == null;
                if (_tripleEquals) {
                    this.error("Invalid array type, expected single value!", (EStructuralFeature)FDeployPackage.Literals.FD_PROPERTY__VALUE);
                } else {
                    this.checkValueArrayType(typeRef, value.getArray());
                }
            }
        }
    }

    private void checkValueType(FDTypeRef typeRef, FDValue value, EObject src, EReference literal, int index) {
        block15: {
            block14: {
                boolean _tripleEquals;
                FDType _complex = typeRef.getComplex();
                boolean bl = _tripleEquals = _complex == null;
                if (!_tripleEquals) break block14;
                int predefined = typeRef.getPredefined().getValue();
                switch (predefined) {
                    case 0: {
                        if (!(value instanceof FDInteger)) {
                            this.error("Invalid type, expected Integer constant", src, (EStructuralFeature)literal, index);
                            break;
                        }
                        break block15;
                    }
                    case 1: {
                        if (!(value instanceof FDString)) {
                            this.error("Invalid type, expected String constant", src, (EStructuralFeature)literal, index);
                            break;
                        }
                        break block15;
                    }
                    case 2: {
                        if (!(value instanceof FDBoolean)) {
                            this.error("Invalid type, expected 'true' or 'false'", src, (EStructuralFeature)literal, index);
                            break;
                        }
                        break block15;
                    }
                    case 3: {
                        if (value instanceof FDInterfaceRef) break block15;
                        this.error("Invalid type, expected reference to Franca interface", src, (EStructuralFeature)literal, index);
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block15;
            }
            FDType type = typeRef.getComplex();
            if (type instanceof FDEnumType) {
                boolean _not;
                boolean _isEnumerator = FDModelUtils.isEnumerator(value);
                boolean bl = _not = !_isEnumerator;
                if (_not) {
                    this.error("Invalid type, expected enumerator", src, (EStructuralFeature)literal, index);
                }
            }
        }
    }

    private void checkValueArrayType(FDTypeRef typeRef, FDValueArray array) {
        int i = 0;
        EList<FDValue> _values = array.getValues();
        for (FDValue value : _values) {
            this.checkValueType(typeRef, value, array, FDeployPackage.Literals.FD_VALUE_ARRAY__VALUES, i);
            ++i;
        }
    }

    @Override
    public void reportError(String message, EObject object, EStructuralFeature feature) {
        this.error(message, object, feature, -1);
    }

    @Override
    public void reportError(String message, EObject object, EStructuralFeature feature, int idx) {
        this.error(message, object, feature, idx);
    }

    @Override
    public void reportWarning(String message, EObject object, EStructuralFeature feature) {
        this.warning(message, object, feature, -1);
    }
}

