/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.dsl.validation;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.franca.core.FrancaModelExtensions;
import org.franca.core.franca.FArrayType;
import org.franca.core.franca.FEnumerationType;
import org.franca.core.franca.FModel;
import org.franca.core.franca.FStructType;
import org.franca.core.franca.FType;
import org.franca.core.franca.FTypeRef;
import org.franca.core.franca.FUnionType;
import org.franca.core.utils.CycleChecker;
import org.franca.deploymodel.core.FDPropertyHost;
import org.franca.deploymodel.dsl.fDeploy.FDDeclaration;
import org.franca.deploymodel.dsl.fDeploy.FDEnumType;
import org.franca.deploymodel.dsl.fDeploy.FDInterface;
import org.franca.deploymodel.dsl.fDeploy.FDPropertyDecl;
import org.franca.deploymodel.dsl.fDeploy.FDRootElement;
import org.franca.deploymodel.dsl.fDeploy.FDSpecification;
import org.franca.deploymodel.dsl.fDeploy.FDType;
import org.franca.deploymodel.dsl.fDeploy.FDTypes;
import org.franca.deploymodel.dsl.fDeploy.FDeployPackage;
import org.franca.deploymodel.dsl.generator.internal.HostLogic;
import org.franca.deploymodel.dsl.validation.PropertyDefChecker;
import org.franca.deploymodel.dsl.validation.ValidationMessageReporter;

public class FDeployValidatorAux {
    private ValidationMessageReporter reporter;

    public FDeployValidatorAux(ValidationMessageReporter reporter) {
        this.reporter = reporter;
    }

    public void checkRootElement(FDRootElement it) {
        Functions.Function1<FDRootElement, Collection<FDRootElement>> _function = new Functions.Function1<FDRootElement, Collection<FDRootElement>>(){

            public Collection<FDRootElement> apply(FDRootElement e) {
                return e.getUse();
            }
        };
        List path = CycleChecker.isReferenced((Object)it, (Functions.Function1)_function);
        if (path != null) {
            int idx = it.getUse().indexOf(path.get(0));
            String _name = it.getName();
            String _plus = "Cyclic use-relation in element '" + _name;
            String _plus_1 = String.valueOf(_plus) + "'";
            this.reporter.reportError(_plus_1, it, (EStructuralFeature)FDeployPackage.Literals.FD_ROOT_ELEMENT__USE, idx);
        }
        EList<FDRootElement> _use = it.getUse();
        for (FDRootElement other : _use) {
            boolean _not;
            if (it.getSpec() == null || other.getSpec() == null) continue;
            boolean _isCompatible = this.isCompatible(it.getSpec(), other.getSpec());
            boolean bl = _not = !_isCompatible;
            if (!_not) continue;
            String _name_1 = other.getName();
            String _plus_2 = "Use-relation '" + _name_1;
            String _plus_3 = String.valueOf(_plus_2) + "' ";
            String _plus_4 = String.valueOf(_plus_3) + "refers to deployment with incompatible specification ";
            String _plus_5 = String.valueOf(_plus_4) + "'";
            String _name_2 = other.getSpec().getName();
            String _plus_6 = String.valueOf(_plus_5) + _name_2;
            String _plus_7 = String.valueOf(_plus_6) + "'";
            this.reporter.reportError(_plus_7, it, (EStructuralFeature)FDeployPackage.Literals.FD_ROOT_ELEMENT__USE, it.getUse().indexOf((Object)other));
        }
    }

    private boolean isCompatible(FDSpecification spec1, FDSpecification spec2) {
        boolean _tripleNotEquals;
        FDSpecification _cyclicBaseSpec = this.getCyclicBaseSpec(spec2);
        boolean bl = _tripleNotEquals = _cyclicBaseSpec != null;
        if (_tripleNotEquals) {
            return true;
        }
        FDSpecification check = spec2;
        do {
            boolean _equals;
            if (!(_equals = Objects.equal((Object)spec1, (Object)check))) continue;
            return true;
        } while ((check = check.getBase()) != null);
        return false;
    }

    public FDSpecification getCyclicBaseSpec(FDSpecification spec) {
        HashSet visited = CollectionLiterals.newHashSet((Object[])new FDSpecification[0]);
        FDSpecification s = spec;
        FDSpecification last = null;
        do {
            visited.add(s);
            last = s;
            s = s.getBase();
            if (s == null || !visited.contains(s)) continue;
            return last;
        } while (s != null);
        return null;
    }

    public void checkClashingProperties(FDSpecification spec) {
        Functions.Function1<FDDeclaration, EList<FDPropertyDecl>> _function = new Functions.Function1<FDDeclaration, EList<FDPropertyDecl>>(){

            public EList<FDPropertyDecl> apply(FDDeclaration it) {
                return it.getProperties();
            }
        };
        Iterable allPropertyDecls = Iterables.concat((Iterable)ListExtensions.map(spec.getDeclarations(), (Functions.Function1)_function));
        Functions.Function1<FDPropertyDecl, String> _function_1 = new Functions.Function1<FDPropertyDecl, String>(){

            public String apply(FDPropertyDecl it) {
                return it.getName();
            }
        };
        Map groups = IterableExtensions.groupBy((Iterable)allPropertyDecls, (Functions.Function1)_function_1);
        Set _keySet = groups.keySet();
        for (String propName : _keySet) {
            boolean _greaterThan;
            List props = (List)groups.get(propName);
            Functions.Function1<FDPropertyDecl, FDPropertyHost> _function_2 = new Functions.Function1<FDPropertyDecl, FDPropertyHost>(){

                public FDPropertyHost apply(FDPropertyDecl it) {
                    return FDeployValidatorAux.this.getHost(it);
                }
            };
            Map perHost = IterableExtensions.groupBy((Iterable)props, (Functions.Function1)_function_2);
            Functions.Function1<List<FDPropertyDecl>, Boolean> _function_3 = new Functions.Function1<List<FDPropertyDecl>, Boolean>(){

                public Boolean apply(List<FDPropertyDecl> it) {
                    int _size = it.size();
                    return _size > 1;
                }
            };
            Set directDuplicates = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.filter(perHost.values(), (Functions.Function1)_function_3)));
            for (FDPropertyDecl pd : directDuplicates) {
                String _name = pd.getName();
                String _plus = "Duplicate property name '" + _name;
                String _plus_1 = String.valueOf(_plus) + "'";
                this.reporter.reportError(_plus_1, pd, (EStructuralFeature)FDeployPackage.Literals.FD_PROPERTY_DECL__NAME);
            }
            Sets.SetView localUnique = Sets.difference((Set)IterableExtensions.toSet((Iterable)props), (Set)directDuplicates);
            this.checkGroupArgumentType((Iterable<FDPropertyDecl>)localUnique);
            Functions.Function1<FDPropertyDecl, Boolean> _function_4 = new Functions.Function1<FDPropertyDecl, Boolean>(){

                public Boolean apply(FDPropertyDecl it) {
                    return FDeployValidatorAux.this.isEnumType(it);
                }
            };
            Iterable enumProps = IterableExtensions.filter((Iterable)localUnique, (Functions.Function1)_function_4);
            int _size = IterableExtensions.size((Iterable)enumProps);
            boolean bl = _greaterThan = _size > 1;
            if (!_greaterThan) continue;
            for (FDPropertyDecl ep : enumProps) {
                String _name_1 = ep.getName();
                String _plus_2 = "Deployment property '" + _name_1;
                String _plus_3 = String.valueOf(_plus_2) + "' with an enumeration type has to be unique";
                this.reporter.reportError(_plus_3, ep, (EStructuralFeature)FDeployPackage.Literals.FD_PROPERTY_DECL__NAME);
            }
        }
    }

    private void checkGroupArgumentType(Iterable<FDPropertyDecl> items) {
        Functions.Function1<FDPropertyDecl, Class<? extends EObject>> _function = new Functions.Function1<FDPropertyDecl, Class<? extends EObject>>(){

            public Class<? extends EObject> apply(FDPropertyDecl it) {
                return HostLogic.getArgumentType(FDeployValidatorAux.this.getHost(it), HostLogic.Context.FRANCA_INTERFACE);
            }
        };
        final Map argtypeGroups = IterableExtensions.groupBy(items, (Functions.Function1)_function);
        HashMap colliding = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        Set argtypes = argtypeGroups.keySet();
        for (final Class at : argtypes) {
            boolean _not;
            boolean _greaterThan;
            ArrayList colliders = CollectionLiterals.newArrayList((Object[])new Class[0]);
            int _size = ((List)argtypeGroups.get(at)).size();
            boolean bl = _greaterThan = _size > 1;
            if (_greaterThan) {
                colliders.add(at);
            }
            Functions.Function1<Class<? extends EObject>, Boolean> _function_1 = new Functions.Function1<Class<? extends EObject>, Boolean>(){

                public Boolean apply(Class<? extends EObject> it) {
                    return !Objects.equal(it, (Object)at) && FDeployValidatorAux.this.willCollide(it, at);
                }
            };
            Iterable _filter = IterableExtensions.filter(argtypes, (Functions.Function1)_function_1);
            Iterables.addAll((Collection)colliders, (Iterable)_filter);
            boolean _isEmpty = colliders.isEmpty();
            boolean bl2 = _not = !_isEmpty;
            if (!_not) continue;
            colliding.put(at, colliders);
        }
        Set _keySet = colliding.keySet();
        for (Class h : _keySet) {
            Functions.Function1<Class<? extends EObject>, List<FDPropertyDecl>> _function_1 = new Functions.Function1<Class<? extends EObject>, List<FDPropertyDecl>>(){

                public List<FDPropertyDecl> apply(Class<? extends EObject> it) {
                    return (List)argtypeGroups.get(it);
                }
            };
            Set collidingProps = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)((Iterable)colliding.get(h)), (Functions.Function1)_function_1)));
            List _get = (List)argtypeGroups.get(h);
            for (final FDPropertyDecl p : _get) {
                Functions.Function1<FDPropertyDecl, Boolean> _function_2 = new Functions.Function1<FDPropertyDecl, Boolean>(){

                    public Boolean apply(FDPropertyDecl it) {
                        return !Objects.equal((Object)it, (Object)p);
                    }
                };
                Functions.Function1<FDPropertyDecl, FDPropertyHost> _function_3 = new Functions.Function1<FDPropertyDecl, FDPropertyHost>(){

                    public FDPropertyHost apply(FDPropertyDecl it) {
                        return FDeployValidatorAux.this.getHost(it);
                    }
                };
                Functions.Function1<FDPropertyHost, String> _function_4 = new Functions.Function1<FDPropertyHost, String>(){

                    public String apply(FDPropertyHost it) {
                        return it.getName();
                    }
                };
                String coll = IterableExtensions.join((Iterable)IterableExtensions.sort((Iterable)IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)collidingProps, (Functions.Function1)_function_2), (Functions.Function1)_function_3), (Functions.Function1)_function_4))), (CharSequence)", ");
                String _name = p.getName();
                String _plus = "Name conflict for property '" + _name;
                String _plus_1 = String.valueOf(_plus) + "' due to conflicting property hosts";
                String _plus_2 = String.valueOf(_plus_1) + " (conflicting: ";
                String _plus_3 = String.valueOf(_plus_2) + coll;
                String _plus_4 = String.valueOf(_plus_3) + ")";
                this.reporter.reportError(_plus_4, p, (EStructuralFeature)FDeployPackage.Literals.FD_PROPERTY_DECL__NAME);
            }
        }
    }

    private boolean willCollide(Class<? extends EObject> a, Class<? extends EObject> b) {
        return a.isAssignableFrom(b) || b.isAssignableFrom(a);
    }

    private boolean isEnumType(FDPropertyDecl decl) {
        boolean _xblockexpression = false;
        FDType t = decl.getType().getComplex();
        _xblockexpression = t != null && t instanceof FDEnumType;
        return _xblockexpression;
    }

    private FDPropertyHost getHost(FDPropertyDecl decl) {
        FDPropertyHost _xblockexpression = null;
        EObject _eContainer = decl.eContainer();
        FDDeclaration declaration = (FDDeclaration)_eContainer;
        _xblockexpression = declaration.getHost();
        return _xblockexpression;
    }

    public boolean checkUsedTypes(FDTypes rootElem, List<FType> localTypes, PropertyDefChecker checker) {
        boolean _xblockexpression = false;
        HashSet typerefs = CollectionLiterals.newHashSet((Object[])new FTypeRef[0]);
        EList _types = rootElem.getTarget().getTypes();
        for (FType t : _types) {
            typerefs.addAll(IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)EcoreUtil2.eAllContents((EObject)t), FTypeRef.class)));
        }
        _xblockexpression = this.checkUsedTypesRoot(rootElem, typerefs, localTypes, checker);
        return _xblockexpression;
    }

    public boolean checkUsedTypes(FDInterface rootElem, List<FType> localTypes, PropertyDefChecker checker) {
        Set typerefs = IterableExtensions.toSet((Iterable)Iterables.filter((Iterable)EcoreUtil2.eAllContents((EObject)rootElem.getTarget()), FTypeRef.class));
        return this.checkUsedTypesRoot(rootElem, typerefs, localTypes, checker);
    }

    private boolean checkUsedTypesRoot(FDRootElement rootElem, Collection<FTypeRef> typerefs, final List<FType> localTypes, PropertyDefChecker checker) {
        boolean hasError = false;
        Functions.Function1<FTypeRef, FType> _function = new Functions.Function1<FTypeRef, FType>(){

            public FType apply(FTypeRef it) {
                return it.getDerived();
            }
        };
        Functions.Function1<FType, Boolean> _function_1 = new Functions.Function1<FType, Boolean>(){

            public Boolean apply(FType it) {
                return FDeployValidatorAux.this.isDeploymentRelevantType(it);
            }
        };
        Set referencedTypes = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map(typerefs, (Functions.Function1)_function)), (Functions.Function1)_function_1));
        Functions.Function1<FType, Boolean> _function_2 = new Functions.Function1<FType, Boolean>(){

            public Boolean apply(FType it) {
                boolean _contains = localTypes.contains(it);
                return !_contains;
            }
        };
        Set nonLocal = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)referencedTypes, (Functions.Function1)_function_2));
        final Set<FType> fromOthers = this.getTypeDefinitionsByTransitiveUse(rootElem);
        Functions.Function1<FType, Boolean> _function_3 = new Functions.Function1<FType, Boolean>(){

            public Boolean apply(FType it) {
                boolean _contains = fromOthers.contains(it);
                return !_contains;
            }
        };
        Set remaining = IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)nonLocal, (Functions.Function1)_function_3));
        for (FType missing : remaining) {
            boolean _mustBeDefined = this.mustBeDefined(checker, missing);
            if (!_mustBeDefined) continue;
            FModel model = FrancaModelExtensions.getModel((EObject)missing);
            String _name = missing.getName();
            String _plus = "Deployment for type '" + _name;
            String _plus_1 = String.valueOf(_plus) + "' is missing, ";
            String _plus_2 = String.valueOf(_plus_1) + "add 'use' reference for deployment of package '";
            String _name_1 = model.getName();
            String _plus_3 = String.valueOf(_plus_2) + _name_1;
            String _plus_4 = String.valueOf(_plus_3) + "'";
            this.reporter.reportError(_plus_4, rootElem, (EStructuralFeature)FDeployPackage.Literals.FD_INTERFACE__TARGET);
            hasError = true;
        }
        return hasError;
    }

    private boolean mustBeDefined(PropertyDefChecker checker, FType t) {
        boolean _switchResult = false;
        boolean _matched = false;
        if (t instanceof FArrayType) {
            _matched = true;
            _switchResult = checker.mustBeDefined((FArrayType)t);
        }
        if (!_matched && t instanceof FStructType) {
            _matched = true;
            _switchResult = checker.mustBeDefined((FStructType)t);
        }
        if (!_matched && t instanceof FUnionType) {
            _matched = true;
            _switchResult = checker.mustBeDefined((FUnionType)t);
        }
        if (!_matched && t instanceof FEnumerationType) {
            _matched = true;
            _switchResult = checker.mustBeDefined((FEnumerationType)t);
        }
        if (!_matched) {
            _switchResult = true;
        }
        return _switchResult;
    }

    private boolean isDeploymentRelevantType(FType it) {
        return it instanceof FArrayType || it instanceof FStructType || it instanceof FUnionType || it instanceof FEnumerationType;
    }

    private Set<FType> getTypeDefinitionsByTransitiveUse(FDRootElement rootElem) {
        HashSet _xblockexpression = null;
        HashSet visited = CollectionLiterals.newHashSet((Object[])new FDRootElement[]{rootElem});
        LinkedList work = CollectionLiterals.newLinkedList((Object[])new FDRootElement[0]);
        HashSet found = CollectionLiterals.newHashSet((Object[])new FType[0]);
        work.addAll(rootElem.getUse());
        while (!work.isEmpty()) {
            boolean _not;
            FDRootElement e = (FDRootElement)work.poll();
            boolean _contains = visited.contains(e);
            boolean bl = _not = !_contains;
            if (!_not) continue;
            visited.add(e);
            found.addAll(this.getLocalTypes(e));
            work.addAll(e.getUse());
        }
        _xblockexpression = found;
        return _xblockexpression;
    }

    private Collection<FType> getLocalTypes(FDRootElement rootElem) {
        Object _switchResult = null;
        boolean _matched = false;
        if (rootElem instanceof FDInterface) {
            _matched = true;
            _switchResult = ((FDInterface)rootElem).getTarget().getTypes();
        }
        if (!_matched && rootElem instanceof FDTypes) {
            _matched = true;
            _switchResult = ((FDTypes)rootElem).getTarget().getTypes();
        }
        if (!_matched) {
            _switchResult = CollectionLiterals.newArrayList((Object[])new FType[0]);
        }
        return _switchResult;
    }
}

