/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.dsl.validation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.franca.deploymodel.dsl.validation.ValidationMessageReporter;

public class ValidationHelpers {
    public static <T extends EObject> int checkDuplicates(ValidationMessageReporter reporter, Iterable<T> items, EStructuralFeature feature, String description) {
        int nErrors = 0;
        String msg = "Duplicate " + description + ' ';
        HashMap<String, EObject> firstOccurrenceOfName = new HashMap<String, EObject>();
        HashSet<String> duplicateNames = new HashSet<String>();
        for (EObject i : items) {
            String name = i.eGet(feature).toString();
            if (firstOccurrenceOfName.get(name) != null) {
                duplicateNames.add(name);
                reporter.reportError(String.valueOf(msg) + "'" + name + "'", i, feature);
                ++nErrors;
                continue;
            }
            firstOccurrenceOfName.put(name, i);
        }
        for (String s : duplicateNames) {
            reporter.reportError(String.valueOf(msg) + "'" + s + "'", (EObject)firstOccurrenceOfName.get(s), feature);
            ++nErrors;
        }
        return nErrors;
    }

    public static NameList createNameList() {
        return new NameList();
    }

    public static int checkDuplicates(ValidationMessageReporter reporter, NameList items, EStructuralFeature feature, String description) {
        int nErrors = 0;
        String msg = "Duplicate " + description + ' ';
        HashMap<String, EObject> firstOccurrenceOfName = new HashMap<String, EObject>();
        HashSet<String> duplicateNames = new HashSet<String>();
        for (Entry p : items.iterable()) {
            if (firstOccurrenceOfName.get(p.name) != null) {
                duplicateNames.add(p.name);
                reporter.reportError(String.valueOf(msg) + p.name, p.object, feature);
                ++nErrors;
                continue;
            }
            firstOccurrenceOfName.put(p.name, p.object);
        }
        for (String s : duplicateNames) {
            reporter.reportError(String.valueOf(msg) + "'" + s + "'", (EObject)firstOccurrenceOfName.get(s), feature);
            ++nErrors;
        }
        return nErrors;
    }

    public static class Entry {
        public EObject object;
        public String name;

        public Entry(EObject object, String name) {
            this.object = object;
            this.name = name;
        }
    }

    public static class NameList {
        private List<Entry> list = new ArrayList<Entry>();

        public void add(EObject object, String name) {
            this.list.add(new Entry(object, name));
        }

        public Iterable<Entry> iterable() {
            return this.list;
        }
    }
}

