/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.dsl.validation.internal;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.xtext.validation.CheckMode;
import org.franca.deploymodel.dsl.validation.IFDeployExternalValidator;

public class ValidatorRegistry {
    private static final String EXTENSION_POINT_ID = "org.franca.deploymodel.dsl.deploymentValidator";
    private static Multimap<CheckMode, IFDeployExternalValidator> validatorMap;
    public static final String MODE_EXPENSIVE = "EXPENSIVE";
    public static final String MODE_NORMAL = "NORMAL";
    public static final String MODE_FAST = "FAST";

    public static Multimap<CheckMode, IFDeployExternalValidator> getValidatorMap() {
        if (validatorMap == null) {
            ValidatorRegistry.initializeValidators();
        }
        return validatorMap;
    }

    public static void addValidator(IFDeployExternalValidator validator, String mode) {
        if (validatorMap == null) {
            validatorMap = ArrayListMultimap.create();
        }
        ValidatorRegistry.putToMap(validator, mode);
    }

    private static void initializeValidators() {
        validatorMap = ArrayListMultimap.create();
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        if (reg == null) {
            return;
        }
        IExtensionPoint ep = reg.getExtensionPoint(EXTENSION_POINT_ID);
        IExtension[] iExtensionArray = ep.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                if (ce.getName().equals("validator")) {
                    try {
                        Object o = ce.createExecutableExtension("class");
                        if (o instanceof IFDeployExternalValidator) {
                            IFDeployExternalValidator validator = (IFDeployExternalValidator)o;
                            String mode = ce.getAttribute("mode");
                            ValidatorRegistry.putToMap(validator, mode);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static void putToMap(IFDeployExternalValidator validator, String mode) {
        validatorMap.put((Object)CheckMode.ALL, (Object)validator);
        if (mode.matches(MODE_EXPENSIVE)) {
            validatorMap.put((Object)CheckMode.EXPENSIVE_ONLY, (Object)validator);
        } else if (mode.matches(MODE_NORMAL)) {
            validatorMap.put((Object)CheckMode.NORMAL_ONLY, (Object)validator);
            validatorMap.put((Object)CheckMode.NORMAL_AND_FAST, (Object)validator);
        } else {
            validatorMap.put((Object)CheckMode.FAST_ONLY, (Object)validator);
            validatorMap.put((Object)CheckMode.NORMAL_AND_FAST, (Object)validator);
        }
    }
}

