/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.dsl.valueconverter;

import com.google.inject.Inject;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.conversion.ValueConverter;
import org.eclipse.xtext.conversion.ValueConverterException;
import org.eclipse.xtext.conversion.impl.AbstractDeclarativeValueConverterService;
import org.eclipse.xtext.conversion.impl.AbstractIDValueConverter;
import org.eclipse.xtext.conversion.impl.AbstractNullSafeConverter;
import org.eclipse.xtext.conversion.impl.AbstractValueConverter;
import org.eclipse.xtext.conversion.impl.INTValueConverter;
import org.eclipse.xtext.conversion.impl.STRINGValueConverter;
import org.eclipse.xtext.nodemodel.INode;
import org.franca.deploymodel.core.FDPropertyHost;
import org.franca.deploymodel.dsl.fDeploy.FDBuiltInPropertyHost;

public class FDeployValueConverters
extends AbstractDeclarativeValueConverterService {
    @Inject
    private AbstractIDValueConverter idValueConverter;
    private FQNValueConverter fqnValueConverter = new FQNValueConverter();
    @Inject
    private INTValueConverter intValueConverter;
    @Inject
    private STRINGValueConverter stringValueConverter;

    @ValueConverter(rule="ID")
    public IValueConverter<String> ID() {
        return this.idValueConverter;
    }

    @ValueConverter(rule="FQN")
    public IValueConverter<String> FQN() {
        return this.fqnValueConverter;
    }

    @ValueConverter(rule="FQN_WITH_SELECTOR")
    public IValueConverter<String> FQN_WITH_SELECTOR() {
        return this.fqnValueConverter;
    }

    @ValueConverter(rule="INT")
    public IValueConverter<Integer> INT() {
        return this.intValueConverter;
    }

    @ValueConverter(rule="SignedInt")
    public IValueConverter<Integer> SignedInt() {
        return new AbstractNullSafeConverter<Integer>(){

            protected String internalToString(Integer value) {
                return Integer.toString(value);
            }

            protected Integer internalToValue(String string, INode node) throws ValueConverterException {
                try {
                    Integer result;
                    if (string.startsWith("0x") || string.startsWith("0X")) {
                        String data = string.substring(2);
                        result = Integer.parseInt(data, 16);
                    } else if (string.startsWith("0b") || string.startsWith("0B")) {
                        String data = string.substring(2);
                        result = Integer.parseInt(data, 2);
                    } else {
                        result = Integer.parseInt(string, 10);
                    }
                    return result;
                }
                catch (Exception e) {
                    throw new ValueConverterException("Not a proper integer value.", node, e);
                }
            }
        };
    }

    @ValueConverter(rule="STRING")
    public IValueConverter<String> STRING() {
        return this.stringValueConverter;
    }

    @ValueConverter(rule="PROPERTY_HOST")
    public AbstractNullSafeConverter<FDPropertyHost> PROPERTY_HOST() {
        return new AbstractNullSafeConverter<FDPropertyHost>(){

            protected FDPropertyHost internalToValue(String string, INode node) {
                FDBuiltInPropertyHost host = FDBuiltInPropertyHost.get(string);
                if (host != null) {
                    return new FDPropertyHost(host);
                }
                return new FDPropertyHost(string);
            }

            protected String internalToString(FDPropertyHost value) {
                return value.getName();
            }
        };
    }

    private class FQNValueConverter
    extends AbstractValueConverter<String> {
        static final String SELECTOR = ":";

        private FQNValueConverter() {
        }

        public String toString(String s) {
            StringBuilder result = new StringBuilder();
            String[] selarray = s.split(SELECTOR);
            int i = 0;
            while (i < selarray.length) {
                if (i > 0) {
                    result.append(':');
                }
                String[] idarray = selarray[i].split("\\.");
                int j = 0;
                while (j < idarray.length) {
                    if (j > 0) {
                        result.append('.');
                    }
                    result.append(FDeployValueConverters.this.idValueConverter.toString((Object)idarray[j]));
                    ++j;
                }
                ++i;
            }
            return result.toString();
        }

        public String toValue(String string, INode node) {
            if (string == null) {
                return null;
            }
            return string.replace("^", "");
        }
    }
}

