/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.extensions;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.franca.deploymodel.dsl.fDeploy.FDAbstractExtensionElement;
import org.franca.deploymodel.dsl.fDeploy.FDExtensionElement;
import org.franca.deploymodel.dsl.fDeploy.FDExtensionRoot;
import org.franca.deploymodel.dsl.fDeploy.FDeployPackage;
import org.franca.deploymodel.extensions.ExtensionUtils;
import org.franca.deploymodel.extensions.IFDeployExtension;

public class ExtensionRegistry {
    private static final String EXTENSION_POINT_ID = "org.franca.deploymodel.dsl.deploymentExtension";
    private static List<IFDeployExtension> extensions = null;
    private static Map<EClass, Iterable<IFDeployExtension.Host>> allAdditionalHosts = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private static Map<IFDeployExtension.Host, Set<EClass>> hostingClasses = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private static Map<EClass, IFDeployExtension> mixinExtensions = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private static Map<EClass, EClassifier> accessorArgumentType = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private static Set<EClass> isNonFrancaMixin = CollectionLiterals.newHashSet((Object[])new EClass[0]);
    private static Map<EClass, String> nonFrancaMixinRootPrefix = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
    private static Multimap<EClass, EClass> mixinChildren = LinkedListMultimap.create();

    public static void addExtension(IFDeployExtension extension) {
        if (extensions == null) {
            extensions = Lists.newArrayList();
        }
        ExtensionRegistry.register(extension);
    }

    public static void reset() {
        extensions.clear();
        allAdditionalHosts.clear();
        hostingClasses.clear();
        mixinExtensions.clear();
        accessorArgumentType.clear();
        isNonFrancaMixin.clear();
        mixinChildren.clear();
    }

    public static Collection<IFDeployExtension> getExtensions() {
        if (extensions == null) {
            ExtensionRegistry.initializeValidators();
        }
        return extensions;
    }

    private static void initializeValidators() {
        IExtension[] _extensions;
        IExtensionRegistry reg;
        if (extensions == null) {
            extensions = Lists.newArrayList();
        }
        if ((reg = Platform.getExtensionRegistry()) == null) {
            return;
        }
        IExtensionPoint ep = reg.getExtensionPoint(EXTENSION_POINT_ID);
        IExtension[] iExtensionArray = _extensions = ep.getExtensions();
        int n = _extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] _configurationElements;
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = _configurationElements = ext.getConfigurationElements();
            int n3 = _configurationElements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement ce = iConfigurationElementArray[n4];
                boolean _equals = ce.getName().equals("validator");
                if (_equals) {
                    try {
                        Object o = ce.createExecutableExtension("class");
                        if (o instanceof IFDeployExtension) {
                            IFDeployExtension dExt = (IFDeployExtension)o;
                            ExtensionRegistry.register(dExt);
                        }
                    }
                    catch (Throwable _t) {
                        if (_t instanceof CoreException) {
                            CoreException e = (CoreException)_t;
                            e.printStackTrace();
                        }
                        throw Exceptions.sneakyThrow((Throwable)_t);
                    }
                }
                ++n4;
            }
            ++n2;
        }
    }

    private static void register(IFDeployExtension extension) {
        Object _function_2;
        Object _function_1;
        String desc = extension.getShortDescription();
        Functions.Function1<IFDeployExtension, String> _function = new Functions.Function1<IFDeployExtension, String>(){

            public String apply(IFDeployExtension it) {
                return it.getShortDescription();
            }
        };
        boolean _contains = ListExtensions.map(extensions, (Functions.Function1)_function).contains(desc);
        if (_contains) {
            System.err.println("ERROR: Deployment extension '" + desc + "' has already been registered!");
            return;
        }
        extensions.add(extension);
        Collection<IFDeployExtension.RootDef> _roots = extension.getRoots();
        for (IFDeployExtension.RootDef root : _roots) {
            _function_1 = new Consumer<IFDeployExtension.Host>(){

                @Override
                public void accept(IFDeployExtension.Host it) {
                    ExtensionRegistry.addHostingClass(it, FDeployPackage.eINSTANCE.getFDExtensionRoot());
                }
            };
            root.getHosts().forEach(_function_1);
            _function_2 = new Consumer<IFDeployExtension.Host>(){

                @Override
                public void accept(IFDeployExtension.Host it) {
                    ExtensionRegistry.addHostingClass(it, FDeployPackage.eINSTANCE.getFDExtensionElement());
                }
            };
            ExtensionUtils.getHostsOnlyInSubtree(root).forEach(_function_2);
        }
        Collection<IFDeployExtension.HostMixinDef> _mixins = extension.getMixins();
        for (IFDeployExtension.HostMixinDef mixin : _mixins) {
            final EClass clazz = mixin.getHostingClass();
            Collection<IFDeployExtension.Host> hosts = mixin.getHosts();
            boolean _containsKey = allAdditionalHosts.containsKey(clazz);
            if (_containsKey) {
                Iterable<IFDeployExtension.Host> previousHosts = allAdditionalHosts.get(clazz);
                Iterable joined = Iterables.unmodifiableIterable((Iterable)Iterables.concat(previousHosts, hosts));
                allAdditionalHosts.put(clazz, joined);
            } else {
                allAdditionalHosts.put(clazz, hosts);
            }
            Consumer<IFDeployExtension.Host> _function_12 = new Consumer<IFDeployExtension.Host>(){

                @Override
                public void accept(IFDeployExtension.Host it) {
                    ExtensionRegistry.addHostingClass(it, clazz);
                }
            };
            hosts.forEach(_function_12);
        }
        Collection<IFDeployExtension.HostMixinDef> _mixins_1 = extension.getMixins();
        for (IFDeployExtension.HostMixinDef mixin_1 : _mixins_1) {
            boolean _tripleNotEquals;
            boolean _isNonFrancaMixin;
            boolean _tripleEquals;
            EClass clazz = mixin_1.getHostingClass();
            mixinExtensions.put(clazz, extension);
            IFDeployExtension.HostMixinDef.AccessorArgumentStyle _accessorArgument = mixin_1.getAccessorArgument();
            boolean bl = _tripleEquals = _accessorArgument == IFDeployExtension.HostMixinDef.AccessorArgumentStyle.BY_TARGET_FEATURE;
            if (_tripleEquals) {
                EClassifier targetType = ExtensionRegistry.getClassOfTargetFeature(clazz);
                boolean _containsKey = accessorArgumentType.containsKey(clazz);
                if (_containsKey) {
                    EClassifier targetType0 = accessorArgumentType.get(clazz);
                    if (targetType0 != targetType) {
                        String _name = clazz.getName();
                        String _plus = "ERROR: Duplicate argument type definition for class '" + _name;
                        String _plus_1 = String.valueOf(_plus) + "'";
                        System.err.println(_plus_1);
                    }
                } else {
                    accessorArgumentType.put(clazz, targetType);
                }
            }
            if (!(_isNonFrancaMixin = mixin_1.isNonFrancaMixin())) continue;
            isNonFrancaMixin.add(clazz);
            String _accessorRootPrefix = mixin_1.getAccessorRootPrefix();
            boolean bl2 = _tripleNotEquals = _accessorRootPrefix != null;
            if (!_tripleNotEquals) continue;
            String prefix = mixin_1.getAccessorRootPrefix();
            nonFrancaMixinRootPrefix.put(clazz, prefix);
        }
        _function_1 = new Functions.Function1<IFDeployExtension.HostMixinDef, Boolean>(){

            public Boolean apply(IFDeployExtension.HostMixinDef it) {
                return it.isChildMixin();
            }
        };
        _function_2 = new Functions.Function1<IFDeployExtension.HostMixinDef, EClass>(){

            public EClass apply(IFDeployExtension.HostMixinDef it) {
                return it.getHostingClass();
            }
        };
        Set children = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(extension.getMixins(), (Functions.Function1)_function_1), (Functions.Function1)_function_2));
        Functions.Function1<IFDeployExtension.HostMixinDef, Boolean> _function_3 = new Functions.Function1<IFDeployExtension.HostMixinDef, Boolean>(){

            public Boolean apply(IFDeployExtension.HostMixinDef it) {
                String _accessorRootPrefix = it.getAccessorRootPrefix();
                return _accessorRootPrefix != null;
            }
        };
        Functions.Function1<IFDeployExtension.HostMixinDef, EClass> _function_4 = new Functions.Function1<IFDeployExtension.HostMixinDef, EClass>(){

            public EClass apply(IFDeployExtension.HostMixinDef it) {
                return it.getHostingClass();
            }
        };
        Iterable roots = IterableExtensions.map((Iterable)IterableExtensions.filter(extension.getMixins(), (Functions.Function1)_function_3), (Functions.Function1)_function_4);
        for (EClass rootMixin : roots) {
            Functions.Function1<EStructuralFeature, EClassifier> _function_5 = new Functions.Function1<EStructuralFeature, EClassifier>(){

                public EClassifier apply(EStructuralFeature it) {
                    return it.getEType();
                }
            };
            Set usedClasses = IterableExtensions.toSet((Iterable)ListExtensions.map((List)rootMixin.getEStructuralFeatures(), (Functions.Function1)_function_5));
            Sets.SetView both = Sets.intersection((Set)children, (Set)usedClasses);
            mixinChildren.putAll((Object)rootMixin, (Iterable)both);
        }
    }

    private static boolean addHostingClass(IFDeployExtension.Host host, EClass clazz) {
        boolean _not;
        boolean _xblockexpression = false;
        boolean _containsKey = hostingClasses.containsKey(host);
        boolean bl = _not = !_containsKey;
        if (_not) {
            hostingClasses.put(host, CollectionLiterals.newHashSet((Object[])new EClass[0]));
        }
        _xblockexpression = hostingClasses.get(host).add(clazz);
        return _xblockexpression;
    }

    private static EClassifier getClassOfTargetFeature(EClass clazz) {
        EClassifier _xblockexpression = null;
        Functions.Function1<EReference, Boolean> _function = new Functions.Function1<EReference, Boolean>(){

            public Boolean apply(EReference it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)"target");
            }
        };
        EReference targetFeature = (EReference)IterableExtensions.findFirst((Iterable)clazz.getEAllReferences(), (Functions.Function1)_function);
        EClassifier _xifexpression = null;
        if (targetFeature != null) {
            EClassifier _xifexpression_1 = null;
            EClassifier _eType = targetFeature.getEType();
            _xifexpression_1 = _eType instanceof EClassifier ? targetFeature.getEType() : null;
            _xifexpression = _xifexpression_1;
        } else {
            _xifexpression = null;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static Map<IFDeployExtension.Host, IFDeployExtension> getHosts() {
        HashMap _xblockexpression = null;
        HashMap result = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        Collection<IFDeployExtension> _extensions = ExtensionRegistry.getExtensions();
        for (final IFDeployExtension ext : _extensions) {
            Functions.Function1<IFDeployExtension.Host, IFDeployExtension> _function = new Functions.Function1<IFDeployExtension.Host, IFDeployExtension>(){

                public IFDeployExtension apply(IFDeployExtension.Host it) {
                    return ext;
                }
            };
            Map extHosts = IterableExtensions.toInvertedMap(ExtensionUtils.getAllHosts(ext), (Functions.Function1)_function);
            result.putAll(extHosts);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static IFDeployExtension.Host findHost(final String hostname) {
        IFDeployExtension.Host _xblockexpression = null;
        Set<IFDeployExtension.Host> hosts = ExtensionRegistry.getHosts().keySet();
        Functions.Function1<IFDeployExtension.Host, Boolean> _function = new Functions.Function1<IFDeployExtension.Host, Boolean>(){

            public Boolean apply(IFDeployExtension.Host it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)hostname);
            }
        };
        _xblockexpression = (IFDeployExtension.Host)IterableExtensions.findFirst(hosts, (Functions.Function1)_function);
        return _xblockexpression;
    }

    public static Map<IFDeployExtension.RootDef, IFDeployExtension> getRoots() {
        HashMap _xblockexpression = null;
        HashMap result = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        Collection<IFDeployExtension> _extensions = ExtensionRegistry.getExtensions();
        for (IFDeployExtension ext : _extensions) {
            Collection<IFDeployExtension.RootDef> _roots = ext.getRoots();
            for (IFDeployExtension.RootDef root : _roots) {
                result.put(root, ext);
            }
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static IFDeployExtension.RootDef findRoot(final String rootTag) {
        IFDeployExtension.RootDef _xblockexpression = null;
        Functions.Function1<IFDeployExtension, Collection<IFDeployExtension.RootDef>> _function = new Functions.Function1<IFDeployExtension, Collection<IFDeployExtension.RootDef>>(){

            public Collection<IFDeployExtension.RootDef> apply(IFDeployExtension it) {
                return it.getRoots();
            }
        };
        Iterable roots = Iterables.concat((Iterable)IterableExtensions.map(ExtensionRegistry.getExtensions(), (Functions.Function1)_function));
        Functions.Function1<IFDeployExtension.RootDef, Boolean> _function_1 = new Functions.Function1<IFDeployExtension.RootDef, Boolean>(){

            public Boolean apply(IFDeployExtension.RootDef it) {
                String _tag = it.getTag();
                return Objects.equal((Object)_tag, (Object)rootTag);
            }
        };
        _xblockexpression = (IFDeployExtension.RootDef)IterableExtensions.findFirst((Iterable)roots, (Functions.Function1)_function_1);
        return _xblockexpression;
    }

    public static boolean hasHostSubtree(IFDeployExtension.AbstractElementDef elem, IFDeployExtension.Host host) {
        return ExtensionUtils.getAllHosts(elem).contains(host);
    }

    public static IFDeployExtension.AbstractElementDef getElement(final FDAbstractExtensionElement elem) {
        IFDeployExtension.AbstractElementDef _switchResult = null;
        boolean _matched = false;
        if (elem instanceof FDExtensionRoot) {
            _matched = true;
            _switchResult = ExtensionRegistry.findRoot(((FDExtensionRoot)elem).getTag());
        }
        if (!_matched && elem instanceof FDExtensionElement) {
            _matched = true;
            IFDeployExtension.ElementDef _xblockexpression = null;
            EObject _eContainer = ((FDExtensionElement)elem).eContainer();
            IFDeployExtension.AbstractElementDef parent = ExtensionRegistry.getElement((FDAbstractExtensionElement)_eContainer);
            Functions.Function1<IFDeployExtension.ElementDef, Boolean> _function = new Functions.Function1<IFDeployExtension.ElementDef, Boolean>(){

                public Boolean apply(IFDeployExtension.ElementDef it) {
                    String _tag = it.getTag();
                    String _tag_1 = ((FDExtensionElement)elem).getTag();
                    return Objects.equal((Object)_tag, (Object)_tag_1);
                }
            };
            _xblockexpression = (IFDeployExtension.ElementDef)IterableExtensions.findFirst(parent.getChildren(), (Functions.Function1)_function);
            _switchResult = _xblockexpression;
        }
        if (!_matched) {
            return null;
        }
        return _switchResult;
    }

    public static Iterable<IFDeployExtension.Host> getAdditionalHosts(EClass clazz) {
        ArrayList _xblockexpression = null;
        if (extensions == null) {
            ExtensionRegistry.initializeValidators();
        }
        ArrayList result = allAdditionalHosts.get(clazz);
        ArrayList _xifexpression = null;
        _xifexpression = result != null ? result : CollectionLiterals.newArrayList((Object[])new IFDeployExtension.Host[0]);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static Set<EClass> getHostingClasses(IFDeployExtension.Host host) {
        HashSet _xblockexpression = null;
        if (extensions == null) {
            ExtensionRegistry.initializeValidators();
        }
        HashSet result = hostingClasses.get(host);
        HashSet _xifexpression = null;
        _xifexpression = result != null ? result : CollectionLiterals.newHashSet((Object[])new EClass[0]);
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static EClassifier getAccessorArgumentType(EClass clazz) {
        Object _xifexpression = null;
        boolean _containsKey = accessorArgumentType.containsKey(clazz);
        _xifexpression = _containsKey ? accessorArgumentType.get(clazz) : clazz;
        return _xifexpression;
    }

    public static IFDeployExtension getMixinExtension(EClass clazz) {
        return mixinExtensions.get(clazz);
    }

    public static Set<EClass> getNonFrancaMixinRoots() {
        return nonFrancaMixinRootPrefix.keySet();
    }

    public static String getNonFrancaMixinPrefix(EClass clazz) {
        return nonFrancaMixinRootPrefix.get(clazz);
    }

    public static Iterable<EClass> getMixinClasses(EClass rootClass) {
        return Iterables.concat((Iterable)mixinChildren.get((Object)rootClass), (Iterable)CollectionLiterals.newArrayList((Object[])new EClass[]{rootClass}));
    }

    public static boolean isNonFrancaMixinHost(EClass clazz) {
        return isNonFrancaMixin.contains(clazz);
    }

    public static Map<IFDeployExtension.TypeDef, IFDeployExtension> getTypes() {
        HashMap _xblockexpression = null;
        HashMap result = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        Collection<IFDeployExtension> _extensions = ExtensionRegistry.getExtensions();
        for (IFDeployExtension ext : _extensions) {
            Collection<IFDeployExtension.TypeDef> _types = ext.getTypes();
            for (IFDeployExtension.TypeDef type : _types) {
                result.put(type, ext);
            }
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public static IFDeployExtension.TypeDef findType(final String typeName) {
        IFDeployExtension.TypeDef _xblockexpression = null;
        Functions.Function1<IFDeployExtension, Collection<IFDeployExtension.TypeDef>> _function = new Functions.Function1<IFDeployExtension, Collection<IFDeployExtension.TypeDef>>(){

            public Collection<IFDeployExtension.TypeDef> apply(IFDeployExtension it) {
                return it.getTypes();
            }
        };
        Iterable types = Iterables.concat((Iterable)IterableExtensions.map(ExtensionRegistry.getExtensions(), (Functions.Function1)_function));
        Functions.Function1<IFDeployExtension.TypeDef, Boolean> _function_1 = new Functions.Function1<IFDeployExtension.TypeDef, Boolean>(){

            public Boolean apply(IFDeployExtension.TypeDef it) {
                String _name = it.getName();
                return Objects.equal((Object)_name, (Object)typeName);
            }
        };
        _xblockexpression = (IFDeployExtension.TypeDef)IterableExtensions.findFirst((Iterable)types, (Functions.Function1)_function_1);
        return _xblockexpression;
    }
}

