/*
 * Decompiled with CFR 0.152.
 */
package org.franca.deploymodel.extensions;

import com.google.common.base.Objects;
import java.util.Collection;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.franca.deploymodel.dsl.fDeploy.FDElement;
import org.franca.deploymodel.dsl.fDeploy.FDValue;

public interface IFDeployExtension {
    public String getShortDescription();

    public Collection<RootDef> getRoots();

    public Collection<HostMixinDef> getMixins();

    public Collection<TypeDef> getTypes();

    public static abstract class AbstractElementDef {
        private String tag;
        private EClass targetClass;
        private Nameable isNameable;
        private Collection<Host> hosts;
        private Collection<ElementDef> children;

        public AbstractElementDef(String tag, Nameable isNameable, Collection<Host> hosts) {
            this(tag, null, isNameable, hosts);
        }

        public AbstractElementDef(String tag, EClass targetClass, Nameable isNameable, Collection<Host> hosts) {
            this.tag = tag;
            this.targetClass = targetClass;
            this.isNameable = isNameable;
            this.hosts = hosts;
            this.children = CollectionLiterals.newArrayList((Object[])new ElementDef[0]);
        }

        public void addChild(ElementDef child) {
            this.children.add(child);
            child.setParent(this);
        }

        public String getTag() {
            return this.tag;
        }

        public boolean mayHaveName() {
            return this.isNameable != Nameable.NO_NAME;
        }

        public boolean mustHaveName() {
            return this.isNameable == Nameable.MANDATORY_NAME;
        }

        public EClass getTargetClass() {
            return this.targetClass;
        }

        public Collection<Host> getHosts() {
            return this.hosts;
        }

        public Collection<ElementDef> getChildren() {
            return this.children;
        }

        public static enum Nameable {
            NO_NAME,
            OPTIONAL_NAME,
            MANDATORY_NAME;

        }
    }

    public static class ElementDef
    extends AbstractElementDef {
        private AbstractElementDef parent;

        public ElementDef(String tag, AbstractElementDef.Nameable isNameable, Collection<Host> hosts) {
            super(tag, isNameable, hosts);
        }

        public ElementDef(String tag, EClass targetClass, AbstractElementDef.Nameable isNameable, Collection<Host> hosts) {
            super(tag, targetClass, isNameable, hosts);
        }

        public void setParent(AbstractElementDef parent) {
            this.parent = parent;
        }
    }

    public static class Host {
        private String name;

        public Host(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return "\ufffd" + this.name + "\ufffd";
        }
    }

    public static class HostMixinDef {
        public static final String CHILD_ELEMENT = "$CHILD_ELEMENT$";
        private EClass clazz;
        private AccessorArgumentStyle argumentStyle;
        private String accessorPrefix;
        private Collection<Host> hosts;

        public HostMixinDef(EClass clazz, AccessorArgumentStyle argumentStyle, Collection<Host> hosts) {
            this(clazz, argumentStyle, null, hosts);
        }

        public HostMixinDef(EClass clazz, AccessorArgumentStyle argumentStyle, String accessorPrefix, Collection<Host> hosts) {
            this.clazz = clazz;
            this.argumentStyle = argumentStyle;
            this.accessorPrefix = accessorPrefix;
            this.hosts = hosts;
        }

        public EClass getHostingClass() {
            return this.clazz;
        }

        public AccessorArgumentStyle getAccessorArgument() {
            return this.argumentStyle;
        }

        public Collection<Host> getHosts() {
            return this.hosts;
        }

        public boolean isNonFrancaMixin() {
            return this.accessorPrefix != null;
        }

        public String getAccessorRootPrefix() {
            String _xifexpression = null;
            _xifexpression = this.accessorPrefix == null || Objects.equal((Object)this.accessorPrefix, (Object)CHILD_ELEMENT) ? null : this.accessorPrefix;
            return _xifexpression;
        }

        public boolean isChildMixin() {
            return Objects.equal((Object)this.accessorPrefix, (Object)CHILD_ELEMENT);
        }

        public static enum AccessorArgumentStyle {
            BY_RULE_CLASS,
            BY_TARGET_FEATURE;

        }
    }

    public static class RootDef
    extends AbstractElementDef {
        private IFDeployExtension extension;

        public RootDef(IFDeployExtension extension, String tag, AbstractElementDef.Nameable isNameable, Collection<Host> hosts) {
            this(extension, tag, null, isNameable, hosts);
        }

        public RootDef(IFDeployExtension extension, String tag, EClass targetClass, AbstractElementDef.Nameable isNameable, Collection<Host> hosts) {
            super(tag, targetClass, isNameable, hosts);
            this.extension = extension;
        }

        public IFDeployExtension getExtension() {
            return this.extension;
        }
    }

    public static class TypeDef {
        private String name;
        private Functions.Function1<? super IScope, ? extends IScope> scopeFunc;
        private Functions.Function1<? super FDElement, ? extends FDValue> defaultCreator;
        private Class<? extends EObject> runtimeType;

        public TypeDef(String name, Functions.Function1<? super IScope, ? extends IScope> scopeFunc, Functions.Function1<? super FDElement, ? extends FDValue> defaultCreator, Class<? extends EObject> runtimeType) {
            this.name = name;
            this.scopeFunc = scopeFunc;
            this.defaultCreator = defaultCreator;
            this.runtimeType = runtimeType;
        }

        public String getName() {
            return this.name;
        }

        public IScope getScope(IScope all) {
            IScope _xifexpression = null;
            _xifexpression = this.scopeFunc == null ? IScope.NULLSCOPE : (IScope)this.scopeFunc.apply((Object)all);
            return _xifexpression;
        }

        public FDValue createDefaultValue(FDElement element) {
            FDValue _apply = null;
            if (this.defaultCreator != null) {
                _apply = (FDValue)this.defaultCreator.apply((Object)element);
            }
            return _apply;
        }

        public Class<? extends EObject> getRuntimeType() {
            return this.runtimeType;
        }
    }
}

