/*
 * Decompiled with CFR 0.152.
 */
package org.freecompany.util.text;

import org.freecompany.util.text.Comparison;
import org.freecompany.util.text.State;

public class Scanner {
    public static final int scan(State state, CharSequence sequence) {
        CharSequence target = state.sequence();
        int end = Scanner.end(target, sequence);
        int match = Scanner.scan(target, sequence, state.position(), end);
        state.position(match == -1 ? end : match + sequence.length());
        return match;
    }

    public static final boolean skip(State state, CharSequence sequence) {
        int match = Scanner.skip(state.sequence(), sequence, state.position());
        if (match != state.position()) {
            state.position(match);
            return true;
        }
        return false;
    }

    public static final boolean startsWith(CharSequence target, CharSequence sequence) {
        return Scanner.match(target, sequence, 0);
    }

    public static final boolean endsWith(CharSequence target, CharSequence sequence) {
        return Scanner.match(target, sequence, target.length() - sequence.length());
    }

    public static final int last(CharSequence target, CharSequence sequence) {
        return Scanner.scan(target, sequence, target.length() - 1, 0);
    }

    public static final int scan(CharSequence target, CharSequence sequence) {
        return Scanner.scan(target, sequence, 0);
    }

    public static final int scan(CharSequence target, CharSequence sequence, int start) {
        return Scanner.scan(target, sequence, start, Scanner.end(target, sequence));
    }

    public static final int scan(CharSequence target, CharSequence sequence, int start, int end) {
        if (start < end) {
            while (start < end) {
                if (Scanner.match(target, sequence, start)) {
                    return start;
                }
                ++start;
            }
        } else {
            while (end <= start) {
                if (Scanner.match(target, sequence, start)) {
                    return start;
                }
                --start;
            }
        }
        return -1;
    }

    public static final int skip(CharSequence target, CharSequence sequence) {
        return Scanner.skip(target, sequence, 0);
    }

    public static final int skip(CharSequence target, CharSequence sequence, int index) {
        return Scanner.match(target, sequence, index) ? index + sequence.length() : index;
    }

    public static final boolean match(CharSequence target, CharSequence sequence, int start) {
        return Scanner.match(target, sequence, start, start + sequence.length());
    }

    public static final boolean match(CharSequence target, CharSequence sequence, int start, int end) {
        int base = start;
        while (start < end) {
            if (!Comparison.equals(target.charAt(start), sequence.charAt(start - base))) {
                return false;
            }
            ++start;
        }
        return true;
    }

    protected static final int end(CharSequence target, CharSequence sequence) {
        return target.length() - sequence.length() + 1;
    }
}

