/*
 * Decompiled with CFR 0.152.
 */
package org.freecompany.util.text;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.util.Iterator;
import org.freecompany.util.text.ByteBufferWrapper;
import org.freecompany.util.text.CharSequenceAggregate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class State
implements CharSequence,
Iterator<Character>,
Iterable<Character> {
    protected CharSequence sequence = CharSequenceAggregate.empty();
    protected int position;
    protected int mark;

    public void clear() {
        this.sequence = CharSequenceAggregate.empty();
        this.position = 0;
        this.mark = 0;
    }

    public void append(CharSequence sequence) {
        if (sequence == null) {
            throw new NullPointerException();
        }
        this.sequence = CharSequenceAggregate.add(this.sequence, sequence);
    }

    public void append(ByteBuffer buffer) {
        this.append(new ByteBufferWrapper(buffer));
    }

    public void append(ByteBuffer buffer, CharsetDecoder decoder) throws CharacterCodingException {
        this.append(decoder.decode(buffer));
    }

    public CharSequence expunge() {
        return this.expunge(false);
    }

    public CharSequence expunge(boolean force) {
        CharSequence root = this.sequence instanceof CharSequenceAggregate ? ((CharSequenceAggregate)this.sequence).root() : this.sequence;
        if (root != CharSequenceAggregate.NULL && (force || this.position >= root.length())) {
            this.sequence = CharSequenceAggregate.remove(this.sequence, root);
            this.position = Math.max(0, this.position - root.length());
            this.mark = Math.max(0, this.mark - root.length());
            return root;
        }
        return null;
    }

    public CharSequence sequence() {
        return this.sequence;
    }

    @Override
    public CharSequence subSequence(int from, int to) {
        return this.sequence.subSequence(from, to);
    }

    @Override
    public char charAt(int index) {
        return this.sequence.charAt(index);
    }

    @Override
    public int length() {
        return this.sequence.length();
    }

    @Override
    public Iterator<Character> iterator() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharSequence slice() {
        try {
            CharSequence charSequence = this.sequence.subSequence(this.mark, this.position);
            return charSequence;
        }
        finally {
            this.mark();
        }
    }

    public final char previous() {
        return this.sequence.charAt(this.position - 1);
    }

    public final char peek() {
        return this.sequence.charAt(this.position);
    }

    public final char peekPlus(int advance) {
        return this.sequence.charAt(this.position + advance);
    }

    @Override
    public final Character next() {
        return Character.valueOf(this.sequence.charAt(this.position++));
    }

    public final int remaining() {
        return this.sequence.length() - this.position;
    }

    @Override
    public final boolean hasNext() {
        return this.sequence.length() > this.position;
    }

    public final CharSequence rest() {
        this.position(this.sequence.length());
        return this.slice();
    }

    public final void position(int position) {
        this.position = position;
    }

    public final int position() {
        return this.position;
    }

    public boolean marked() {
        return this.mark != 0 && this.mark != this.position;
    }

    public final void mark() {
        this.mark = this.position;
    }

    public final int getMark() {
        return this.mark;
    }

    public final void reset() {
        this.position = this.mark;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

