/*
 * Decompiled with CFR 0.152.
 */
package org.freecompany.util.text;

import org.freecompany.util.text.Scanner;
import org.freecompany.util.text.TokenizerState;

public class Tokenizer
extends Scanner {
    protected static final CharSequence sub(CharSequence target, int start, int end, boolean trim) {
        if (trim) {
            while (start < end - 1 && Character.isWhitespace(target.charAt(start))) {
                ++start;
            }
            while (end > start && Character.isWhitespace(target.charAt(end - 1))) {
                --end;
            }
        }
        return target.subSequence(start, end);
    }

    public static final CharSequence before(TokenizerState state, CharSequence sequence) {
        state.mark();
        int start = state.position();
        int end = Tokenizer.scan(state, sequence);
        if (end == -1) {
            state.reset();
            return null;
        }
        return Tokenizer.sub(state.sequence(), start, end, state.trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final CharSequence after(TokenizerState state, CharSequence sequence) {
        state.mark();
        if (Tokenizer.scan(state, sequence) == -1) {
            state.reset();
            return null;
        }
        CharSequence target = state.sequence();
        try {
            CharSequence charSequence = Tokenizer.sub(target, state.position(), target.length(), state.trim());
            return charSequence;
        }
        finally {
            state.position(target.length());
        }
    }

    public static final CharSequence between(TokenizerState state, CharSequence one, CharSequence two) {
        state.mark();
        if (Tokenizer.scan(state, one) == -1) {
            state.reset();
            return null;
        }
        int start = state.position();
        int end = Tokenizer.scan(state, two);
        if (end == -1) {
            state.reset();
            return null;
        }
        return Tokenizer.sub(state.sequence(), start, end, state.trim());
    }

    public static final CharSequence rest(TokenizerState state) {
        int start = state.position();
        int end = state.sequence().length();
        state.position(end);
        return Tokenizer.sub(state.sequence(), start, end, state.trim());
    }

    public static final CharSequence before(CharSequence target, CharSequence sequence) {
        return Tokenizer.before(target, sequence, false);
    }

    public static final CharSequence before(CharSequence target, CharSequence sequence, boolean trim) {
        int start = Tokenizer.scan(target, sequence);
        return start == -1 ? null : Tokenizer.sub(target, 0, start, trim);
    }

    public static final CharSequence before(CharSequence target, int start) {
        return Tokenizer.before(target, start, false);
    }

    public static final CharSequence before(CharSequence target, int start, boolean trim) {
        return start < 0 || start >= target.length() ? null : Tokenizer.sub(target, 0, start, trim);
    }

    public static final CharSequence after(CharSequence target, CharSequence sequence) {
        return Tokenizer.after(target, sequence, false);
    }

    public static final CharSequence after(CharSequence target, int index) {
        return Tokenizer.after(target, index, false);
    }

    public static final CharSequence after(CharSequence target, CharSequence sequence, boolean trim) {
        int start = Tokenizer.scan(target, sequence);
        return start == -1 ? null : Tokenizer.sub(target, start + sequence.length(), target.length(), trim);
    }

    public static final CharSequence after(CharSequence target, int start, boolean trim) {
        return start < 0 || start >= target.length() ? null : Tokenizer.sub(target, start + 1, target.length(), trim);
    }

    public static final CharSequence between(CharSequence target, CharSequence one, CharSequence two) {
        return Tokenizer.between(target, one, two, false);
    }

    public static final CharSequence between(CharSequence target, CharSequence one, CharSequence two, boolean trim) {
        int start = Tokenizer.scan(target, one);
        if (start == -1) {
            return null;
        }
        int end = Tokenizer.scan(target, two, start + 1);
        return end == -1 ? null : Tokenizer.sub(target, start + one.length(), end, trim);
    }
}

