/*
 * Decompiled with CFR 0.152.
 */
package org.freecompany.util.text;

import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnicodeSequenceIterator
implements Iterator<Integer> {
    protected CharSequence sequence;
    protected int count;

    public UnicodeSequenceIterator(CharSequence sequence) {
        this.sequence = sequence;
    }

    public UnicodeSequenceIterator(CharSequence sequence, int count) {
        this.count = count;
        this.sequence = sequence;
    }

    @Override
    public boolean hasNext() {
        if (this.count >= this.sequence.length()) {
            return false;
        }
        if (this.count < this.sequence.length() + 2) {
            return true;
        }
        return Character.isSurrogatePair(this.sequence.charAt(this.count), this.sequence.charAt(this.count + 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer next() {
        try {
            Integer n = this.peek();
            return n;
        }
        finally {
            ++this.count;
        }
    }

    public Integer peek() {
        if (Character.isLowSurrogate(this.sequence.charAt(this.count))) {
            return Character.toCodePoint(this.sequence.charAt(this.count), this.sequence.charAt(this.count + 1));
        }
        return this.sequence.charAt(this.count);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

