/*
 * Decompiled with CFR 0.152.
 */
package org.freecompany.util.text;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Formatter;

public class Util {
    public static void dump(byte[] data) {
        Util.dump(data, (Appendable)System.out);
    }

    public static void dump(byte[] data, Appendable out) {
        Util.dump(ByteBuffer.wrap(data), out);
    }

    public static void dump(char[] data) {
        Util.dump(data, (Appendable)System.out);
    }

    public static void dump(CharSequence data) {
        Util.dump(Charset.forName("US-ASCII").encode(CharBuffer.wrap(data)), (Appendable)System.out);
    }

    public static void dump(char[] data, Appendable out) {
        Util.dump(Charset.forName("US-ASCII").encode(CharBuffer.wrap(data)), out);
    }

    public static void dump(ByteBuffer buf, Appendable out) {
        Formatter fmt = new Formatter(out);
        int pos = buf.position();
        fmt.format("%8x:", pos & 0xFFFFFFF0);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < (pos & 0xF); ++i) {
            fmt.format("   ", new Object[0]);
            builder.append(' ');
        }
        while (buf.hasRemaining()) {
            byte b = buf.get();
            fmt.format(" %2x", b);
            if (32 <= b && b < 127) {
                builder.append((char)b);
            } else {
                builder.append(' ');
            }
            if (!buf.hasRemaining() || (buf.position() & 0xF) != 0) continue;
            fmt.format(" %s\n%8x:", builder, buf.position());
            builder.setLength(0);
        }
        buf.position(pos);
    }

    public static String hex(byte[] data) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream printer = new PrintStream(baos);
        for (byte b : data) {
            printer.format("%02x", b);
        }
        printer.flush();
        return baos.toString();
    }
}

