/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.gstreamer.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.VolatileImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.freedesktop.gstreamer.Buffer;
import org.freedesktop.gstreamer.Caps;
import org.freedesktop.gstreamer.Element;
import org.freedesktop.gstreamer.FlowReturn;
import org.freedesktop.gstreamer.Sample;
import org.freedesktop.gstreamer.Structure;
import org.freedesktop.gstreamer.elements.AppSink;

public class GstVideoComponent
extends JComponent {
    private final Lock bufferLock = new ReentrantLock();
    private final AppSink videosink;
    private final boolean useVolatile;
    private BufferedImage currentImage = null;
    private RenderComponent renderComponent = new RenderComponent();
    private boolean keepAspect = true;
    private Timer resourceTimer;
    private VolatileImage volatileImage;
    private boolean frameRendered = false;
    private volatile boolean updatePending = false;
    private ActionListener resourceReaper = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (!GstVideoComponent.this.frameRendered) {
                if (GstVideoComponent.this.volatileImage != null) {
                    GstVideoComponent.this.volatileImage.flush();
                    GstVideoComponent.this.volatileImage = null;
                }
                GstVideoComponent.this.resourceTimer.stop();
            }
            GstVideoComponent.this.frameRendered = false;
        }
    };
    private int imgWidth = 0;
    private int imgHeight = 0;

    public GstVideoComponent() {
        this(new AppSink("GstVideoComponent"));
    }

    public GstVideoComponent(AppSink appsink) {
        this.videosink = appsink;
        this.videosink.set("emit-signals", (Object)true);
        AppSinkListener listener = new AppSinkListener();
        this.videosink.connect((AppSink.NEW_SAMPLE)listener);
        this.videosink.connect((AppSink.NEW_PREROLL)listener);
        StringBuilder caps = new StringBuilder("video/x-raw,pixel-aspect-ratio=1/1,");
        if (ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
            caps.append("format=BGRx");
        } else {
            caps.append("format=xRGB");
        }
        this.videosink.setCaps(new Caps(caps.toString()));
        this.useVolatile = true;
        this.resourceTimer = new Timer(250, this.resourceReaper);
        this.setLayout(null);
        this.add(this.renderComponent);
        this.renderComponent.addPropertyChangeListener("preferredSize", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                GstVideoComponent.this.setPreferredSize(GstVideoComponent.this.renderComponent.getPreferredSize());
                GstVideoComponent.this.scaleVideoOutput();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent arg0) {
                GstVideoComponent.this.scaleVideoOutput();
            }
        });
        this.renderComponent.setBounds(this.getBounds());
        this.setOpaque(true);
        this.setBackground(Color.BLACK);
    }

    private void scaleVideoOutput() {
        RenderComponent child = this.renderComponent;
        Dimension childSize = ((Component)child).getPreferredSize();
        int width = this.getWidth();
        int height = this.getHeight();
        double aspect = this.keepAspect ? (double)childSize.width / (double)childSize.height : 1.0;
        int scaledHeight = (int)((double)width / aspect);
        if (!this.keepAspect) {
            child.setBounds(0, 0, width, height);
        } else if (scaledHeight < height) {
            int y = (height - scaledHeight) / 2;
            child.setBounds(0, y, width, scaledHeight);
        } else {
            int scaledWidth = (int)((double)height * aspect);
            int x = (width - scaledWidth) / 2;
            child.setBounds(x, 0, scaledWidth, height);
        }
    }

    public Element getElement() {
        return this.videosink;
    }

    public void setKeepAspect(boolean keepAspect) {
        this.keepAspect = keepAspect;
    }

    @Override
    public boolean isLightweight() {
        return true;
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isOpaque()) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.dispose();
        }
    }

    private void renderVolatileImage(BufferedImage bufferedImage) {
        do {
            int w = bufferedImage.getWidth();
            int h = bufferedImage.getHeight();
            GraphicsConfiguration gc = this.getGraphicsConfiguration();
            if (this.volatileImage == null || this.volatileImage.getWidth() != w || this.volatileImage.getHeight() != h || this.volatileImage.validate(gc) == 2) {
                if (this.volatileImage != null) {
                    this.volatileImage.flush();
                }
                this.volatileImage = gc.createCompatibleVolatileImage(w, h);
                this.volatileImage.setAccelerationPriority(1.0f);
            }
            Graphics2D g = this.volatileImage.createGraphics();
            g.drawImage((Image)bufferedImage, 0, 0, null);
            g.dispose();
        } while (this.volatileImage.contentsLost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void volatileRender(Graphics g, int x, int y, int w, int h) {
        do {
            if (this.updatePending || this.volatileImage == null || this.volatileImage.validate(this.getGraphicsConfiguration()) != 0) {
                this.bufferLock.lock();
                try {
                    this.updatePending = false;
                    this.renderVolatileImage(this.currentImage);
                }
                finally {
                    this.bufferLock.unlock();
                }
            }
            g.drawImage(this.volatileImage, x, y, w, h, null);
        } while (this.volatileImage.contentsLost());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void heapRender(Graphics g, int x, int y, int w, int h) {
        this.bufferLock.lock();
        try {
            this.updatePending = false;
            g.drawImage(this.currentImage, x, y, w, h, null);
        }
        finally {
            this.bufferLock.unlock();
        }
    }

    private void render(Graphics g, int x, int y, int w, int h) {
        if (this.useVolatile) {
            this.volatileRender(g, x, y, w, h);
        } else {
            this.heapRender(g, x, y, w, h);
        }
        if (!this.frameRendered) {
            this.frameRendered = true;
            if (!this.resourceTimer.isRunning()) {
                this.resourceTimer.restart();
            }
        }
    }

    private final void update(final int width, final int height) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (width != GstVideoComponent.this.imgWidth || height != GstVideoComponent.this.imgHeight) {
                    GstVideoComponent.this.renderComponent.setPreferredSize(new Dimension(width, height));
                    GstVideoComponent.this.imgWidth = width;
                    GstVideoComponent.this.imgHeight = height;
                }
                if (GstVideoComponent.this.renderComponent.isVisible()) {
                    GstVideoComponent.this.renderComponent.paintImmediately(0, 0, GstVideoComponent.this.renderComponent.getWidth(), GstVideoComponent.this.renderComponent.getHeight());
                }
            }
        });
    }

    private BufferedImage getBufferedImage(int width, int height) {
        if (this.currentImage != null && this.currentImage.getWidth() == width && this.currentImage.getHeight() == height) {
            return this.currentImage;
        }
        if (this.currentImage != null) {
            this.currentImage.flush();
        }
        this.currentImage = new BufferedImage(width, height, 1);
        this.currentImage.setAccelerationPriority(0.0f);
        return this.currentImage;
    }

    private class AppSinkListener
    implements AppSink.NEW_SAMPLE,
    AppSink.NEW_PREROLL {
        private AppSinkListener() {
        }

        public FlowReturn newSample(AppSink elem) {
            Sample sample = elem.pullSample();
            Structure capsStruct = sample.getCaps().getStructure(0);
            int w = capsStruct.getInteger("width");
            int h = capsStruct.getInteger("height");
            Buffer buffer = sample.getBuffer();
            ByteBuffer bb = buffer.map(false);
            if (bb != null) {
                this.rgbFrame(false, w, h, bb.asIntBuffer());
                buffer.unmap();
            }
            sample.dispose();
            return FlowReturn.OK;
        }

        public FlowReturn newPreroll(AppSink elem) {
            Sample sample = elem.pullPreroll();
            Structure capsStruct = sample.getCaps().getStructure(0);
            int w = capsStruct.getInteger("width");
            int h = capsStruct.getInteger("height");
            Buffer buffer = sample.getBuffer();
            ByteBuffer bb = buffer.map(false);
            if (bb != null) {
                this.rgbFrame(true, w, h, bb.asIntBuffer());
                buffer.unmap();
            }
            sample.dispose();
            return FlowReturn.OK;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rgbFrame(boolean isPrerollFrame, int width, int height, IntBuffer rgb) {
            if (!GstVideoComponent.this.bufferLock.tryLock()) {
                return;
            }
            if (GstVideoComponent.this.updatePending && !isPrerollFrame) {
                GstVideoComponent.this.bufferLock.unlock();
                return;
            }
            try {
                BufferedImage renderImage = GstVideoComponent.this.getBufferedImage(width, height);
                int[] pixels = ((DataBufferInt)renderImage.getRaster().getDataBuffer()).getData();
                rgb.get(pixels, 0, width * height);
                GstVideoComponent.this.updatePending = true;
            }
            finally {
                GstVideoComponent.this.bufferLock.unlock();
            }
            GstVideoComponent.this.update(GstVideoComponent.this.currentImage.getWidth(), GstVideoComponent.this.currentImage.getHeight());
        }
    }

    private class RenderComponent
    extends JComponent {
        private static final long serialVersionUID = -4736605073704494268L;

        private RenderComponent() {
        }

        @Override
        protected void paintComponent(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            if (GstVideoComponent.this.currentImage != null) {
                GraphicsConfiguration gc = this.getGraphicsConfiguration();
                GstVideoComponent.this.render(g2d, 0, 0, width, height);
            } else {
                g2d.setColor(this.getBackground());
                g2d.fillRect(0, 0, width, height);
            }
            g2d.dispose();
        }

        @Override
        public boolean isOpaque() {
            return GstVideoComponent.this.isOpaque();
        }

        @Override
        public boolean isLightweight() {
            return true;
        }
    }
}

