/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.wayland.client;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.freedesktop.jaccall.Pointer;
import org.freedesktop.wayland.client.EventQueue;
import org.freedesktop.wayland.client.jaccall.WaylandClientCore;
import org.freedesktop.wayland.util.Arguments;
import org.freedesktop.wayland.util.Dispatcher;
import org.freedesktop.wayland.util.InterfaceMeta;
import org.freedesktop.wayland.util.ObjectCache;
import org.freedesktop.wayland.util.WaylandObject;

public abstract class Proxy<I>
implements WaylandObject {
    private static final Map<Class<? extends Proxy<?>>, Constructor<? extends Proxy<?>>> PROXY_CONSTRUCTORS = new HashMap();
    public final Long pointer;
    private final int version;
    private final I implementation;
    private final Pointer<Object> jObjectPointer;

    protected Proxy(long pointer) {
        this(pointer, null, 99);
    }

    protected Proxy(Long pointer, I implementation, int version) {
        this.pointer = pointer;
        this.implementation = implementation;
        this.version = version;
        ObjectCache.store((long)this.pointer, (Object)this);
        this.jObjectPointer = Pointer.from((Object)this);
        if (implementation != null) {
            WaylandClientCore.INSTANCE().wl_proxy_add_dispatcher(this.pointer, Dispatcher.INSTANCE.address, this.jObjectPointer.address, 0L);
        }
    }

    protected void marshal(int opcode, Arguments args) {
        WaylandClientCore.INSTANCE().wl_proxy_marshal_array(this.pointer, opcode, args.pointer.address);
        args.pointer.close();
    }

    protected void marshal(int opcode) {
        WaylandClientCore.INSTANCE().wl_proxy_marshal_array(this.pointer, opcode, 0L);
    }

    protected <J, T extends Proxy<J>> T marshalConstructor(int opcode, J implementation, int version, Class<T> newProxyCls, Arguments args) {
        T t = this.marshalConstructor(opcode, implementation, version, newProxyCls, args.pointer.address);
        args.pointer.close();
        return t;
    }

    private <J, T extends Proxy<J>> T marshalConstructor(int opcode, J implementation, int version, Class<T> newProxyCls, long argsPointer) {
        try {
            long wlProxy = WaylandClientCore.INSTANCE().wl_proxy_marshal_array_constructor(this.pointer, opcode, argsPointer, InterfaceMeta.get(newProxyCls).pointer.address);
            return this.marshalProxy(wlProxy, implementation, version, newProxyCls);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Uh oh, this is a bug!", e);
        }
    }

    private <J, T extends Proxy<J>> T marshalProxy(long pointer, J implementation, int version, Class<T> newProxyCls) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Constructor<Proxy<Object>> proxyConstructor = PROXY_CONSTRUCTORS.get(newProxyCls);
        if (proxyConstructor == null) {
            proxyConstructor = this.findMatchingConstructor(newProxyCls, Long.TYPE, implementation.getClass(), Integer.TYPE);
            PROXY_CONSTRUCTORS.put(newProxyCls, proxyConstructor);
        }
        return (T)proxyConstructor.newInstance(pointer, implementation, version);
    }

    private <J, T extends Proxy<J>> Constructor<T> findMatchingConstructor(Class<T> newProxyCls, Class<?> pointerClass, Class<?> implementationClass, Class<?> intClass) throws NoSuchMethodException {
        for (Constructor<?> constructor : newProxyCls.getConstructors()) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            if (parameterTypes.length != 3 || !parameterTypes[0].isAssignableFrom(pointerClass) || !parameterTypes[1].isAssignableFrom(implementationClass) || !parameterTypes[2].isAssignableFrom(intClass)) continue;
            return constructor;
        }
        throw new NoSuchMethodException();
    }

    public I getImplementation() {
        return this.implementation;
    }

    public int getId() {
        return WaylandClientCore.INSTANCE().wl_proxy_get_id(this.pointer);
    }

    public int getVersion() {
        return this.version;
    }

    public void setQueue(EventQueue queue) {
        WaylandClientCore.INSTANCE().wl_proxy_set_queue(this.pointer, queue.pointer);
    }

    public int hashCode() {
        return this.pointer.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Proxy)) {
            return false;
        }
        Proxy proxy = (Proxy)o;
        return this.pointer.equals(proxy.pointer);
    }

    public void destroy() {
        WaylandClientCore.INSTANCE().wl_proxy_destroy(this.pointer);
        ObjectCache.remove((long)this.pointer);
        this.jObjectPointer.close();
    }

    public Long getPointer() {
        return this.pointer;
    }
}

