/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.wayland.client.egl;

import org.freedesktop.jaccall.Pointer;
import org.freedesktop.wayland.client.Proxy;
import org.freedesktop.wayland.client.egl.jaccall.WaylandEglCore;
import org.freedesktop.wayland.util.ObjectCache;

public class EglWindow {
    public final long pointer;

    protected EglWindow(long pointer) {
        this.pointer = pointer;
        ObjectCache.store((long)this.pointer, (Object)this);
    }

    public static EglWindow create(Proxy<?> wlSurfaceProxy, int width, int height) {
        return EglWindow.get(WaylandEglCore.INSTANCE().wl_egl_window_create(wlSurfaceProxy.pointer, width, height));
    }

    public static EglWindow get(long pointer) {
        EglWindow eglWindow = (EglWindow)ObjectCache.from((long)pointer);
        if (eglWindow == null) {
            eglWindow = new EglWindow(pointer);
        }
        return eglWindow;
    }

    public void resize(int width, int height, int dx, int dy) {
        WaylandEglCore.INSTANCE().wl_egl_window_resize(this.pointer, width, height, dx, dy);
    }

    public Size getAttachedSize() {
        Pointer x = Pointer.nref((int[])new int[]{0});
        Pointer y = Pointer.nref((int[])new int[]{0});
        WaylandEglCore.INSTANCE().wl_egl_window_get_attached_size(this.pointer, x.address, y.address);
        return new Size((Integer)x.dref(), (Integer)y.dref());
    }

    public void destroy() {
        WaylandEglCore.INSTANCE().wl_egl_window_destroy(this.pointer);
        ObjectCache.remove((long)this.pointer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EglWindow)) {
            return false;
        }
        EglWindow eglWindow = (EglWindow)o;
        return this.pointer == eglWindow.pointer;
    }

    public int hashCode() {
        return new Long(this.pointer).hashCode();
    }

    public static final class Size {
        private final int width;
        private final int height;

        Size(int width, int height) {
            this.width = width;
            this.height = height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int hashCode() {
            int result = this.width;
            result = 31 * result + this.height;
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Size size = (Size)o;
            return this.height == size.height && this.width == size.width;
        }
    }
}

