package org.freedesktop.wayland.client;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.freedesktop.wayland.util.Arguments;
import org.freedesktop.wayland.util.Interface;
import org.freedesktop.wayland.util.Message;
// 
//
//    Copyright © 2008-2011 Kristian Høgsberg
//    Copyright © 2010-2011 Intel Corporation
//    Copyright © 2012-2013 Collabora, Ltd.
//
//    Permission is hereby granted, free of charge, to any person
//    obtaining a copy of this software and associated documentation files
//    (the "Software"), to deal in the Software without restriction,
//    including without limitation the rights to use, copy, modify, merge,
//    publish, distribute, sublicense, and/or sell copies of the Software,
//    and to permit persons to whom the Software is furnished to do so,
//    subject to the following conditions:
//
//    The above copyright notice and this permission notice (including the
//    next paragraph) shall be included in all copies or substantial
//    portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//    NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
//    BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
//    ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
//    CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//    SOFTWARE.
//  
/**
 * the compositor singleton
 * <p>
 *
 *       A compositor.  This object is a singleton global.  The
 *       compositor is in charge of combining the contents of multiple
 *       surfaces into one displayable output.
 *     
 */
@Interface(
  methods = {
    @Message(
  types = {
    org.freedesktop.wayland.client.WlSurfaceProxy.class
  },
  signature = "n",
  functionName = "createSurface",
  name = "create_surface"
)
,
    @Message(
  types = {
    org.freedesktop.wayland.client.WlRegionProxy.class
  },
  signature = "n",
  functionName = "createRegion",
  name = "create_region"
)

  },
  name = "wl_compositor",
  version = 4,
  events = {
  }
)
public class WlCompositorProxy extends Proxy<WlCompositorEvents> {

  public static final String INTERFACE_NAME = "wl_compositor";

  public WlCompositorProxy(long pointer, WlCompositorEvents implementation, int version) {
    super(pointer, implementation, version);
  }

  public WlCompositorProxy(long pointer) {
    super(pointer);
  }

  /**
   * create new surface
   * <p>
   *
   * 	Ask the compositor to create a new surface.
   *       
   * @param implementation A protocol event listener for the newly created proxy.
   */
  public WlSurfaceProxy createSurface(WlSurfaceEvents implementation) {
    return marshalConstructor(0, implementation, getVersion(), org.freedesktop.wayland.client.WlSurfaceProxy.class, Arguments.create(1).set(0, 0));
  }

  /**
   * create new region
   * <p>
   *
   * 	Ask the compositor to create a new region.
   *       
   * @param implementation A protocol event listener for the newly created proxy.
   */
  public WlRegionProxy createRegion(WlRegionEvents implementation) {
    return marshalConstructor(1, implementation, getVersion(), org.freedesktop.wayland.client.WlRegionProxy.class, Arguments.create(1).set(0, 0));
  }
}
