package org.freedesktop.wayland.client;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
// 
//
//    Copyright © 2008-2011 Kristian Høgsberg
//    Copyright © 2010-2011 Intel Corporation
//    Copyright © 2012-2013 Collabora, Ltd.
//
//    Permission is hereby granted, free of charge, to any person
//    obtaining a copy of this software and associated documentation files
//    (the "Software"), to deal in the Software without restriction,
//    including without limitation the rights to use, copy, modify, merge,
//    publish, distribute, sublicense, and/or sell copies of the Software,
//    and to permit persons to whom the Software is furnished to do so,
//    subject to the following conditions:
//
//    The above copyright notice and this permission notice (including the
//    next paragraph) shall be included in all copies or substantial
//    portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//    NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
//    BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
//    ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
//    CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//    SOFTWARE.
//  
/**
 * offer to transfer data
 * <p>
 *
 *       A wl_data_offer represents a piece of data offered for transfer
 *       by another client (the source client).  It is used by the
 *       copy-and-paste and drag-and-drop mechanisms.  The offer
 *       describes the different mime types that the data can be
 *       converted to and provides the mechanism for transferring the
 *       data directly from the source client.
 *     
 */
public interface WlDataOfferEventsV2 extends WlDataOfferEvents {
  int VERSION = 2;

  /**
   * advertise offered mime type
   * <p>
   *
   * 	Sent immediately after creating the wl_data_offer object.  One
   * 	event per offered mime type.
   *       
   * @param emitter The protocol object that emitted the event.
   * @param mimeType offered mime type
   */
  public void offer(WlDataOfferProxy emitter, @Nonnull String mimeType);
}
