package org.freedesktop.wayland.client;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
// 
//
//    Copyright © 2008-2011 Kristian Høgsberg
//    Copyright © 2010-2011 Intel Corporation
//    Copyright © 2012-2013 Collabora, Ltd.
//
//    Permission is hereby granted, free of charge, to any person
//    obtaining a copy of this software and associated documentation files
//    (the "Software"), to deal in the Software without restriction,
//    including without limitation the rights to use, copy, modify, merge,
//    publish, distribute, sublicense, and/or sell copies of the Software,
//    and to permit persons to whom the Software is furnished to do so,
//    subject to the following conditions:
//
//    The above copyright notice and this permission notice (including the
//    next paragraph) shall be included in all copies or substantial
//    portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//    NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
//    BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
//    ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
//    CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//    SOFTWARE.
//  
/**
 * offer to transfer data
 * <p>
 *
 *       The wl_data_source object is the source side of a wl_data_offer.
 *       It is created by the source client in a data transfer and
 *       provides a way to describe the offered data and a way to respond
 *       to requests to transfer the data.
 *     
 */
public interface WlDataSourceEvents {
  int VERSION = 1;

  /**
   * a target accepts an offered mime type
   * <p>
   *
   * 	Sent when a target accepts pointer_focus or motion events.  If
   * 	a target does not accept any of the offered types, type is NULL.
   * <p>
   * 	Used for feedback during drag-and-drop.
   *       
   * @param emitter The protocol object that emitted the event.
   * @param mimeType mime type accepted by the target
   */
  public void target(WlDataSourceProxy emitter, @Nullable String mimeType);

  /**
   * send the data
   * <p>
   *
   * 	Request for data from the client.  Send the data as the
   * 	specified mime type over the passed file descriptor, then
   * 	close it.
   *       
   * @param emitter The protocol object that emitted the event.
   * @param mimeType mime type for the data
   * @param fd file descriptor for the data
   */
  public void send(WlDataSourceProxy emitter, @Nonnull String mimeType, int fd);

  /**
   * selection was cancelled
   * <p>
   *
   * 	This data source is no longer valid. There are several reasons why
   * 	this could happen:
   * <p>
   * 	- The data source has been replaced by another data source.
   * 	- The drag-and-drop operation was performed, but the drop destination
   * 	  did not accept any of the mime types offered through
   * 	  wl_data_source.target.
   * 	- The drag-and-drop operation was performed, but the drop destination
   * 	  did not select any of the actions present in the mask offered through
   * 	  wl_data_source.action.
   * 	- The drag-and-drop operation was performed but didn't happen over a
   * 	  surface.
   * 	- The compositor cancelled the drag-and-drop operation (e.g. compositor
   * 	  dependent timeouts to avoid stale drag-and-drop transfers).
   * <p>
   * 	The client should clean up and destroy this data source.
   * <p>
   * 	For objects of version 2 or older, wl_data_source.cancelled will
   * 	only be emitted if the data source was replaced by another data
   * 	source.
   *       
   * @param emitter The protocol object that emitted the event.
   */
  public void cancelled(WlDataSourceProxy emitter);
}
