package org.freedesktop.wayland.client;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
// 
//
//    Copyright © 2008-2011 Kristian Høgsberg
//    Copyright © 2010-2011 Intel Corporation
//    Copyright © 2012-2013 Collabora, Ltd.
//
//    Permission is hereby granted, free of charge, to any person
//    obtaining a copy of this software and associated documentation files
//    (the "Software"), to deal in the Software without restriction,
//    including without limitation the rights to use, copy, modify, merge,
//    publish, distribute, sublicense, and/or sell copies of the Software,
//    and to permit persons to whom the Software is furnished to do so,
//    subject to the following conditions:
//
//    The above copyright notice and this permission notice (including the
//    next paragraph) shall be included in all copies or substantial
//    portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//    NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
//    BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
//    ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
//    CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//    SOFTWARE.
//  
/**
 * keyboard input device
 * <p>
 *
 *       The wl_keyboard interface represents one or more keyboards
 *       associated with a seat.
 *     
 */
public interface WlKeyboardEventsV3 extends WlKeyboardEventsV2 {
  int VERSION = 3;

  /**
   * keyboard mapping
   * <p>
   *
   * 	This event provides a file descriptor to the client which can be
   * 	memory-mapped to provide a keyboard mapping description.
   *       
   * @param emitter The protocol object that emitted the event.
   * @param format keymap format
   * @param fd keymap file descriptor
   * @param size keymap size, in bytes
   */
  public void keymap(WlKeyboardProxy emitter, int format, int fd, int size);

  /**
   * enter event
   * <p>
   *
   * 	Notification that this seat's keyboard focus is on a certain
   * 	surface.
   *       
   * @param emitter The protocol object that emitted the event.
   * @param serial serial number of the enter event
   * @param surface surface gaining keyboard focus
   * @param keys the currently pressed keys
   */
  public void enter(WlKeyboardProxy emitter, int serial, @Nonnull WlSurfaceProxy surface, @Nonnull java.nio.ByteBuffer keys);

  /**
   * leave event
   * <p>
   *
   * 	Notification that this seat's keyboard focus is no longer on
   * 	a certain surface.
   * <p>
   * 	The leave notification is sent before the enter notification
   * 	for the new focus.
   *       
   * @param emitter The protocol object that emitted the event.
   * @param serial serial number of the leave event
   * @param surface surface that lost keyboard focus
   */
  public void leave(WlKeyboardProxy emitter, int serial, @Nonnull WlSurfaceProxy surface);

  /**
   * key event
   * <p>
   *
   * 	A key was pressed or released.
   *         The time argument is a timestamp with millisecond
   *         granularity, with an undefined base.
   *       
   * @param emitter The protocol object that emitted the event.
   * @param serial serial number of the key event
   * @param time timestamp with millisecond granularity
   * @param key key that produced the event
   * @param state physical state of the key
   */
  public void key(WlKeyboardProxy emitter, int serial, int time, int key, int state);

  /**
   * modifier and group state
   * <p>
   *
   * 	Notifies clients that the modifier and/or group state has
   * 	changed, and it should update its local state.
   *       
   * @param emitter The protocol object that emitted the event.
   * @param serial serial number of the modifiers event
   * @param modsDepressed depressed modifiers
   * @param modsLatched latched modifiers
   * @param modsLocked locked modifiers
   * @param group keyboard layout
   */
  public void modifiers(WlKeyboardProxy emitter, int serial, int modsDepressed, int modsLatched, int modsLocked, int group);
}
