package org.freedesktop.wayland.client;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.freedesktop.wayland.util.Arguments;
import org.freedesktop.wayland.util.Interface;
import org.freedesktop.wayland.util.Message;
// 
//
//    Copyright © 2008-2011 Kristian Høgsberg
//    Copyright © 2010-2011 Intel Corporation
//    Copyright © 2012-2013 Collabora, Ltd.
//
//    Permission is hereby granted, free of charge, to any person
//    obtaining a copy of this software and associated documentation files
//    (the "Software"), to deal in the Software without restriction,
//    including without limitation the rights to use, copy, modify, merge,
//    publish, distribute, sublicense, and/or sell copies of the Software,
//    and to permit persons to whom the Software is furnished to do so,
//    subject to the following conditions:
//
//    The above copyright notice and this permission notice (including the
//    next paragraph) shall be included in all copies or substantial
//    portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//    NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
//    BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
//    ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
//    CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//    SOFTWARE.
//  
/**
 * keyboard input device
 * <p>
 *
 *       The wl_keyboard interface represents one or more keyboards
 *       associated with a seat.
 *     
 */
@Interface(
  methods = {
    @Message(
  types = {
  },
  signature = "3",
  functionName = "release",
  name = "release"
)

  },
  name = "wl_keyboard",
  version = 5,
  events = {
    @Message(
  types = {
    int.class,
    int.class,
    int.class
  },
  signature = "uhu",
  functionName = "keymap",
  name = "keymap"
)
,
    @Message(
  types = {
    int.class,
    org.freedesktop.wayland.client.WlSurfaceProxy.class,
    java.nio.ByteBuffer.class
  },
  signature = "uoa",
  functionName = "enter",
  name = "enter"
)
,
    @Message(
  types = {
    int.class,
    org.freedesktop.wayland.client.WlSurfaceProxy.class
  },
  signature = "uo",
  functionName = "leave",
  name = "leave"
)
,
    @Message(
  types = {
    int.class,
    int.class,
    int.class,
    int.class
  },
  signature = "uuuu",
  functionName = "key",
  name = "key"
)
,
    @Message(
  types = {
    int.class,
    int.class,
    int.class,
    int.class,
    int.class
  },
  signature = "uuuuu",
  functionName = "modifiers",
  name = "modifiers"
)
,
    @Message(
  types = {
    int.class,
    int.class
  },
  signature = "4ii",
  functionName = "repeatInfo",
  name = "repeat_info"
)

  }
)
public class WlKeyboardProxy extends Proxy<WlKeyboardEvents> {

  public static final String INTERFACE_NAME = "wl_keyboard";

  public WlKeyboardProxy(long pointer, WlKeyboardEvents implementation, int version) {
    super(pointer, implementation, version);
  }

  public WlKeyboardProxy(long pointer) {
    super(pointer);
  }

  /**
   * release the keyboard object
   * <p>
   */
  public void release() {
    if (getVersion() < 3) {
      throw new UnsupportedOperationException("This object is version "+getVersion()+" while version 3 is required for this operation.");
    }
    marshal(0);
  }
}
