package org.freedesktop.wayland.client;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.freedesktop.wayland.util.Arguments;
import org.freedesktop.wayland.util.Interface;
import org.freedesktop.wayland.util.Message;
// 
//
//    Copyright © 2008-2011 Kristian Høgsberg
//    Copyright © 2010-2011 Intel Corporation
//    Copyright © 2012-2013 Collabora, Ltd.
//
//    Permission is hereby granted, free of charge, to any person
//    obtaining a copy of this software and associated documentation files
//    (the "Software"), to deal in the Software without restriction,
//    including without limitation the rights to use, copy, modify, merge,
//    publish, distribute, sublicense, and/or sell copies of the Software,
//    and to permit persons to whom the Software is furnished to do so,
//    subject to the following conditions:
//
//    The above copyright notice and this permission notice (including the
//    next paragraph) shall be included in all copies or substantial
//    portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//    NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
//    BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
//    ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
//    CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//    SOFTWARE.
//  
/**
 * create desktop-style surfaces
 * <p>
 *
 *       This interface is implemented by servers that provide
 *       desktop-style user interfaces.
 * <p>
 *       It allows clients to associate a wl_shell_surface with
 *       a basic surface.
 *     
 */
@Interface(
  methods = {
    @Message(
  types = {
    org.freedesktop.wayland.client.WlShellSurfaceProxy.class,
    org.freedesktop.wayland.client.WlSurfaceProxy.class
  },
  signature = "no",
  functionName = "getShellSurface",
  name = "get_shell_surface"
)

  },
  name = "wl_shell",
  version = 1,
  events = {
  }
)
public class WlShellProxy extends Proxy<WlShellEvents> {

  public static final String INTERFACE_NAME = "wl_shell";

  public WlShellProxy(long pointer, WlShellEvents implementation, int version) {
    super(pointer, implementation, version);
  }

  public WlShellProxy(long pointer) {
    super(pointer);
  }

  /**
   * create a shell surface from a surface
   * <p>
   *
   * 	Create a shell surface for an existing surface. This gives
   * 	the wl_surface the role of a shell surface. If the wl_surface
   * 	already has another role, it raises a protocol error.
   * <p>
   * 	Only one shell surface can be associated with a given surface.
   *       
   * @param implementation A protocol event listener for the newly created proxy.
   * @param surface surface to be given the shell surface role
   */
  public WlShellSurfaceProxy getShellSurface(WlShellSurfaceEvents implementation, @Nonnull WlSurfaceProxy surface) {
    return marshalConstructor(0, implementation, getVersion(), org.freedesktop.wayland.client.WlShellSurfaceProxy.class, Arguments.create(2).set(0, 0).set(1, surface));
  }
}
