package org.freedesktop.wayland.client;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
// 
//
//    Copyright © 2008-2011 Kristian Høgsberg
//    Copyright © 2010-2011 Intel Corporation
//    Copyright © 2012-2013 Collabora, Ltd.
//
//    Permission is hereby granted, free of charge, to any person
//    obtaining a copy of this software and associated documentation files
//    (the "Software"), to deal in the Software without restriction,
//    including without limitation the rights to use, copy, modify, merge,
//    publish, distribute, sublicense, and/or sell copies of the Software,
//    and to permit persons to whom the Software is furnished to do so,
//    subject to the following conditions:
//
//    The above copyright notice and this permission notice (including the
//    next paragraph) shall be included in all copies or substantial
//    portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//    NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
//    BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
//    ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
//    CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//    SOFTWARE.
//  
/**
 * shared memory support
 * <p>
 *
 *       A global singleton object that provides support for shared
 *       memory.
 * <p>
 *       Clients can create wl_shm_pool objects using the create_pool
 *       request.
 * <p>
 *       At connection setup time, the wl_shm object emits one or more
 *       format events to inform clients about the valid pixel formats
 *       that can be used for buffers.
 *     
 */
public interface WlShmEvents {
  int VERSION = 1;

  /**
   * pixel format description
   * <p>
   *
   * 	Informs the client about a valid pixel format that
   * 	can be used for buffers. Known formats include
   * 	argb8888 and xrgb8888.
   *       
   * @param emitter The protocol object that emitted the event.
   * @param format buffer pixel format
   */
  public void format(WlShmProxy emitter, int format);
}
