package org.freedesktop.wayland.client;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.freedesktop.wayland.util.Arguments;
import org.freedesktop.wayland.util.Interface;
import org.freedesktop.wayland.util.Message;
// 
//
//    Copyright © 2008-2011 Kristian Høgsberg
//    Copyright © 2010-2011 Intel Corporation
//    Copyright © 2012-2013 Collabora, Ltd.
//
//    Permission is hereby granted, free of charge, to any person
//    obtaining a copy of this software and associated documentation files
//    (the "Software"), to deal in the Software without restriction,
//    including without limitation the rights to use, copy, modify, merge,
//    publish, distribute, sublicense, and/or sell copies of the Software,
//    and to permit persons to whom the Software is furnished to do so,
//    subject to the following conditions:
//
//    The above copyright notice and this permission notice (including the
//    next paragraph) shall be included in all copies or substantial
//    portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//    NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
//    BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
//    ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
//    CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//    SOFTWARE.
//  
/**
 * shared memory support
 * <p>
 *
 *       A global singleton object that provides support for shared
 *       memory.
 * <p>
 *       Clients can create wl_shm_pool objects using the create_pool
 *       request.
 * <p>
 *       At connection setup time, the wl_shm object emits one or more
 *       format events to inform clients about the valid pixel formats
 *       that can be used for buffers.
 *     
 */
@Interface(
  methods = {
    @Message(
  types = {
    org.freedesktop.wayland.client.WlShmPoolProxy.class,
    int.class,
    int.class
  },
  signature = "nhi",
  functionName = "createPool",
  name = "create_pool"
)

  },
  name = "wl_shm",
  version = 1,
  events = {
    @Message(
  types = {
    int.class
  },
  signature = "u",
  functionName = "format",
  name = "format"
)

  }
)
public class WlShmProxy extends Proxy<WlShmEvents> {

  public static final String INTERFACE_NAME = "wl_shm";

  public WlShmProxy(long pointer, WlShmEvents implementation, int version) {
    super(pointer, implementation, version);
  }

  public WlShmProxy(long pointer) {
    super(pointer);
  }

  /**
   * create a shm pool
   * <p>
   *
   * 	Create a new wl_shm_pool object.
   * <p>
   * 	The pool can be used to create shared memory based buffer
   * 	objects.  The server will mmap size bytes of the passed file
   *         descriptor, to use as backing memory for the pool.
   *       
   * @param implementation A protocol event listener for the newly created proxy.
   * @param fd file descriptor for the pool
   * @param size pool size, in bytes
   */
  public WlShmPoolProxy createPool(WlShmPoolEvents implementation, int fd, int size) {
    return marshalConstructor(0, implementation, getVersion(), org.freedesktop.wayland.client.WlShmPoolProxy.class, Arguments.create(3).set(0, 0).set(1, fd).set(2, size));
  }
}
