package org.freedesktop.wayland.client;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
// 
//
//    Copyright © 2008-2011 Kristian Høgsberg
//    Copyright © 2010-2011 Intel Corporation
//    Copyright © 2012-2013 Collabora, Ltd.
//
//    Permission is hereby granted, free of charge, to any person
//    obtaining a copy of this software and associated documentation files
//    (the "Software"), to deal in the Software without restriction,
//    including without limitation the rights to use, copy, modify, merge,
//    publish, distribute, sublicense, and/or sell copies of the Software,
//    and to permit persons to whom the Software is furnished to do so,
//    subject to the following conditions:
//
//    The above copyright notice and this permission notice (including the
//    next paragraph) shall be included in all copies or substantial
//    portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//    NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
//    BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
//    ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
//    CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//    SOFTWARE.
//  
/**
 * sub-surface compositing
 * <p>
 *
 *       The global interface exposing sub-surface compositing capabilities.
 *       A wl_surface, that has sub-surfaces associated, is called the
 *       parent surface. Sub-surfaces can be arbitrarily nested and create
 *       a tree of sub-surfaces.
 * <p>
 *       The root surface in a tree of sub-surfaces is the main
 *       surface. The main surface cannot be a sub-surface, because
 *       sub-surfaces must always have a parent.
 * <p>
 *       A main surface with its sub-surfaces forms a (compound) window.
 *       For window management purposes, this set of wl_surface objects is
 *       to be considered as a single window, and it should also behave as
 *       such.
 * <p>
 *       The aim of sub-surfaces is to offload some of the compositing work
 *       within a window from clients to the compositor. A prime example is
 *       a video player with decorations and video in separate wl_surface
 *       objects. This should allow the compositor to pass YUV video buffer
 *       processing to dedicated overlay hardware when possible.
 *     
 */
public interface WlSubcompositorEvents {
  int VERSION = 1;
}
