package org.freedesktop.wayland.client;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
// 
//
//    Copyright © 2008-2011 Kristian Høgsberg
//    Copyright © 2010-2011 Intel Corporation
//    Copyright © 2012-2013 Collabora, Ltd.
//
//    Permission is hereby granted, free of charge, to any person
//    obtaining a copy of this software and associated documentation files
//    (the "Software"), to deal in the Software without restriction,
//    including without limitation the rights to use, copy, modify, merge,
//    publish, distribute, sublicense, and/or sell copies of the Software,
//    and to permit persons to whom the Software is furnished to do so,
//    subject to the following conditions:
//
//    The above copyright notice and this permission notice (including the
//    next paragraph) shall be included in all copies or substantial
//    portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//    NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
//    BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
//    ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
//    CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//    SOFTWARE.
//  
/**
 * sub-surface interface to a wl_surface
 * <p>
 *
 *       An additional interface to a wl_surface object, which has been
 *       made a sub-surface. A sub-surface has one parent surface. A
 *       sub-surface's size and position are not limited to that of the parent.
 *       Particularly, a sub-surface is not automatically clipped to its
 *       parent's area.
 * <p>
 *       A sub-surface becomes mapped, when a non-NULL wl_buffer is applied
 *       and the parent surface is mapped. The order of which one happens
 *       first is irrelevant. A sub-surface is hidden if the parent becomes
 *       hidden, or if a NULL wl_buffer is applied. These rules apply
 *       recursively through the tree of surfaces.
 * <p>
 *       The behaviour of a wl_surface.commit request on a sub-surface
 *       depends on the sub-surface's mode. The possible modes are
 *       synchronized and desynchronized, see methods
 *       wl_subsurface.set_sync and wl_subsurface.set_desync. Synchronized
 *       mode caches the wl_surface state to be applied when the parent's
 *       state gets applied, and desynchronized mode applies the pending
 *       wl_surface state directly. A sub-surface is initially in the
 *       synchronized mode.
 * <p>
 *       Sub-surfaces have also other kind of state, which is managed by
 *       wl_subsurface requests, as opposed to wl_surface requests. This
 *       state includes the sub-surface position relative to the parent
 *       surface (wl_subsurface.set_position), and the stacking order of
 *       the parent and its sub-surfaces (wl_subsurface.place_above and
 *       .place_below). This state is applied when the parent surface's
 *       wl_surface state is applied, regardless of the sub-surface's mode.
 *       As the exception, set_sync and set_desync are effective immediately.
 * <p>
 *       The main surface can be thought to be always in desynchronized mode,
 *       since it does not have a parent in the sub-surfaces sense.
 * <p>
 *       Even if a sub-surface is in desynchronized mode, it will behave as
 *       in synchronized mode, if its parent surface behaves as in
 *       synchronized mode. This rule is applied recursively throughout the
 *       tree of surfaces. This means, that one can set a sub-surface into
 *       synchronized mode, and then assume that all its child and grand-child
 *       sub-surfaces are synchronized, too, without explicitly setting them.
 * <p>
 *       If the wl_surface associated with the wl_subsurface is destroyed, the
 *       wl_subsurface object becomes inert. Note, that destroying either object
 *       takes effect immediately. If you need to synchronize the removal
 *       of a sub-surface to the parent surface update, unmap the sub-surface
 *       first by attaching a NULL wl_buffer, update parent, and then destroy
 *       the sub-surface.
 * <p>
 *       If the parent wl_surface object is destroyed, the sub-surface is
 *       unmapped.
 *     
 */
public interface WlSubsurfaceEvents {
  int VERSION = 1;
}
