package org.freedesktop.wayland.client;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
// 
//
//    Copyright © 2008-2011 Kristian Høgsberg
//    Copyright © 2010-2011 Intel Corporation
//    Copyright © 2012-2013 Collabora, Ltd.
//
//    Permission is hereby granted, free of charge, to any person
//    obtaining a copy of this software and associated documentation files
//    (the "Software"), to deal in the Software without restriction,
//    including without limitation the rights to use, copy, modify, merge,
//    publish, distribute, sublicense, and/or sell copies of the Software,
//    and to permit persons to whom the Software is furnished to do so,
//    subject to the following conditions:
//
//    The above copyright notice and this permission notice (including the
//    next paragraph) shall be included in all copies or substantial
//    portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//    NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
//    BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
//    ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
//    CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//    SOFTWARE.
//  
/**
 * touchscreen input device
 * <p>
 *
 *       The wl_touch interface represents a touchscreen
 *       associated with a seat.
 * <p>
 *       Touch interactions can consist of one or more contacts.
 *       For each contact, a series of events is generated, starting
 *       with a down event, followed by zero or more motion events,
 *       and ending with an up event. Events relating to the same
 *       contact point can be identified by the ID of the sequence.
 *     
 */
public interface WlTouchEventsV3 extends WlTouchEventsV2 {
  int VERSION = 3;

  /**
   * touch down event and beginning of a touch sequence
   * <p>
   *
   * 	A new touch point has appeared on the surface. This touch point is
   * 	assigned a unique ID. Future events from this touch point reference
   * 	this ID. The ID ceases to be valid after a touch up event and may be
   * 	reused in the future.
   *       
   * @param emitter The protocol object that emitted the event.
   * @param serial serial number of the touch down event
   * @param time timestamp with millisecond granularity
   * @param surface surface touched
   * @param id the unique ID of this touch point
   * @param x surface-local x coordinate
   * @param y surface-local y coordinate
   */
  public void down(WlTouchProxy emitter, int serial, int time, @Nonnull WlSurfaceProxy surface, int id, @Nonnull org.freedesktop.wayland.util.Fixed x, @Nonnull org.freedesktop.wayland.util.Fixed y);

  /**
   * end of a touch event sequence
   * <p>
   *
   * 	The touch point has disappeared. No further events will be sent for
   * 	this touch point and the touch point's ID is released and may be
   * 	reused in a future touch down event.
   *       
   * @param emitter The protocol object that emitted the event.
   * @param serial serial number of the touch up event
   * @param time timestamp with millisecond granularity
   * @param id the unique ID of this touch point
   */
  public void up(WlTouchProxy emitter, int serial, int time, int id);

  /**
   * update of touch point coordinates
   * <p>
   *
   * 	A touch point has changed coordinates.
   *       
   * @param emitter The protocol object that emitted the event.
   * @param time timestamp with millisecond granularity
   * @param id the unique ID of this touch point
   * @param x surface-local x coordinate
   * @param y surface-local y coordinate
   */
  public void motion(WlTouchProxy emitter, int time, int id, @Nonnull org.freedesktop.wayland.util.Fixed x, @Nonnull org.freedesktop.wayland.util.Fixed y);

  /**
   * end of touch frame event
   * <p>
   *
   * 	Indicates the end of a contact point list.
   *       
   * @param emitter The protocol object that emitted the event.
   */
  public void frame(WlTouchProxy emitter);

  /**
   * touch session cancelled
   * <p>
   *
   * 	Sent if the compositor decides the touch stream is a global
   * 	gesture. No further events are sent to the clients from that
   * 	particular gesture. Touch cancellation applies to all touch points
   * 	currently active on this client's surface. The client is
   * 	responsible for finalizing the touch points, future touch points on
   * 	this surface may reuse the touch point ID.
   *       
   * @param emitter The protocol object that emitted the event.
   */
  public void cancel(WlTouchProxy emitter);
}
