package org.freedesktop.wayland.client;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.freedesktop.wayland.util.Arguments;
import org.freedesktop.wayland.util.Interface;
import org.freedesktop.wayland.util.Message;
// 
//
//    Copyright © 2008-2011 Kristian Høgsberg
//    Copyright © 2010-2011 Intel Corporation
//    Copyright © 2012-2013 Collabora, Ltd.
//
//    Permission is hereby granted, free of charge, to any person
//    obtaining a copy of this software and associated documentation files
//    (the "Software"), to deal in the Software without restriction,
//    including without limitation the rights to use, copy, modify, merge,
//    publish, distribute, sublicense, and/or sell copies of the Software,
//    and to permit persons to whom the Software is furnished to do so,
//    subject to the following conditions:
//
//    The above copyright notice and this permission notice (including the
//    next paragraph) shall be included in all copies or substantial
//    portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//    NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
//    BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
//    ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
//    CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//    SOFTWARE.
//  
/**
 * touchscreen input device
 * <p>
 *
 *       The wl_touch interface represents a touchscreen
 *       associated with a seat.
 * <p>
 *       Touch interactions can consist of one or more contacts.
 *       For each contact, a series of events is generated, starting
 *       with a down event, followed by zero or more motion events,
 *       and ending with an up event. Events relating to the same
 *       contact point can be identified by the ID of the sequence.
 *     
 */
@Interface(
  methods = {
    @Message(
  types = {
  },
  signature = "3",
  functionName = "release",
  name = "release"
)

  },
  name = "wl_touch",
  version = 5,
  events = {
    @Message(
  types = {
    int.class,
    int.class,
    org.freedesktop.wayland.client.WlSurfaceProxy.class,
    int.class,
    org.freedesktop.wayland.util.Fixed.class,
    org.freedesktop.wayland.util.Fixed.class
  },
  signature = "uuoiff",
  functionName = "down",
  name = "down"
)
,
    @Message(
  types = {
    int.class,
    int.class,
    int.class
  },
  signature = "uui",
  functionName = "up",
  name = "up"
)
,
    @Message(
  types = {
    int.class,
    int.class,
    org.freedesktop.wayland.util.Fixed.class,
    org.freedesktop.wayland.util.Fixed.class
  },
  signature = "uiff",
  functionName = "motion",
  name = "motion"
)
,
    @Message(
  types = {
  },
  signature = "",
  functionName = "frame",
  name = "frame"
)
,
    @Message(
  types = {
  },
  signature = "",
  functionName = "cancel",
  name = "cancel"
)

  }
)
public class WlTouchProxy extends Proxy<WlTouchEvents> {

  public static final String INTERFACE_NAME = "wl_touch";

  public WlTouchProxy(long pointer, WlTouchEvents implementation, int version) {
    super(pointer, implementation, version);
  }

  public WlTouchProxy(long pointer) {
    super(pointer);
  }

  /**
   * release the touch object
   * <p>
   */
  public void release() {
    if (getVersion() < 3) {
      throw new UnsupportedOperationException("This object is version "+getVersion()+" while version 3 is required for this operation.");
    }
    marshal(0);
  }
}
