package org.freedesktop.wayland.shared;

// 
//
//    Copyright © 2008-2011 Kristian Høgsberg
//    Copyright © 2010-2011 Intel Corporation
//    Copyright © 2012-2013 Collabora, Ltd.
//
//    Permission is hereby granted, free of charge, to any person
//    obtaining a copy of this software and associated documentation files
//    (the "Software"), to deal in the Software without restriction,
//    including without limitation the rights to use, copy, modify, merge,
//    publish, distribute, sublicense, and/or sell copies of the Software,
//    and to permit persons to whom the Software is furnished to do so,
//    subject to the following conditions:
//
//    The above copyright notice and this permission notice (including the
//    next paragraph) shall be included in all copies or substantial
//    portions of the Software.
//
//    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
//    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
//    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
//    NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
//    BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
//    ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
//    CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
//    SOFTWARE.
//  
/**
 * edge values for resizing
 * <p>
 *
 * 	These values are used to indicate which edge of a surface
 * 	is being dragged in a resize operation. The server may
 * 	use this information to adapt its behavior, e.g. choose
 * 	an appropriate cursor image.
 *       
 */
public enum WlShellSurfaceResize {

  /**
   * no edge
   */
  NONE(0),
  /**
   * top edge
   */
  TOP(1),
  /**
   * bottom edge
   */
  BOTTOM(2),
  /**
   * left edge
   */
  LEFT(4),
  /**
   * top and left edges
   */
  TOP_LEFT(5),
  /**
   * bottom and left edges
   */
  BOTTOM_LEFT(6),
  /**
   * right edge
   */
  RIGHT(8),
  /**
   * top and right edges
   */
  TOP_RIGHT(9),
  /**
   * bottom and right edges
   */
  BOTTOM_RIGHT(10);

  public final int value;

  private WlShellSurfaceResize(int value) {
    this.value = value;
  }
}
