/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.argv;

import java.math.BigDecimal;
import java.util.List;
import org.freehep.util.argv.ArgumentFormatException;
import org.freehep.util.argv.MissingArgumentException;
import org.freehep.util.argv.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberOption
implements Option {
    private String flag;
    private String shortCut;
    private String name;
    private String desc;
    private BigDecimal defaultValue;
    private BigDecimal value = null;

    public NumberOption(String flag, String name, String description) {
        this(flag, null, name, null, description);
    }

    public NumberOption(String flag, String shortCut, String name, String description) {
        this(flag, shortCut, name, null, description);
    }

    public NumberOption(String flag, String name, BigDecimal defaultValue, String description) {
        this(flag, null, name, defaultValue, description);
    }

    public NumberOption(String flag, String shortCut, String name, BigDecimal defaultValue, String description) {
        this.flag = flag;
        this.shortCut = shortCut;
        this.name = name;
        this.desc = description;
        this.value = defaultValue;
        this.defaultValue = defaultValue;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public int parse(List<String> values) throws MissingArgumentException, ArgumentFormatException {
        if (values.get(0).equals(this.flag) || values.get(0).equals(this.shortCut)) {
            if (values.size() == 1) {
                throw new MissingArgumentException(this.flag + ": expects '" + this.name + "' of type <number>");
            }
            try {
                this.value = new BigDecimal(values.get(1));
            }
            catch (NumberFormatException nfe) {
                throw new ArgumentFormatException(this.flag + ": '" + values.get(1) + "' not a <number>");
            }
            return 2;
        }
        return 0;
    }

    @Override
    public String getOption() {
        StringBuffer s = new StringBuffer(this.flag);
        s.append(" <");
        s.append(this.name);
        if (this.defaultValue != null) {
            s.append("=");
            s.append(this.defaultValue);
        }
        s.append(">");
        return s.toString();
    }

    @Override
    public String getUsage() {
        return this.desc;
    }
}

