/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.argv;

import java.math.BigDecimal;
import java.util.List;
import org.freehep.util.argv.ArgumentFormatException;
import org.freehep.util.argv.MissingArgumentException;
import org.freehep.util.argv.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberParameter
implements Parameter {
    private String name;
    private String desc;
    private BigDecimal value = null;

    public NumberParameter(String name, String description) {
        this.name = name;
        this.desc = description;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public int parse(List<String> values) throws MissingArgumentException, ArgumentFormatException {
        if (values.size() < 1) {
            throw new MissingArgumentException("Parameter '" + this.name + "' of type <number> expected");
        }
        try {
            this.value = new BigDecimal(values.get(0));
        }
        catch (NumberFormatException nfe) {
            throw new ArgumentFormatException("For parameter '" + this.name + "' '" + values.get(1) + "' is not a <number>");
        }
        return 1;
    }

    @Override
    public String getName() {
        return "<" + this.name + ">";
    }

    @Override
    public String getUsage() {
        return this.desc;
    }
}

