/*
 * Decompiled with CFR 0.152.
 */
package org.frgaal.maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArrayList;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerMessage;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.codehaus.plexus.compiler.CompilerResult;
import org.codehaus.plexus.util.Os;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.frgaal.Main;

public class FrgaalCompiler
extends AbstractCompiler {
    private static final String[] WARNING_PREFIXES = new String[]{"warning: ", "\u8b66\u544a: ", "\u8b66\u544a\uff1a "};
    private static final String[] NOTE_PREFIXES = new String[]{"Note: ", "\u6ce8: ", "\u6ce8\u610f\uff1a "};
    private static final String[] MISC_PREFIXES = new String[]{"["};
    private static final Object LOCK = new Object();
    private static final String JAVAC_CLASSNAME = "com.sun.tools.javac.Main";
    private static volatile Class<?> JAVAC_CLASS;
    private List<Class<?>> javaccClasses = new CopyOnWriteArrayList();

    public FrgaalCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, ".java", ".class", null);
    }

    public CompilerResult performCompile(CompilerConfiguration config) throws CompilerException {
        String[] sourceFiles;
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        if ((sourceFiles = FrgaalCompiler.getSourceFiles((CompilerConfiguration)config)) == null || sourceFiles.length == 0) {
            return new CompilerResult();
        }
        if (this.getLogger() != null && this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Compiling " + sourceFiles.length + " source file" + (sourceFiles.length == 1 ? "" : "s") + " to " + destinationDir.getAbsolutePath());
        }
        String[] args = FrgaalCompiler.buildCompilerArguments(config, sourceFiles);
        CompilerResult result = this.compileInProcess(args, config);
        return result;
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        return FrgaalCompiler.buildCompilerArguments(config, FrgaalCompiler.getSourceFiles((CompilerConfiguration)config));
    }

    public static String[] buildCompilerArguments(CompilerConfiguration config, String[] sourceFiles) {
        List sourceLocations;
        List modulepathEntries;
        ArrayList<String> args = new ArrayList<String>();
        File destinationDir = new File(config.getOutputLocation());
        args.add("-d");
        args.add(destinationDir.getAbsolutePath());
        List classpathEntries = config.getClasspathEntries();
        if (classpathEntries != null && !classpathEntries.isEmpty()) {
            args.add("-classpath");
            args.add(FrgaalCompiler.getPathString((List)classpathEntries));
        }
        if ((modulepathEntries = config.getModulepathEntries()) != null && !modulepathEntries.isEmpty()) {
            args.add("--module-path");
            args.add(FrgaalCompiler.getPathString((List)modulepathEntries));
        }
        if ((sourceLocations = config.getSourceLocations()) != null && !sourceLocations.isEmpty()) {
            args.add("-sourcepath");
            args.add(FrgaalCompiler.getPathString((List)sourceLocations));
        }
        args.addAll(Arrays.asList(sourceFiles));
        if (config.isOptimize()) {
            args.add("-O");
        }
        if (config.isDebug()) {
            if (StringUtils.isNotEmpty((String)config.getDebugLevel())) {
                args.add("-g:" + config.getDebugLevel());
            } else {
                args.add("-g");
            }
        }
        if (config.isVerbose()) {
            args.add("-verbose");
        }
        if (config.isParameters()) {
            args.add("-parameters");
        }
        if (config.isShowDeprecation()) {
            args.add("-deprecation");
            config.setShowWarnings(true);
        }
        if (!config.isShowWarnings()) {
            args.add("-nowarn");
        }
        if (config.isFailOnWarning()) {
            args.add("-Werror");
        }
        if (!StringUtils.isEmpty((String)config.getReleaseVersion())) {
            args.add("--release");
            args.add(config.getReleaseVersion());
        } else {
            if (StringUtils.isEmpty((String)config.getTargetVersion())) {
                args.add("-target");
                args.add("1.8");
            } else {
                args.add("-target");
                args.add(config.getTargetVersion());
            }
            if (StringUtils.isEmpty((String)config.getSourceVersion())) {
                args.add("-source");
                args.add("14");
            } else {
                args.add("-source");
                args.add(config.getSourceVersion());
            }
        }
        if (!StringUtils.isEmpty((String)config.getSourceEncoding())) {
            args.add("-encoding");
            args.add(config.getSourceEncoding());
        }
        if (!StringUtils.isEmpty((String)config.getModuleVersion())) {
            args.add("--module-version");
            args.add(config.getModuleVersion());
        }
        for (Map.Entry entry : config.getCustomCompilerArgumentsEntries()) {
            String key = (String)entry.getKey();
            if (StringUtils.isEmpty((String)key) || key.startsWith("-J")) continue;
            args.add(key);
            String value = (String)entry.getValue();
            if (StringUtils.isEmpty((String)value)) continue;
            args.add(value);
        }
        return args.toArray(new String[args.size()]);
    }

    CompilerResult compileInProcess(String[] args, CompilerConfiguration config) throws CompilerException {
        List<CompilerMessage> messages;
        int ok;
        StringWriter out = new StringWriter();
        try {
            ok = Main.compile((String[])args, (PrintWriter)new PrintWriter(out));
            messages = FrgaalCompiler.parseModernStream(ok, new BufferedReader(new StringReader(out.toString())));
        }
        catch (IOException e) {
            throw new CompilerException("Error while executing the compiler.", (Throwable)e);
        }
        boolean success = ok == 0;
        return new CompilerResult(success, messages);
    }

    static List<CompilerMessage> parseModernStream(int exitCode, BufferedReader input) throws IOException {
        ArrayList<CompilerMessage> errors = new ArrayList<CompilerMessage>();
        StringBuilder buffer = new StringBuilder();
        boolean hasPointer = false;
        while (true) {
            String line;
            if ((line = input.readLine()) == null) {
                if (buffer.length() > 0 && buffer.toString().startsWith("javac:")) {
                    errors.add(new CompilerMessage(buffer.toString(), CompilerMessage.Kind.ERROR));
                }
                return errors;
            }
            if (line.startsWith("An exception has occurred in the compiler")) {
                buffer = new StringBuilder();
                while (line != null) {
                    buffer.append(line);
                    buffer.append(EOL);
                    line = input.readLine();
                }
                errors.add(new CompilerMessage(buffer.toString(), CompilerMessage.Kind.ERROR));
                return errors;
            }
            if (!line.startsWith(" ") && hasPointer) {
                errors.add(FrgaalCompiler.parseModernError(exitCode, buffer.toString()));
                buffer = new StringBuilder();
                hasPointer = false;
            }
            if (buffer.length() == 0 && line.startsWith("error: ")) {
                errors.add(new CompilerMessage(line, CompilerMessage.Kind.ERROR));
            } else if (buffer.length() == 0 && line.startsWith("warning: ")) {
                errors.add(new CompilerMessage(line, CompilerMessage.Kind.WARNING));
            } else if (buffer.length() != 0 || !FrgaalCompiler.isNote(line)) {
                if (buffer.length() == 0 && FrgaalCompiler.isMisc(line)) {
                    errors.add(new CompilerMessage(line, CompilerMessage.Kind.OTHER));
                } else {
                    buffer.append(line);
                    buffer.append(EOL);
                }
            }
            if (!line.endsWith("^")) continue;
            hasPointer = true;
        }
    }

    private static boolean isMisc(String line) {
        return FrgaalCompiler.startsWithPrefix(line, MISC_PREFIXES);
    }

    private static boolean isNote(String line) {
        return FrgaalCompiler.startsWithPrefix(line, NOTE_PREFIXES);
    }

    private static boolean startsWithPrefix(String line, String[] prefixes) {
        for (int i = 0; i < prefixes.length; ++i) {
            if (!line.startsWith(prefixes[i])) continue;
            return true;
        }
        return false;
    }

    static CompilerMessage parseModernError(int exitCode, String error) {
        StringTokenizer tokens = new StringTokenizer(error, ":");
        boolean isError = exitCode != 0;
        try {
            int endcolumn;
            boolean tokenIsAnInteger;
            StringBuilder file = null;
            String currentToken = null;
            do {
                if (currentToken != null) {
                    if (file == null) {
                        file = new StringBuilder(currentToken);
                    } else {
                        file.append(':').append(currentToken);
                    }
                }
                currentToken = tokens.nextToken();
                tokenIsAnInteger = true;
                try {
                    Integer.parseInt(currentToken);
                }
                catch (NumberFormatException e) {
                    tokenIsAnInteger = false;
                }
            } while (!tokenIsAnInteger);
            String lineIndicator = currentToken;
            int startOfFileName = file.toString().lastIndexOf(93);
            if (startOfFileName > -1) {
                file = new StringBuilder(file.substring(startOfFileName + 1 + EOL.length()));
            }
            int line = Integer.parseInt(lineIndicator);
            StringBuilder msgBuffer = new StringBuilder();
            String msg = tokens.nextToken(EOL).substring(2);
            String warnPrefix = FrgaalCompiler.getWarnPrefix(msg);
            if (warnPrefix != null) {
                isError = false;
                msg = msg.substring(warnPrefix.length());
            } else {
                isError = exitCode != 0;
            }
            msgBuffer.append(msg);
            msgBuffer.append(EOL);
            String context = tokens.nextToken(EOL);
            String pointer = null;
            do {
                String msgLine = tokens.nextToken(EOL);
                if (pointer != null) {
                    msgBuffer.append(msgLine);
                    msgBuffer.append(EOL);
                    continue;
                }
                if (msgLine.endsWith("^")) {
                    pointer = msgLine;
                    continue;
                }
                msgBuffer.append(context);
                msgBuffer.append(EOL);
                context = msgLine;
            } while (tokens.hasMoreTokens());
            msgBuffer.append(EOL);
            String message = msgBuffer.toString();
            int startcolumn = pointer.indexOf("^");
            int n = endcolumn = context == null ? startcolumn : context.indexOf(" ", startcolumn);
            if (endcolumn == -1) {
                endcolumn = context.length();
            }
            return new CompilerMessage(file.toString(), isError, line, startcolumn, line, endcolumn, message.trim());
        }
        catch (NoSuchElementException e) {
            return new CompilerMessage("no more tokens - could not parse error message: " + error, isError);
        }
        catch (NumberFormatException e) {
            return new CompilerMessage("could not parse error message: " + error, isError);
        }
        catch (Exception e) {
            return new CompilerMessage("could not parse error message: " + error, isError);
        }
    }

    private static String getWarnPrefix(String msg) {
        for (int i = 0; i < WARNING_PREFIXES.length; ++i) {
            if (!msg.startsWith(WARNING_PREFIXES[i])) continue;
            return WARNING_PREFIXES[i];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createFileWithArguments(String[] args, String outputDirectory) throws IOException {
        try (PrintWriter writer = null;){
            File tempFile;
            if (this.getLogger() != null && this.getLogger().isDebugEnabled()) {
                tempFile = File.createTempFile(FrgaalCompiler.class.getName(), "arguments", new File(outputDirectory));
            } else {
                tempFile = File.createTempFile(FrgaalCompiler.class.getName(), "arguments");
                tempFile.deleteOnExit();
            }
            writer = new PrintWriter(new FileWriter(tempFile));
            for (int i = 0; i < args.length; ++i) {
                String argValue = args[i].replace(File.separatorChar, '/');
                writer.write("\"" + argValue + "\"");
                writer.println();
            }
            writer.flush();
            File file = tempFile;
            return file;
        }
    }

    private static String getJavacExecutable() throws IOException {
        String javacCommand = "javac" + (Os.isFamily((String)"windows") ? ".exe" : "");
        String javaHome = System.getProperty("java.home");
        File javacExe = Os.isName((String)"AIX") ? new File(javaHome + File.separator + ".." + File.separator + "sh", javacCommand) : (Os.isName((String)"Mac OS X") ? new File(javaHome + File.separator + "bin", javacCommand) : new File(javaHome + File.separator + ".." + File.separator + "bin", javacCommand));
        if (!javacExe.isFile()) {
            Properties env = CommandLineUtils.getSystemEnvVars();
            javaHome = env.getProperty("JAVA_HOME");
            if (StringUtils.isEmpty((String)javaHome)) {
                throw new IOException("The environment variable JAVA_HOME is not correctly set.");
            }
            if (!new File(javaHome).isDirectory()) {
                throw new IOException("The environment variable JAVA_HOME=" + javaHome + " doesn't exist or is not a valid directory.");
            }
            javacExe = new File(env.getProperty("JAVA_HOME") + File.separator + "bin", javacCommand);
        }
        if (!javacExe.isFile()) {
            throw new IOException("The javadoc executable '" + javacExe + "' doesn't exist or is not a file. Verify the JAVA_HOME environment variable.");
        }
        return javacExe.getAbsolutePath();
    }
}

