/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.ArrayUtils;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Bits;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class Flow {
    protected static final Context.Key<Flow> flowKey = new Context.Key();
    private final Names names;
    private final Log log;
    private final Symtab syms;
    private final Types types;
    private final Check chk;
    private TreeMaker make;
    private final Resolve rs;
    private final JCDiagnostic.Factory diags;
    private Env<AttrContext> attrEnv;
    private Lint lint;
    private final boolean allowEffectivelyFinalInInnerClasses;

    public static Flow instance(Context context) {
        Flow flow = context.get(flowKey);
        if (flow == null) {
            flow = new Flow(context);
        }
        return flow;
    }

    public void analyzeTree(Env<AttrContext> env, TreeMaker treeMaker) {
        new AliveAnalyzer().analyzeTree(env, treeMaker);
        new AssignAnalyzer().analyzeTree(env, treeMaker);
        new FlowAnalyzer().analyzeTree(env, treeMaker);
        new CaptureAnalyzer().analyzeTree(env, treeMaker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeLambda(Env<AttrContext> env, JCTree.JCLambda jCLambda, TreeMaker treeMaker, boolean bl) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = null;
        if (!bl) {
            discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        }
        try {
            new LambdaAliveAnalyzer().analyzeTree(env, jCLambda, treeMaker);
        }
        finally {
            if (!bl) {
                this.log.popDiagnosticHandler(discardDiagnosticHandler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Type> analyzeLambdaThrownTypes(Env<AttrContext> env, JCTree.JCLambda jCLambda, TreeMaker treeMaker) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            new LambdaAssignAnalyzer(env).analyzeTree(env, jCLambda, treeMaker);
            LambdaFlowAnalyzer lambdaFlowAnalyzer = new LambdaFlowAnalyzer();
            lambdaFlowAnalyzer.analyzeTree(env, jCLambda, treeMaker);
            List<Type> list = lambdaFlowAnalyzer.inferredThrownTypes;
            return list;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean aliveAfter(Env<AttrContext> env, JCTree jCTree, TreeMaker treeMaker) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            SnippetAliveAnalyzer snippetAliveAnalyzer = new SnippetAliveAnalyzer();
            snippetAliveAnalyzer.analyzeTree(env, jCTree, treeMaker);
            boolean bl = snippetAliveAnalyzer.isAlive();
            return bl;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean breaksOutOf(Env<AttrContext> env, JCTree jCTree, JCTree jCTree2, TreeMaker treeMaker) {
        Log.DiscardDiagnosticHandler discardDiagnosticHandler = new Log.DiscardDiagnosticHandler(this.log);
        try {
            SnippetBreakAnalyzer snippetBreakAnalyzer = new SnippetBreakAnalyzer();
            snippetBreakAnalyzer.analyzeTree(env, jCTree2, treeMaker);
            boolean bl = snippetBreakAnalyzer.breaksOut();
            return bl;
        }
        finally {
            this.log.popDiagnosticHandler(discardDiagnosticHandler);
        }
    }

    protected Flow(Context context) {
        context.put(flowKey, this);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.chk = Check.instance(context);
        this.lint = Lint.instance(context);
        this.rs = Resolve.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        Source source = Source.instance(context);
        Target target = Target.instance(context);
        this.allowEffectivelyFinalInInnerClasses = Source.Feature.EFFECTIVELY_FINAL_IN_INNER_CLASSES.allowedInSource(source, target);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    class AliveAnalyzer
    extends BaseAnalyzer {
        private Liveness alive;

        AliveAnalyzer() {
        }

        @Override
        void markDead() {
            this.alive = Liveness.DEAD;
        }

        void scanDef(JCTree jCTree) {
            this.scanStat(jCTree);
            if (jCTree != null && jCTree.hasTag(JCTree.Tag.BLOCK) && this.alive == Liveness.DEAD) {
                Flow.this.log.error(jCTree.pos(), CompilerProperties.Errors.InitializerMustBeAbleToCompleteNormally);
            }
        }

        void scanStat(JCTree jCTree) {
            if (this.alive == Liveness.DEAD && jCTree != null) {
                Flow.this.log.error(jCTree.pos(), CompilerProperties.Errors.UnreachableStmt);
                if (!jCTree.hasTag(JCTree.Tag.SKIP)) {
                    this.alive = Liveness.RECOVERY;
                }
            }
            this.scan(jCTree);
        }

        void scanStats(List<? extends JCTree.JCStatement> list) {
            if (list != null) {
                List<JCTree.JCStatement> list2 = list;
                while (list2.nonEmpty()) {
                    this.scanStat((JCTree)list2.head);
                    list2 = list2.tail;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            if (jCClassDecl.sym == null) {
                return;
            }
            Liveness liveness = this.alive;
            ListBuffer listBuffer = this.pendingExits;
            Lint lint = Flow.this.lint;
            this.pendingExits = new ListBuffer();
            Flow.this.lint = Flow.this.lint.augment(jCClassDecl.sym);
            try {
                List<JCTree> list = jCClassDecl.defs;
                while (list.nonEmpty()) {
                    if (!((JCTree)list.head).hasTag(JCTree.Tag.METHODDEF) && (TreeInfo.flags((JCTree)list.head) & 8L) != 0L) {
                        this.scanDef((JCTree)list.head);
                        this.clearPendingExits(false);
                    }
                    list = list.tail;
                }
                list = jCClassDecl.defs;
                while (list.nonEmpty()) {
                    if (!((JCTree)list.head).hasTag(JCTree.Tag.METHODDEF) && (TreeInfo.flags((JCTree)list.head) & 8L) == 0L) {
                        this.scanDef((JCTree)list.head);
                        this.clearPendingExits(false);
                    }
                    list = list.tail;
                }
                list = jCClassDecl.defs;
                while (list.nonEmpty()) {
                    if (((JCTree)list.head).hasTag(JCTree.Tag.METHODDEF)) {
                        this.scan((JCTree)list.head);
                    }
                    list = list.tail;
                }
            }
            finally {
                this.pendingExits = listBuffer;
                this.alive = liveness;
                Flow.this.lint = lint;
            }
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
            if (jCMethodDecl.body == null) {
                return;
            }
            Lint lint = Flow.this.lint;
            Flow.this.lint = Flow.this.lint.augment(jCMethodDecl.sym);
            Assert.check(this.pendingExits.isEmpty());
            try {
                this.alive = Liveness.ALIVE;
                this.scanStat(jCMethodDecl.body);
                boolean bl = jCMethodDecl.completesNormally = this.alive != Liveness.DEAD;
                if (this.alive == Liveness.ALIVE && !jCMethodDecl.sym.type.getReturnType().hasTag(TypeTag.VOID)) {
                    Flow.this.log.error(TreeInfo.diagEndPos(jCMethodDecl.body), CompilerProperties.Errors.MissingRetStmt);
                }
                this.clearPendingExits(true);
            }
            finally {
                Flow.this.lint = lint;
            }
        }

        private void clearPendingExits(boolean bl) {
            List list = this.pendingExits.toList();
            this.pendingExits = new ListBuffer();
            while (list.nonEmpty()) {
                BaseAnalyzer.PendingExit pendingExit = (BaseAnalyzer.PendingExit)list.head;
                list = list.tail;
                Assert.check(bl && pendingExit.tree.hasTag(JCTree.Tag.RETURN) || Flow.this.log.hasErrorOn(pendingExit.tree.pos()));
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            if (jCVariableDecl.init != null) {
                Lint lint = Flow.this.lint;
                Flow.this.lint = Flow.this.lint.augment(jCVariableDecl.sym);
                try {
                    this.scan(jCVariableDecl.init);
                }
                finally {
                    Flow.this.lint = lint;
                }
            }
        }

        @Override
        public void visitBlock(JCTree.JCBlock jCBlock) {
            this.scanStats(jCBlock.stats);
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scanStat(jCDoWhileLoop.body);
            this.alive = this.alive.or(this.resolveContinues(jCDoWhileLoop));
            this.scan(jCDoWhileLoop.cond);
            this.alive = this.alive.and(!jCDoWhileLoop.cond.type.isTrue());
            this.alive = this.alive.or(this.resolveBreaks(jCDoWhileLoop, listBuffer));
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCWhileLoop.cond);
            this.alive = Liveness.from(!jCWhileLoop.cond.type.isFalse());
            this.scanStat(jCWhileLoop.body);
            this.alive = this.alive.or(this.resolveContinues(jCWhileLoop));
            this.alive = this.resolveBreaks(jCWhileLoop, listBuffer).or(!jCWhileLoop.cond.type.isTrue());
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop jCForLoop) {
            ListBuffer listBuffer = this.pendingExits;
            this.scanStats(jCForLoop.init);
            this.pendingExits = new ListBuffer();
            if (jCForLoop.cond != null) {
                this.scan(jCForLoop.cond);
                this.alive = Liveness.from(!jCForLoop.cond.type.isFalse());
            } else {
                this.alive = Liveness.ALIVE;
            }
            this.scanStat(jCForLoop.body);
            this.alive = this.alive.or(this.resolveContinues(jCForLoop));
            this.scan(jCForLoop.step);
            this.alive = this.resolveBreaks(jCForLoop, listBuffer).or(jCForLoop.cond != null && !jCForLoop.cond.type.isTrue());
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
            this.visitVarDef(jCEnhancedForLoop.var);
            ListBuffer listBuffer = this.pendingExits;
            this.scan(jCEnhancedForLoop.expr);
            this.pendingExits = new ListBuffer();
            this.scanStat(jCEnhancedForLoop.body);
            this.alive = this.alive.or(this.resolveContinues(jCEnhancedForLoop));
            this.resolveBreaks(jCEnhancedForLoop, listBuffer);
            this.alive = Liveness.ALIVE;
        }

        @Override
        public void visitLabelled(JCTree.JCLabeledStatement jCLabeledStatement) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scanStat(jCLabeledStatement.body);
            this.alive = this.alive.or(this.resolveBreaks(jCLabeledStatement, listBuffer));
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch jCSwitch) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCSwitch.selector);
            boolean bl = TreeInfo.expectedExhaustive(jCSwitch);
            Collection<Object> collection = jCSwitch.cases;
            while (collection.nonEmpty()) {
                this.alive = Liveness.ALIVE;
                JCTree.JCCase jCCase = (JCTree.JCCase)collection.head;
                for (JCTree.JCCaseLabel jCCaseLabel : jCCase.labels) {
                    this.scan(jCCaseLabel);
                }
                this.scanStats(jCCase.stats);
                if (this.alive != Liveness.DEAD && jCCase.caseKind == JCTree.JCCase.RULE) {
                    this.scanSyntheticBreak(Flow.this.make, jCSwitch);
                    this.alive = Liveness.DEAD;
                }
                if (this.alive == Liveness.ALIVE && Flow.this.lint.isEnabled(Lint.LintCategory.FALLTHROUGH) && jCCase.stats.nonEmpty() && collection.tail.nonEmpty()) {
                    Flow.this.log.warning(Lint.LintCategory.FALLTHROUGH, ((JCTree.JCCase)collection.tail.head).pos(), CompilerProperties.Warnings.PossibleFallThroughIntoCase);
                }
                collection = collection.tail;
            }
            boolean bl2 = jCSwitch.isExhaustive = jCSwitch.hasUnconditionalPattern || TreeInfo.isErrorEnumSwitch(jCSwitch.selector, jCSwitch.cases);
            if (bl) {
                collection = this.coveredSymbolsForCases(jCSwitch.pos(), jCSwitch.selector, jCSwitch.cases);
                jCSwitch.isExhaustive |= this.isExhaustive(jCSwitch.selector.pos(), jCSwitch.selector.type, (Set<Symbol>)collection);
                if (!jCSwitch.isExhaustive) {
                    Flow.this.log.error(jCSwitch, CompilerProperties.Errors.NotExhaustiveStatement);
                }
            }
            if (!jCSwitch.hasUnconditionalPattern) {
                this.alive = Liveness.ALIVE;
            }
            this.alive = this.alive.or(this.resolveBreaks(jCSwitch, listBuffer));
        }

        @Override
        public void visitSwitchExpression(JCTree.JCSwitchExpression jCSwitchExpression) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCSwitchExpression.selector);
            Liveness liveness = this.alive;
            Collection<Object> collection = jCSwitchExpression.cases;
            while (collection.nonEmpty()) {
                this.alive = Liveness.ALIVE;
                JCTree.JCCase jCCase = (JCTree.JCCase)collection.head;
                for (JCTree.JCCaseLabel jCCaseLabel : jCCase.labels) {
                    this.scan(jCCaseLabel);
                }
                this.scanStats(jCCase.stats);
                if (this.alive == Liveness.ALIVE) {
                    if (jCCase.caseKind == JCTree.JCCase.RULE) {
                        Flow.this.log.error(TreeInfo.diagEndPos(jCCase.body), CompilerProperties.Errors.RuleCompletesNormally);
                    } else if (collection.tail.isEmpty()) {
                        Flow.this.log.error(TreeInfo.diagEndPos(jCSwitchExpression), CompilerProperties.Errors.SwitchExpressionCompletesNormally);
                    }
                }
                collection = collection.tail;
            }
            collection = this.coveredSymbolsForCases(jCSwitchExpression.pos(), jCSwitchExpression.selector, jCSwitchExpression.cases);
            boolean bl = jCSwitchExpression.isExhaustive = jCSwitchExpression.hasUnconditionalPattern || TreeInfo.isErrorEnumSwitch(jCSwitchExpression.selector, jCSwitchExpression.cases) || this.isExhaustive(jCSwitchExpression.selector.pos(), jCSwitchExpression.selector.type, (Set<Symbol>)collection);
            if (!jCSwitchExpression.isExhaustive) {
                Flow.this.log.error(jCSwitchExpression, CompilerProperties.Errors.NotExhaustive);
            }
            this.alive = liveness;
            this.alive = this.alive.or(this.resolveYields(jCSwitchExpression, listBuffer));
        }

        private Set<Symbol> coveredSymbolsForCases(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCTree.JCExpression jCExpression, List<JCTree.JCCase> list) {
            HashSet hashSet = list.stream().flatMap(jCCase -> jCCase.labels.stream()).filter(TreeInfo::unguardedCaseLabel).filter(jCCaseLabel -> !jCCaseLabel.hasTag(JCTree.Tag.DEFAULTCASELABEL)).map(jCCaseLabel -> jCCaseLabel.hasTag(JCTree.Tag.CONSTANTCASELABEL) ? ((JCTree.JCConstantCaseLabel)jCCaseLabel).expr : ((JCTree.JCPatternCaseLabel)jCCaseLabel).pat).collect(Collectors.toCollection(HashSet::new));
            return this.coveredSymbols(diagnosticPosition, jCExpression.type, hashSet);
        }

        private Set<Symbol> coveredSymbols(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Iterable<? extends JCTree> iterable) {
            HashSet<Symbol> hashSet = new HashSet<Symbol>();
            HashMap hashMap = new HashMap();
            block4: for (JCTree object : iterable) {
                switch (object.getTag()) {
                    case BINDINGPATTERN: 
                    case PARENTHESIZEDPATTERN: {
                        Object object2 = TreeInfo.primaryPatternType((JCTree.JCPattern)object);
                        if (((Type)object2).hasTag(TypeTag.NONE)) continue block4;
                        hashSet.add(((Type)object2).tsym);
                        break;
                    }
                    case RECORDPATTERN: {
                        Object object2 = (JCTree.JCRecordPattern)object;
                        Symbol.ClassSymbol classSymbol = ((JCTree.JCRecordPattern)object2).record;
                        List<Object> list = hashMap.getOrDefault(classSymbol, List.nil()).prepend(object2);
                        hashMap.put(classSymbol, list);
                        break;
                    }
                    default: {
                        Assert.check(object instanceof JCTree.JCExpression, object.getTag().name());
                        Object object2 = (JCTree.JCExpression)object;
                        if (!((JCTree)object2).hasTag(JCTree.Tag.IDENT) || !((JCTree.JCIdent)object2).sym.isEnum()) continue block4;
                        hashSet.add(((JCTree.JCIdent)object2).sym);
                    }
                }
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                if (!this.coversDeconstructionFromComponent(diagnosticPosition, type, (List)entry.getValue(), 0)) continue;
                hashSet.add((Symbol)entry.getKey());
            }
            return hashSet;
        }

        private boolean coversDeconstructionFromComponent(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, List<JCTree.JCRecordPattern> list, int n) {
            java.util.List list2 = ((JCTree.JCRecordPattern)list.head).record.getRecordComponents();
            if (((List)list2).size() == n) {
                return true;
            }
            Type type2 = Flow.this.types.memberType(type, (Symbol)((List)list2).get(n));
            List<JCTree.JCPattern> list3 = list.map(jCRecordPattern -> jCRecordPattern.nested.get(n));
            Set<Symbol> set = this.coveredSymbols(diagnosticPosition, type2, list3);
            HashMap hashMap = new HashMap();
            for (JCTree.JCRecordPattern object : list) {
                JCTree.JCPattern jCPattern = object.nested.get(n);
                Symbol.TypeSymbol typeSymbol = switch (jCPattern.getTag()) {
                    case JCTree.Tag.BINDINGPATTERN, JCTree.Tag.PARENTHESIZEDPATTERN -> {
                        Type var14_17 = TreeInfo.primaryPatternType(jCPattern);
                        yield var14_17.tsym;
                    }
                    case JCTree.Tag.RECORDPATTERN -> ((JCTree.JCRecordPattern)jCPattern).record;
                    default -> throw Assert.error("Unexpected tree kind: " + String.valueOf((Object)jCPattern.getTag()));
                };
                for (Symbol symbol : set) {
                    if (!Flow.this.types.isSubtype(Flow.this.types.erasure(symbol.type), Flow.this.types.erasure(typeSymbol.type))) continue;
                    hashMap.put(symbol, hashMap.getOrDefault(symbol, List.nil()).prepend(object));
                }
            }
            HashSet hashSet = new HashSet();
            for (Map.Entry entry : hashMap.entrySet()) {
                if (!this.coversDeconstructionFromComponent(diagnosticPosition, type, (List)entry.getValue(), n + 1)) continue;
                hashSet.add((Symbol)entry.getKey());
            }
            return this.isExhaustive(diagnosticPosition, type2, hashSet);
        }

        private void transitiveCovers(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Set<Symbol> set) {
            List<Symbol> list = List.from(set);
            block4: while (list.nonEmpty()) {
                Symbol symbol2 = (Symbol)list.head;
                list = list.tail;
                switch (symbol2.kind) {
                    case VAR: {
                        Iterable<Symbol> iterable = symbol2.owner.members().getSymbols(symbol -> symbol.isEnum() && symbol.kind == Kinds.Kind.VAR);
                        boolean bl = StreamSupport.stream(iterable.spliterator(), false).allMatch(set::contains);
                        if (!bl || !set.add(symbol2.owner)) continue block4;
                        list = list.prepend(symbol2.owner);
                        break;
                    }
                    case TYP: {
                        for (Type type2 : Flow.this.types.directSupertypes(symbol2.type)) {
                            if (type2.tsym.kind != Kinds.Kind.TYP || !this.isTransitivelyCovered(diagnosticPosition, type, type2.tsym, set) || !set.add(type2.tsym)) continue;
                            list = list.prepend(type2.tsym);
                        }
                        break;
                    }
                }
            }
        }

        private boolean isTransitivelyCovered(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, Symbol symbol3, Set<Symbol> set) {
            try {
                if (set.stream().anyMatch(symbol2 -> symbol3.isSubClass((Symbol)symbol2, Flow.this.types))) {
                    return true;
                }
                if (symbol3.kind == Kinds.Kind.TYP && symbol3.isAbstract() && symbol3.isSealed()) {
                    return ((Symbol.ClassSymbol)symbol3).permitted.stream().filter(symbol -> Flow.this.types.isCastable(type, symbol.type)).allMatch(symbol -> this.isTransitivelyCovered(diagnosticPosition, type, (Symbol)symbol, set));
                }
                return false;
            }
            catch (Symbol.CompletionFailure completionFailure) {
                Flow.this.chk.completionError(diagnosticPosition, completionFailure);
                return true;
            }
        }

        private boolean isExhaustive(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type2, Set<Symbol> set) {
            this.transitiveCovers(diagnosticPosition, type2, set);
            return switch (type2.getTag()) {
                case TypeTag.CLASS -> {
                    if (type2.isCompound()) {
                        if (type2.isIntersection()) {
                            yield ((Type.IntersectionClassType)type2).getComponents().stream().anyMatch(type -> this.isExhaustive(diagnosticPosition, (Type)type, set));
                        }
                        yield false;
                    }
                    yield set.stream().filter(symbol -> symbol.kind == Kinds.Kind.TYP).anyMatch(symbol -> Flow.this.types.isSubtype(Flow.this.types.erasure(type2), Flow.this.types.erasure(symbol.type)));
                }
                case TypeTag.TYPEVAR -> this.isExhaustive(diagnosticPosition, ((Type.TypeVar)type2).getUpperBound(), set);
                default -> set.contains(type2.tsym);
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitTry(JCTree.JCTry jCTry) {
            void var4_6;
            JCTree jCTree;
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            for (JCTree object2 : jCTry.resources) {
                if (object2 instanceof JCTree.JCVariableDecl) {
                    JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)object2;
                    this.visitVarDef(jCVariableDecl);
                    continue;
                }
                if (object2 instanceof JCTree.JCExpression) {
                    jCTree = (JCTree.JCExpression)object2;
                    this.scan(jCTree);
                    continue;
                }
                throw new AssertionError(jCTry);
            }
            this.scanStat(jCTry.body);
            Object object3 = this.alive;
            List<JCTree.JCCatch> list = jCTry.catchers;
            while (var4_6.nonEmpty()) {
                this.alive = Liveness.ALIVE;
                jCTree = ((JCTree.JCCatch)var4_6.head).param;
                this.scan(jCTree);
                this.scanStat(((JCTree.JCCatch)var4_6.head).body);
                object3 = ((Liveness)((Object)object3)).or(this.alive);
                List list2 = var4_6.tail;
            }
            if (jCTry.finalizer != null) {
                ListBuffer listBuffer2 = this.pendingExits;
                this.pendingExits = listBuffer;
                this.alive = Liveness.ALIVE;
                this.scanStat(jCTry.finalizer);
                boolean bl = jCTry.finallyCanCompleteNormally = this.alive != Liveness.DEAD;
                if (this.alive == Liveness.DEAD) {
                    if (Flow.this.lint.isEnabled(Lint.LintCategory.FINALLY)) {
                        Flow.this.log.warning(Lint.LintCategory.FINALLY, TreeInfo.diagEndPos(jCTry.finalizer), CompilerProperties.Warnings.FinallyCannotComplete);
                    }
                } else {
                    while (listBuffer2.nonEmpty()) {
                        this.pendingExits.append((BaseAnalyzer.PendingExit)listBuffer2.next());
                    }
                    this.alive = object3;
                }
            } else {
                this.alive = object3;
                ListBuffer listBuffer3 = this.pendingExits;
                this.pendingExits = listBuffer;
                while (listBuffer3.nonEmpty()) {
                    this.pendingExits.append((BaseAnalyzer.PendingExit)listBuffer3.next());
                }
            }
        }

        @Override
        public void visitIf(JCTree.JCIf jCIf) {
            this.scan(jCIf.cond);
            this.scanStat(jCIf.thenpart);
            if (jCIf.elsepart != null) {
                Liveness liveness = this.alive;
                this.alive = Liveness.ALIVE;
                this.scanStat(jCIf.elsepart);
                this.alive = this.alive.or(liveness);
            } else {
                this.alive = Liveness.ALIVE;
            }
        }

        @Override
        public void visitBreak(JCTree.JCBreak jCBreak) {
            this.recordExit(new BaseAnalyzer.PendingExit(jCBreak));
        }

        @Override
        public void visitYield(JCTree.JCYield jCYield) {
            this.scan(jCYield.value);
            this.recordExit(new BaseAnalyzer.PendingExit(jCYield));
        }

        @Override
        public void visitContinue(JCTree.JCContinue jCContinue) {
            this.recordExit(new BaseAnalyzer.PendingExit(jCContinue));
        }

        @Override
        public void visitReturn(JCTree.JCReturn jCReturn) {
            this.scan(jCReturn.expr);
            this.recordExit(new BaseAnalyzer.PendingExit(jCReturn));
        }

        @Override
        public void visitThrow(JCTree.JCThrow jCThrow) {
            this.scan(jCThrow.expr);
            this.markDead();
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
            this.scan(jCMethodInvocation.meth);
            this.scan(jCMethodInvocation.args);
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass jCNewClass) {
            this.scan(jCNewClass.encl);
            this.scan(jCNewClass.args);
            if (jCNewClass.def != null) {
                this.scan(jCNewClass.def);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            if (jCLambda.type != null && jCLambda.type.isErroneous()) {
                return;
            }
            ListBuffer listBuffer = this.pendingExits;
            Liveness liveness = this.alive;
            try {
                this.pendingExits = new ListBuffer();
                this.alive = Liveness.ALIVE;
                this.scanStat(jCLambda.body);
                jCLambda.canCompleteNormally = this.alive != Liveness.DEAD;
            }
            finally {
                this.pendingExits = listBuffer;
                this.alive = liveness;
            }
        }

        @Override
        public void visitModuleDef(JCTree.JCModuleDecl jCModuleDecl) {
        }

        public void analyzeTree(Env<AttrContext> env, TreeMaker treeMaker) {
            this.analyzeTree(env, env.tree, treeMaker);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void analyzeTree(Env<AttrContext> env, JCTree jCTree, TreeMaker treeMaker) {
            try {
                Flow.this.attrEnv = env;
                Flow.this.make = treeMaker;
                this.pendingExits = new ListBuffer();
                this.alive = Liveness.ALIVE;
                this.scan(jCTree);
            }
            finally {
                this.pendingExits = null;
                Flow.this.make = null;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public class AssignAnalyzer
    extends BaseAnalyzer {
        final Bits inits;
        final Bits uninits;
        final Bits uninitsTry;
        final Bits initsWhenTrue;
        final Bits initsWhenFalse;
        final Bits uninitsWhenTrue;
        final Bits uninitsWhenFalse;
        protected JCTree.JCVariableDecl[] vardecls;
        JCTree.JCClassDecl classDef;
        int firstadr;
        protected int nextadr;
        protected int returnadr;
        Scope.WriteableScope unrefdResources;
        FlowKind flowKind = FlowKind.NORMAL;
        int startPos;
        private boolean isInitialConstructor = false;

        public AssignAnalyzer() {
            this.inits = new Bits();
            this.uninits = new Bits();
            this.uninitsTry = new Bits();
            this.initsWhenTrue = new Bits(true);
            this.initsWhenFalse = new Bits(true);
            this.uninitsWhenTrue = new Bits(true);
            this.uninitsWhenFalse = new Bits(true);
        }

        @Override
        protected void markDead() {
            if (!this.isInitialConstructor) {
                this.inits.inclRange(this.returnadr, this.nextadr);
            } else {
                for (int i = this.returnadr; i < this.nextadr; ++i) {
                    if (this.isFinalUninitializedStaticField(this.vardecls[i].sym)) continue;
                    this.inits.incl(i);
                }
            }
            this.uninits.inclRange(this.returnadr, this.nextadr);
        }

        protected boolean trackable(Symbol.VarSymbol varSymbol) {
            return varSymbol.pos >= this.startPos && (varSymbol.owner.kind == Kinds.Kind.MTH || varSymbol.owner.kind == Kinds.Kind.VAR || this.isFinalUninitializedField(varSymbol));
        }

        boolean isFinalUninitializedField(Symbol.VarSymbol varSymbol) {
            return varSymbol.owner.kind == Kinds.Kind.TYP && (varSymbol.flags() & 0x200040010L) == 16L && this.classDef.sym.isEnclosedBy((Symbol.ClassSymbol)varSymbol.owner);
        }

        boolean isFinalUninitializedStaticField(Symbol.VarSymbol varSymbol) {
            return this.isFinalUninitializedField(varSymbol) && varSymbol.isStatic();
        }

        void newVar(JCTree.JCVariableDecl jCVariableDecl) {
            Symbol.VarSymbol varSymbol = jCVariableDecl.sym;
            this.vardecls = ArrayUtils.ensureCapacity(this.vardecls, this.nextadr);
            if ((varSymbol.flags() & 0x10L) == 0L) {
                varSymbol.flags_field |= 0x20000000000L;
            }
            varSymbol.adr = this.nextadr;
            this.vardecls[this.nextadr] = jCVariableDecl;
            this.inits.excl(this.nextadr);
            this.uninits.incl(this.nextadr);
            ++this.nextadr;
        }

        void letInit(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.VarSymbol varSymbol) {
            if (varSymbol.adr >= this.firstadr && this.trackable(varSymbol)) {
                if ((varSymbol.flags() & 0x20000000000L) != 0L) {
                    if (!this.uninits.isMember(varSymbol.adr)) {
                        varSymbol.flags_field &= 0xFFFFFDFFFFFFFFFFL;
                    } else {
                        this.uninit(varSymbol);
                    }
                } else if ((varSymbol.flags() & 0x10L) != 0L) {
                    if ((varSymbol.flags() & 0x200000000L) != 0L) {
                        if ((varSymbol.flags() & 0x8000000000L) != 0L) {
                            Flow.this.log.error(diagnosticPosition, CompilerProperties.Errors.MulticatchParameterMayNotBeAssigned(varSymbol));
                        } else {
                            Flow.this.log.error(diagnosticPosition, CompilerProperties.Errors.FinalParameterMayNotBeAssigned(varSymbol));
                        }
                    } else if (!this.uninits.isMember(varSymbol.adr)) {
                        Flow.this.log.error(diagnosticPosition, Flow.this.diags.errorKey(this.flowKind.errKey, varSymbol));
                    } else {
                        this.uninit(varSymbol);
                    }
                }
                this.inits.incl(varSymbol.adr);
            } else if ((varSymbol.flags() & 0x10L) != 0L) {
                Flow.this.log.error(diagnosticPosition, CompilerProperties.Errors.VarMightAlreadyBeAssigned(varSymbol));
            }
        }

        void uninit(Symbol.VarSymbol varSymbol) {
            if (!this.inits.isMember(varSymbol.adr)) {
                this.uninits.excl(varSymbol.adr);
                this.uninitsTry.excl(varSymbol.adr);
            } else {
                this.uninits.excl(varSymbol.adr);
            }
        }

        void letInit(JCTree jCTree) {
            if ((jCTree = TreeInfo.skipParens(jCTree)).hasTag(JCTree.Tag.IDENT) || jCTree.hasTag(JCTree.Tag.SELECT)) {
                Symbol symbol = TreeInfo.symbol(jCTree);
                if (symbol.kind == Kinds.Kind.VAR) {
                    this.letInit(jCTree.pos(), (Symbol.VarSymbol)symbol);
                }
            }
        }

        void checkInit(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.VarSymbol varSymbol) {
            this.checkInit(diagnosticPosition, varSymbol, CompilerProperties.Errors.VarMightNotHaveBeenInitialized(varSymbol));
        }

        void checkInit(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.VarSymbol varSymbol, JCDiagnostic.Error error) {
            if ((varSymbol.adr >= this.firstadr || varSymbol.owner.kind != Kinds.Kind.TYP) && this.trackable(varSymbol) && !this.inits.isMember(varSymbol.adr) && (varSymbol.flags_field & 0x40000000000L) == 0L) {
                Flow.this.log.error(diagnosticPosition, error);
                this.inits.incl(varSymbol.adr);
            }
        }

        private void resetBits(Bits ... bitsArray) {
            for (Bits bits : bitsArray) {
                bits.reset();
            }
        }

        void split(boolean bl) {
            this.initsWhenFalse.assign(this.inits);
            this.uninitsWhenFalse.assign(this.uninits);
            this.initsWhenTrue.assign(this.inits);
            this.uninitsWhenTrue.assign(this.uninits);
            if (bl) {
                this.resetBits(this.inits, this.uninits);
            }
        }

        protected void merge() {
            this.inits.assign(this.initsWhenFalse.andSet(this.initsWhenTrue));
            this.uninits.assign(this.uninitsWhenFalse.andSet(this.uninitsWhenTrue));
        }

        void scanExpr(JCTree jCTree) {
            if (jCTree != null) {
                this.scan(jCTree);
                if (this.inits.isReset()) {
                    this.merge();
                }
            }
        }

        void scanExprs(List<? extends JCTree.JCExpression> list) {
            if (list != null) {
                List<JCTree.JCExpression> list2 = list;
                while (list2.nonEmpty()) {
                    this.scanExpr((JCTree)list2.head);
                    list2 = list2.tail;
                }
            }
        }

        void scanPattern(JCTree jCTree) {
            this.scan(jCTree);
            if (this.inits.isReset()) {
                this.inits.assign(this.initsWhenTrue);
                this.uninits.assign(this.uninitsWhenTrue);
            }
        }

        void scanCond(JCTree jCTree) {
            if (jCTree.type.isFalse()) {
                if (this.inits.isReset()) {
                    this.merge();
                }
                this.initsWhenTrue.assign(this.inits);
                this.initsWhenTrue.inclRange(this.firstadr, this.nextadr);
                this.uninitsWhenTrue.assign(this.uninits);
                this.uninitsWhenTrue.inclRange(this.firstadr, this.nextadr);
                this.initsWhenFalse.assign(this.inits);
                this.uninitsWhenFalse.assign(this.uninits);
            } else if (jCTree.type.isTrue()) {
                if (this.inits.isReset()) {
                    this.merge();
                }
                this.initsWhenFalse.assign(this.inits);
                this.initsWhenFalse.inclRange(this.firstadr, this.nextadr);
                this.uninitsWhenFalse.assign(this.uninits);
                this.uninitsWhenFalse.inclRange(this.firstadr, this.nextadr);
                this.initsWhenTrue.assign(this.inits);
                this.uninitsWhenTrue.assign(this.uninits);
            } else {
                this.scan(jCTree);
                if (!this.inits.isReset()) {
                    this.split(jCTree.type != Flow.this.syms.unknownType);
                }
            }
            if (jCTree.type != Flow.this.syms.unknownType) {
                this.resetBits(this.inits, this.uninits);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            if (jCClassDecl.sym == null) {
                return;
            }
            Lint lint = Flow.this.lint;
            Flow.this.lint = Flow.this.lint.augment(jCClassDecl.sym);
            try {
                if (jCClassDecl.sym == null) {
                    return;
                }
                JCTree.JCClassDecl jCClassDecl2 = this.classDef;
                int n = this.firstadr;
                int n2 = this.nextadr;
                ListBuffer listBuffer = this.pendingExits;
                this.pendingExits = new ListBuffer();
                if (jCClassDecl.name != Flow.this.names.empty) {
                    this.firstadr = this.nextadr;
                }
                this.classDef = jCClassDecl;
                try {
                    Symbol.VarSymbol varSymbol;
                    JCTree.JCVariableDecl jCVariableDecl;
                    List<JCTree> list = jCClassDecl.defs;
                    while (list.nonEmpty()) {
                        if (((JCTree)list.head).hasTag(JCTree.Tag.VARDEF)) {
                            jCVariableDecl = (JCTree.JCVariableDecl)list.head;
                            if ((jCVariableDecl.mods.flags & 8L) != 0L && this.trackable(varSymbol = jCVariableDecl.sym)) {
                                this.newVar(jCVariableDecl);
                            }
                        }
                        list = list.tail;
                    }
                    list = jCClassDecl.defs;
                    while (list.nonEmpty()) {
                        if (!((JCTree)list.head).hasTag(JCTree.Tag.METHODDEF) && (TreeInfo.flags((JCTree)list.head) & 8L) != 0L) {
                            this.scan((JCTree)list.head);
                            this.clearPendingExits(false);
                        }
                        list = list.tail;
                    }
                    list = jCClassDecl.defs;
                    while (list.nonEmpty()) {
                        if (((JCTree)list.head).hasTag(JCTree.Tag.VARDEF)) {
                            jCVariableDecl = (JCTree.JCVariableDecl)list.head;
                            if ((jCVariableDecl.mods.flags & 8L) == 0L && this.trackable(varSymbol = jCVariableDecl.sym)) {
                                this.newVar(jCVariableDecl);
                            }
                        }
                        list = list.tail;
                    }
                    list = jCClassDecl.defs;
                    while (list.nonEmpty()) {
                        if (!((JCTree)list.head).hasTag(JCTree.Tag.METHODDEF) && (TreeInfo.flags((JCTree)list.head) & 8L) == 0L) {
                            this.scan((JCTree)list.head);
                            this.clearPendingExits(false);
                        }
                        list = list.tail;
                    }
                    list = jCClassDecl.defs;
                    while (list.nonEmpty()) {
                        if (((JCTree)list.head).hasTag(JCTree.Tag.METHODDEF)) {
                            this.scan((JCTree)list.head);
                        }
                        list = list.tail;
                    }
                }
                finally {
                    this.pendingExits = listBuffer;
                    this.nextadr = n2;
                    this.firstadr = n;
                    this.classDef = jCClassDecl2;
                }
            }
            finally {
                Flow.this.lint = lint;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
            if (jCMethodDecl.body == null) {
                return;
            }
            if ((jCMethodDecl.sym.flags() & 0x1000L) != 0L) {
                return;
            }
            Lint lint = Flow.this.lint;
            Flow.this.lint = Flow.this.lint.augment(jCMethodDecl.sym);
            try {
                if (jCMethodDecl.body == null) {
                    return;
                }
                if ((jCMethodDecl.sym.flags() & 0x2000000001000L) == 4096L) {
                    return;
                }
                Bits bits = new Bits(this.inits);
                Bits bits2 = new Bits(this.uninits);
                int n = this.nextadr;
                int n2 = this.firstadr;
                int n3 = this.returnadr;
                Assert.check(this.pendingExits.isEmpty());
                boolean bl = this.isInitialConstructor;
                try {
                    boolean bl2;
                    this.isInitialConstructor = TreeInfo.isInitialConstructor(jCMethodDecl);
                    if (!this.isInitialConstructor) {
                        this.firstadr = this.nextadr;
                    }
                    List<JCTree.JCVariableDecl> list = jCMethodDecl.params;
                    while (list.nonEmpty()) {
                        JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)list.head;
                        this.scan(jCVariableDecl);
                        Assert.check((jCVariableDecl.sym.flags() & 0x200000000L) != 0L, "Method parameter without PARAMETER flag");
                        this.initParam(jCVariableDecl);
                        list = list.tail;
                    }
                    this.scan(jCMethodDecl.body);
                    boolean bl3 = bl2 = (jCMethodDecl.sym.flags() & 0x8000000000000L) != 0L;
                    if (this.isInitialConstructor) {
                        boolean bl4 = (jCMethodDecl.sym.flags() & 0x1000000000L) != 0L;
                        for (int i = this.firstadr; i < this.nextadr; ++i) {
                            JCTree.JCVariableDecl jCVariableDecl = this.vardecls[i];
                            Symbol.VarSymbol varSymbol = jCVariableDecl.sym;
                            if (varSymbol.owner != this.classDef.sym) continue;
                            if (bl4 && !bl2) {
                                this.checkInit(TreeInfo.diagnosticPositionFor((Symbol)varSymbol, jCVariableDecl), varSymbol, CompilerProperties.Errors.VarNotInitializedInDefaultConstructor(varSymbol));
                                continue;
                            }
                            if (bl2) {
                                boolean bl5;
                                boolean bl6 = bl5 = varSymbol.enclClass().isRecord() && (varSymbol.flags_field & 0x2000000001000012L) != 0L && !varSymbol.isStatic() && varSymbol.owner.kind == Kinds.Kind.TYP;
                                if (bl5) {
                                    boolean bl7;
                                    boolean bl8 = bl7 = !this.inits.isMember(varSymbol.adr);
                                    if (bl7 && this.uninits.isMember(varSymbol.adr) && jCMethodDecl.completesNormally) {
                                        varSymbol.flags_field |= 0x8000000000000L;
                                        continue;
                                    }
                                    this.checkInit(TreeInfo.diagEndPos(jCMethodDecl.body), varSymbol);
                                    continue;
                                }
                                this.checkInit(TreeInfo.diagnosticPositionFor((Symbol)varSymbol, jCVariableDecl), varSymbol);
                                continue;
                            }
                            this.checkInit(TreeInfo.diagEndPos(jCMethodDecl.body), varSymbol);
                        }
                    }
                    this.clearPendingExits(true);
                }
                finally {
                    this.inits.assign(bits);
                    this.uninits.assign(bits2);
                    this.nextadr = n;
                    this.firstadr = n2;
                    this.returnadr = n3;
                    this.isInitialConstructor = bl;
                }
            }
            finally {
                Flow.this.lint = lint;
            }
        }

        private void clearPendingExits(boolean bl) {
            List list = this.pendingExits.toList();
            this.pendingExits = new ListBuffer();
            while (list.nonEmpty()) {
                BaseAnalyzer.PendingExit pendingExit = (BaseAnalyzer.PendingExit)list.head;
                list = list.tail;
                Assert.check(bl && pendingExit.tree.hasTag(JCTree.Tag.RETURN) || Flow.this.log.hasErrorOn(pendingExit.tree.pos()), pendingExit.tree);
                if (!bl || !this.isInitialConstructor) continue;
                Assert.check(pendingExit instanceof AssignPendingExit);
                this.inits.assign(((AssignPendingExit)pendingExit).exit_inits);
                for (int i = this.firstadr; i < this.nextadr; ++i) {
                    this.checkInit(pendingExit.tree.pos(), this.vardecls[i].sym);
                }
            }
        }

        protected void initParam(JCTree.JCVariableDecl jCVariableDecl) {
            this.inits.incl(jCVariableDecl.sym.adr);
            this.uninits.excl(jCVariableDecl.sym.adr);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            Lint lint = Flow.this.lint;
            Flow.this.lint = Flow.this.lint.augment(jCVariableDecl.sym);
            try {
                boolean bl = this.trackable(jCVariableDecl.sym);
                if (bl && (jCVariableDecl.sym.owner.kind == Kinds.Kind.MTH || jCVariableDecl.sym.owner.kind == Kinds.Kind.VAR)) {
                    this.newVar(jCVariableDecl);
                }
                if (jCVariableDecl.init != null) {
                    this.scanExpr(jCVariableDecl.init);
                    if (bl) {
                        this.letInit(jCVariableDecl.pos(), jCVariableDecl.sym);
                    }
                }
            }
            finally {
                Flow.this.lint = lint;
            }
        }

        @Override
        public void visitBlock(JCTree.JCBlock jCBlock) {
            int n = this.nextadr;
            this.scan(jCBlock.stats);
            this.nextadr = n;
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
            ListBuffer listBuffer = this.pendingExits;
            FlowKind flowKind = this.flowKind;
            this.flowKind = FlowKind.NORMAL;
            Bits bits = new Bits(true);
            Bits bits2 = new Bits(true);
            this.pendingExits = new ListBuffer();
            int n = Flow.this.log.nerrors;
            while (true) {
                Bits bits3 = new Bits(this.uninits);
                bits3.excludeFrom(this.nextadr);
                this.scan(jCDoWhileLoop.body);
                this.resolveContinues(jCDoWhileLoop);
                this.scanCond(jCDoWhileLoop.cond);
                if (!this.flowKind.isFinal()) {
                    bits.assign(this.initsWhenFalse);
                    bits2.assign(this.uninitsWhenFalse);
                }
                if (Flow.this.log.nerrors != n || this.flowKind.isFinal() || new Bits(bits3).diffSet(this.uninitsWhenTrue).nextBit(this.firstadr) == -1) break;
                this.inits.assign(this.initsWhenTrue);
                this.uninits.assign(bits3.andSet(this.uninitsWhenTrue));
                this.flowKind = FlowKind.SPECULATIVE_LOOP;
            }
            this.flowKind = flowKind;
            this.inits.assign(bits);
            this.uninits.assign(bits2);
            this.resolveBreaks(jCDoWhileLoop, listBuffer);
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
            ListBuffer listBuffer = this.pendingExits;
            FlowKind flowKind = this.flowKind;
            this.flowKind = FlowKind.NORMAL;
            Bits bits = new Bits(true);
            Bits bits2 = new Bits(true);
            this.pendingExits = new ListBuffer();
            int n = Flow.this.log.nerrors;
            Bits bits3 = new Bits(this.uninits);
            bits3.excludeFrom(this.nextadr);
            while (true) {
                this.scanCond(jCWhileLoop.cond);
                if (!this.flowKind.isFinal()) {
                    bits.assign(this.initsWhenFalse);
                    bits2.assign(this.uninitsWhenFalse);
                }
                this.inits.assign(this.initsWhenTrue);
                this.uninits.assign(this.uninitsWhenTrue);
                this.scan(jCWhileLoop.body);
                this.resolveContinues(jCWhileLoop);
                if (Flow.this.log.nerrors != n || this.flowKind.isFinal() || new Bits(bits3).diffSet(this.uninits).nextBit(this.firstadr) == -1) break;
                this.uninits.assign(bits3.andSet(this.uninits));
                this.flowKind = FlowKind.SPECULATIVE_LOOP;
            }
            this.flowKind = flowKind;
            this.inits.assign(bits);
            this.uninits.assign(bits2);
            this.resolveBreaks(jCWhileLoop, listBuffer);
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop jCForLoop) {
            ListBuffer listBuffer = this.pendingExits;
            FlowKind flowKind = this.flowKind;
            this.flowKind = FlowKind.NORMAL;
            int n = this.nextadr;
            this.scan(jCForLoop.init);
            Bits bits = new Bits(true);
            Bits bits2 = new Bits(true);
            this.pendingExits = new ListBuffer();
            int n2 = Flow.this.log.nerrors;
            while (true) {
                Bits bits3 = new Bits(this.uninits);
                bits3.excludeFrom(this.nextadr);
                if (jCForLoop.cond != null) {
                    this.scanCond(jCForLoop.cond);
                    if (!this.flowKind.isFinal()) {
                        bits.assign(this.initsWhenFalse);
                        bits2.assign(this.uninitsWhenFalse);
                    }
                    this.inits.assign(this.initsWhenTrue);
                    this.uninits.assign(this.uninitsWhenTrue);
                } else if (!this.flowKind.isFinal()) {
                    bits.assign(this.inits);
                    bits.inclRange(this.firstadr, this.nextadr);
                    bits2.assign(this.uninits);
                    bits2.inclRange(this.firstadr, this.nextadr);
                }
                this.scan(jCForLoop.body);
                this.resolveContinues(jCForLoop);
                this.scan(jCForLoop.step);
                if (Flow.this.log.nerrors != n2 || this.flowKind.isFinal() || new Bits(bits3).diffSet(this.uninits).nextBit(this.firstadr) == -1) break;
                this.uninits.assign(bits3.andSet(this.uninits));
                this.flowKind = FlowKind.SPECULATIVE_LOOP;
            }
            this.flowKind = flowKind;
            this.inits.assign(bits);
            this.uninits.assign(bits2);
            this.resolveBreaks(jCForLoop, listBuffer);
            this.nextadr = n;
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
            this.visitVarDef(jCEnhancedForLoop.var);
            ListBuffer listBuffer = this.pendingExits;
            FlowKind flowKind = this.flowKind;
            this.flowKind = FlowKind.NORMAL;
            int n = this.nextadr;
            this.scan(jCEnhancedForLoop.expr);
            Bits bits = new Bits(this.inits);
            Bits bits2 = new Bits(this.uninits);
            this.letInit(jCEnhancedForLoop.pos(), jCEnhancedForLoop.var.sym);
            this.pendingExits = new ListBuffer();
            int n2 = Flow.this.log.nerrors;
            while (true) {
                Bits bits3 = new Bits(this.uninits);
                bits3.excludeFrom(this.nextadr);
                this.scan(jCEnhancedForLoop.body);
                this.resolveContinues(jCEnhancedForLoop);
                if (Flow.this.log.nerrors != n2 || this.flowKind.isFinal() || new Bits(bits3).diffSet(this.uninits).nextBit(this.firstadr) == -1) break;
                this.uninits.assign(bits3.andSet(this.uninits));
                this.flowKind = FlowKind.SPECULATIVE_LOOP;
            }
            this.flowKind = flowKind;
            this.inits.assign(bits);
            this.uninits.assign(bits2.andSet(this.uninits));
            this.resolveBreaks(jCEnhancedForLoop, listBuffer);
            this.nextadr = n;
        }

        @Override
        public void visitLabelled(JCTree.JCLabeledStatement jCLabeledStatement) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCLabeledStatement.body);
            this.resolveBreaks(jCLabeledStatement, listBuffer);
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch jCSwitch) {
            this.handleSwitch(jCSwitch, jCSwitch.selector, jCSwitch.cases, jCSwitch.isExhaustive);
        }

        @Override
        public void visitSwitchExpression(JCTree.JCSwitchExpression jCSwitchExpression) {
            this.handleSwitch(jCSwitchExpression, jCSwitchExpression.selector, jCSwitchExpression.cases, jCSwitchExpression.isExhaustive);
        }

        private void handleSwitch(JCTree jCTree, JCTree.JCExpression jCExpression, List<JCTree.JCCase> list, boolean bl) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            int n = this.nextadr;
            this.scanExpr(jCExpression);
            Bits bits = new Bits(this.inits);
            Bits bits2 = new Bits(this.uninits);
            List<JCTree.JCCase> list2 = list;
            while (list2.nonEmpty()) {
                this.inits.assign(bits);
                this.uninits.assign(this.uninits.andSet(bits2));
                JCTree.JCCase jCCase = (JCTree.JCCase)list2.head;
                for (JCTree.JCCaseLabel jCCaseLabel : jCCase.labels) {
                    this.scanPattern(jCCaseLabel);
                }
                if (((JCTree.JCCase)list2.head).stats.isEmpty() && list2.tail.nonEmpty() && ((JCTree.JCCase)list2.tail.head).labels.size() == 1 && TreeInfo.isNullCaseLabel((JCTree.JCCaseLabel)((JCTree.JCCase)list2.tail.head).labels.head)) {
                    list2 = list2.tail;
                    jCCase = (JCTree.JCCase)list2.head;
                }
                this.scan(jCCase.stats);
                if (jCCase.completesNormally && jCCase.caseKind == JCTree.JCCase.RULE) {
                    this.scanSyntheticBreak(Flow.this.make, jCTree);
                }
                this.addVars(jCCase.stats, bits, bits2);
                list2 = list2.tail;
            }
            if (!bl) {
                if (jCTree.hasTag(JCTree.Tag.SWITCH_EXPRESSION)) {
                    this.markDead();
                } else if (jCTree.hasTag(JCTree.Tag.SWITCH) && !TreeInfo.expectedExhaustive((JCTree.JCSwitch)jCTree)) {
                    this.inits.assign(bits);
                    this.uninits.assign(this.uninits.andSet(bits2));
                }
            }
            if (jCTree.hasTag(JCTree.Tag.SWITCH_EXPRESSION)) {
                this.resolveYields(jCTree, listBuffer);
            } else {
                this.resolveBreaks(jCTree, listBuffer);
            }
            this.nextadr = n;
        }

        private void addVars(List<JCTree.JCStatement> list, Bits bits, Bits bits2) {
            while (list.nonEmpty()) {
                JCTree jCTree = (JCTree)list.head;
                if (jCTree.hasTag(JCTree.Tag.VARDEF)) {
                    int n = ((JCTree.JCVariableDecl)jCTree).sym.adr;
                    bits.excl(n);
                    bits2.incl(n);
                }
                list = list.tail;
            }
        }

        @Override
        public void visitTry(JCTree.JCTry jCTry) {
            Object object;
            Iterator iterator;
            ListBuffer<JCTree.JCVariableDecl> listBuffer = new ListBuffer<JCTree.JCVariableDecl>();
            Bits bits = new Bits(this.uninitsTry);
            ListBuffer listBuffer2 = this.pendingExits;
            this.pendingExits = new ListBuffer();
            Bits bits2 = new Bits(this.inits);
            this.uninitsTry.assign(this.uninits);
            for (JCTree object32 : jCTry.resources) {
                if (object32 instanceof JCTree.JCVariableDecl) {
                    iterator = (JCTree.JCVariableDecl)object32;
                    this.visitVarDef((JCTree.JCVariableDecl)((Object)iterator));
                    this.unrefdResources.enter(((JCTree.JCVariableDecl)((Object)iterator)).sym);
                    listBuffer.append((JCTree.JCVariableDecl)((Object)iterator));
                    continue;
                }
                if (object32 instanceof JCTree.JCExpression) {
                    JCTree.JCExpression n = (JCTree.JCExpression)object32;
                    this.scanExpr(n);
                    continue;
                }
                throw new AssertionError(jCTry);
            }
            this.scan(jCTry.body);
            this.uninitsTry.andSet(this.uninits);
            Bits bits3 = new Bits(this.inits);
            Bits bits4 = new Bits(this.uninits);
            int n = this.nextadr;
            if (!listBuffer.isEmpty() && Flow.this.lint.isEnabled(Lint.LintCategory.TRY)) {
                for (JCTree.JCVariableDecl jCVariableDecl : listBuffer) {
                    if (!this.unrefdResources.includes(jCVariableDecl.sym)) continue;
                    Flow.this.log.warning(Lint.LintCategory.TRY, jCVariableDecl.pos(), CompilerProperties.Warnings.TryResourceNotReferenced(jCVariableDecl.sym));
                    this.unrefdResources.remove(jCVariableDecl.sym);
                }
            }
            iterator = new Bits(bits2);
            Bits bits5 = new Bits(this.uninitsTry);
            AbstractCollection abstractCollection = jCTry.catchers;
            while (((List)abstractCollection).nonEmpty()) {
                object = ((JCTree.JCCatch)((List)abstractCollection).head).param;
                this.inits.assign((Bits)((Object)iterator));
                this.uninits.assign(bits5);
                this.scan((JCTree)object);
                this.initParam((JCTree.JCVariableDecl)object);
                this.scan(((JCTree.JCCatch)((List)abstractCollection).head).body);
                bits3.andSet(this.inits);
                bits4.andSet(this.uninits);
                this.nextadr = n;
                abstractCollection = ((List)abstractCollection).tail;
            }
            if (jCTry.finalizer != null) {
                this.inits.assign(bits2);
                this.uninits.assign(this.uninitsTry);
                abstractCollection = this.pendingExits;
                this.pendingExits = listBuffer2;
                this.scan(jCTry.finalizer);
                if (jCTry.finallyCanCompleteNormally) {
                    this.uninits.andSet(bits4);
                    while (((ListBuffer)abstractCollection).nonEmpty()) {
                        object = (BaseAnalyzer.PendingExit)((ListBuffer)abstractCollection).next();
                        if (object instanceof AssignPendingExit) {
                            AssignPendingExit assignPendingExit = (AssignPendingExit)object;
                            assignPendingExit.exit_inits.orSet(this.inits);
                            assignPendingExit.exit_uninits.andSet(this.uninits);
                        }
                        this.pendingExits.append(object);
                    }
                    this.inits.orSet(bits3);
                }
            } else {
                this.inits.assign(bits3);
                this.uninits.assign(bits4);
                abstractCollection = this.pendingExits;
                this.pendingExits = listBuffer2;
                while (((ListBuffer)abstractCollection).nonEmpty()) {
                    this.pendingExits.append((BaseAnalyzer.PendingExit)((ListBuffer)abstractCollection).next());
                }
            }
            this.uninitsTry.andSet(bits).andSet(this.uninits);
        }

        @Override
        public void visitConditional(JCTree.JCConditional jCConditional) {
            this.scanCond(jCConditional.cond);
            Bits bits = new Bits(this.initsWhenFalse);
            Bits bits2 = new Bits(this.uninitsWhenFalse);
            this.inits.assign(this.initsWhenTrue);
            this.uninits.assign(this.uninitsWhenTrue);
            if (jCConditional.truepart.type.hasTag(TypeTag.BOOLEAN) && jCConditional.falsepart.type.hasTag(TypeTag.BOOLEAN)) {
                this.scanCond(jCConditional.truepart);
                Bits bits3 = new Bits(this.initsWhenTrue);
                Bits bits4 = new Bits(this.initsWhenFalse);
                Bits bits5 = new Bits(this.uninitsWhenTrue);
                Bits bits6 = new Bits(this.uninitsWhenFalse);
                this.inits.assign(bits);
                this.uninits.assign(bits2);
                this.scanCond(jCConditional.falsepart);
                this.initsWhenTrue.andSet(bits3);
                this.initsWhenFalse.andSet(bits4);
                this.uninitsWhenTrue.andSet(bits5);
                this.uninitsWhenFalse.andSet(bits6);
            } else {
                this.scanExpr(jCConditional.truepart);
                Bits bits7 = new Bits(this.inits);
                Bits bits8 = new Bits(this.uninits);
                this.inits.assign(bits);
                this.uninits.assign(bits2);
                this.scanExpr(jCConditional.falsepart);
                this.inits.andSet(bits7);
                this.uninits.andSet(bits8);
            }
        }

        @Override
        public void visitIf(JCTree.JCIf jCIf) {
            this.scanCond(jCIf.cond);
            Bits bits = new Bits(this.initsWhenFalse);
            Bits bits2 = new Bits(this.uninitsWhenFalse);
            this.inits.assign(this.initsWhenTrue);
            this.uninits.assign(this.uninitsWhenTrue);
            this.scan(jCIf.thenpart);
            if (jCIf.elsepart != null) {
                Bits bits3 = new Bits(this.inits);
                Bits bits4 = new Bits(this.uninits);
                this.inits.assign(bits);
                this.uninits.assign(bits2);
                this.scan(jCIf.elsepart);
                this.inits.andSet(bits3);
                this.uninits.andSet(bits4);
            } else {
                this.inits.andSet(bits);
                this.uninits.andSet(bits2);
            }
        }

        @Override
        public void visitBreak(JCTree.JCBreak jCBreak) {
            this.recordExit(new AssignPendingExit(jCBreak, this.inits, this.uninits));
        }

        @Override
        public void visitYield(JCTree.JCYield jCYield) {
            JCTree.JCSwitchExpression jCSwitchExpression = (JCTree.JCSwitchExpression)jCYield.target;
            if (jCSwitchExpression != null && jCSwitchExpression.type.hasTag(TypeTag.BOOLEAN)) {
                this.scanCond(jCYield.value);
                final Bits bits = new Bits(this.initsWhenTrue);
                final Bits bits2 = new Bits(this.initsWhenFalse);
                final Bits bits3 = new Bits(this.uninitsWhenTrue);
                final Bits bits4 = new Bits(this.uninitsWhenFalse);
                BaseAnalyzer.PendingExit pendingExit = new BaseAnalyzer.PendingExit(jCYield){

                    @Override
                    void resolveJump() {
                        if (!AssignAnalyzer.this.inits.isReset()) {
                            AssignAnalyzer.this.split(true);
                        }
                        AssignAnalyzer.this.initsWhenTrue.andSet(bits);
                        AssignAnalyzer.this.initsWhenFalse.andSet(bits2);
                        AssignAnalyzer.this.uninitsWhenTrue.andSet(bits3);
                        AssignAnalyzer.this.uninitsWhenFalse.andSet(bits4);
                    }
                };
                this.merge();
                this.recordExit(pendingExit);
                return;
            }
            this.scanExpr(jCYield.value);
            this.recordExit(new AssignPendingExit(jCYield, this.inits, this.uninits));
        }

        @Override
        public void visitContinue(JCTree.JCContinue jCContinue) {
            this.recordExit(new AssignPendingExit(jCContinue, this.inits, this.uninits));
        }

        @Override
        public void visitReturn(JCTree.JCReturn jCReturn) {
            this.scanExpr(jCReturn.expr);
            this.recordExit(new AssignPendingExit(jCReturn, this.inits, this.uninits));
        }

        @Override
        public void visitThrow(JCTree.JCThrow jCThrow) {
            this.scanExpr(jCThrow.expr);
            this.markDead();
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
            this.scanExpr(jCMethodInvocation.meth);
            this.scanExprs(jCMethodInvocation.args);
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass jCNewClass) {
            this.scanExpr(jCNewClass.encl);
            this.scanExprs(jCNewClass.args);
            this.scan(jCNewClass.def);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            Bits bits = new Bits(this.uninits);
            Bits bits2 = new Bits(this.inits);
            int n = this.returnadr;
            int n2 = this.nextadr;
            ListBuffer listBuffer = this.pendingExits;
            try {
                this.returnadr = this.nextadr;
                this.pendingExits = new ListBuffer();
                List<JCTree.JCVariableDecl> list = jCLambda.params;
                while (list.nonEmpty()) {
                    JCTree.JCVariableDecl jCVariableDecl = (JCTree.JCVariableDecl)list.head;
                    this.scan(jCVariableDecl);
                    this.inits.incl(jCVariableDecl.sym.adr);
                    this.uninits.excl(jCVariableDecl.sym.adr);
                    list = list.tail;
                }
                if (jCLambda.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                    this.scanExpr(jCLambda.body);
                } else {
                    this.scan(jCLambda.body);
                }
            }
            finally {
                this.returnadr = n;
                this.uninits.assign(bits);
                this.inits.assign(bits2);
                this.pendingExits = listBuffer;
                this.nextadr = n2;
            }
        }

        @Override
        public void visitNewArray(JCTree.JCNewArray jCNewArray) {
            this.scanExprs(jCNewArray.dims);
            this.scanExprs(jCNewArray.elems);
        }

        @Override
        public void visitAssert(JCTree.JCAssert jCAssert) {
            Bits bits = new Bits(this.inits);
            Bits bits2 = new Bits(this.uninits);
            this.scanCond(jCAssert.cond);
            bits2.andSet(this.uninitsWhenTrue);
            if (jCAssert.detail != null) {
                this.inits.assign(this.initsWhenFalse);
                this.uninits.assign(this.uninitsWhenFalse);
                this.scanExpr(jCAssert.detail);
            }
            this.inits.assign(bits);
            this.uninits.assign(bits2);
        }

        @Override
        public void visitAssign(JCTree.JCAssign jCAssign) {
            if (!TreeInfo.isIdentOrThisDotIdent(jCAssign.lhs)) {
                this.scanExpr(jCAssign.lhs);
            }
            this.scanExpr(jCAssign.rhs);
            this.letInit(jCAssign.lhs);
        }

        @Override
        public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
            super.visitSelect(jCFieldAccess);
            if (TreeInfo.isThisQualifier(jCFieldAccess.selected) && jCFieldAccess.sym.kind == Kinds.Kind.VAR) {
                this.checkInit(jCFieldAccess.pos(), (Symbol.VarSymbol)jCFieldAccess.sym);
            }
        }

        @Override
        public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
            this.scanExpr(jCAssignOp.lhs);
            this.scanExpr(jCAssignOp.rhs);
            this.letInit(jCAssignOp.lhs);
        }

        @Override
        public void visitUnary(JCTree.JCUnary jCUnary) {
            switch (jCUnary.getTag()) {
                case NOT: {
                    this.scanCond(jCUnary.arg);
                    Bits bits = new Bits(this.initsWhenFalse);
                    this.initsWhenFalse.assign(this.initsWhenTrue);
                    this.initsWhenTrue.assign(bits);
                    bits.assign(this.uninitsWhenFalse);
                    this.uninitsWhenFalse.assign(this.uninitsWhenTrue);
                    this.uninitsWhenTrue.assign(bits);
                    break;
                }
                case PREINC: 
                case POSTINC: 
                case PREDEC: 
                case POSTDEC: {
                    this.scanExpr(jCUnary.arg);
                    this.letInit(jCUnary.arg);
                    break;
                }
                default: {
                    this.scanExpr(jCUnary.arg);
                }
            }
        }

        @Override
        public void visitBinary(JCTree.JCBinary jCBinary) {
            switch (jCBinary.getTag()) {
                case AND: {
                    this.scanCond(jCBinary.lhs);
                    Bits bits = new Bits(this.initsWhenFalse);
                    Bits bits2 = new Bits(this.uninitsWhenFalse);
                    this.inits.assign(this.initsWhenTrue);
                    this.uninits.assign(this.uninitsWhenTrue);
                    this.scanCond(jCBinary.rhs);
                    this.initsWhenFalse.andSet(bits);
                    this.uninitsWhenFalse.andSet(bits2);
                    break;
                }
                case OR: {
                    this.scanCond(jCBinary.lhs);
                    Bits bits = new Bits(this.initsWhenTrue);
                    Bits bits3 = new Bits(this.uninitsWhenTrue);
                    this.inits.assign(this.initsWhenFalse);
                    this.uninits.assign(this.uninitsWhenFalse);
                    this.scanCond(jCBinary.rhs);
                    this.initsWhenTrue.andSet(bits);
                    this.uninitsWhenTrue.andSet(bits3);
                    break;
                }
                default: {
                    this.scanExpr(jCBinary.lhs);
                    this.scanExpr(jCBinary.rhs);
                }
            }
        }

        @Override
        public void visitIdent(JCTree.JCIdent jCIdent) {
            if (jCIdent.sym.kind == Kinds.Kind.VAR) {
                this.checkInit(jCIdent.pos(), (Symbol.VarSymbol)jCIdent.sym);
                this.referenced(jCIdent.sym);
            }
        }

        @Override
        public void visitTypeTest(JCTree.JCInstanceOf jCInstanceOf) {
            this.scanExpr(jCInstanceOf.expr);
            this.scan(jCInstanceOf.pattern);
        }

        @Override
        public void visitBindingPattern(JCTree.JCBindingPattern jCBindingPattern) {
            this.scan(jCBindingPattern.var);
            this.initParam(jCBindingPattern.var);
        }

        @Override
        public void visitPatternCaseLabel(JCTree.JCPatternCaseLabel jCPatternCaseLabel) {
            this.scan(jCPatternCaseLabel.pat);
            this.scan(jCPatternCaseLabel.guard);
        }

        @Override
        public void visitRecordPattern(JCTree.JCRecordPattern jCRecordPattern) {
            super.visitRecordPattern(jCRecordPattern);
            if (jCRecordPattern.var != null) {
                this.initParam(jCRecordPattern.var);
            }
        }

        void referenced(Symbol symbol) {
            this.unrefdResources.remove(symbol);
        }

        @Override
        public void visitAnnotatedType(JCTree.JCAnnotatedType jCAnnotatedType) {
            jCAnnotatedType.underlyingType.accept(this);
        }

        @Override
        public void visitModuleDef(JCTree.JCModuleDecl jCModuleDecl) {
        }

        public void analyzeTree(Env<?> env, TreeMaker treeMaker) {
            this.analyzeTree(env, env.tree, treeMaker);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void analyzeTree(Env<?> env, JCTree jCTree, TreeMaker treeMaker) {
            int n;
            try {
                this.startPos = jCTree.pos().getStartPosition();
                if (this.vardecls == null) {
                    this.vardecls = new JCTree.JCVariableDecl[32];
                } else {
                    for (n = 0; n < this.vardecls.length; ++n) {
                        this.vardecls[n] = null;
                    }
                }
                this.firstadr = 0;
                this.nextadr = 0;
                Flow.this.make = treeMaker;
                this.pendingExits = new ListBuffer();
                this.classDef = null;
                this.unrefdResources = Scope.WriteableScope.create(env.enclClass.sym);
                this.scan(jCTree);
                this.startPos = -1;
            }
            catch (Throwable throwable) {
                this.startPos = -1;
                this.resetBits(this.inits, this.uninits, this.uninitsTry, this.initsWhenTrue, this.initsWhenFalse, this.uninitsWhenTrue, this.uninitsWhenFalse);
                if (this.vardecls != null) {
                    for (int i = 0; i < this.vardecls.length; ++i) {
                        this.vardecls[i] = null;
                    }
                }
                this.firstadr = 0;
                this.nextadr = 0;
                Flow.this.make = null;
                this.pendingExits = null;
                this.classDef = null;
                this.unrefdResources = null;
                throw throwable;
            }
            this.resetBits(this.inits, this.uninits, this.uninitsTry, this.initsWhenTrue, this.initsWhenFalse, this.uninitsWhenTrue, this.uninitsWhenFalse);
            if (this.vardecls != null) {
                for (n = 0; n < this.vardecls.length; ++n) {
                    this.vardecls[n] = null;
                }
            }
            this.firstadr = 0;
            this.nextadr = 0;
            Flow.this.make = null;
            this.pendingExits = null;
            this.classDef = null;
            this.unrefdResources = null;
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        public class AssignPendingExit
        extends BaseAnalyzer.PendingExit {
            final Bits inits;
            final Bits uninits;
            final Bits exit_inits;
            final Bits exit_uninits;

            public AssignPendingExit(JCTree jCTree, Bits bits, Bits bits2) {
                super(jCTree);
                this.exit_inits = new Bits(true);
                this.exit_uninits = new Bits(true);
                this.inits = bits;
                this.uninits = bits2;
                this.exit_inits.assign(bits);
                this.exit_uninits.assign(bits2);
            }

            @Override
            public void resolveJump() {
                this.inits.andSet(this.exit_inits);
                this.uninits.andSet(this.exit_uninits);
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    class FlowAnalyzer
    extends BaseAnalyzer {
        HashMap<Symbol, List<Type>> preciseRethrowTypes;
        JCTree.JCClassDecl classDef;
        List<Type> thrown;
        List<Type> caught;

        FlowAnalyzer() {
        }

        @Override
        void markDead() {
        }

        void errorUncaught() {
            BaseAnalyzer.PendingExit pendingExit = (BaseAnalyzer.PendingExit)this.pendingExits.next();
            while (pendingExit != null) {
                if (pendingExit instanceof ThrownPendingExit) {
                    ThrownPendingExit thrownPendingExit = (ThrownPendingExit)pendingExit;
                    if (this.classDef != null && this.classDef.pos == pendingExit.tree.pos) {
                        Flow.this.log.error(pendingExit.tree.pos(), CompilerProperties.Errors.UnreportedExceptionDefaultConstructor(thrownPendingExit.thrown));
                    } else if (pendingExit.tree.hasTag(JCTree.Tag.VARDEF) && ((JCTree.JCVariableDecl)pendingExit.tree).sym.isResourceVariable()) {
                        Flow.this.log.error(pendingExit.tree.pos(), CompilerProperties.Errors.UnreportedExceptionImplicitClose(thrownPendingExit.thrown, ((JCTree.JCVariableDecl)pendingExit.tree).sym.name));
                    } else {
                        Flow.this.log.error(pendingExit.tree.pos(), CompilerProperties.Errors.UnreportedExceptionNeedToCatchOrThrow(thrownPendingExit.thrown));
                    }
                } else {
                    Assert.check(Flow.this.log.hasErrorOn(pendingExit.tree.pos()));
                }
                pendingExit = (BaseAnalyzer.PendingExit)this.pendingExits.next();
            }
        }

        void markThrown(JCTree jCTree, Type type) {
            if (!Flow.this.chk.isUnchecked(jCTree.pos(), type)) {
                if (!Flow.this.chk.isHandled(type, this.caught)) {
                    this.pendingExits.append(new ThrownPendingExit(jCTree, type));
                }
                this.thrown = Flow.this.chk.incl(type, this.thrown);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            if (jCClassDecl.sym == null) {
                return;
            }
            JCTree.JCClassDecl jCClassDecl2 = this.classDef;
            List<Type> list = this.thrown;
            List<Type> list2 = this.caught;
            ListBuffer listBuffer = this.pendingExits;
            Lint lint = Flow.this.lint;
            boolean bl = jCClassDecl.name == Flow.this.names.empty;
            this.pendingExits = new ListBuffer();
            if (!bl) {
                this.caught = List.nil();
            }
            this.classDef = jCClassDecl;
            this.thrown = List.nil();
            Flow.this.lint = Flow.this.lint.augment(jCClassDecl.sym);
            try {
                Object object;
                List<JCTree> list3 = jCClassDecl.defs;
                while (list3.nonEmpty()) {
                    if (!((JCTree)list3.head).hasTag(JCTree.Tag.METHODDEF) && (TreeInfo.flags((JCTree)list3.head) & 8L) != 0L) {
                        this.scan((JCTree)list3.head);
                        this.errorUncaught();
                    }
                    list3 = list3.tail;
                }
                if (!bl) {
                    boolean bl2 = true;
                    object = jCClassDecl.defs;
                    while (((List)object).nonEmpty()) {
                        if (TreeInfo.isInitialConstructor((JCTree)((List)object).head)) {
                            List<Type> list4 = ((JCTree.JCMethodDecl)((List)object).head).sym.type.getThrownTypes();
                            if (bl2) {
                                this.caught = list4;
                                bl2 = false;
                            } else {
                                this.caught = Flow.this.chk.intersect(list4, this.caught);
                            }
                        }
                        object = ((List)object).tail;
                    }
                }
                list3 = jCClassDecl.defs;
                while (list3.nonEmpty()) {
                    if (!((JCTree)list3.head).hasTag(JCTree.Tag.METHODDEF) && (TreeInfo.flags((JCTree)list3.head) & 8L) == 0L) {
                        this.scan((JCTree)list3.head);
                        this.errorUncaught();
                    }
                    list3 = list3.tail;
                }
                if (bl) {
                    list3 = jCClassDecl.defs;
                    while (list3.nonEmpty()) {
                        if (TreeInfo.isConstructor((JCTree)list3.head)) {
                            object = (JCTree.JCMethodDecl)list3.head;
                            this.scan((JCTree)object);
                            ((JCTree.JCMethodDecl)object).thrown = Flow.this.make.Types(this.thrown);
                            ((JCTree.JCMethodDecl)object).sym.type = Flow.this.types.createMethodTypeWithThrown(((JCTree.JCMethodDecl)object).sym.type, this.thrown);
                        }
                        list3 = list3.tail;
                    }
                    list = Flow.this.chk.union(this.thrown, list);
                }
                list3 = jCClassDecl.defs;
                while (list3.nonEmpty()) {
                    if (!(bl && TreeInfo.isConstructor((JCTree)list3.head) || !((JCTree)list3.head).hasTag(JCTree.Tag.METHODDEF))) {
                        this.scan((JCTree)list3.head);
                        this.errorUncaught();
                    }
                    list3 = list3.tail;
                }
                this.thrown = list;
            }
            finally {
                this.pendingExits = listBuffer;
                this.caught = list2;
                this.classDef = jCClassDecl2;
                Flow.this.lint = lint;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
            if (jCMethodDecl.body == null) {
                return;
            }
            List<Type> list = this.caught;
            List<Type> list2 = jCMethodDecl.sym.type.getThrownTypes();
            Lint lint = Flow.this.lint;
            Flow.this.lint = Flow.this.lint.augment(jCMethodDecl.sym);
            Assert.check(this.pendingExits.isEmpty());
            try {
                Object object;
                List<JCTree.JCVariableDecl> list3 = jCMethodDecl.params;
                while (list3.nonEmpty()) {
                    object = (JCTree.JCVariableDecl)list3.head;
                    this.scan((JCTree)object);
                    list3 = list3.tail;
                }
                if (TreeInfo.isInitialConstructor(jCMethodDecl)) {
                    this.caught = Flow.this.chk.union(this.caught, list2);
                } else if ((jCMethodDecl.sym.flags() & 0x100008L) != 0x100000L) {
                    this.caught = list2;
                }
                this.scan(jCMethodDecl.body);
                list3 = this.pendingExits.toList();
                this.pendingExits = new ListBuffer();
                while (list3.nonEmpty()) {
                    object = (BaseAnalyzer.PendingExit)list3.head;
                    list3 = list3.tail;
                    if (!(object instanceof ThrownPendingExit)) {
                        Assert.check(((BaseAnalyzer.PendingExit)object).tree.hasTag(JCTree.Tag.RETURN) || Flow.this.log.hasErrorOn(((BaseAnalyzer.PendingExit)object).tree.pos()));
                        continue;
                    }
                    this.pendingExits.append(object);
                }
            }
            finally {
                this.caught = list;
                Flow.this.lint = lint;
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            if (jCVariableDecl.init != null) {
                Lint lint = Flow.this.lint;
                Flow.this.lint = Flow.this.lint.augment(jCVariableDecl.sym);
                try {
                    this.scan(jCVariableDecl.init);
                }
                finally {
                    Flow.this.lint = lint;
                }
            }
        }

        @Override
        public void visitBlock(JCTree.JCBlock jCBlock) {
            this.scan(jCBlock.stats);
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCDoWhileLoop.body);
            this.resolveContinues(jCDoWhileLoop);
            this.scan(jCDoWhileLoop.cond);
            this.resolveBreaks(jCDoWhileLoop, listBuffer);
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCWhileLoop.cond);
            this.scan(jCWhileLoop.body);
            this.resolveContinues(jCWhileLoop);
            this.resolveBreaks(jCWhileLoop, listBuffer);
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop jCForLoop) {
            ListBuffer listBuffer = this.pendingExits;
            this.scan(jCForLoop.init);
            this.pendingExits = new ListBuffer();
            if (jCForLoop.cond != null) {
                this.scan(jCForLoop.cond);
            }
            this.scan(jCForLoop.body);
            this.resolveContinues(jCForLoop);
            this.scan(jCForLoop.step);
            this.resolveBreaks(jCForLoop, listBuffer);
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
            this.visitVarDef(jCEnhancedForLoop.var);
            ListBuffer listBuffer = this.pendingExits;
            this.scan(jCEnhancedForLoop.expr);
            this.pendingExits = new ListBuffer();
            this.scan(jCEnhancedForLoop.body);
            this.resolveContinues(jCEnhancedForLoop);
            this.resolveBreaks(jCEnhancedForLoop, listBuffer);
        }

        @Override
        public void visitLabelled(JCTree.JCLabeledStatement jCLabeledStatement) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCLabeledStatement.body);
            this.resolveBreaks(jCLabeledStatement, listBuffer);
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch jCSwitch) {
            this.handleSwitch(jCSwitch, jCSwitch.selector, jCSwitch.cases);
        }

        @Override
        public void visitSwitchExpression(JCTree.JCSwitchExpression jCSwitchExpression) {
            this.handleSwitch(jCSwitchExpression, jCSwitchExpression.selector, jCSwitchExpression.cases);
        }

        private void handleSwitch(JCTree jCTree, JCTree.JCExpression jCExpression, List<JCTree.JCCase> list) {
            ListBuffer listBuffer = this.pendingExits;
            this.pendingExits = new ListBuffer();
            this.scan(jCExpression);
            List<JCTree.JCCase> list2 = list;
            while (list2.nonEmpty()) {
                JCTree.JCCase jCCase = (JCTree.JCCase)list2.head;
                this.scan(jCCase.labels);
                this.scan(jCCase.stats);
                list2 = list2.tail;
            }
            if (jCTree.hasTag(JCTree.Tag.SWITCH_EXPRESSION)) {
                this.resolveYields(jCTree, listBuffer);
            } else {
                this.resolveBreaks(jCTree, listBuffer);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitTry(JCTree.JCTry jCTry) {
            void var6_12;
            Object object;
            List<Type> list;
            Object object2;
            AbstractCollection abstractCollection;
            Object object4;
            List<Type> list2 = this.caught;
            List<Type> list3 = this.thrown;
            this.thrown = List.nil();
            AbstractCollection abstractCollection2 = jCTry.catchers;
            while (abstractCollection2.nonEmpty()) {
                object4 = TreeInfo.isMultiCatch((JCTree.JCCatch)abstractCollection2.head) ? ((JCTree.JCTypeUnion)((JCTree.JCCatch)abstractCollection2.head).param.vartype).alternatives : List.of(((JCTree.JCCatch)abstractCollection2.head).param.vartype);
                Iterator object32 = ((List)object4).iterator();
                while (object32.hasNext()) {
                    abstractCollection = (JCTree.JCExpression)object32.next();
                    this.caught = Flow.this.chk.incl(((JCTree.JCExpression)((Object)abstractCollection)).type, this.caught);
                }
                abstractCollection2 = abstractCollection2.tail;
            }
            abstractCollection2 = this.pendingExits;
            this.pendingExits = new ListBuffer();
            for (JCTree jCTree : jCTry.resources) {
                if (jCTree instanceof JCTree.JCVariableDecl) {
                    object2 = (JCTree.JCVariableDecl)jCTree;
                    this.visitVarDef((JCTree.JCVariableDecl)object2);
                    continue;
                }
                if (jCTree instanceof JCTree.JCExpression) {
                    abstractCollection = (JCTree.JCExpression)jCTree;
                    this.scan((JCTree)((Object)abstractCollection));
                    continue;
                }
                throw new AssertionError(jCTry);
            }
            for (JCTree jCTree : jCTry.resources) {
                abstractCollection = jCTree.type.isCompound() ? Flow.this.types.interfaces(jCTree.type).prepend(Flow.this.types.supertype(jCTree.type)) : List.of(jCTree.type);
                for (Object object3 : abstractCollection) {
                    if (Flow.this.types.asSuper((Type)object3, Flow.this.syms.autoCloseableType.tsym) == null) continue;
                    list = Flow.this.rs.resolveQualifiedMethod(jCTry, Flow.this.attrEnv, Flow.this.types.skipTypeVars((Type)object3, false), Flow.this.names.close, List.nil(), List.nil());
                    object = Flow.this.types.memberType(jCTree.type, (Symbol)((Object)list));
                    if (((Symbol)((Object)list)).kind != Kinds.Kind.MTH) continue;
                    for (Type type : ((Type)object).getThrownTypes()) {
                        this.markThrown(jCTree, type);
                    }
                }
            }
            this.scan(jCTry.body);
            object4 = Flow.this.chk.union(this.thrown, List.of(Flow.this.syms.runtimeExceptionType, Flow.this.syms.errorType));
            this.thrown = list3;
            this.caught = list2;
            List list4 = List.nil();
            abstractCollection = jCTry.catchers;
            while (((List)abstractCollection).nonEmpty()) {
                Object object3;
                object2 = ((JCTree.JCCatch)((List)abstractCollection).head).param;
                object3 = TreeInfo.isMultiCatch((JCTree.JCCatch)((List)abstractCollection).head) ? ((JCTree.JCTypeUnion)((JCTree.JCCatch)((List)abstractCollection).head).param.vartype).alternatives : List.of(((JCTree.JCCatch)((List)abstractCollection).head).param.vartype);
                list = List.nil();
                object = Flow.this.chk.diff((List<Type>)object4, (List<Type>)var6_12);
                Iterator<Object> iterator = ((List)object3).iterator();
                while (iterator.hasNext()) {
                    JCTree.JCExpression jCExpression = (JCTree.JCExpression)iterator.next();
                    Type type = jCExpression.type;
                    if (type == Flow.this.syms.unknownType) continue;
                    list = list.append(type);
                    if (Flow.this.types.isSameType(type, Flow.this.syms.objectType)) continue;
                    JCDiagnostic.DiagnosticPosition diagnosticPosition = ((List)object3).size() > 1 ? jCExpression.pos() : ((JCTree.JCCatch)((List)abstractCollection).head).pos();
                    this.checkCaughtType(diagnosticPosition, type, (List<Type>)object4, (List<Type>)var6_12);
                    List<Type> list5 = Flow.this.chk.incl(type, (List<Type>)var6_12);
                }
                this.scan((JCTree)object2);
                this.preciseRethrowTypes.put(((JCTree.JCVariableDecl)object2).sym, Flow.this.chk.intersect(list, (List<Type>)object));
                this.scan(((JCTree.JCCatch)((List)abstractCollection).head).body);
                this.preciseRethrowTypes.remove(((JCTree.JCVariableDecl)object2).sym);
                abstractCollection = ((List)abstractCollection).tail;
            }
            if (jCTry.finalizer != null) {
                abstractCollection = this.thrown;
                this.thrown = List.nil();
                object2 = this.pendingExits;
                this.pendingExits = abstractCollection2;
                this.scan(jCTry.finalizer);
                if (!jCTry.finallyCanCompleteNormally) {
                    this.thrown = Flow.this.chk.union(this.thrown, list3);
                } else {
                    this.thrown = Flow.this.chk.union(this.thrown, Flow.this.chk.diff((List<Type>)object4, (List<Type>)var6_12));
                    this.thrown = Flow.this.chk.union(this.thrown, (List<Type>)abstractCollection);
                    while (((ListBuffer)object2).nonEmpty()) {
                        this.pendingExits.append((BaseAnalyzer.PendingExit)((ListBuffer)object2).next());
                    }
                }
            } else {
                this.thrown = Flow.this.chk.union(this.thrown, Flow.this.chk.diff((List<Type>)object4, (List<Type>)var6_12));
                abstractCollection = this.pendingExits;
                this.pendingExits = abstractCollection2;
                while (((ListBuffer)abstractCollection).nonEmpty()) {
                    this.pendingExits.append((BaseAnalyzer.PendingExit)((ListBuffer)abstractCollection).next());
                }
            }
        }

        @Override
        public void visitIf(JCTree.JCIf jCIf) {
            this.scan(jCIf.cond);
            this.scan(jCIf.thenpart);
            if (jCIf.elsepart != null) {
                this.scan(jCIf.elsepart);
            }
        }

        void checkCaughtType(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, List<Type> list, List<Type> list2) {
            if (Flow.this.chk.subset(type, list2)) {
                Flow.this.log.error(diagnosticPosition, CompilerProperties.Errors.ExceptAlreadyCaught(type));
            } else if (!(Flow.this.chk.isUnchecked(diagnosticPosition, type) || this.isExceptionOrThrowable(type) || Flow.this.chk.intersects(type, list))) {
                Flow.this.log.error(diagnosticPosition, CompilerProperties.Errors.ExceptNeverThrownInTry(type));
            } else {
                List<Type> list3 = Flow.this.chk.intersect(List.of(type), list);
                if (Flow.this.chk.diff(list3, list2).isEmpty() && !this.isExceptionOrThrowable(type)) {
                    JCDiagnostic.Warning warning = list3.length() == 1 ? CompilerProperties.Warnings.UnreachableCatch(list3) : CompilerProperties.Warnings.UnreachableCatch1(list3);
                    Flow.this.log.warning(diagnosticPosition, warning);
                }
            }
        }

        private boolean isExceptionOrThrowable(Type type) {
            return type.tsym == Flow.this.syms.throwableType.tsym || type.tsym == Flow.this.syms.exceptionType.tsym;
        }

        @Override
        public void visitBreak(JCTree.JCBreak jCBreak) {
            this.recordExit(new BaseAnalyzer.PendingExit(jCBreak));
        }

        @Override
        public void visitYield(JCTree.JCYield jCYield) {
            this.scan(jCYield.value);
            this.recordExit(new BaseAnalyzer.PendingExit(jCYield));
        }

        @Override
        public void visitContinue(JCTree.JCContinue jCContinue) {
            this.recordExit(new BaseAnalyzer.PendingExit(jCContinue));
        }

        @Override
        public void visitReturn(JCTree.JCReturn jCReturn) {
            this.scan(jCReturn.expr);
            this.recordExit(new BaseAnalyzer.PendingExit(jCReturn));
        }

        @Override
        public void visitThrow(JCTree.JCThrow jCThrow) {
            this.scan(jCThrow.expr);
            Symbol symbol = TreeInfo.symbol(jCThrow.expr);
            if (symbol != null && symbol.kind == Kinds.Kind.VAR && (symbol.flags() & 0x20000000010L) != 0L && this.preciseRethrowTypes.get(symbol) != null) {
                for (Type type : this.preciseRethrowTypes.get(symbol)) {
                    this.markThrown(jCThrow, type);
                }
            } else {
                this.markThrown(jCThrow, jCThrow.expr.type);
            }
            this.markDead();
        }

        @Override
        public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
            this.scan(jCMethodInvocation.meth);
            this.scan(jCMethodInvocation.args);
            List<Type> list = jCMethodInvocation.meth.type.getThrownTypes();
            while (list.nonEmpty()) {
                this.markThrown(jCMethodInvocation, (Type)list.head);
                list = list.tail;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitNewClass(JCTree.JCNewClass jCNewClass) {
            this.scan(jCNewClass.encl);
            this.scan(jCNewClass.args);
            List<Type> list = jCNewClass.constructorType.getThrownTypes();
            while (list.nonEmpty()) {
                this.markThrown(jCNewClass, (Type)list.head);
                list = list.tail;
            }
            list = this.caught;
            try {
                if (jCNewClass.def != null) {
                    List<Type> list2 = jCNewClass.constructor.type.getThrownTypes();
                    while (list2.nonEmpty()) {
                        this.caught = Flow.this.chk.incl((Type)list2.head, this.caught);
                        list2 = list2.tail;
                    }
                }
                this.scan(jCNewClass.def);
            }
            finally {
                this.caught = list;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            if (jCLambda.type != null && jCLambda.type.isErroneous()) {
                return;
            }
            List<Type> list = this.caught;
            List<Type> list2 = this.thrown;
            ListBuffer listBuffer = this.pendingExits;
            try {
                this.pendingExits = new ListBuffer();
                this.caught = jCLambda.getDescriptorType(Flow.this.types).getThrownTypes();
                this.thrown = List.nil();
                this.scan(jCLambda.body);
                List list3 = this.pendingExits.toList();
                this.pendingExits = new ListBuffer();
                while (list3.nonEmpty()) {
                    BaseAnalyzer.PendingExit pendingExit = (BaseAnalyzer.PendingExit)list3.head;
                    list3 = list3.tail;
                    if (!(pendingExit instanceof ThrownPendingExit)) {
                        Assert.check(pendingExit.tree.hasTag(JCTree.Tag.RETURN) || Flow.this.log.hasErrorOn(pendingExit.tree.pos()));
                        continue;
                    }
                    this.pendingExits.append(pendingExit);
                }
                this.errorUncaught();
            }
            finally {
                this.pendingExits = listBuffer;
                this.caught = list;
                this.thrown = list2;
            }
        }

        @Override
        public void visitModuleDef(JCTree.JCModuleDecl jCModuleDecl) {
        }

        public void analyzeTree(Env<AttrContext> env, TreeMaker treeMaker) {
            this.analyzeTree(env, env.tree, treeMaker);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void analyzeTree(Env<AttrContext> env, JCTree jCTree, TreeMaker treeMaker) {
            try {
                Flow.this.attrEnv = env;
                Flow.this.make = treeMaker;
                this.pendingExits = new ListBuffer();
                this.preciseRethrowTypes = new HashMap();
                this.caught = null;
                this.thrown = null;
                this.classDef = null;
                this.scan(jCTree);
            }
            finally {
                this.pendingExits = null;
                Flow.this.make = null;
                this.caught = null;
                this.thrown = null;
                this.classDef = null;
            }
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        class ThrownPendingExit
        extends BaseAnalyzer.PendingExit {
            Type thrown;

            ThrownPendingExit(JCTree jCTree, Type type) {
                super(jCTree);
                this.thrown = type;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    class CaptureAnalyzer
    extends BaseAnalyzer {
        JCTree currentTree;

        CaptureAnalyzer() {
        }

        @Override
        void markDead() {
        }

        void checkEffectivelyFinal(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.VarSymbol varSymbol) {
            if (this.currentTree != null && varSymbol.owner.kind == Kinds.Kind.MTH && varSymbol.pos < this.currentTree.getStartPosition()) {
                switch (this.currentTree.getTag()) {
                    case CLASSDEF: {
                        if (!Flow.this.allowEffectivelyFinalInInnerClasses) {
                            if ((varSymbol.flags() & 0x10L) != 0L) break;
                            this.reportInnerClsNeedsFinalError(diagnosticPosition, varSymbol);
                            break;
                        }
                    }
                    case PATTERNCASELABEL: 
                    case LAMBDA: {
                        if ((varSymbol.flags() & 0x20000000010L) != 0L) break;
                        this.reportEffectivelyFinalError(diagnosticPosition, varSymbol);
                    }
                }
            }
        }

        void letInit(JCTree jCTree) {
            if ((jCTree = TreeInfo.skipParens(jCTree)).hasTag(JCTree.Tag.IDENT) || jCTree.hasTag(JCTree.Tag.SELECT)) {
                Symbol symbol = TreeInfo.symbol(jCTree);
                if (this.currentTree != null && symbol.kind == Kinds.Kind.VAR && symbol.owner.kind == Kinds.Kind.MTH && ((Symbol.VarSymbol)symbol).pos < this.currentTree.getStartPosition()) {
                    switch (this.currentTree.getTag()) {
                        case CLASSDEF: {
                            if (!Flow.this.allowEffectivelyFinalInInnerClasses) {
                                this.reportInnerClsNeedsFinalError(jCTree, symbol);
                                break;
                            }
                        }
                        case LAMBDA: 
                        case CASE: {
                            this.reportEffectivelyFinalError(jCTree, symbol);
                        }
                    }
                }
            }
        }

        void reportEffectivelyFinalError(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
            JCDiagnostic.Fragment fragment = switch (this.currentTree.getTag()) {
                case JCTree.Tag.LAMBDA -> CompilerProperties.Fragments.Lambda;
                case JCTree.Tag.PATTERNCASELABEL -> CompilerProperties.Fragments.Guard;
                case JCTree.Tag.CLASSDEF -> CompilerProperties.Fragments.InnerCls;
                default -> throw new AssertionError((Object)("Unexpected tree kind: " + String.valueOf((Object)this.currentTree.getTag())));
            };
            Flow.this.log.error(diagnosticPosition, CompilerProperties.Errors.CantRefNonEffectivelyFinalVar(symbol, Flow.this.diags.fragment(fragment)));
        }

        void reportInnerClsNeedsFinalError(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
            Flow.this.log.error(diagnosticPosition, CompilerProperties.Errors.LocalVarAccessedFromIclsNeedsFinal(symbol));
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            JCTree jCTree = this.currentTree;
            try {
                this.currentTree = jCClassDecl.sym.isDirectlyOrIndirectlyLocal() ? jCClassDecl : null;
                super.visitClassDef(jCClassDecl);
            }
            finally {
                this.currentTree = jCTree;
            }
        }

        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            JCTree jCTree = this.currentTree;
            try {
                this.currentTree = jCLambda;
                super.visitLambda(jCLambda);
            }
            finally {
                this.currentTree = jCTree;
            }
        }

        @Override
        public void visitBindingPattern(JCTree.JCBindingPattern jCBindingPattern) {
            this.scan(jCBindingPattern.var);
        }

        @Override
        public void visitParenthesizedPattern(JCTree.JCParenthesizedPattern jCParenthesizedPattern) {
            this.scan(jCParenthesizedPattern.pattern);
        }

        @Override
        public void visitPatternCaseLabel(JCTree.JCPatternCaseLabel jCPatternCaseLabel) {
            this.scan(jCPatternCaseLabel.pat);
            JCTree jCTree = this.currentTree;
            try {
                this.currentTree = jCPatternCaseLabel;
                this.scan(jCPatternCaseLabel.guard);
            }
            finally {
                this.currentTree = jCTree;
            }
        }

        @Override
        public void visitRecordPattern(JCTree.JCRecordPattern jCRecordPattern) {
            this.scan(jCRecordPattern.deconstructor);
            this.scan(jCRecordPattern.nested);
            this.scan(jCRecordPattern.var);
        }

        @Override
        public void visitIdent(JCTree.JCIdent jCIdent) {
            if (jCIdent.sym.kind == Kinds.Kind.VAR) {
                this.checkEffectivelyFinal(jCIdent, (Symbol.VarSymbol)jCIdent.sym);
            }
        }

        @Override
        public void visitAssign(JCTree.JCAssign jCAssign) {
            JCTree.JCExpression jCExpression = TreeInfo.skipParens(jCAssign.lhs);
            if (!(jCExpression instanceof JCTree.JCIdent)) {
                this.scan(jCExpression);
            }
            this.scan(jCAssign.rhs);
            this.letInit(jCExpression);
        }

        @Override
        public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
            this.scan(jCAssignOp.lhs);
            this.scan(jCAssignOp.rhs);
            this.letInit(jCAssignOp.lhs);
        }

        @Override
        public void visitUnary(JCTree.JCUnary jCUnary) {
            switch (jCUnary.getTag()) {
                case PREINC: 
                case POSTINC: 
                case PREDEC: 
                case POSTDEC: {
                    this.scan(jCUnary.arg);
                    this.letInit(jCUnary.arg);
                    break;
                }
                default: {
                    this.scan(jCUnary.arg);
                }
            }
        }

        @Override
        public void visitTry(JCTree.JCTry jCTry) {
            for (JCTree jCTree : jCTry.resources) {
                Symbol symbol;
                if (jCTree.hasTag(JCTree.Tag.VARDEF) || (symbol = TreeInfo.symbol(jCTree)) == null || (symbol.flags() & 0x20000000010L) != 0L) continue;
                Flow.this.log.error(jCTree.pos(), CompilerProperties.Errors.TryWithResourcesExprEffectivelyFinalVar(symbol));
            }
            super.visitTry(jCTry);
        }

        @Override
        public void visitYield(JCTree.JCYield jCYield) {
            this.scan(jCYield.value);
        }

        @Override
        public void visitModuleDef(JCTree.JCModuleDecl jCModuleDecl) {
        }

        public void analyzeTree(Env<AttrContext> env, TreeMaker treeMaker) {
            this.analyzeTree(env, env.tree, treeMaker);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void analyzeTree(Env<AttrContext> env, JCTree jCTree, TreeMaker treeMaker) {
            try {
                Flow.this.attrEnv = env;
                Flow.this.make = treeMaker;
                this.pendingExits = new ListBuffer();
                this.scan(jCTree);
            }
            finally {
                this.pendingExits = null;
                Flow.this.make = null;
            }
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    class LambdaAliveAnalyzer
    extends AliveAnalyzer {
        boolean inLambda;

        LambdaAliveAnalyzer() {
        }

        @Override
        public void visitReturn(JCTree.JCReturn jCReturn) {
            this.recordExit(new BaseAnalyzer.PendingExit(jCReturn));
        }

        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            if (this.inLambda || jCLambda.getBodyKind() == LambdaExpressionTree.BodyKind.EXPRESSION) {
                return;
            }
            this.inLambda = true;
            try {
                super.visitLambda(jCLambda);
            }
            finally {
                this.inLambda = false;
            }
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    class LambdaAssignAnalyzer
    extends AssignAnalyzer {
        Scope.WriteableScope enclosedSymbols;
        boolean inLambda;

        LambdaAssignAnalyzer(Env<AttrContext> env) {
            this.enclosedSymbols = Scope.WriteableScope.create(env.enclClass.sym);
        }

        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            if (this.inLambda) {
                return;
            }
            this.inLambda = true;
            try {
                super.visitLambda(jCLambda);
            }
            finally {
                this.inLambda = false;
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            this.enclosedSymbols.enter(jCVariableDecl.sym);
            super.visitVarDef(jCVariableDecl);
        }

        @Override
        protected boolean trackable(Symbol.VarSymbol varSymbol) {
            return this.enclosedSymbols.includes(varSymbol) && varSymbol.owner.kind == Kinds.Kind.MTH;
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    class LambdaFlowAnalyzer
    extends FlowAnalyzer {
        List<Type> inferredThrownTypes;
        boolean inLambda;

        LambdaFlowAnalyzer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            if (jCLambda.type != null && jCLambda.type.isErroneous() || this.inLambda) {
                return;
            }
            List list = this.caught;
            List list2 = this.thrown;
            ListBuffer listBuffer = this.pendingExits;
            this.inLambda = true;
            try {
                this.pendingExits = new ListBuffer();
                this.caught = List.of(Flow.this.syms.throwableType);
                this.thrown = List.nil();
                this.scan(jCLambda.body);
                this.inferredThrownTypes = this.thrown;
            }
            finally {
                this.pendingExits = listBuffer;
                this.caught = list;
                this.thrown = list2;
                this.inLambda = false;
            }
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    class SnippetAliveAnalyzer
    extends AliveAnalyzer {
        SnippetAliveAnalyzer() {
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        }

        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
        }

        public boolean isAlive() {
            return this.alive != Liveness.DEAD;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    class SnippetBreakAnalyzer
    extends AliveAnalyzer {
        private final Set<JCTree> seenTrees = new HashSet<JCTree>();
        private boolean breaksOut;

        @Override
        public void visitLabelled(JCTree.JCLabeledStatement jCLabeledStatement) {
            this.seenTrees.add(jCLabeledStatement);
            super.visitLabelled(jCLabeledStatement);
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
            this.seenTrees.add(jCWhileLoop);
            super.visitWhileLoop(jCWhileLoop);
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop jCForLoop) {
            this.seenTrees.add(jCForLoop);
            super.visitForLoop(jCForLoop);
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
            this.seenTrees.add(jCEnhancedForLoop);
            super.visitForeachLoop(jCEnhancedForLoop);
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
            this.seenTrees.add(jCDoWhileLoop);
            super.visitDoLoop(jCDoWhileLoop);
        }

        @Override
        public void visitBreak(JCTree.JCBreak jCBreak) {
            this.breaksOut |= this.alive == Liveness.ALIVE && !this.seenTrees.contains(jCBreak.target);
            super.visitBreak(jCBreak);
        }

        public boolean breaksOut() {
            return this.breaksOut;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static enum Liveness {
        ALIVE{

            @Override
            public Liveness or(Liveness liveness) {
                return this;
            }

            @Override
            public Liveness and(Liveness liveness) {
                return liveness;
            }
        }
        ,
        DEAD{

            @Override
            public Liveness or(Liveness liveness) {
                return liveness;
            }

            @Override
            public Liveness and(Liveness liveness) {
                return this;
            }
        }
        ,
        RECOVERY{

            @Override
            public Liveness or(Liveness liveness) {
                if (liveness == ALIVE) {
                    return ALIVE;
                }
                return this;
            }

            @Override
            public Liveness and(Liveness liveness) {
                if (liveness == DEAD) {
                    return DEAD;
                }
                return this;
            }
        };


        public abstract Liveness or(Liveness var1);

        public abstract Liveness and(Liveness var1);

        public Liveness or(boolean bl) {
            return this.or(Liveness.from(bl));
        }

        public Liveness and(boolean bl) {
            return this.and(Liveness.from(bl));
        }

        public static Liveness from(boolean bl) {
            return bl ? ALIVE : DEAD;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static abstract class BaseAnalyzer
    extends TreeScanner {
        ListBuffer<PendingExit> pendingExits;

        BaseAnalyzer() {
        }

        abstract void markDead();

        void recordExit(PendingExit pendingExit) {
            this.pendingExits.append(pendingExit);
            this.markDead();
        }

        private Liveness resolveJump(JCTree jCTree, ListBuffer<PendingExit> listBuffer, JumpKind jumpKind) {
            boolean bl = false;
            List<PendingExit> list = this.pendingExits.toList();
            this.pendingExits = listBuffer;
            while (list.nonEmpty()) {
                PendingExit pendingExit = (PendingExit)list.head;
                if (pendingExit.tree.hasTag(jumpKind.treeTag) && jumpKind.getTarget(pendingExit.tree) == jCTree) {
                    pendingExit.resolveJump();
                    bl = true;
                } else {
                    this.pendingExits.append(pendingExit);
                }
                list = list.tail;
            }
            return Liveness.from(bl);
        }

        Liveness resolveContinues(JCTree jCTree) {
            return this.resolveJump(jCTree, new ListBuffer<PendingExit>(), JumpKind.CONTINUE);
        }

        Liveness resolveBreaks(JCTree jCTree, ListBuffer<PendingExit> listBuffer) {
            return this.resolveJump(jCTree, listBuffer, JumpKind.BREAK);
        }

        Liveness resolveYields(JCTree jCTree, ListBuffer<PendingExit> listBuffer) {
            return this.resolveJump(jCTree, listBuffer, JumpKind.YIELD);
        }

        @Override
        public void scan(JCTree jCTree) {
            if (jCTree != null && (jCTree.type == null || jCTree.type != Type.stuckType)) {
                super.scan(jCTree);
            }
        }

        @Override
        public void visitPackageDef(JCTree.JCPackageDecl jCPackageDecl) {
        }

        protected void scanSyntheticBreak(TreeMaker treeMaker, JCTree jCTree) {
            if (jCTree.hasTag(JCTree.Tag.SWITCH_EXPRESSION)) {
                JCTree.JCYield jCYield = treeMaker.at(-1).Yield(null);
                jCYield.target = jCTree;
                this.scan(jCYield);
            } else {
                JCTree.JCBreak jCBreak = treeMaker.at(-1).Break(null);
                jCBreak.target = jCTree;
                this.scan(jCBreak);
            }
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        static class PendingExit {
            JCTree tree;

            PendingExit(JCTree jCTree) {
                this.tree = jCTree;
            }

            void resolveJump() {
            }
        }

        /*
         * Uses 'sealed' constructs - enablewith --sealed true
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        static enum JumpKind {
            BREAK(JCTree.Tag.BREAK){

                @Override
                JCTree getTarget(JCTree jCTree) {
                    return ((JCTree.JCBreak)jCTree).target;
                }
            }
            ,
            CONTINUE(JCTree.Tag.CONTINUE){

                @Override
                JCTree getTarget(JCTree jCTree) {
                    return ((JCTree.JCContinue)jCTree).target;
                }
            }
            ,
            YIELD(JCTree.Tag.YIELD){

                @Override
                JCTree getTarget(JCTree jCTree) {
                    return ((JCTree.JCYield)jCTree).target;
                }
            };

            final JCTree.Tag treeTag;

            private JumpKind(JCTree.Tag tag) {
                this.treeTag = tag;
            }

            abstract JCTree getTarget(JCTree var1);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static enum FlowKind {
        NORMAL("var.might.already.be.assigned", false),
        SPECULATIVE_LOOP("var.might.be.assigned.in.loop", true);

        final String errKey;
        final boolean isFinal;

        private FlowKind(String string2, boolean bl) {
            this.errKey = string2;
            this.isFinal = bl;
        }

        boolean isFinal() {
            return this.isFinal;
        }
    }
}

