/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.BaseFileManager;
import com.sun.tools.javac.file.FSInfo;
import com.sun.tools.javac.file.JRTIndex;
import com.sun.tools.javac.file.Locations;
import com.sun.tools.javac.file.PathFileObject;
import com.sun.tools.javac.file.RelativePath;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipException;
import javax.lang.model.SourceVersion;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JavacFileManager
extends BaseFileManager
implements StandardJavaFileManager {
    private FSInfo fsInfo;
    private static final Set<JavaFileObject.Kind> SOURCE_OR_CLASS = EnumSet.of(JavaFileObject.Kind.SOURCE, JavaFileObject.Kind.CLASS);
    protected boolean symbolFileEnabled;
    private StandardJavaFileManager.PathFactory pathFactory = Paths::get;
    protected SortFiles sortFiles;
    private Map<JavaFileManager.Location, Map<RelativePath.RelativeDirectory, java.util.List<PathAndContainer>>> pathsAndContainersByLocationAndRelativeDirectory = new HashMap<JavaFileManager.Location, Map<RelativePath.RelativeDirectory, java.util.List<PathAndContainer>>>();
    private Map<JavaFileManager.Location, java.util.List<PathAndContainer>> nonIndexingContainersByLocation = new HashMap<JavaFileManager.Location, java.util.List<PathAndContainer>>();
    private final Map<Path, Container> containers = new HashMap<Path, Container>();
    private static final Container MISSING_CONTAINER = new Container(){

        @Override
        public void list(Path path, RelativePath.RelativeDirectory relativeDirectory, Set<JavaFileObject.Kind> set, boolean bl, ListBuffer<JavaFileObject> listBuffer) throws IOException {
        }

        @Override
        public JavaFileObject getFileObject(Path path, RelativePath.RelativeFile relativeFile) throws IOException {
            return null;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean maintainsDirectoryIndex() {
            return false;
        }

        @Override
        public Iterable<RelativePath.RelativeDirectory> indexedDirectories() {
            return List.nil();
        }
    };
    private JRTIndex jrtIndex;
    private static final Set<FileVisitOption> NO_FILE_VISIT_OPTIONS = Collections.emptySet();
    private static final Set<FileVisitOption> FOLLOW_LINKS_OPTIONS = Collections.singleton(FileVisitOption.FOLLOW_LINKS);
    private static final boolean fileSystemIsCaseSensitive = File.separatorChar == '/';

    public static char[] toArray(CharBuffer charBuffer) {
        if (charBuffer.hasArray()) {
            return charBuffer.compact().flip().array();
        }
        return charBuffer.toString().toCharArray();
    }

    public static void preRegister(Context context2) {
        context2.put(JavaFileManager.class, context -> new JavacFileManager(context, true, null));
    }

    public JavacFileManager(Context context, boolean bl, Charset charset) {
        super(charset);
        if (bl) {
            context.put(JavaFileManager.class, this);
        }
        this.setContext(context);
    }

    @Override
    public void setContext(Context context) {
        super.setContext(context);
        this.fsInfo = FSInfo.instance(context);
        this.symbolFileEnabled = !this.options.isSet("ignore.symbol.file");
        String string = this.options.get("sortFiles");
        if (string != null) {
            this.sortFiles = string.equals("reverse") ? SortFiles.REVERSE : SortFiles.FORWARD;
        }
    }

    @Override
    public void setPathFactory(StandardJavaFileManager.PathFactory pathFactory) {
        this.pathFactory = Objects.requireNonNull(pathFactory);
        this.locations.setPathFactory(pathFactory);
    }

    private Path getPath(String string, String ... stringArray) {
        return this.pathFactory.getPath(string, stringArray);
    }

    public void setSymbolFileEnabled(boolean bl) {
        this.symbolFileEnabled = bl;
    }

    public boolean isSymbolFileEnabled() {
        return this.symbolFileEnabled;
    }

    public JavaFileObject getJavaFileObject(String string) {
        return this.getJavaFileObjects(string).iterator().next();
    }

    public JavaFileObject getJavaFileObject(Path path) {
        return this.getJavaFileObjects(path).iterator().next();
    }

    public JavaFileObject getFileForOutput(String string, JavaFileObject.Kind kind, JavaFileObject javaFileObject) throws IOException {
        return this.getJavaFileForOutput(StandardLocation.CLASS_OUTPUT, string, kind, javaFileObject);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> iterable) {
        ListBuffer<Path> listBuffer = new ListBuffer<Path>();
        for (String string : iterable) {
            listBuffer.append(this.getPath(JavacFileManager.nullCheck(string), new String[0]));
        }
        return this.getJavaFileObjectsFromPaths(listBuffer.toList());
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... stringArray) {
        return this.getJavaFileObjectsFromStrings(Arrays.asList(JavacFileManager.nullCheck(stringArray)));
    }

    private static boolean isValidName(String string) {
        for (String string2 : string.split("\\.", -1)) {
            if (SourceVersion.isIdentifier(string2)) continue;
            return false;
        }
        return true;
    }

    private static void validateClassName(String string) {
        if (!JavacFileManager.isValidName(string)) {
            throw new IllegalArgumentException("Invalid class name: " + string);
        }
    }

    private static void validatePackageName(String string) {
        if (string.length() > 0 && !JavacFileManager.isValidName(string)) {
            throw new IllegalArgumentException("Invalid packageName name: " + string);
        }
    }

    public static void testName(String string, boolean bl, boolean bl2) {
        try {
            JavacFileManager.validatePackageName(string);
            if (!bl) {
                throw new AssertionError((Object)("Invalid package name accepted: " + string));
            }
            JavacFileManager.printAscii("Valid package name: \"%s\"", string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (bl) {
                throw new AssertionError((Object)("Valid package name rejected: " + string));
            }
            JavacFileManager.printAscii("Invalid package name: \"%s\"", string);
        }
        try {
            JavacFileManager.validateClassName(string);
            if (!bl2) {
                throw new AssertionError((Object)("Invalid class name accepted: " + string));
            }
            JavacFileManager.printAscii("Valid class name: \"%s\"", string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (bl2) {
                throw new AssertionError((Object)("Valid class name rejected: " + string));
            }
            JavacFileManager.printAscii("Invalid class name: \"%s\"", string);
        }
    }

    private static void printAscii(String string, Object ... objectArray) {
        String string2 = new String(String.format(null, string, objectArray).getBytes(StandardCharsets.US_ASCII), StandardCharsets.US_ASCII);
        System.out.println(string2);
    }

    synchronized Container getContainer(Path path) throws IOException {
        Container container = this.containers.get(path);
        if (container != null) {
            return container;
        }
        if (this.fsInfo.isFile(path) && path.equals(Locations.thisSystemModules)) {
            container = new JRTImageContainer();
            this.containers.put(path, container);
            return container;
        }
        Path path2 = this.fsInfo.getCanonicalFile(path);
        container = this.containers.get(path2);
        if (container != null) {
            this.containers.put(path, container);
            return container;
        }
        BasicFileAttributes basicFileAttributes = null;
        try {
            basicFileAttributes = Files.readAttributes(path2, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException iOException) {
            container = MISSING_CONTAINER;
        }
        if (basicFileAttributes != null) {
            if (basicFileAttributes.isDirectory()) {
                container = new DirectoryContainer(path2);
            } else {
                try {
                    container = new ArchiveContainer(path);
                }
                catch (SecurityException | ProviderNotFoundException runtimeException) {
                    throw new IOException(runtimeException);
                }
            }
        }
        this.containers.put(path2, container);
        this.containers.put(path, container);
        return container;
    }

    private synchronized JRTIndex getJRTIndex() {
        if (this.jrtIndex == null) {
            this.jrtIndex = JRTIndex.getSharedInstance();
        }
        return this.jrtIndex;
    }

    private boolean isValidFile(String string, Set<JavaFileObject.Kind> set) {
        JavaFileObject.Kind kind = JavacFileManager.getKind(string);
        return set.contains((Object)kind);
    }

    private boolean caseMapCheck(Path path, RelativePath relativePath) {
        char c;
        String string;
        if (fileSystemIsCaseSensitive) {
            return true;
        }
        try {
            string = path.toRealPath(LinkOption.NOFOLLOW_LINKS).toString();
            c = path.getFileSystem().getSeparator().charAt(0);
        }
        catch (IOException iOException) {
            return false;
        }
        char[] cArray = string.toCharArray();
        char[] cArray2 = relativePath.path.toCharArray();
        int n = cArray.length - 1;
        int n2 = cArray2.length - 1;
        while (n >= 0 && n2 >= 0) {
            while (n >= 0 && cArray[n] == c) {
                --n;
            }
            while (n2 >= 0 && cArray2[n2] == '/') {
                --n2;
            }
            if (n < 0 || n2 < 0) continue;
            if (cArray[n] != cArray2[n2]) {
                return false;
            }
            --n;
            --n2;
        }
        return n2 < 0;
    }

    @Override
    public void flush() {
        this.contentCache.clear();
        this.pathsAndContainersByLocationAndRelativeDirectory.clear();
        this.nonIndexingContainersByLocation.clear();
    }

    @Override
    public void close() throws IOException {
        if (this.deferredCloseTimeout > 0L) {
            this.deferredClose();
            return;
        }
        this.locations.close();
        for (Container container : this.containers.values()) {
            container.close();
        }
        this.containers.clear();
        this.pathsAndContainersByLocationAndRelativeDirectory.clear();
        this.nonIndexingContainersByLocation.clear();
        this.contentCache.clear();
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        this.checkNotModuleOrientedLocation(location);
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            return null;
        }
        ListBuffer<URL> listBuffer = new ListBuffer<URL>();
        for (File file : iterable) {
            try {
                listBuffer.append(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                throw new AssertionError((Object)malformedURLException);
            }
        }
        return this.getClassLoader(listBuffer.toArray(new URL[listBuffer.size()]));
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String string, Set<JavaFileObject.Kind> set, boolean bl) throws IOException {
        this.checkNotModuleOrientedLocation(location);
        JavacFileManager.nullCheck(string);
        JavacFileManager.nullCheck(set);
        RelativePath.RelativeDirectory relativeDirectory = RelativePath.RelativeDirectory.forPackage(string);
        ListBuffer<JavaFileObject> listBuffer = new ListBuffer<JavaFileObject>();
        for (PathAndContainer pathAndContainer : this.pathsAndContainers(location, relativeDirectory)) {
            Path path = pathAndContainer.path;
            Container container = pathAndContainer.container;
            container.list(path, relativeDirectory, set, bl, listBuffer);
        }
        return listBuffer.toList();
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        this.checkNotModuleOrientedLocation(location);
        Objects.requireNonNull(javaFileObject);
        Iterable iterable = this.getLocationAsPaths(location);
        if (iterable == null) {
            return null;
        }
        if (javaFileObject instanceof PathFileObject) {
            PathFileObject pathFileObject = (PathFileObject)javaFileObject;
            return pathFileObject.inferBinaryName(iterable);
        }
        throw new IllegalArgumentException(javaFileObject.getClass().getName());
    }

    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject2) {
        JavacFileManager.nullCheck(fileObject);
        JavacFileManager.nullCheck(fileObject2);
        if (fileObject instanceof PathFileObject) {
            PathFileObject pathFileObject = (PathFileObject)fileObject;
            if (fileObject2 instanceof PathFileObject) {
                PathFileObject pathFileObject2 = (PathFileObject)fileObject2;
                return pathFileObject.isSameFile(pathFileObject2);
            }
        }
        return fileObject.equals(fileObject2);
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        return this.locations.hasLocation(location);
    }

    protected boolean hasExplicitLocation(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        return this.locations.hasExplicitLocation(location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind) throws IOException {
        this.checkNotModuleOrientedLocation(location);
        JavacFileManager.nullCheck(string);
        JavacFileManager.nullCheck(kind);
        if (!SOURCE_OR_CLASS.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind: " + String.valueOf((Object)kind));
        }
        return this.getFileForInput(location, RelativePath.RelativeFile.forClass(string, kind));
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String string, String string2) throws IOException {
        this.checkNotModuleOrientedLocation(location);
        JavacFileManager.nullCheck(string);
        if (!JavacFileManager.isRelativeUri(string2)) {
            throw new IllegalArgumentException("Invalid relative name: " + string2);
        }
        RelativePath.RelativeFile relativeFile = string.length() == 0 ? new RelativePath.RelativeFile(string2) : new RelativePath.RelativeFile(RelativePath.RelativeDirectory.forPackage(string), string2);
        return this.getFileForInput(location, relativeFile);
    }

    private JavaFileObject getFileForInput(JavaFileManager.Location location, RelativePath.RelativeFile relativeFile) throws IOException {
        Iterable iterable = this.getLocationAsPaths(location);
        if (iterable == null) {
            return null;
        }
        for (Path path : iterable) {
            JavaFileObject javaFileObject = this.getContainer(path).getFileObject(path, relativeFile);
            if (javaFileObject == null) continue;
            return javaFileObject;
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
        this.checkOutputLocation(location);
        JavacFileManager.nullCheck(string);
        JavacFileManager.nullCheck(kind);
        if (!SOURCE_OR_CLASS.contains((Object)kind)) {
            throw new IllegalArgumentException("Invalid kind: " + String.valueOf((Object)kind));
        }
        return this.getFileForOutput(location, RelativePath.RelativeFile.forClass(string, kind), fileObject);
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String string, String string2, FileObject fileObject) throws IOException {
        this.checkOutputLocation(location);
        JavacFileManager.nullCheck(string);
        if (!JavacFileManager.isRelativeUri(string2)) {
            throw new IllegalArgumentException("Invalid relative name: " + string2);
        }
        RelativePath.RelativeFile relativeFile = string.length() == 0 ? new RelativePath.RelativeFile(string2) : new RelativePath.RelativeFile(RelativePath.RelativeDirectory.forPackage(string), string2);
        return this.getFileForOutput(location, relativeFile, fileObject);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JavaFileObject getFileForOutput(JavaFileManager.Location location, RelativePath.RelativeFile relativeFile, FileObject fileObject) throws IOException {
        Path path;
        block10: {
            if (location == StandardLocation.CLASS_OUTPUT) {
                if (this.getClassOutDir() != null) {
                    path = this.getClassOutDir();
                    break block10;
                } else {
                    String string = relativeFile.basename();
                    if (fileObject != null && fileObject instanceof PathFileObject) {
                        PathFileObject pathFileObject = (PathFileObject)fileObject;
                        return pathFileObject.getSibling(string);
                    }
                    Path path2 = this.getPath(string, new String[0]);
                    Path path3 = this.fsInfo.getCanonicalFile(path2);
                    return PathFileObject.forSimplePath(this, path3, path2);
                }
            }
            if (location == StandardLocation.SOURCE_OUTPUT) {
                path = this.getSourceOutDir() != null ? this.getSourceOutDir() : this.getClassOutDir();
            } else {
                Collection<Path> collection = this.locations.getLocation(location);
                path = null;
                Iterator iterator = collection.iterator();
                if (iterator.hasNext()) {
                    Path path4;
                    path = path4 = (Path)iterator.next();
                }
            }
        }
        try {
            if (path == null) {
                path = this.getPath(System.getProperty("user.dir"), new String[0]);
            }
            Path path5 = relativeFile.resolveAgainst(this.fsInfo.getCanonicalFile(path));
            return PathFileObject.forDirectoryPath(this, path5, path, relativeFile);
        }
        catch (InvalidPathException invalidPathException) {
            throw new IOException("bad filename " + String.valueOf(relativeFile), invalidPathException);
        }
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> iterable) {
        ArrayList<PathFileObject> arrayList;
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            arrayList = new ArrayList(collection.size());
        } else {
            arrayList = new ArrayList<PathFileObject>();
        }
        for (File file : iterable) {
            Objects.requireNonNull(file);
            Path path = file.toPath();
            arrayList.add(PathFileObject.forSimplePath(this, this.fsInfo.getCanonicalFile(path), path));
        }
        return arrayList;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromPaths(Collection<? extends Path> collection) {
        ArrayList<PathFileObject> arrayList;
        if (collection != null) {
            arrayList = new ArrayList(collection.size());
            for (Path path : collection) {
                arrayList.add(PathFileObject.forSimplePath(this, this.fsInfo.getCanonicalFile(path), path));
            }
        } else {
            arrayList = new ArrayList<PathFileObject>();
        }
        return arrayList;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... fileArray) {
        return this.getJavaFileObjectsFromFiles(Arrays.asList(JavacFileManager.nullCheck(fileArray)));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(Path ... pathArray) {
        return this.getJavaFileObjectsFromPaths((Collection<? extends Path>)Arrays.asList(JavacFileManager.nullCheck(pathArray)));
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> iterable) throws IOException {
        JavacFileManager.nullCheck(location);
        this.locations.setLocation(location, JavacFileManager.asPaths(iterable));
        this.clearCachesForLocation(location);
    }

    @Override
    public void setLocationFromPaths(JavaFileManager.Location location, Collection<? extends Path> collection) throws IOException {
        JavacFileManager.nullCheck(location);
        this.locations.setLocation(location, JavacFileManager.nullCheck(collection));
        this.clearCachesForLocation(location);
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        return JavacFileManager.asFiles(this.locations.getLocation(location));
    }

    public Collection<? extends Path> getLocationAsPaths(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        return this.locations.getLocation(location);
    }

    private java.util.List<PathAndContainer> pathsAndContainers(JavaFileManager.Location location, RelativePath.RelativeDirectory relativeDirectory2) throws IOException {
        try {
            return this.pathsAndContainersByLocationAndRelativeDirectory.computeIfAbsent(location, this::indexPathsAndContainersByRelativeDirectory).computeIfAbsent(relativeDirectory2, relativeDirectory -> this.nonIndexingContainersByLocation.get(location));
        }
        catch (UncheckedIOException uncheckedIOException) {
            throw uncheckedIOException.getCause();
        }
    }

    private Map<RelativePath.RelativeDirectory, java.util.List<PathAndContainer>> indexPathsAndContainersByRelativeDirectory(JavaFileManager.Location location) {
        HashMap<RelativePath.RelativeDirectory, java.util.List<PathAndContainer>> hashMap = new HashMap<RelativePath.RelativeDirectory, java.util.List<PathAndContainer>>();
        java.util.List<PathAndContainer> list2 = this.pathsAndContainers(location);
        ArrayList<PathAndContainer> arrayList = new ArrayList<PathAndContainer>();
        for (PathAndContainer pathAndContainer : list2) {
            if (pathAndContainer.container.maintainsDirectoryIndex()) continue;
            arrayList.add(pathAndContainer);
        }
        for (PathAndContainer pathAndContainer : list2) {
            Container container = pathAndContainer.container;
            if (!container.maintainsDirectoryIndex()) continue;
            for (RelativePath.RelativeDirectory relativeDirectory2 : container.indexedDirectories()) {
                hashMap.computeIfAbsent(relativeDirectory2, relativeDirectory -> new ArrayList(arrayList)).add(pathAndContainer);
            }
        }
        this.nonIndexingContainersByLocation.put(location, arrayList);
        hashMap.values().forEach(list -> Collections.sort(list));
        return hashMap;
    }

    private java.util.List<PathAndContainer> pathsAndContainers(JavaFileManager.Location location) {
        Iterable iterable = this.getLocationAsPaths(location);
        if (iterable == null) {
            return List.nil();
        }
        ArrayList<PathAndContainer> arrayList = new ArrayList<PathAndContainer>(iterable.size());
        for (Path path : iterable) {
            Container container;
            try {
                container = this.getContainer(path);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
            arrayList.add(new PathAndContainer(path, container, arrayList.size()));
        }
        return arrayList;
    }

    @Override
    public boolean contains(JavaFileManager.Location location, FileObject fileObject) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(fileObject);
        Path path = this.asPath(fileObject);
        return this.locations.contains(location, path);
    }

    private Path getClassOutDir() {
        return this.locations.getOutputLocation(StandardLocation.CLASS_OUTPUT);
    }

    private Path getSourceOutDir() {
        return this.locations.getOutputLocation(StandardLocation.SOURCE_OUTPUT);
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, String string) throws IOException {
        this.checkModuleOrientedOrOutputLocation(location);
        JavacFileManager.nullCheck(string);
        if (location == StandardLocation.SOURCE_OUTPUT && this.getSourceOutDir() == null) {
            location = StandardLocation.CLASS_OUTPUT;
        }
        return this.locations.getLocationForModule(location, string);
    }

    @Override
    public <S> ServiceLoader<S> getServiceLoader(JavaFileManager.Location location, Class<S> clazz) throws IOException {
        JavacFileManager.nullCheck(location);
        JavacFileManager.nullCheck(clazz);
        if (location.isModuleOrientedLocation()) {
            return null;
        }
        return ServiceLoader.load(clazz, this.getClassLoader(location));
    }

    @Override
    public JavaFileManager.Location getLocationForModule(JavaFileManager.Location location, JavaFileObject javaFileObject) throws IOException {
        this.checkModuleOrientedOrOutputLocation(location);
        if (!(javaFileObject instanceof PathFileObject)) {
            return null;
        }
        PathFileObject pathFileObject = (PathFileObject)javaFileObject;
        Path path = Locations.normalize(pathFileObject.path);
        return this.locations.getLocationForModule(location, path);
    }

    @Override
    public void setLocationForModule(JavaFileManager.Location location, String string, Collection<? extends Path> collection) throws IOException {
        JavacFileManager.nullCheck(location);
        this.checkModuleOrientedOrOutputLocation(location);
        this.locations.setLocationForModule(location, JavacFileManager.nullCheck(string), JavacFileManager.nullCheck(collection));
        this.clearCachesForLocation(location);
    }

    @Override
    public String inferModuleName(JavaFileManager.Location location) {
        this.checkNotModuleOrientedLocation(location);
        return this.locations.inferModuleName(location);
    }

    @Override
    public Iterable<Set<JavaFileManager.Location>> listLocationsForModules(JavaFileManager.Location location) throws IOException {
        this.checkModuleOrientedOrOutputLocation(location);
        return this.locations.listLocationsForModules(location);
    }

    @Override
    public Path asPath(FileObject fileObject) {
        if (fileObject instanceof PathFileObject) {
            PathFileObject pathFileObject = (PathFileObject)fileObject;
            return pathFileObject.path;
        }
        throw new IllegalArgumentException(fileObject.getName());
    }

    protected static boolean isRelativeUri(URI uRI) {
        if (uRI.isAbsolute()) {
            return false;
        }
        String string = uRI.normalize().getPath();
        if (string.length() == 0) {
            return false;
        }
        if (!string.equals(uRI.getPath())) {
            return false;
        }
        return !string.startsWith("/") && !string.startsWith("./") && !string.startsWith("../");
    }

    protected static boolean isRelativeUri(String string) {
        try {
            return JavacFileManager.isRelativeUri(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public static String getRelativeName(File file) {
        String string;
        if (!file.isAbsolute() && JavacFileManager.isRelativeUri(string = file.getPath().replace(File.separatorChar, '/'))) {
            return string;
        }
        throw new IllegalArgumentException("Invalid relative path: " + String.valueOf(file));
    }

    public static String getMessage(IOException iOException) {
        String string = iOException.getLocalizedMessage();
        if (string != null) {
            return string;
        }
        string = iOException.getMessage();
        if (string != null) {
            return string;
        }
        return iOException.toString();
    }

    private void checkOutputLocation(JavaFileManager.Location location) {
        Objects.requireNonNull(location);
        if (!location.isOutputLocation()) {
            throw new IllegalArgumentException("location is not an output location: " + location.getName());
        }
    }

    private void checkModuleOrientedOrOutputLocation(JavaFileManager.Location location) {
        Objects.requireNonNull(location);
        if (!location.isModuleOrientedLocation() && !location.isOutputLocation()) {
            throw new IllegalArgumentException("location is not an output location or a module-oriented location: " + location.getName());
        }
    }

    private void checkNotModuleOrientedLocation(JavaFileManager.Location location) {
        Objects.requireNonNull(location);
        if (location.isModuleOrientedLocation()) {
            throw new IllegalArgumentException("location is module-oriented: " + location.getName());
        }
    }

    private static Iterable<Path> asPaths(final Iterable<? extends File> iterable) {
        if (iterable == null) {
            return null;
        }
        return () -> new Iterator<Path>(){
            Iterator<? extends File> iter;
            {
                this.iter = iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public Path next() {
                return this.iter.next().toPath();
            }
        };
    }

    private static Iterable<File> asFiles(final Iterable<? extends Path> iterable) {
        if (iterable == null) {
            return null;
        }
        return () -> new Iterator<File>(){
            Iterator<? extends Path> iter;
            {
                this.iter = iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iter.hasNext();
            }

            @Override
            public File next() {
                try {
                    return this.iter.next().toFile();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    throw new IllegalStateException(unsupportedOperationException);
                }
            }
        };
    }

    @Override
    public boolean handleOption(Option option, String string) {
        if (javacFileManagerOptions.contains((Object)option)) {
            this.pathsAndContainersByLocationAndRelativeDirectory.clear();
            this.nonIndexingContainersByLocation.clear();
        }
        return super.handleOption(option, string);
    }

    private void clearCachesForLocation(JavaFileManager.Location location) {
        JavacFileManager.nullCheck(location);
        this.pathsAndContainersByLocationAndRelativeDirectory.remove(location);
        this.nonIndexingContainersByLocation.remove(location);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected static enum SortFiles implements Comparator<Path>
    {
        FORWARD{

            @Override
            public int compare(Path path, Path path2) {
                return path.getFileName().compareTo(path2.getFileName());
            }
        }
        ,
        REVERSE{

            @Override
            public int compare(Path path, Path path2) {
                return path2.getFileName().compareTo(path.getFileName());
            }
        };

    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static interface Container {
        public void list(Path var1, RelativePath.RelativeDirectory var2, Set<JavaFileObject.Kind> var3, boolean var4, ListBuffer<JavaFileObject> var5) throws IOException;

        public JavaFileObject getFileObject(Path var1, RelativePath.RelativeFile var2) throws IOException;

        public void close() throws IOException;

        public boolean maintainsDirectoryIndex();

        public Iterable<RelativePath.RelativeDirectory> indexedDirectories();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private final class JRTImageContainer
    implements Container {
        private JRTImageContainer() {
        }

        @Override
        public void list(Path path, RelativePath.RelativeDirectory relativeDirectory, Set<JavaFileObject.Kind> set, boolean bl, ListBuffer<JavaFileObject> listBuffer) throws IOException {
            try {
                JRTIndex.Entry entry = JavacFileManager.this.getJRTIndex().getEntry(relativeDirectory);
                if (JavacFileManager.this.symbolFileEnabled && entry.ctSym.hidden) {
                    return;
                }
                for (Path comparable : entry.files.values()) {
                    if (!set.contains((Object)BaseFileManager.getKind(comparable))) continue;
                    PathFileObject pathFileObject = PathFileObject.forJRTPath(JavacFileManager.this, comparable);
                    listBuffer.append(pathFileObject);
                }
                if (bl) {
                    for (RelativePath.RelativeDirectory relativeDirectory2 : entry.subdirs) {
                        this.list(path, relativeDirectory2, set, bl, listBuffer);
                    }
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
                JavacFileManager.this.log.error(CompilerProperties.Errors.ErrorReadingFile(path, JavacFileManager.getMessage(iOException)));
            }
        }

        @Override
        public JavaFileObject getFileObject(Path path, RelativePath.RelativeFile relativeFile) throws IOException {
            JRTIndex.Entry entry = JavacFileManager.this.getJRTIndex().getEntry(relativeFile.dirname());
            if (JavacFileManager.this.symbolFileEnabled && entry.ctSym.hidden) {
                return null;
            }
            Path path2 = entry.files.get(relativeFile.basename());
            if (path2 != null) {
                return PathFileObject.forJRTPath(JavacFileManager.this, path2);
            }
            return null;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean maintainsDirectoryIndex() {
            return false;
        }

        @Override
        public Iterable<RelativePath.RelativeDirectory> indexedDirectories() {
            return List.nil();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private final class DirectoryContainer
    implements Container {
        private final Path directory;

        public DirectoryContainer(Path path) {
            this.directory = path;
        }

        @Override
        public void list(Path path, RelativePath.RelativeDirectory relativeDirectory, Set<JavaFileObject.Kind> set, boolean bl, ListBuffer<JavaFileObject> listBuffer) throws IOException {
            java.util.List list;
            Path path2;
            try {
                path2 = relativeDirectory.resolveAgainst(path);
            }
            catch (InvalidPathException invalidPathException) {
                return;
            }
            if (!Files.exists(path2, new LinkOption[0])) {
                return;
            }
            if (!JavacFileManager.this.caseMapCheck(path2, relativeDirectory)) {
                return;
            }
            try (Stream<Path> stream = Files.list(path2);){
                list = (JavacFileManager.this.sortFiles == null ? stream : stream.sorted(JavacFileManager.this.sortFiles)).collect(Collectors.toList());
            }
            catch (IOException iOException) {
                return;
            }
            for (Path path3 : list) {
                String string = path3.getFileName().toString();
                if (string.endsWith("/")) {
                    string = string.substring(0, string.length() - 1);
                }
                if (Files.isDirectory(path3, new LinkOption[0])) {
                    if (!bl || !SourceVersion.isIdentifier(string)) continue;
                    this.list(path, new RelativePath.RelativeDirectory(relativeDirectory, string), set, bl, listBuffer);
                    continue;
                }
                if (!JavacFileManager.this.isValidFile(string, set)) continue;
                try {
                    RelativePath.RelativeFile relativeFile = new RelativePath.RelativeFile(relativeDirectory, string);
                    PathFileObject pathFileObject = PathFileObject.forDirectoryPath(JavacFileManager.this, relativeFile.resolveAgainst(this.directory), path, relativeFile);
                    listBuffer.append(pathFileObject);
                }
                catch (InvalidPathException invalidPathException) {
                    throw new IOException("error accessing directory " + String.valueOf(this.directory) + String.valueOf(invalidPathException));
                }
            }
        }

        @Override
        public JavaFileObject getFileObject(Path path, RelativePath.RelativeFile relativeFile) throws IOException {
            try {
                Path path2 = relativeFile.resolveAgainst(path);
                if (Files.exists(path2, new LinkOption[0])) {
                    return PathFileObject.forSimplePath(JavacFileManager.this, JavacFileManager.this.fsInfo.getCanonicalFile(path2), path2);
                }
            }
            catch (InvalidPathException invalidPathException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public boolean maintainsDirectoryIndex() {
            return false;
        }

        @Override
        public Iterable<RelativePath.RelativeDirectory> indexedDirectories() {
            return List.nil();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private final class ArchiveContainer
    implements Container {
        private final Path archivePath;
        private final FileSystem fileSystem;
        private final Map<RelativePath.RelativeDirectory, Path> packages;

        public ArchiveContainer(Path path) throws IOException, ProviderNotFoundException, SecurityException {
            this.archivePath = path;
            if (JavacFileManager.this.multiReleaseValue != null && path.toString().endsWith(".jar")) {
                Map<String, String> map = Collections.singletonMap("multi-release", JavacFileManager.this.multiReleaseValue);
                FileSystemProvider object = JavacFileManager.this.fsInfo.getJarFSProvider();
                Assert.checkNonNull(object, "should have been caught before!");
                try {
                    this.fileSystem = object.newFileSystem(path, map);
                }
                catch (ZipException zipException) {
                    throw new IOException("ZipException opening \"" + String.valueOf(path.getFileName()) + "\": " + zipException.getMessage(), zipException);
                }
            } else {
                this.fileSystem = FileSystems.newFileSystem(path, (ClassLoader)null);
            }
            this.packages = new HashMap<RelativePath.RelativeDirectory, Path>();
            for (final Path path2 : this.fileSystem.getRootDirectories()) {
                Files.walkFileTree(path2, NO_FILE_VISIT_OPTIONS, Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
                        if (ArchiveContainer.this.isValid(path.getFileName())) {
                            ArchiveContainer.this.packages.put(new RelativePath.RelativeDirectory(path2.relativize(path).toString()), path);
                            return FileVisitResult.CONTINUE;
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                });
            }
        }

        @Override
        public void list(Path path, RelativePath.RelativeDirectory relativeDirectory, final Set<JavaFileObject.Kind> set, boolean bl, final ListBuffer<JavaFileObject> listBuffer) throws IOException {
            Path path2 = this.packages.get(relativeDirectory);
            if (path2 == null) {
                return;
            }
            int n = bl ? Integer.MAX_VALUE : 1;
            Files.walkFileTree(path2, FOLLOW_LINKS_OPTIONS, n, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) {
                    if (ArchiveContainer.this.isValid(path.getFileName())) {
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }

                @Override
                public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) {
                    if (basicFileAttributes.isRegularFile() && set.contains((Object)BaseFileManager.getKind(path.getFileName().toString()))) {
                        PathFileObject pathFileObject = PathFileObject.forJarPath(JavacFileManager.this, path, ArchiveContainer.this.archivePath);
                        listBuffer.append(pathFileObject);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }

        private boolean isValid(Path path) {
            if (path == null) {
                return true;
            }
            String string = path.toString();
            if (string.endsWith("/")) {
                string = string.substring(0, string.length() - 1);
            }
            return SourceVersion.isIdentifier(string);
        }

        @Override
        public JavaFileObject getFileObject(Path path, RelativePath.RelativeFile relativeFile) throws IOException {
            Path path2;
            RelativePath.RelativeDirectory relativeDirectory = relativeFile.dirname();
            Path path3 = this.packages.get(relativeDirectory);
            if (path3 != null && Files.exists(path2 = path3.resolve(relativeFile.basename()), new LinkOption[0])) {
                return PathFileObject.forJarPath(JavacFileManager.this, path2, path);
            }
            return null;
        }

        @Override
        public void close() throws IOException {
            this.fileSystem.close();
        }

        @Override
        public boolean maintainsDirectoryIndex() {
            return true;
        }

        @Override
        public Iterable<RelativePath.RelativeDirectory> indexedDirectories() {
            return this.packages.keySet();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static class PathAndContainer
    implements Comparable<PathAndContainer> {
        private final Path path;
        private final Container container;
        private final int index;

        PathAndContainer(Path path, Container container, int n) {
            this.path = path;
            this.container = container;
            this.index = n;
        }

        @Override
        public int compareTo(PathAndContainer pathAndContainer) {
            return this.index - pathAndContainer.index;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof PathAndContainer)) return false;
            PathAndContainer pathAndContainer = (PathAndContainer)object;
            if (!this.path.equals(pathAndContainer.path)) return false;
            if (!this.container.equals(pathAndContainer.container)) return false;
            if (this.index != pathAndContainer.index) return false;
            return true;
        }

        public int hashCode() {
            return Objects.hash(this.path, this.container, this.index);
        }
    }
}

