/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.jvm;

import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Options;
import java.util.EnumSet;
import java.util.Set;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public enum Profile {
    COMPACT1("compact1", 1, Target.JDK1_8, new Target[0]),
    COMPACT2("compact2", 2, Target.JDK1_8, new Target[0]),
    COMPACT3("compact3", 3, Target.JDK1_8, new Target[0]),
    DEFAULT{

        @Override
        public boolean isValid(Target target) {
            return true;
        }
    };

    private static final Context.Key<Profile> profileKey;
    public final String name;
    public final int value;
    final Set<Target> targets;

    public static Profile instance(Context context) {
        Profile profile = context.get(profileKey);
        if (profile == null) {
            Options options = Options.instance(context);
            String string = options.get(Option.PROFILE);
            if (string != null) {
                profile = Profile.lookup(string);
            }
            if (profile == null) {
                profile = DEFAULT;
            }
            context.put(profileKey, profile);
        }
        return profile;
    }

    private Profile() {
        this.name = null;
        this.value = Integer.MAX_VALUE;
        this.targets = null;
    }

    private Profile(String string2, int n2, Target target, Target ... targetArray) {
        this.name = string2;
        this.value = n2;
        this.targets = EnumSet.of(target, targetArray);
    }

    public static Profile lookup(String string) {
        for (Profile profile : Profile.values()) {
            if (!string.equals(profile.name)) continue;
            return profile;
        }
        return null;
    }

    public static Profile lookup(int n) {
        for (Profile profile : Profile.values()) {
            if (n != profile.value) continue;
            return profile;
        }
        return null;
    }

    public boolean isValid(Target target) {
        return this.targets.contains((Object)target);
    }

    static {
        profileKey = new Context.Key();
    }
}

