/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.shellsupport.doc;

import com.sun.source.doctree.AttributeTree;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.InlineTagTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.doctree.ReturnTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.ThrowsTree;
import com.sun.source.util.DocTreeScanner;
import com.sun.source.util.DocTrees;
import com.sun.source.util.JavacTask;
import com.sun.tools.javac.util.StringUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Stack;
import javax.lang.model.element.Name;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.ToolProvider;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JavadocFormatter {
    private static final String CODE_RESET = "\u001b[0m";
    private static final String CODE_HIGHLIGHT = "\u001b[1m";
    private static final String CODE_UNDERLINE = "\u001b[4m";
    private final int lineLimit;
    private final boolean escapeSequencesSupported;
    private static final int MAX_LINE_LENGTH = 95;
    private static final int SHORTEST_LINE = 30;
    private static final int INDENT = 4;
    private static final Map<Sections, String> docSections = new LinkedHashMap<Sections, String>();
    private static final String inlineReturns;

    public JavadocFormatter(int n, boolean bl) {
        this.lineLimit = n;
        this.escapeSequencesSupported = bl;
    }

    public String formatJavadoc(String string, final String string2) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(this.escape(CODE_HIGHLIGHT)).append(string).append(this.escape(CODE_RESET)).append("\n");
            if (string2 == null) {
                return stringBuilder.toString();
            }
            JavacTask javacTask = (JavacTask)ToolProvider.getSystemJavaCompiler().getTask(null, null, null, null, null, null);
            DocTrees docTrees = DocTrees.instance(javacTask);
            DocCommentTree docCommentTree = docTrees.getDocCommentTree(new SimpleJavaFileObject(new URI("mem://doc.html"), JavaFileObject.Kind.HTML){

                @Override
                public CharSequence getCharContent(boolean bl) throws IOException {
                    return "<body>" + string2 + "</body>";
                }
            });
            new FormatJavadocScanner(stringBuilder, javacTask).scan((DocTree)docCommentTree, (Object)null);
            JavadocFormatter.addNewLineIfNeeded(stringBuilder);
            return stringBuilder.toString();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InternalError("Unexpected exception", uRISyntaxException);
        }
    }

    private String escape(String string) {
        return this.escapeSequencesSupported ? string : "";
    }

    private static String indentString(int n) {
        char[] cArray = new char[n];
        Arrays.fill(cArray, ' ');
        return new String(cArray);
    }

    private static void reflow(StringBuilder stringBuilder, int n, int n2, int n3) {
        int n4;
        for (n4 = n; n4 > 0 && stringBuilder.charAt(n4 - 1) != '\n'; --n4) {
        }
        int n5 = n - n4;
        int n6 = -1;
        for (int i = n; i < stringBuilder.length(); ++i) {
            if (stringBuilder.charAt(i) == ' ') {
                n6 = i;
            }
            if (n5 >= n3 && n6 != -1) {
                stringBuilder.setCharAt(n6, '\n');
                stringBuilder.insert(n6 + 1, JavadocFormatter.indentString(n2));
                n5 = n2 + i - n6 - 1;
                i += n2;
                n6 = -1;
            }
            ++n5;
        }
    }

    private static void addNewLineIfNeeded(StringBuilder stringBuilder) {
        if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != '\n') {
            stringBuilder.append("\n");
        }
    }

    private static void addSpaceIfNeeded(StringBuilder stringBuilder) {
        if (stringBuilder.length() == 0) {
            return;
        }
        char c = stringBuilder.charAt(stringBuilder.length() - 1);
        if (c != ' ' && c != '\n') {
            stringBuilder.append(" ");
        }
    }

    private static HtmlTag getHtmlTag(Name name) {
        HtmlTag htmlTag = HtmlTag.get(name);
        return htmlTag != null ? htmlTag : HtmlTag.HTML;
    }

    private static Map<StartElementTree, Integer> countTableColumns(DocCommentTree docCommentTree) {
        final IdentityHashMap<StartElementTree, Integer> identityHashMap = new IdentityHashMap<StartElementTree, Integer>();
        new DocTreeScanner<Void, Void>(){
            private StartElementTree currentTable;
            private int currentMaxColumns;
            private int currentRowColumns;

            @Override
            public Void visitStartElement(StartElementTree startElementTree, Void void_) {
                switch (JavadocFormatter.getHtmlTag(startElementTree.getName())) {
                    case TABLE: {
                        this.currentTable = startElementTree;
                        break;
                    }
                    case TR: {
                        this.currentMaxColumns = Math.max(this.currentMaxColumns, this.currentRowColumns);
                        this.currentRowColumns = 0;
                        break;
                    }
                    case TH: 
                    case TD: {
                        ++this.currentRowColumns;
                    }
                }
                return (Void)super.visitStartElement(startElementTree, void_);
            }

            @Override
            public Void visitEndElement(EndElementTree endElementTree, Void void_) {
                if (HtmlTag.get(endElementTree.getName()) == HtmlTag.TABLE) {
                    this.closeTable();
                }
                return (Void)super.visitEndElement(endElementTree, void_);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void visitDocComment(DocCommentTree docCommentTree, Void void_) {
                try {
                    Void void_2 = (Void)super.visitDocComment(docCommentTree, void_);
                    return void_2;
                }
                finally {
                    this.closeTable();
                }
            }

            private void closeTable() {
                if (this.currentTable != null) {
                    identityHashMap.put(this.currentTable, Math.max(this.currentMaxColumns, this.currentRowColumns));
                    this.currentTable = null;
                }
            }
        }.scan(docCommentTree, null);
        return identityHashMap;
    }

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("jdk.internal.shellsupport.doc.resources.javadocformatter");
        docSections.put(Sections.TYPE_PARAMS, resourceBundle.getString("CAP_TypeParameters"));
        docSections.put(Sections.PARAMS, resourceBundle.getString("CAP_Parameters"));
        docSections.put(Sections.RETURNS, resourceBundle.getString("CAP_Returns"));
        docSections.put(Sections.THROWS, resourceBundle.getString("CAP_Thrown_Exceptions"));
        inlineReturns = resourceBundle.getString("Inline_Returns");
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private class FormatJavadocScanner
    extends DocTreeScanner<Object, Object> {
        private final StringBuilder result;
        private final JavacTask task;
        private final DocTrees trees;
        private int reflownTo;
        private int indent;
        private int limit;
        private boolean pre;
        private Map<StartElementTree, Integer> tableColumns;
        Stack<Integer> listStack;
        Stack<Integer> defStack;
        Stack<Integer> tableStack;
        Stack<List<Integer>> cellsStack;
        Stack<List<Boolean>> headerStack;
        private DocTree lastNode;

        public FormatJavadocScanner(StringBuilder stringBuilder, JavacTask javacTask) {
            this.limit = Math.min(JavadocFormatter.this.lineLimit, 95);
            this.listStack = new Stack();
            this.defStack = new Stack();
            this.tableStack = new Stack();
            this.cellsStack = new Stack();
            this.headerStack = new Stack();
            this.result = stringBuilder;
            this.task = javacTask;
            this.trees = DocTrees.instance(javacTask);
        }

        @Override
        public Object visitDocComment(DocCommentTree docCommentTree, Object object) {
            this.tableColumns = JavadocFormatter.countTableColumns(docCommentTree);
            this.reflownTo = this.result.length();
            this.scan(docCommentTree.getFirstSentence(), object);
            this.scan(docCommentTree.getBody(), object);
            JavadocFormatter.reflow(this.result, this.reflownTo, this.indent, this.limit);
            for (Sections sections : docSections.keySet()) {
                boolean bl = false;
                Object object2 = docCommentTree.getBlockTags().iterator();
                while (object2.hasNext()) {
                    DocTree docTree = object2.next();
                    if (!sections.matches(docTree)) continue;
                    if (!bl) {
                        bl = true;
                        this.startSection(sections);
                    }
                    this.scan(docTree, (Object)null);
                }
                if (sections != Sections.RETURNS || bl || (object2 = docCommentTree.getFirstSentence()).size() != 1 || ((DocTree)object2.get(0)).getKind() != DocTree.Kind.RETURN) continue;
                this.startSection(sections);
                this.scan((DocTree)object2.get(0), (Object)true);
            }
            return null;
        }

        private void startSection(Sections sections) {
            if (this.result.charAt(this.result.length() - 1) != '\n') {
                this.result.append("\n");
            }
            this.result.append("\n");
            this.result.append(JavadocFormatter.this.escape(JavadocFormatter.CODE_UNDERLINE)).append(docSections.get((Object)sections)).append(JavadocFormatter.this.escape(JavadocFormatter.CODE_RESET)).append("\n");
        }

        @Override
        public Object visitText(TextTree textTree, Object object) {
            String string = textTree.getBody();
            if (!this.pre) {
                if ((string = string.replaceAll("[ \t\r\n]+", " ").trim()).isEmpty()) {
                    string = " ";
                }
            } else {
                string = string.replaceAll("\n", "\n" + JavadocFormatter.indentString(this.indent));
            }
            this.result.append(string);
            return null;
        }

        @Override
        public Object visitLink(LinkTree linkTree, Object object) {
            if (!linkTree.getLabel().isEmpty()) {
                this.scan(linkTree.getLabel(), object);
            } else {
                this.result.append(linkTree.getReference().getSignature());
            }
            return null;
        }

        @Override
        public Object visitParam(ParamTree paramTree, Object object) {
            return this.formatDef(paramTree.getName().getName(), paramTree.getDescription());
        }

        @Override
        public Object visitThrows(ThrowsTree throwsTree, Object object) {
            return this.formatDef(throwsTree.getExceptionName().getSignature(), throwsTree.getDescription());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object formatDef(CharSequence charSequence, List<? extends DocTree> list) {
            this.result.append(charSequence);
            this.result.append(" - ");
            this.reflownTo = this.result.length();
            this.indent = charSequence.length() + 3;
            if (this.limit - this.indent < 30) {
                this.result.append("\n");
                this.result.append(JavadocFormatter.indentString(4));
                this.indent = 4;
                this.reflownTo += 4;
            }
            try {
                Object r = this.scan(list, null);
                return r;
            }
            finally {
                JavadocFormatter.reflow(this.result, this.reflownTo, this.indent, this.limit);
                this.result.append("\n");
            }
        }

        @Override
        public Object visitLiteral(LiteralTree literalTree, Object object) {
            return this.scan((DocTree)literalTree.getBody(), object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object visitReturn(ReturnTree returnTree, Object object) {
            if (returnTree.isInline() && object == null) {
                String string = "{0}";
                int n = inlineReturns.indexOf(string);
                this.result.append(inlineReturns, 0, n);
                try {
                    Object r = super.visitReturn(returnTree, object);
                    return r;
                }
                finally {
                    this.result.append(inlineReturns.substring(n + string.length()));
                }
            }
            this.reflownTo = this.result.length();
            try {
                Object r = super.visitReturn(returnTree, object);
                return r;
            }
            finally {
                JavadocFormatter.reflow(this.result, this.reflownTo, 0, this.limit);
            }
        }

        @Override
        public Object visitStartElement(StartElementTree startElementTree, Object object) {
            block0 : switch (JavadocFormatter.getHtmlTag(startElementTree.getName())) {
                case P: {
                    if (this.lastNode != null && this.lastNode.getKind() == DocTree.Kind.START_ELEMENT && HtmlTag.get(((StartElementTree)this.lastNode).getName()) == HtmlTag.LI) break;
                    this.reflowTillNow();
                    JavadocFormatter.addNewLineIfNeeded(this.result);
                    this.result.append(JavadocFormatter.indentString(this.indent));
                    this.reflownTo = this.result.length();
                    break;
                }
                case BLOCKQUOTE: {
                    this.reflowTillNow();
                    this.indent += 4;
                    break;
                }
                case PRE: {
                    this.reflowTillNow();
                    this.pre = true;
                    break;
                }
                case UL: {
                    this.reflowTillNow();
                    this.listStack.push(-1);
                    this.indent += 4;
                    break;
                }
                case OL: {
                    this.reflowTillNow();
                    this.listStack.push(1);
                    this.indent += 4;
                    break;
                }
                case DL: {
                    this.reflowTillNow();
                    this.defStack.push(this.indent);
                    break;
                }
                case LI: {
                    this.reflowTillNow();
                    if (this.listStack.empty()) break;
                    JavadocFormatter.addNewLineIfNeeded(this.result);
                    int n = this.listStack.pop();
                    if (n == -1) {
                        this.result.append(JavadocFormatter.indentString(this.indent - 2));
                        this.result.append("* ");
                    } else {
                        this.result.append(JavadocFormatter.indentString(this.indent - 3));
                        this.result.append(n++ + ". ");
                    }
                    this.listStack.push(n);
                    this.reflownTo = this.result.length();
                    break;
                }
                case DT: {
                    this.reflowTillNow();
                    if (this.defStack.isEmpty()) break;
                    JavadocFormatter.addNewLineIfNeeded(this.result);
                    this.indent = this.defStack.peek();
                    this.result.append(JavadocFormatter.this.escape(JavadocFormatter.CODE_HIGHLIGHT));
                    break;
                }
                case DD: {
                    this.reflowTillNow();
                    if (this.defStack.isEmpty()) break;
                    if (this.indent == this.defStack.peek()) {
                        this.result.append(JavadocFormatter.this.escape(JavadocFormatter.CODE_RESET));
                    }
                    JavadocFormatter.addNewLineIfNeeded(this.result);
                    this.indent = this.defStack.peek() + 4;
                    this.result.append(JavadocFormatter.indentString(this.indent));
                    break;
                }
                case H1: 
                case H2: 
                case H3: 
                case H4: 
                case H5: 
                case H6: {
                    this.reflowTillNow();
                    JavadocFormatter.addNewLineIfNeeded(this.result);
                    this.result.append("\n").append(JavadocFormatter.this.escape(JavadocFormatter.CODE_UNDERLINE));
                    this.reflownTo = this.result.length();
                    break;
                }
                case TABLE: {
                    int n = this.tableColumns.get(startElementTree);
                    if (n == 0) break;
                    this.reflowTillNow();
                    JavadocFormatter.addNewLineIfNeeded(this.result);
                    this.reflownTo = this.result.length();
                    this.tableStack.push(this.limit);
                    this.limit = (this.limit - 1) / n - 3;
                    for (int i = 0; i < (this.limit + 3) * n + 1; ++i) {
                        this.result.append("-");
                    }
                    this.result.append("\n");
                    break;
                }
                case TR: {
                    if (this.cellsStack.size() >= this.tableStack.size()) {
                        this.handleEndElement(startElementTree.getName());
                    }
                    this.cellsStack.push(new ArrayList());
                    this.headerStack.push(new ArrayList());
                    break;
                }
                case TH: 
                case TD: {
                    if (this.cellsStack.isEmpty()) break;
                    this.reflowTillNow();
                    this.result.append("\n");
                    this.reflownTo = this.result.length();
                    this.cellsStack.peek().add(this.result.length());
                    this.headerStack.peek().add(HtmlTag.get(startElementTree.getName()) == HtmlTag.TH);
                    break;
                }
                case IMG: {
                    for (DocTree docTree : startElementTree.getAttributes()) {
                        AttributeTree attributeTree;
                        if (docTree.getKind() != DocTree.Kind.ATTRIBUTE || !"alt".equals(StringUtils.toLowerCase((attributeTree = (AttributeTree)docTree).getName().toString()))) continue;
                        JavadocFormatter.addSpaceIfNeeded(this.result);
                        this.scan(attributeTree.getValue(), null);
                        JavadocFormatter.addSpaceIfNeeded(this.result);
                        break block0;
                    }
                    break;
                }
                default: {
                    JavadocFormatter.addSpaceIfNeeded(this.result);
                }
            }
            return null;
        }

        @Override
        public Object visitEndElement(EndElementTree endElementTree, Object object) {
            this.handleEndElement(endElementTree.getName());
            return super.visitEndElement(endElementTree, object);
        }

        private void handleEndElement(Name name) {
            switch (JavadocFormatter.getHtmlTag(name)) {
                case BLOCKQUOTE: {
                    this.indent -= 4;
                    break;
                }
                case PRE: {
                    this.pre = false;
                    JavadocFormatter.addNewLineIfNeeded(this.result);
                    this.reflownTo = this.result.length();
                    break;
                }
                case UL: 
                case OL: {
                    if (this.listStack.isEmpty()) break;
                    this.reflowTillNow();
                    this.listStack.pop();
                    this.indent -= 4;
                    JavadocFormatter.addNewLineIfNeeded(this.result);
                    break;
                }
                case DL: {
                    if (this.defStack.isEmpty()) break;
                    this.reflowTillNow();
                    if (this.indent == this.defStack.peek()) {
                        this.result.append(JavadocFormatter.this.escape(JavadocFormatter.CODE_RESET));
                    }
                    this.indent = this.defStack.pop();
                    JavadocFormatter.addNewLineIfNeeded(this.result);
                    break;
                }
                case H1: 
                case H2: 
                case H3: 
                case H4: 
                case H5: 
                case H6: {
                    this.reflowTillNow();
                    this.result.append(JavadocFormatter.this.escape(JavadocFormatter.CODE_RESET)).append("\n");
                    this.reflownTo = this.result.length();
                    break;
                }
                case TABLE: {
                    if (this.cellsStack.size() >= this.tableStack.size()) {
                        this.handleEndElement(this.task.getElements().getName("tr"));
                    }
                    if (this.tableStack.isEmpty()) break;
                    this.limit = this.tableStack.pop();
                    break;
                }
                case TR: {
                    int n;
                    if (this.cellsStack.isEmpty()) break;
                    this.reflowTillNow();
                    List<Integer> list = this.cellsStack.pop();
                    List<Boolean> list2 = this.headerStack.pop();
                    ArrayList<String[]> arrayList = new ArrayList<String[]>();
                    int n2 = 0;
                    this.result.append("\n");
                    while (!list.isEmpty()) {
                        n = list.remove(list.size() - 1);
                        String[] stringArray = this.result.substring(n, this.result.length()).split("\n");
                        this.result.delete(n - 1, this.result.length());
                        arrayList.add(stringArray);
                        n2 = Math.max(n2, stringArray.length);
                    }
                    Collections.reverse(arrayList);
                    for (n = 0; n < n2; ++n) {
                        for (int i = 0; i < arrayList.size(); ++i) {
                            int n3;
                            String[] stringArray = (String[])arrayList.get(i);
                            String string = n < stringArray.length ? stringArray[n] : "";
                            this.result.append("| ");
                            boolean bl = list2.get(i);
                            if (bl) {
                                this.result.append(JavadocFormatter.this.escape(JavadocFormatter.CODE_HIGHLIGHT));
                            }
                            this.result.append(string);
                            if (bl) {
                                this.result.append(JavadocFormatter.this.escape(JavadocFormatter.CODE_RESET));
                            }
                            if ((n3 = this.limit - string.length()) > 0) {
                                this.result.append(JavadocFormatter.indentString(n3));
                            }
                            this.result.append(" ");
                        }
                        this.result.append("|\n");
                    }
                    for (n = 0; n < (this.limit + 3) * arrayList.size() + 1; ++n) {
                        this.result.append("-");
                    }
                    this.result.append("\n");
                    this.reflownTo = this.result.length();
                    break;
                }
                case TH: 
                case TD: {
                    break;
                }
                default: {
                    JavadocFormatter.addSpaceIfNeeded(this.result);
                }
            }
        }

        @Override
        public Object visitEntity(EntityTree entityTree, Object object) {
            String string = this.trees.getCharacters(entityTree);
            this.result.append(string == null ? entityTree.toString() : string);
            return super.visitEntity(entityTree, object);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object scan(DocTree docTree, Object object) {
            if (docTree instanceof InlineTagTree) {
                JavadocFormatter.addSpaceIfNeeded(this.result);
            }
            try {
                Object r = super.scan(docTree, object);
                return r;
            }
            finally {
                if (docTree instanceof InlineTagTree) {
                    JavadocFormatter.addSpaceIfNeeded(this.result);
                }
                this.lastNode = docTree;
            }
        }

        private void reflowTillNow() {
            while (this.result.length() > 0 && this.result.charAt(this.result.length() - 1) == ' ') {
                this.result.delete(this.result.length() - 1, this.result.length());
            }
            this.reflownTo = Math.min(this.reflownTo, this.result.length());
            JavadocFormatter.reflow(this.result, this.reflownTo, this.indent, this.limit);
            this.reflownTo = this.result.length();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static enum HtmlTag {
        HTML,
        H1,
        H2,
        H3,
        H4,
        H5,
        H6,
        BLOCKQUOTE,
        P,
        PRE,
        IMG,
        OL,
        UL,
        LI,
        DL,
        DT,
        DD,
        TABLE,
        TR,
        TD,
        TH;

        private static final Map<String, HtmlTag> index;

        public static HtmlTag get(Name name) {
            return index.get(StringUtils.toLowerCase(name.toString()));
        }

        static {
            index = new HashMap<String, HtmlTag>();
            for (HtmlTag htmlTag : HtmlTag.values()) {
                index.put(StringUtils.toLowerCase(htmlTag.name()), htmlTag);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    private static enum Sections {
        TYPE_PARAMS{

            @Override
            public boolean matches(DocTree docTree) {
                return docTree.getKind() == DocTree.Kind.PARAM && ((ParamTree)docTree).isTypeParameter();
            }
        }
        ,
        PARAMS{

            @Override
            public boolean matches(DocTree docTree) {
                return docTree.getKind() == DocTree.Kind.PARAM && !((ParamTree)docTree).isTypeParameter();
            }
        }
        ,
        RETURNS{

            @Override
            public boolean matches(DocTree docTree) {
                return docTree.getKind() == DocTree.Kind.RETURN;
            }
        }
        ,
        THROWS{

            @Override
            public boolean matches(DocTree docTree) {
                return docTree.getKind() == DocTree.Kind.THROWS;
            }
        };


        public abstract boolean matches(DocTree var1);
    }
}

