/*
 * Decompiled with CFR 0.152.
 */
package com.sun.source.util;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.util.DocTreePathScanner;
import com.sun.source.util.TreePath;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public class DocTreePath
implements Iterable<DocTree> {
    private final TreePath treePath;
    private final DocCommentTree docComment;
    private final DocTree leaf;
    private final DocTreePath parent;

    public static DocTreePath getPath(TreePath treePath, DocCommentTree docCommentTree, DocTree docTree) {
        return DocTreePath.getPath(new DocTreePath(treePath, docCommentTree), docTree);
    }

    public static DocTreePath getPath(DocTreePath docTreePath, DocTree docTree) {
        Objects.requireNonNull(docTreePath);
        Objects.requireNonNull(docTree);
        class PathFinder
        extends DocTreePathScanner<DocTreePath, DocTree> {
            private DocTreePath result;

            PathFinder() {
            }

            @Override
            public DocTreePath scan(DocTreePath docTreePath, DocTree docTree) {
                super.scan(docTreePath, docTree);
                return this.result;
            }

            @Override
            public DocTreePath scan(DocTree docTree, DocTree docTree2) {
                if (this.result == null) {
                    if (docTree == docTree2) {
                        this.result = new DocTreePath(this.getCurrentPath(), docTree2);
                    } else {
                        super.scan(docTree, docTree2);
                    }
                }
                return this.result;
            }

            @Override
            public DocTreePath scan(Iterable<? extends DocTree> iterable, DocTree docTree) {
                if (iterable != null && this.result == null) {
                    for (DocTree docTree2 : iterable) {
                        this.scan(docTree2, docTree);
                        if (this.result == null) continue;
                        break;
                    }
                }
                return this.result;
            }
        }
        return docTreePath.getLeaf() == docTree ? docTreePath : new PathFinder().scan(docTreePath, docTree);
    }

    public DocTreePath(TreePath treePath, DocCommentTree docCommentTree) {
        this.treePath = treePath;
        this.docComment = Objects.requireNonNull(docCommentTree);
        this.parent = null;
        this.leaf = docCommentTree;
    }

    public DocTreePath(DocTreePath docTreePath, DocTree docTree) {
        if (docTree.getKind() == DocTree.Kind.DOC_COMMENT) {
            throw new IllegalArgumentException("Use DocTreePath(TreePath, DocCommentTree) to construct DocTreePath for a DocCommentTree.");
        }
        this.treePath = docTreePath.treePath;
        this.docComment = docTreePath.docComment;
        this.parent = docTreePath;
        this.leaf = docTree;
    }

    public TreePath getTreePath() {
        return this.treePath;
    }

    public DocCommentTree getDocComment() {
        return this.docComment;
    }

    public DocTree getLeaf() {
        return this.leaf;
    }

    public DocTreePath getParentPath() {
        return this.parent;
    }

    @Override
    public Iterator<DocTree> iterator() {
        return new Iterator<DocTree>(){
            private DocTreePath next;
            {
                this.next = DocTreePath.this;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public DocTree next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                DocTree docTree = this.next.leaf;
                this.next = this.next.parent;
                return docTree;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

