/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.api;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.api.MultiTaskListener;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Preview;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.CompileStates;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.main.Arguments;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.platform.PlatformDescription;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class JavacTaskPool {
    private static final JavacTool systemProvider = JavacTool.create();
    private static final Queue<ReusableContext> EMPTY_QUEUE = new ArrayDeque<ReusableContext>(0);
    private final int maxPoolSize;
    private final Map<List<String>, Queue<ReusableContext>> options2Contexts = new HashMap<List<String>, Queue<ReusableContext>>();
    private int id;
    private int statReused = 0;
    private int statNew = 0;
    private int statPolluted = 0;
    private int statRemoved = 0;

    public JavacTaskPool(int n) {
        this.maxPoolSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Z> Z getTask(Writer writer, JavaFileManager javaFileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> iterable, Iterable<String> iterable2, Iterable<? extends JavaFileObject> iterable3, Worker<Z> worker) {
        ReusableContext reusableContext3;
        Queue<ReusableContext> queue;
        List list2 = StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toCollection(ArrayList::new));
        Object object = this;
        synchronized (object) {
            queue = this.options2Contexts.getOrDefault(list2, EMPTY_QUEUE);
            if (queue.isEmpty()) {
                reusableContext3 = new ReusableContext(list2);
                ++this.statNew;
            } else {
                reusableContext3 = queue.remove();
                ++this.statReused;
            }
        }
        ++reusableContext3.useCount;
        object = (JavacTaskImpl)systemProvider.getTask(writer, javaFileManager, diagnosticListener, list2, iterable2, iterable3, reusableContext3);
        ((BasicJavacTask)object).addTaskListener(reusableContext3);
        if (writer != null) {
            Log.instance(reusableContext3).setWriters(new PrintWriter(writer, true));
        }
        queue = worker.withTask((JavacTask)object);
        reusableContext3.clear();
        if (reusableContext3.polluted) {
            ++this.statPolluted;
        } else {
            ((JavacTaskImpl)object).cleanup();
            JavacTaskPool javacTaskPool = this;
            synchronized (javacTaskPool) {
                while (this.cacheSize() + 1L > (long)this.maxPoolSize) {
                    ReusableContext reusableContext4 = (ReusableContext)this.options2Contexts.values().stream().flatMap(Collection::stream).sorted((reusableContext, reusableContext2) -> reusableContext.timeStamp < reusableContext2.timeStamp ? -1 : 1).findFirst().get();
                    this.options2Contexts.get(reusableContext4.arguments).remove(reusableContext4);
                    ++this.statRemoved;
                }
                this.options2Contexts.computeIfAbsent(reusableContext3.arguments, list -> new ArrayDeque()).add(reusableContext3);
                reusableContext3.timeStamp = this.id++;
            }
        }
        return (Z)queue;
    }

    private long cacheSize() {
        return this.options2Contexts.values().stream().flatMap(Collection::stream).count();
    }

    public void printStatistics(PrintStream printStream) {
        printStream.println(this.statReused + " reused Contexts");
        printStream.println(this.statNew + " newly created Contexts");
        printStream.println(this.statPolluted + " polluted Contexts");
        printStream.println(this.statRemoved + " removed Contexts");
    }

    static class ReusableContext
    extends Context
    implements TaskListener {
        Set<CompilationUnitTree> roots = new HashSet<CompilationUnitTree>();
        List<String> arguments;
        boolean polluted = false;
        int useCount;
        long timeStamp;
        TreeScanner<Void, Symtab> pollutionScanner = new TreeScanner<Void, Symtab>(){

            @Override
            public Void scan(Tree tree, Symtab symtab) {
                if (tree instanceof JCTree.LetExpr) {
                    JCTree.LetExpr letExpr = (JCTree.LetExpr)tree;
                    this.scan(letExpr.defs, symtab);
                    this.scan((Tree)letExpr.expr, symtab);
                    return null;
                }
                return (Void)super.scan(tree, symtab);
            }

            @Override
            public Void visitClass(ClassTree classTree, Symtab symtab) {
                Symbol.ClassSymbol classSymbol = ((JCTree.JCClassDecl)classTree).sym;
                if (classSymbol != null) {
                    symtab.removeClass(classSymbol.packge().modle, ((Symbol)classSymbol).flatName());
                    Type type = this.supertype(classSymbol);
                    if (this.isCoreClass(classSymbol) || type != null && this.isCoreClass(type.tsym) && type.tsym.kind != Kinds.Kind.TYP) {
                        polluted = true;
                    }
                }
                return (Void)super.visitClass(classTree, symtab);
            }

            private boolean isCoreClass(Symbol symbol) {
                return symbol.flatName().toString().startsWith("java.");
            }

            private Type supertype(Symbol symbol) {
                if (symbol.type == null || !symbol.type.hasTag(TypeTag.CLASS)) {
                    return null;
                }
                Type.ClassType classType = (Type.ClassType)symbol.type;
                return classType.supertype_field;
            }
        };

        ReusableContext(List<String> list) {
            this.arguments = list;
            this.put(Log.logKey, ReusableLog.factory);
            this.put(JavaCompiler.compilerKey, ReusableJavaCompiler.factory);
        }

        void clear() {
            this.polluted |= this.get(JavaFileManager.class).hasLocation(StandardLocation.PATCH_MODULE_PATH);
            this.drop(Arguments.argsKey);
            this.drop(DiagnosticListener.class);
            this.drop(Log.outKey);
            this.drop(Log.errKey);
            this.drop(JavaFileManager.class);
            this.drop(JavacTask.class);
            this.drop(JavacTrees.class);
            this.drop(JavacElements.class);
            this.drop(PlatformDescription.class);
            if (this.ht.get(Log.logKey) instanceof ReusableLog) {
                ((ReusableLog)Log.instance(this)).clear();
                Enter.instance(this).newRound();
                ((ReusableJavaCompiler)ReusableJavaCompiler.instance(this)).clear();
                Types.instance(this).newRound();
                Check.instance(this).newRound();
                Check.instance(this).clear();
                Preview.instance(this).clear();
                Modules.instance(this).newRound();
                Annotate.instance(this).newRound();
                CompileStates.instance(this).clear();
                MultiTaskListener.instance(this).clear();
                Options.instance(this).clear();
                Symtab symtab = Symtab.instance(this);
                this.pollutionScanner.scan(this.roots, symtab);
                this.roots.clear();
            }
        }

        @Override
        public void finished(TaskEvent taskEvent) {
            if (taskEvent.getKind() == TaskEvent.Kind.PARSE) {
                this.roots.add(taskEvent.getCompilationUnit());
            }
        }

        @Override
        public void started(TaskEvent taskEvent) {
        }

        <T> void drop(Context.Key<T> key) {
            this.ht.remove(key);
        }

        <T> void drop(Class<T> clazz) {
            this.ht.remove(this.key(clazz));
        }

        static class ReusableLog
        extends Log {
            static final Context.Factory<Log> factory = ReusableLog::new;
            Context context;

            ReusableLog(Context context) {
                super(context);
                this.context = context;
            }

            void clear() {
                this.recorded.clear();
                this.sourceMap.clear();
                this.nerrors = 0;
                this.nwarnings = 0;
                this.diagListener = new DiagnosticListener<JavaFileObject>(){
                    DiagnosticListener<JavaFileObject> cachedListener;

                    @Override
                    public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                        if (this.cachedListener == null) {
                            this.cachedListener = context.get(DiagnosticListener.class);
                        }
                        this.cachedListener.report(diagnostic);
                    }
                };
            }
        }

        static class ReusableJavaCompiler
        extends JavaCompiler {
            static final Context.Factory<JavaCompiler> factory = ReusableJavaCompiler::new;

            ReusableJavaCompiler(Context context) {
                super(context);
            }

            @Override
            public void close() {
            }

            void clear() {
                this.newRound();
            }

            @Override
            protected void checkReusable() {
            }
        }
    }

    public static interface Worker<Z> {
        public Z withTask(JavacTask var1);
    }
}

