/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.List;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.lang.model.element.ModuleElement;

public abstract class Directive
implements ModuleElement.Directive {

    public static class UsesDirective
    extends Directive
    implements ModuleElement.UsesDirective {
        public final Symbol.ClassSymbol service;

        public UsesDirective(Symbol.ClassSymbol classSymbol) {
            this.service = classSymbol;
        }

        @Override
        public ModuleElement.DirectiveKind getKind() {
            return ModuleElement.DirectiveKind.USES;
        }

        @Override
        public Symbol.ClassSymbol getService() {
            return this.service;
        }

        public String toString() {
            return "Uses[" + this.service + "]";
        }

        @Override
        public <R, P> R accept(ModuleElement.DirectiveVisitor<R, P> directiveVisitor, P p) {
            return directiveVisitor.visitUses(this, p);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof UsesDirective)) return false;
            UsesDirective usesDirective = (UsesDirective)object;
            if (this.service != usesDirective.service) return false;
            return true;
        }

        public int hashCode() {
            return this.service.hashCode() * 31;
        }
    }

    public static class RequiresDirective
    extends Directive
    implements ModuleElement.RequiresDirective {
        public final Symbol.ModuleSymbol module;
        public final Set<RequiresFlag> flags;

        public RequiresDirective(Symbol.ModuleSymbol moduleSymbol) {
            this(moduleSymbol, EnumSet.noneOf(RequiresFlag.class));
        }

        public RequiresDirective(Symbol.ModuleSymbol moduleSymbol, Set<RequiresFlag> set) {
            this.module = moduleSymbol;
            this.flags = set;
        }

        @Override
        public ModuleElement.DirectiveKind getKind() {
            return ModuleElement.DirectiveKind.REQUIRES;
        }

        @Override
        public boolean isStatic() {
            return this.flags.contains((Object)RequiresFlag.STATIC_PHASE);
        }

        @Override
        public boolean isTransitive() {
            return this.flags.contains((Object)RequiresFlag.TRANSITIVE);
        }

        @Override
        public Symbol.ModuleSymbol getDependency() {
            return this.module;
        }

        public String toString() {
            return "Requires[" + this.flags + "," + this.module + "]";
        }

        @Override
        public <R, P> R accept(ModuleElement.DirectiveVisitor<R, P> directiveVisitor, P p) {
            return directiveVisitor.visitRequires(this, p);
        }
    }

    public static class ProvidesDirective
    extends Directive
    implements ModuleElement.ProvidesDirective {
        public final Symbol.ClassSymbol service;
        public final List<Symbol.ClassSymbol> impls;

        public ProvidesDirective(Symbol.ClassSymbol classSymbol, List<Symbol.ClassSymbol> list) {
            this.service = classSymbol;
            this.impls = list;
        }

        @Override
        public ModuleElement.DirectiveKind getKind() {
            return ModuleElement.DirectiveKind.PROVIDES;
        }

        @Override
        public Symbol.ClassSymbol getService() {
            return this.service;
        }

        public List<Symbol.ClassSymbol> getImplementations() {
            return this.impls;
        }

        public String toString() {
            return "Provides[" + this.service + "," + this.impls + "]";
        }

        @Override
        public <R, P> R accept(ModuleElement.DirectiveVisitor<R, P> directiveVisitor, P p) {
            return directiveVisitor.visitProvides(this, p);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object object) {
            if (!(object instanceof ProvidesDirective)) return false;
            ProvidesDirective providesDirective = (ProvidesDirective)object;
            if (this.service != providesDirective.service) return false;
            if (!this.impls.equals(providesDirective.impls)) return false;
            return true;
        }

        public int hashCode() {
            return this.service.hashCode() * 31 + this.impls.hashCode() * 37;
        }
    }

    public static class OpensDirective
    extends Directive
    implements ModuleElement.OpensDirective {
        public final Symbol.PackageSymbol packge;
        public final List<Symbol.ModuleSymbol> modules;
        public final Set<OpensFlag> flags;

        public OpensDirective(Symbol.PackageSymbol packageSymbol, List<Symbol.ModuleSymbol> list) {
            this(packageSymbol, list, EnumSet.noneOf(OpensFlag.class));
        }

        public OpensDirective(Symbol.PackageSymbol packageSymbol, List<Symbol.ModuleSymbol> list, Set<OpensFlag> set) {
            this.packge = packageSymbol;
            this.modules = list;
            this.flags = set;
        }

        @Override
        public ModuleElement.DirectiveKind getKind() {
            return ModuleElement.DirectiveKind.OPENS;
        }

        @Override
        public Symbol.PackageSymbol getPackage() {
            return this.packge;
        }

        public java.util.List<Symbol.ModuleSymbol> getTargetModules() {
            return this.modules == null ? null : Collections.unmodifiableList(this.modules);
        }

        public String toString() {
            if (this.modules == null) {
                return "Opens[" + this.packge + "]";
            }
            return "Opens[" + this.packge + ":" + this.modules + "]";
        }

        @Override
        public <R, P> R accept(ModuleElement.DirectiveVisitor<R, P> directiveVisitor, P p) {
            return directiveVisitor.visitOpens(this, p);
        }
    }

    public static enum OpensFlag {
        SYNTHETIC(4096),
        MANDATED(32768);

        public final int value;

        public static int value(Set<OpensFlag> set) {
            int n = 0;
            for (OpensFlag opensFlag : set) {
                n |= opensFlag.value;
            }
            return n;
        }

        private OpensFlag(int n2) {
            this.value = n2;
        }
    }

    public static class ExportsDirective
    extends Directive
    implements ModuleElement.ExportsDirective {
        public final Symbol.PackageSymbol packge;
        public final List<Symbol.ModuleSymbol> modules;
        public final Set<ExportsFlag> flags;

        public ExportsDirective(Symbol.PackageSymbol packageSymbol, List<Symbol.ModuleSymbol> list) {
            this(packageSymbol, list, EnumSet.noneOf(ExportsFlag.class));
        }

        public ExportsDirective(Symbol.PackageSymbol packageSymbol, List<Symbol.ModuleSymbol> list, Set<ExportsFlag> set) {
            this.packge = packageSymbol;
            this.modules = list;
            this.flags = set;
        }

        @Override
        public ModuleElement.DirectiveKind getKind() {
            return ModuleElement.DirectiveKind.EXPORTS;
        }

        @Override
        public Symbol.PackageSymbol getPackage() {
            return this.packge;
        }

        public java.util.List<Symbol.ModuleSymbol> getTargetModules() {
            return this.modules == null ? null : Collections.unmodifiableList(this.modules);
        }

        public String toString() {
            if (this.modules == null) {
                return "Exports[" + this.packge + "]";
            }
            return "Exports[" + this.packge + ":" + this.modules + "]";
        }

        @Override
        public <R, P> R accept(ModuleElement.DirectiveVisitor<R, P> directiveVisitor, P p) {
            return directiveVisitor.visitExports(this, p);
        }
    }

    public static enum ExportsFlag {
        SYNTHETIC(4096),
        MANDATED(32768);

        public final int value;

        public static int value(Set<ExportsFlag> set) {
            int n = 0;
            for (ExportsFlag exportsFlag : set) {
                n |= exportsFlag.value;
            }
            return n;
        }

        private ExportsFlag(int n2) {
            this.value = n2;
        }
    }

    public static enum RequiresFlag {
        TRANSITIVE(32),
        STATIC_PHASE(64),
        SYNTHETIC(4096),
        MANDATED(32768),
        EXTRA(65536);

        public final int value;

        public static int value(Set<RequiresFlag> set) {
            int n = 0;
            for (RequiresFlag requiresFlag : set) {
                n |= requiresFlag.value;
            }
            return n;
        }

        private RequiresFlag(int n2) {
            this.value = n2;
        }

        public String toString() {
            return String.format("ACC_%s (0x%04x", this.name(), this.value);
        }
    }
}

