/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import java.util.HashMap;
import java.util.Map;

public class ExtraSymbolInfo {
    protected static final Context.Key<ExtraSymbolInfo> extraSymbolInfoHandlerWrapperKey = new Context.Key();
    private final Check chk;
    private final Map<Symbol, Integer> symbol2RemovedRelease = new HashMap<Symbol, Integer>();
    private final Map<Symbol, Integer> symbol2DeprecatedRelease = new HashMap<Symbol, Integer>();

    public static ExtraSymbolInfo instance(Context context) {
        ExtraSymbolInfo extraSymbolInfo = context.get(extraSymbolInfoHandlerWrapperKey);
        if (extraSymbolInfo == null) {
            extraSymbolInfo = new ExtraSymbolInfo(context);
        }
        return extraSymbolInfo;
    }

    protected ExtraSymbolInfo(Context context) {
        context.put(extraSymbolInfoHandlerWrapperKey, this);
        this.chk = Check.instance(context);
    }

    public void symbolRemovedInRelease(Symbol symbol, Integer n) {
        this.symbol2RemovedRelease.put(symbol, n);
    }

    public void symbolDeprecatedInRelease(Symbol symbol, Integer n) {
        this.symbol2DeprecatedRelease.put(symbol, n);
    }

    public void checkSymbolRemovedDeprecatedInFutureRelease(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol) {
        Integer n = this.symbol2RemovedRelease.get(symbol);
        if (n != null) {
            this.chk.reportWarningToRemovalHandler(diagnosticPosition, CompilerProperties.Warnings.SymbolRemovedInFutureVersion(Kinds.kindName(symbol), symbol.name, n));
        } else {
            Integer n2 = this.symbol2DeprecatedRelease.get(symbol);
            if (n2 != null) {
                this.chk.reportWarningToDeprecationHandler(diagnosticPosition, CompilerProperties.Warnings.SymbolDeprecatedInFutureVersion(Kinds.kindName(symbol), symbol.name, n2));
            }
        }
    }
}

