/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.Option;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.MandatoryWarningHandler;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileObject;

public class Preview {
    private final boolean enabled;
    private final MandatoryWarningHandler previewHandler;
    private final boolean forcePreview;
    private final Map<Integer, Source> majorVersionToSource;
    private final Set<JavaFileObject> sourcesWithPreviewFeatures = new HashSet<JavaFileObject>();
    private final Names names;
    private final Lint lint;
    private final Log log;
    private final Source source;
    private final Target target;
    private static final Context.Key<Preview> previewKey = new Context.Key();

    public static Preview instance(Context context) {
        Preview preview = context.get(previewKey);
        if (preview == null) {
            preview = new Preview(context);
        }
        return preview;
    }

    Preview(Context context) {
        context.put(previewKey, this);
        Options options = Options.instance(context);
        this.names = Names.instance(context);
        this.enabled = options.isSet(Option.PREVIEW);
        this.log = Log.instance(context);
        this.lint = Lint.instance(context);
        this.source = Source.instance(context);
        this.target = Target.instance(context);
        this.previewHandler = new MandatoryWarningHandler(this.log, this.source, this.lint.isEnabled(Lint.LintCategory.PREVIEW), true, "preview", Lint.LintCategory.PREVIEW);
        this.forcePreview = options.isSet("forcePreview");
        this.majorVersionToSource = this.initMajorVersionToSourceMap();
    }

    private Map<Integer, Source> initMajorVersionToSourceMap() {
        HashMap<Integer, Source> hashMap = new HashMap<Integer, Source>();
        for (Target target : Target.values()) {
            int n = target.majorVersion;
            Source source = Source.lookup(target.name);
            if (source == null) continue;
            hashMap.put(n, source);
        }
        return hashMap;
    }

    public boolean participatesInPreview(Symbol symbol, Symbol symbol2) {
        return symbol2.packge().modle == symbol.packge().modle || symbol.packge().modle.name == this.names.jdk_incubator_vector;
    }

    public void warnPreview(int n, Source.Feature feature) {
        this.warnPreview(new JCDiagnostic.SimpleDiagnosticPosition(n), feature);
    }

    public void warnPreview(JCDiagnostic.DiagnosticPosition diagnosticPosition, Source.Feature feature) {
        Assert.check(this.isEnabled());
        Assert.check(this.isPreview(feature));
        if (!this.lint.isSuppressed(Lint.LintCategory.PREVIEW)) {
            this.sourcesWithPreviewFeatures.add(this.log.currentSourceFile());
            this.previewHandler.report(diagnosticPosition, feature.isPlural() ? CompilerProperties.Warnings.PreviewFeatureUsePlural(feature.nameFragment()) : CompilerProperties.Warnings.PreviewFeatureUse(feature.nameFragment()));
        }
    }

    public void warnPreview(JavaFileObject javaFileObject, int n) {
        Assert.check(this.isEnabled());
        if (this.lint.isEnabled(Lint.LintCategory.PREVIEW)) {
            this.log.mandatoryWarning(Lint.LintCategory.PREVIEW, null, CompilerProperties.Warnings.PreviewFeatureUseClassfile(javaFileObject, this.majorVersionToSource.get((Object)Integer.valueOf((int)n)).name));
        }
    }

    public void markUsesPreview(JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        this.sourcesWithPreviewFeatures.add(this.log.currentSourceFile());
    }

    public void reportPreviewWarning(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCDiagnostic.Warning warning) {
        this.previewHandler.report(diagnosticPosition, warning);
    }

    public boolean usesPreview(JavaFileObject javaFileObject) {
        return this.sourcesWithPreviewFeatures.contains(javaFileObject);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isPreview(Source.Feature feature) {
        boolean bl;
        switch (feature) {
            case CASE_NULL: {
                bl = true;
                break;
            }
            case PATTERN_SWITCH: {
                bl = true;
                break;
            }
            case UNCONDITIONAL_PATTERN_IN_INSTANCEOF: {
                bl = true;
                break;
            }
            case RECORD_PATTERNS: {
                bl = true;
                break;
            }
            default: {
                bl = this.forcePreview;
            }
        }
        return bl;
    }

    public JCDiagnostic.Error disabledError(Source.Feature feature) {
        Assert.check(!this.isEnabled());
        return feature.isPlural() ? CompilerProperties.Errors.PreviewFeatureDisabledPlural(feature.nameFragment()) : CompilerProperties.Errors.PreviewFeatureDisabled(feature.nameFragment());
    }

    public JCDiagnostic.Error disabledError(JavaFileObject javaFileObject, int n) {
        Assert.check(!this.isEnabled());
        return CompilerProperties.Errors.PreviewFeatureDisabledClassfile(javaFileObject, this.majorVersionToSource.get((Object)Integer.valueOf((int)n)).name);
    }

    public boolean declaredUsingPreviewFeature(Symbol symbol) {
        return false;
    }

    public void reportDeferredDiagnostics() {
        this.previewHandler.reportDeferredDiagnostic();
    }

    public void clear() {
        this.previewHandler.clear();
    }

    public void checkSourceLevel(JCDiagnostic.DiagnosticPosition diagnosticPosition, Source.Feature feature) {
        if (this.isPreview(feature) && !this.isEnabled()) {
            this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, diagnosticPosition, this.disabledError(feature));
        } else {
            if (!feature.allowedInSource(this.source, this.target)) {
                this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, diagnosticPosition, feature.error(this.source.name));
            }
            if (this.isEnabled() && this.isPreview(feature)) {
                this.warnPreview(diagnosticPosition, feature);
            }
        }
    }
}

