/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.ArgumentAttr;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeCopier;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticSource;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.stream.Collectors;

public class Analyzer {
    protected static final Context.Key<Analyzer> analyzerKey = new Context.Key();
    final Types types;
    final Log log;
    final Attr attr;
    final DeferredAttr deferredAttr;
    final ArgumentAttr argumentAttr;
    final TreeMaker make;
    final AnalyzerCopier copier;
    private final boolean allowDiamondWithAnonymousClassCreation;
    final EnumSet<AnalyzerMode> analyzerModes;
    StatementAnalyzer<JCTree, JCTree>[] analyzers = new StatementAnalyzer[]{new DiamondInitializer(), new LambdaAnalyzer(), new RedundantTypeArgAnalyzer(), new RedundantLocalVarTypeAnalyzer(), new RedundantLocalVarTypeAnalyzerForEach()};
    DeferredAnalysisHelper flushDeferredHelper = new DeferredAnalysisHelper(){

        @Override
        public void queue(RewritingContext rewritingContext) {
        }

        @Override
        public void flush(Env<AttrContext> env) {
        }
    };
    DeferredAnalysisHelper queueDeferredHelper;
    DeferredAnalysisHelper deferredAnalysisHelper = this.queueDeferredHelper = new DeferredAnalysisHelper(){
        Map<Symbol.ClassSymbol, Queue<RewritingContext>> Q = new HashMap<Symbol.ClassSymbol, Queue<RewritingContext>>();

        @Override
        public void queue(RewritingContext rewritingContext) {
            Queue queue = this.Q.computeIfAbsent(rewritingContext.env.enclClass.sym.outermostClass(), classSymbol -> new ArrayDeque());
            queue.add(rewritingContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush(Env<AttrContext> env) {
            if (!this.Q.isEmpty()) {
                DeferredAnalysisHelper deferredAnalysisHelper = Analyzer.this.deferredAnalysisHelper;
                try {
                    Analyzer.this.deferredAnalysisHelper = Analyzer.this.flushDeferredHelper;
                    Queue<RewritingContext> queue = this.Q.get(env.enclClass.sym.outermostClass());
                    while (queue != null && !queue.isEmpty()) {
                        Analyzer.this.doAnalysis(queue.remove());
                    }
                }
                finally {
                    Analyzer.this.deferredAnalysisHelper = deferredAnalysisHelper;
                }
            }
        }
    };

    public static Analyzer instance(Context context) {
        Analyzer analyzer = context.get(analyzerKey);
        if (analyzer == null) {
            analyzer = new Analyzer(context);
        }
        return analyzer;
    }

    protected Analyzer(Context context) {
        context.put(analyzerKey, this);
        this.types = Types.instance(context);
        this.log = Log.instance(context);
        this.attr = Attr.instance(context);
        this.deferredAttr = DeferredAttr.instance(context);
        this.argumentAttr = ArgumentAttr.instance(context);
        this.make = TreeMaker.instance(context);
        this.copier = new AnalyzerCopier();
        Options options = Options.instance(context);
        String string = options.get("find");
        Source source = Source.instance(context);
        Target target = Target.instance(context);
        this.allowDiamondWithAnonymousClassCreation = Source.Feature.DIAMOND_WITH_ANONYMOUS_CLASS_CREATION.allowedInSource(source, target);
        this.analyzerModes = AnalyzerMode.getAnalyzerModes(string, source, target);
    }

    Env<AttrContext> copyEnvIfNeeded(JCTree jCTree, Env<AttrContext> env) {
        if (!this.analyzerModes.isEmpty() && !((AttrContext)env.info).attributionMode.isSpeculative && TreeInfo.isStatement(jCTree) && !jCTree.hasTag(JCTree.Tag.LABELLED)) {
            Attr.ResultInfo resultInfo;
            Env<AttrContext> env2 = env.dup(env.tree, ((AttrContext)env.info).dup(((AttrContext)env.info).scope.dupUnshared(((AttrContext)env.info).scope.owner)));
            AttrContext attrContext = (AttrContext)env2.info;
            if (((AttrContext)env2.info).returnResult != null) {
                Attr attr = this.attr;
                Objects.requireNonNull(attr);
                resultInfo = new Attr.ResultInfo(attr, ((AttrContext)env2.info).returnResult.pkind, ((AttrContext)env2.info).returnResult.pt);
            } else {
                resultInfo = null;
            }
            attrContext.returnResult = resultInfo;
            return env2;
        }
        return null;
    }

    void analyzeIfNeeded(JCTree jCTree, Env<AttrContext> env) {
        if (env != null) {
            JCTree.JCStatement jCStatement = (JCTree.JCStatement)jCTree;
            this.analyze(jCStatement, env);
        }
    }

    protected void analyze(JCTree.JCStatement jCStatement, Env<AttrContext> env) {
        StatementScanner statementScanner = new StatementScanner(jCStatement, env);
        statementScanner.scan();
        if (!statementScanner.rewritings.isEmpty()) {
            for (RewritingContext rewritingContext : statementScanner.rewritings) {
                this.deferredAnalysisHelper.queue(rewritingContext);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doAnalysis(RewritingContext rewritingContext) {
        DiagnosticSource diagnosticSource = this.log.currentSource();
        ArgumentAttr.LocalCacheContext localCacheContext = this.argumentAttr.withLocalCacheContext();
        try {
            this.log.useSource(rewritingContext.env.toplevel.getSourceFile());
            JCTree.JCStatement jCStatement = (JCTree.JCStatement)rewritingContext.originalTree;
            JCTree jCTree = null;
            if (((AttrContext)rewritingContext.env.info).scope.owner.kind == Kinds.Kind.TYP) {
                jCStatement = this.make.at(-1).Block(4096L, List.of((JCTree.JCStatement)rewritingContext.originalTree));
                jCTree = rewritingContext.originalTree;
            }
            this.deferredAttr.attribSpeculative(jCStatement, rewritingContext.env, this.attr.statInfo, new TreeRewriter(rewritingContext, jCTree), () -> rewritingContext.diagHandler(), DeferredAttr.AttributionMode.ANALYZER, this.argumentAttr.withLocalCacheContext());
            rewritingContext.analyzer.process(rewritingContext.oldTree, rewritingContext.replacement, rewritingContext.erroneous);
        }
        catch (Throwable throwable) {
            Assert.error("Analyzer error when processing: " + rewritingContext.originalTree + ":" + throwable.toString() + "\n" + Arrays.stream(throwable.getStackTrace()).map(stackTraceElement -> stackTraceElement.toString()).collect(Collectors.joining("\n")));
        }
        finally {
            this.log.useSource(diagnosticSource.getFile());
            localCacheContext.leave();
        }
    }

    public void flush(Env<AttrContext> env) {
        this.deferredAnalysisHelper.flush(env);
    }

    abstract class StatementAnalyzer<S extends JCTree, T extends JCTree> {
        AnalyzerMode mode;
        JCTree.Tag tag;

        StatementAnalyzer(AnalyzerMode analyzerMode, JCTree.Tag tag) {
            this.mode = analyzerMode;
            this.tag = tag;
        }

        boolean isEnabled() {
            return Analyzer.this.analyzerModes.contains((Object)this.mode);
        }

        abstract boolean match(S var1);

        abstract List<T> rewrite(S var1);

        abstract void process(S var1, T var2, boolean var3);
    }

    class DiamondInitializer
    extends StatementAnalyzer<JCTree.JCNewClass, JCTree.JCNewClass> {
        DiamondInitializer() {
            super(AnalyzerMode.DIAMOND, JCTree.Tag.NEWCLASS);
        }

        @Override
        boolean match(JCTree.JCNewClass jCNewClass) {
            return jCNewClass.clazz.hasTag(JCTree.Tag.TYPEAPPLY) && !TreeInfo.isDiamond(jCNewClass) && (jCNewClass.def == null || Analyzer.this.allowDiamondWithAnonymousClassCreation);
        }

        @Override
        List<JCTree.JCNewClass> rewrite(JCTree.JCNewClass jCNewClass) {
            if (jCNewClass.clazz.hasTag(JCTree.Tag.TYPEAPPLY)) {
                JCTree.JCNewClass jCNewClass2 = Analyzer.this.copier.copy(jCNewClass);
                ((JCTree.JCTypeApply)jCNewClass2.clazz).arguments = List.nil();
                return List.of(jCNewClass2);
            }
            return List.of(jCNewClass);
        }

        @Override
        void process(JCTree.JCNewClass jCNewClass, JCTree.JCNewClass jCNewClass2, boolean bl) {
            if (!bl) {
                List<Type> list;
                List<Type> list2;
                if (jCNewClass.def != null) {
                    list2 = jCNewClass2.def.implementing.nonEmpty() ? jCNewClass2.def.implementing.get((int)0).type.getTypeArguments() : jCNewClass2.def.extending.type.getTypeArguments();
                    list = jCNewClass.def.implementing.nonEmpty() ? jCNewClass.def.implementing.get((int)0).type.getTypeArguments() : jCNewClass.def.extending.type.getTypeArguments();
                } else {
                    list2 = jCNewClass2.type.getTypeArguments();
                    list = jCNewClass.type.getTypeArguments();
                }
                for (Type type : list2) {
                    if (!Analyzer.this.types.isSameType(type, (Type)list.head)) {
                        return;
                    }
                    list = list.tail;
                }
                Analyzer.this.log.warning(jCNewClass.clazz, CompilerProperties.Warnings.DiamondRedundantArgs);
            }
        }
    }

    class LambdaAnalyzer
    extends StatementAnalyzer<JCTree.JCNewClass, JCTree.JCLambda> {
        LambdaAnalyzer() {
            super(AnalyzerMode.LAMBDA, JCTree.Tag.NEWCLASS);
        }

        @Override
        boolean match(JCTree.JCNewClass jCNewClass) {
            Type type = jCNewClass.clazz.type;
            return jCNewClass.def != null && type.hasTag(TypeTag.CLASS) && Analyzer.this.types.isFunctionalInterface(type.tsym) && this.decls(jCNewClass.def).length() == 1;
        }

        private List<JCTree> decls(JCTree.JCClassDecl jCClassDecl) {
            ListBuffer<JCTree> listBuffer = new ListBuffer<JCTree>();
            for (JCTree jCTree : jCClassDecl.defs) {
                if (jCTree.hasTag(JCTree.Tag.METHODDEF)) {
                    JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)jCTree;
                    if ((jCMethodDecl.getModifiers().flags & 0x1000000000L) != 0L) continue;
                    listBuffer.add(jCMethodDecl);
                    continue;
                }
                listBuffer.add(jCTree);
            }
            return listBuffer.toList();
        }

        @Override
        List<JCTree.JCLambda> rewrite(JCTree.JCNewClass jCNewClass) {
            JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)Analyzer.this.copier.copy((JCTree)this.decls((JCTree.JCClassDecl)jCNewClass.def).head);
            List<JCTree.JCVariableDecl> list = jCMethodDecl.params;
            JCTree.JCBlock jCBlock = jCMethodDecl.body;
            JCTree.JCLambda jCLambda = Analyzer.this.make.at(jCNewClass).Lambda(list, jCBlock);
            return List.of(jCLambda);
        }

        @Override
        void process(JCTree.JCNewClass jCNewClass, JCTree.JCLambda jCLambda, boolean bl) {
            if (!bl) {
                Analyzer.this.log.warning(jCNewClass.def, CompilerProperties.Warnings.PotentialLambdaFound);
            }
        }
    }

    class RedundantTypeArgAnalyzer
    extends StatementAnalyzer<JCTree.JCMethodInvocation, JCTree.JCMethodInvocation> {
        RedundantTypeArgAnalyzer() {
            super(AnalyzerMode.METHOD, JCTree.Tag.APPLY);
        }

        @Override
        boolean match(JCTree.JCMethodInvocation jCMethodInvocation) {
            return jCMethodInvocation.typeargs != null && jCMethodInvocation.typeargs.nonEmpty();
        }

        @Override
        List<JCTree.JCMethodInvocation> rewrite(JCTree.JCMethodInvocation jCMethodInvocation) {
            JCTree.JCMethodInvocation jCMethodInvocation2 = Analyzer.this.copier.copy(jCMethodInvocation);
            jCMethodInvocation2.typeargs = List.nil();
            return List.of(jCMethodInvocation2);
        }

        @Override
        void process(JCTree.JCMethodInvocation jCMethodInvocation, JCTree.JCMethodInvocation jCMethodInvocation2, boolean bl) {
            if (!bl) {
                Analyzer.this.log.warning(jCMethodInvocation, CompilerProperties.Warnings.MethodRedundantTypeargs);
            }
        }
    }

    class RedundantLocalVarTypeAnalyzer
    extends RedundantLocalVarTypeAnalyzerBase<JCTree.JCVariableDecl> {
        RedundantLocalVarTypeAnalyzer() {
            super(JCTree.Tag.VARDEF);
        }

        @Override
        boolean match(JCTree.JCVariableDecl jCVariableDecl) {
            return jCVariableDecl.sym.owner.kind == Kinds.Kind.MTH && jCVariableDecl.init != null && !this.isImplicitlyTyped(jCVariableDecl) && Analyzer.this.attr.canInferLocalVarType(jCVariableDecl) == null;
        }

        @Override
        List<JCTree.JCVariableDecl> rewrite(JCTree.JCVariableDecl jCVariableDecl) {
            return List.of(this.rewriteVarType(jCVariableDecl));
        }

        @Override
        void process(JCTree.JCVariableDecl jCVariableDecl, JCTree.JCVariableDecl jCVariableDecl2, boolean bl) {
            this.processVar(jCVariableDecl, jCVariableDecl2, bl);
        }
    }

    class RedundantLocalVarTypeAnalyzerForEach
    extends RedundantLocalVarTypeAnalyzerBase<JCTree.JCEnhancedForLoop> {
        RedundantLocalVarTypeAnalyzerForEach() {
            super(JCTree.Tag.FOREACHLOOP);
        }

        @Override
        boolean match(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
            return !this.isImplicitlyTyped(jCEnhancedForLoop.var);
        }

        @Override
        List<JCTree.JCEnhancedForLoop> rewrite(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
            JCTree.JCEnhancedForLoop jCEnhancedForLoop2 = Analyzer.this.copier.copy(jCEnhancedForLoop);
            jCEnhancedForLoop2.var = this.rewriteVarType(jCEnhancedForLoop.var);
            jCEnhancedForLoop2.body = Analyzer.this.make.at(jCEnhancedForLoop.body).Block(0L, List.nil());
            return List.of(jCEnhancedForLoop2);
        }

        @Override
        void process(JCTree.JCEnhancedForLoop jCEnhancedForLoop, JCTree.JCEnhancedForLoop jCEnhancedForLoop2, boolean bl) {
            this.processVar(jCEnhancedForLoop.var, jCEnhancedForLoop2.var, bl);
        }
    }

    static interface DeferredAnalysisHelper {
        public void queue(RewritingContext var1);

        public void flush(Env<AttrContext> var1);
    }

    class AnalyzerCopier
    extends TreeCopier<Void> {
        public AnalyzerCopier() {
            super(Analyzer.this.make);
        }

        @Override
        public JCTree visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree, Void void_) {
            JCTree.JCLambda jCLambda = (JCTree.JCLambda)lambdaExpressionTree;
            JCTree.JCLambda jCLambda2 = (JCTree.JCLambda)super.visitLambdaExpression(lambdaExpressionTree, void_);
            if (jCLambda.paramKind == JCTree.JCLambda.ParameterKind.IMPLICIT) {
                jCLambda2.paramKind = JCTree.JCLambda.ParameterKind.IMPLICIT;
                jCLambda2.params.forEach(jCVariableDecl -> {
                    jCVariableDecl.vartype = null;
                });
            }
            return jCLambda2;
        }

        @Override
        public JCTree visitNewClass(NewClassTree newClassTree, Void void_) {
            JCTree.JCNewClass jCNewClass = (JCTree.JCNewClass)newClassTree;
            JCTree.JCNewClass jCNewClass2 = (JCTree.JCNewClass)super.visitNewClass(newClassTree, void_);
            if (!jCNewClass.args.isEmpty() && ((JCTree.JCExpression)jCNewClass.args.head).hasTag(JCTree.Tag.NULLCHK)) {
                jCNewClass2.encl = ((JCTree.JCUnary)jCNewClass2.args.head).arg;
                jCNewClass2.args = jCNewClass2.args.tail;
            }
            return jCNewClass2;
        }
    }

    static enum AnalyzerMode {
        DIAMOND("diamond", Source.Feature.DIAMOND),
        LAMBDA("lambda", Source.Feature.LAMBDA),
        METHOD("method", Source.Feature.GRAPH_INFERENCE),
        LOCAL("local", Source.Feature.LOCAL_VARIABLE_TYPE_INFERENCE);

        final String opt;
        final Source.Feature feature;

        private AnalyzerMode(String string2, Source.Feature feature) {
            this.opt = string2;
            this.feature = feature;
        }

        static EnumSet<AnalyzerMode> getAnalyzerModes(String string, Source source, Target target) {
            if (string == null) {
                return EnumSet.noneOf(AnalyzerMode.class);
            }
            List<String> list = List.from(string.split(","));
            EnumSet<AnalyzerMode> enumSet = EnumSet.noneOf(AnalyzerMode.class);
            if (list.contains("all")) {
                enumSet = EnumSet.allOf(AnalyzerMode.class);
            }
            for (AnalyzerMode analyzerMode : AnalyzerMode.values()) {
                if (list.contains("-" + analyzerMode.opt) || !analyzerMode.feature.allowedInSource(source, target)) {
                    enumSet.remove((Object)analyzerMode);
                    continue;
                }
                if (!list.contains(analyzerMode.opt)) continue;
                enumSet.add(analyzerMode);
            }
            return enumSet;
        }
    }

    class StatementScanner
    extends TreeScanner {
        ListBuffer<RewritingContext> rewritings = new ListBuffer();
        JCTree originalTree;
        Env<AttrContext> env;

        StatementScanner(JCTree jCTree, Env<AttrContext> env) {
            this.originalTree = jCTree;
            this.env = Analyzer.this.attr.copyEnv(env);
        }

        public void scan() {
            this.scan(this.originalTree);
        }

        @Override
        public void scan(JCTree jCTree) {
            if (jCTree != null) {
                for (StatementAnalyzer<JCTree, JCTree> statementAnalyzer : Analyzer.this.analyzers) {
                    if (!statementAnalyzer.isEnabled() || !jCTree.hasTag(statementAnalyzer.tag) || !statementAnalyzer.match(jCTree)) continue;
                    for (JCTree jCTree2 : statementAnalyzer.rewrite(jCTree)) {
                        this.rewritings.add(new RewritingContext(this.originalTree, jCTree, jCTree2, statementAnalyzer, this.env));
                    }
                    break;
                }
            }
            super.scan(jCTree);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
        }

        @Override
        public void visitBlock(JCTree.JCBlock jCBlock) {
        }

        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
        }

        @Override
        public void visitSwitch(JCTree.JCSwitch jCSwitch) {
            this.scan(jCSwitch.getExpression());
        }

        @Override
        public void visitForLoop(JCTree.JCForLoop jCForLoop) {
            this.scan(jCForLoop.getCondition());
            this.scan((List<? extends JCTree>)jCForLoop.getUpdate());
        }

        @Override
        public void visitTry(JCTree.JCTry jCTry) {
            this.scan(jCTry.getBlock());
            this.scan((List<? extends JCTree>)jCTry.getCatches());
            this.scan(jCTry.getFinallyBlock());
        }

        @Override
        public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
            this.scan(jCEnhancedForLoop.getExpression());
        }

        @Override
        public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
            this.scan(jCWhileLoop.getCondition());
        }

        @Override
        public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
            this.scan(jCDoWhileLoop.getCondition());
        }

        @Override
        public void visitIf(JCTree.JCIf jCIf) {
            this.scan(jCIf.getCondition());
        }
    }

    class RewritingContext {
        JCTree originalTree;
        JCTree oldTree;
        JCTree replacement;
        boolean erroneous;
        Env<AttrContext> env;
        StatementAnalyzer<JCTree, JCTree> analyzer;

        RewritingContext(JCTree jCTree, JCTree jCTree2, JCTree jCTree3, StatementAnalyzer<JCTree, JCTree> statementAnalyzer, Env<AttrContext> env) {
            this.originalTree = jCTree;
            this.oldTree = jCTree2;
            this.replacement = jCTree3;
            this.analyzer = statementAnalyzer;
            this.env = Analyzer.this.attr.copyEnv(env);
            if (jCTree.hasTag(JCTree.Tag.VARDEF)) {
                ((AttrContext)this.env.info).scope.remove(((JCTree.JCVariableDecl)jCTree).sym);
            }
        }

        Log.DeferredDiagnosticHandler diagHandler() {
            return new Log.DeferredDiagnosticHandler(Analyzer.this.log, jCDiagnostic -> {
                if (jCDiagnostic.getType() == JCDiagnostic.DiagnosticType.ERROR) {
                    this.erroneous = true;
                }
                return true;
            });
        }
    }

    class TreeRewriter
    extends AnalyzerCopier {
        RewritingContext rewriting;
        JCTree wrappedTree;

        TreeRewriter(RewritingContext rewritingContext, JCTree jCTree) {
            this.rewriting = rewritingContext;
            this.wrappedTree = jCTree;
        }

        @Override
        public <Z extends JCTree> Z copy(Z z, Void void_) {
            Object object = super.copy(z, null);
            if (z != null && z == this.rewriting.oldTree) {
                Assert.checkNonNull(this.rewriting.replacement);
                object = this.rewriting.replacement;
            }
            return object;
        }

        @Override
        public JCTree visitVariable(VariableTree variableTree, Void void_) {
            Object object = super.visitVariable(variableTree, void_);
            if (variableTree == this.wrappedTree) {
                ((JCTree.JCVariableDecl)object).mods.flags &= 0x10L;
            }
            return object;
        }
    }

    abstract class RedundantLocalVarTypeAnalyzerBase<X extends JCTree.JCStatement>
    extends StatementAnalyzer<X, X> {
        RedundantLocalVarTypeAnalyzerBase(JCTree.Tag tag) {
            super(AnalyzerMode.LOCAL, tag);
        }

        boolean isImplicitlyTyped(JCTree.JCVariableDecl jCVariableDecl) {
            return jCVariableDecl.vartype.pos == -1;
        }

        JCTree.JCVariableDecl rewriteVarType(JCTree.JCVariableDecl jCVariableDecl) {
            JCTree.JCVariableDecl jCVariableDecl2 = Analyzer.this.copier.copy(jCVariableDecl);
            jCVariableDecl2.vartype = null;
            return jCVariableDecl2;
        }

        void processVar(JCTree.JCVariableDecl jCVariableDecl, JCTree.JCVariableDecl jCVariableDecl2, boolean bl) {
            if (!bl && Analyzer.this.types.isSameType(jCVariableDecl.type, jCVariableDecl2.type)) {
                Analyzer.this.log.warning(jCVariableDecl, CompilerProperties.Warnings.LocalRedundantType);
            }
        }
    }
}

