/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.AnnoConstruct;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.DeferredLintHandler;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.TypeMetadata;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.ConstFold;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.comp.TypeEnvs;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.Warner;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.tools.JavaFileObject;

public class Annotate {
    protected static final Context.Key<Annotate> annotateKey = new Context.Key();
    private final Attr attr;
    private final Check chk;
    private final ConstFold cfolder;
    private final DeferredLintHandler deferredLintHandler;
    private final Enter enter;
    private final Lint lint;
    private final Log log;
    private final Names names;
    private final Resolve resolve;
    private final TreeMaker make;
    private final Symtab syms;
    private final TypeEnvs typeEnvs;
    private final Types types;
    private final Attribute theUnfinishedDefaultValue;
    private final boolean allowRepeatedAnnos;
    private final String sourceName;
    private int blockCount = 0;
    private ListBuffer<Runnable> q = new ListBuffer();
    private ListBuffer<Runnable> validateQ = new ListBuffer();
    private int flushCount = 0;
    ListBuffer<Runnable> typesQ = new ListBuffer();
    ListBuffer<Runnable> afterTypesQ = new ListBuffer();
    private AnnotationTypeCompleter theSourceCompleter = new AnnotationTypeCompleter(){

        @Override
        public void complete(Symbol.ClassSymbol classSymbol) throws Symbol.CompletionFailure {
            Env<AttrContext> env = Annotate.this.typeEnvs.get(classSymbol);
            Annotate.this.attributeAnnotationType(env);
        }
    };

    public static Annotate instance(Context context) {
        Annotate annotate = context.get(annotateKey);
        if (annotate == null) {
            annotate = new Annotate(context);
        }
        return annotate;
    }

    protected Annotate(Context context) {
        context.put(annotateKey, this);
        this.attr = Attr.instance(context);
        this.chk = Check.instance(context);
        this.cfolder = ConstFold.instance(context);
        this.deferredLintHandler = DeferredLintHandler.instance(context);
        this.enter = Enter.instance(context);
        this.log = Log.instance(context);
        this.lint = Lint.instance(context);
        this.make = TreeMaker.instance(context);
        this.names = Names.instance(context);
        this.resolve = Resolve.instance(context);
        this.syms = Symtab.instance(context);
        this.typeEnvs = TypeEnvs.instance(context);
        this.types = Types.instance(context);
        this.theUnfinishedDefaultValue = new Attribute.Error(this.syms.errType);
        Source source = Source.instance(context);
        Target target = Target.instance(context);
        this.allowRepeatedAnnos = Source.Feature.REPEATED_ANNOTATIONS.allowedInSource(source, target);
        this.sourceName = source.name;
        this.blockCount = 1;
    }

    public void blockAnnotations() {
        ++this.blockCount;
    }

    public void unblockAnnotations() {
        --this.blockCount;
        if (this.blockCount == 0) {
            this.flush();
        }
    }

    public void unblockAnnotationsNoFlush() {
        --this.blockCount;
    }

    public boolean annotationsBlocked() {
        return this.blockCount > 0;
    }

    public void enterDone() {
        this.unblockAnnotations();
    }

    public List<Attribute.TypeCompound> fromAnnotations(List<JCTree.JCAnnotation> list) {
        if (list.isEmpty()) {
            return List.nil();
        }
        ListBuffer<Attribute.TypeCompound> listBuffer = new ListBuffer<Attribute.TypeCompound>();
        for (JCTree.JCAnnotation jCAnnotation : list) {
            Assert.checkNonNull(jCAnnotation.attribute);
            listBuffer.append((Attribute.TypeCompound)jCAnnotation.attribute);
        }
        return listBuffer.toList();
    }

    public void normal(Runnable runnable) {
        this.q.append(runnable);
    }

    public void validate(Runnable runnable) {
        this.validateQ.append(runnable);
    }

    public void flush() {
        if (this.annotationsBlocked()) {
            return;
        }
        if (this.isFlushing()) {
            return;
        }
        this.startFlushing();
        try {
            while (this.q.nonEmpty()) {
                this.q.next().run();
            }
            while (this.typesQ.nonEmpty()) {
                this.typesQ.next().run();
            }
            while (this.afterTypesQ.nonEmpty()) {
                this.afterTypesQ.next().run();
            }
            while (this.validateQ.nonEmpty()) {
                this.validateQ.next().run();
            }
        }
        finally {
            this.doneFlushing();
        }
    }

    private boolean isFlushing() {
        return this.flushCount > 0;
    }

    private void startFlushing() {
        ++this.flushCount;
    }

    private void doneFlushing() {
        --this.flushCount;
    }

    public void typeAnnotation(Runnable runnable) {
        this.typesQ.append(runnable);
    }

    public void afterTypes(Runnable runnable) {
        this.afterTypesQ.append(runnable);
    }

    public void annotateLater(List<JCTree.JCAnnotation> list, Env<AttrContext> env, Symbol symbol, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        if (list.isEmpty()) {
            return;
        }
        symbol.resetAnnotations();
        this.normal(() -> {
            Assert.check(symbol.kind == Kinds.Kind.PCK || symbol.annotationsPendingCompletion());
            JavaFileObject javaFileObject = this.log.useSource(env.toplevel.sourcefile);
            JCDiagnostic.DiagnosticPosition diagnosticPosition2 = diagnosticPosition != null ? this.deferredLintHandler.setPos(diagnosticPosition) : this.deferredLintHandler.immediate();
            Lint lint = diagnosticPosition != null ? null : this.chk.setLint(this.lint);
            try {
                if (symbol.hasAnnotations() && list.nonEmpty()) {
                    this.log.error(((JCTree.JCAnnotation)list.head).pos, CompilerProperties.Errors.AlreadyAnnotated(Kinds.kindName(symbol), symbol));
                }
                Assert.checkNonNull(symbol, "Symbol argument to actualEnterAnnotations is null");
                this.annotateNow(symbol, list, env, false, false);
            }
            finally {
                if (lint != null) {
                    this.chk.setLint(lint);
                }
                this.deferredLintHandler.setPos(diagnosticPosition2);
                this.log.useSource(javaFileObject);
            }
        });
        this.validate(() -> {
            JavaFileObject javaFileObject = this.log.useSource(env.toplevel.sourcefile);
            try {
                this.chk.validateAnnotations(list, TreeInfo.declarationFor(symbol, env.tree), symbol);
            }
            finally {
                this.log.useSource(javaFileObject);
            }
        });
    }

    public void annotateDefaultValueLater(JCTree.JCExpression jCExpression, Env<AttrContext> env, Symbol.MethodSymbol methodSymbol, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        this.normal(() -> {
            JavaFileObject javaFileObject = this.log.useSource(env.toplevel.sourcefile);
            JCDiagnostic.DiagnosticPosition diagnosticPosition2 = this.deferredLintHandler.setPos(diagnosticPosition);
            try {
                this.enterDefaultValue(jCExpression, env, methodSymbol);
            }
            finally {
                this.deferredLintHandler.setPos(diagnosticPosition2);
                this.log.useSource(javaFileObject);
            }
        });
        this.validate(() -> {
            JavaFileObject javaFileObject = this.log.useSource(env.toplevel.sourcefile);
            try {
                this.chk.validateAnnotationTree(jCExpression);
            }
            finally {
                this.log.useSource(javaFileObject);
            }
        });
    }

    private void enterDefaultValue(JCTree.JCExpression jCExpression, Env<AttrContext> env, Symbol.MethodSymbol methodSymbol) {
        methodSymbol.defaultValue = this.attributeAnnotationValue(methodSymbol.type.getReturnType(), jCExpression, env);
    }

    private <T extends Attribute.Compound> void annotateNow(Symbol symbol, List<JCTree.JCAnnotation> list, Env<AttrContext> env, boolean bl, boolean bl2) {
        ListBuffer<Object> listBuffer;
        List<JCTree.JCAnnotation> list2;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        HashMap<Object, JCDiagnostic.DiagnosticPosition> hashMap = new HashMap<Object, JCDiagnostic.DiagnosticPosition>();
        List<JCTree.JCAnnotation> list3 = list;
        while (!list3.isEmpty()) {
            Object object;
            list2 = (JCTree.JCAnnotation)list3.head;
            if (bl) {
                listBuffer = this.attributeTypeAnnotation((JCTree.JCAnnotation)((Object)list2), this.syms.annotationType, env);
                object = listBuffer;
            } else {
                listBuffer = this.attributeAnnotation((JCTree.JCAnnotation)((Object)list2), this.syms.annotationType, env);
                object = listBuffer;
            }
            Assert.checkNonNull(object, "Failed to create annotation");
            if (((JCTree.JCAnnotation)((Object)list2)).type.isErroneous() || ((JCTree.JCAnnotation)((Object)list2)).type.tsym.isAnnotationType()) {
                if (linkedHashMap.containsKey(((JCTree.JCAnnotation)((Object)list2)).type.tsym)) {
                    if (!this.allowRepeatedAnnos) {
                        this.log.error(JCDiagnostic.DiagnosticFlag.SOURCE_LEVEL, ((JCTree)((Object)list2)).pos(), Source.Feature.REPEATED_ANNOTATIONS.error(this.sourceName));
                    }
                    listBuffer = (ListBuffer)linkedHashMap.get(((JCTree.JCAnnotation)((Object)list2)).type.tsym);
                    listBuffer = listBuffer.append(object);
                    linkedHashMap.put(((JCTree.JCAnnotation)((Object)list2)).type.tsym, listBuffer);
                    hashMap.put(object, ((JCTree)((Object)list2)).pos());
                } else {
                    linkedHashMap.put(((JCTree.JCAnnotation)((Object)list2)).type.tsym, ListBuffer.of(object));
                    hashMap.put(object, ((JCTree)((Object)list2)).pos());
                }
            }
            if (!((Attribute.Compound)object).type.isErroneous() && (symbol.kind == Kinds.Kind.MDL || symbol.owner.kind != Kinds.Kind.MTH) && this.types.isSameType(((Attribute.Compound)object).type, this.syms.deprecatedType)) {
                symbol.flags_field |= 0x40000000020000L;
                if (this.isAttributeTrue(((Attribute.Compound)object).member(this.names.forRemoval))) {
                    symbol.flags_field |= 0x80000000000000L;
                }
            }
            if (!((Attribute.Compound)object).type.isErroneous() && this.types.isSameType(((Attribute.Compound)object).type, this.syms.previewFeatureType)) {
                symbol.flags_field |= 0x100000000000000L;
                if (this.isAttributeTrue(((Attribute.Compound)object).member(this.names.reflective))) {
                    symbol.flags_field |= 0x400000000000000L;
                }
            }
            if (!((Attribute.Compound)object).type.isErroneous() && symbol.kind == Kinds.Kind.TYP && this.types.isSameType(((Attribute.Compound)object).type, this.syms.valueBasedType)) {
                symbol.flags_field |= 0x20000000000000L;
            }
            list3 = list3.tail;
        }
        list3 = List.nil();
        for (Object object : linkedHashMap.values()) {
            if (((ListBuffer)object).size() == 1) {
                list3 = list3.prepend((JCTree.JCAnnotation)((Object)((Attribute.Compound)((ListBuffer)object).first())));
                continue;
            }
            listBuffer = new AnnotationContext(env, linkedHashMap, hashMap, bl);
            Object a = this.makeContainerAnnotation(((ListBuffer)object).toList(), (AnnotationContext<T>)((Object)listBuffer), symbol, bl2);
            if (a == null) continue;
            list3 = list3.prepend((JCTree.JCAnnotation)a);
        }
        if (bl) {
            list2 = list3.reverse();
            symbol.appendUniqueTypeAttributes(list2);
        } else {
            list2 = list3.reverse();
            symbol.resetAnnotations();
            symbol.setDeclarationAttributes(list2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAttributeTrue(Attribute attribute) {
        if (!(attribute instanceof Attribute.Constant)) return false;
        Attribute.Constant constant = (Attribute.Constant)attribute;
        if (constant.type != this.syms.booleanType) return false;
        if ((Integer)constant.value == 0) return false;
        return true;
    }

    public Attribute.Compound attributeAnnotation(JCTree.JCAnnotation jCAnnotation, Type type, Env<AttrContext> env) {
        Attribute.Compound compound;
        if (jCAnnotation.attribute != null && jCAnnotation.type != null) {
            return jCAnnotation.attribute;
        }
        List<Pair<Symbol.MethodSymbol, Attribute>> list = this.attributeAnnotationValues(jCAnnotation, type, env);
        jCAnnotation.attribute = compound = new Attribute.Compound(jCAnnotation.type, list);
        return jCAnnotation.attribute;
    }

    public Attribute.TypeCompound attributeTypeAnnotation(JCTree.JCAnnotation jCAnnotation, Type type, Env<AttrContext> env) {
        Object object;
        if (jCAnnotation.attribute == null || jCAnnotation.type == null || !((object = jCAnnotation.attribute) instanceof Attribute.TypeCompound)) {
            object = this.attributeAnnotationValues(jCAnnotation, type, env);
            Attribute.TypeCompound typeCompound = new Attribute.TypeCompound(jCAnnotation.type, (List<Pair<Symbol.MethodSymbol, Attribute>>)object, TypeAnnotationPosition.unknown);
            jCAnnotation.attribute = typeCompound;
            return typeCompound;
        }
        Attribute.TypeCompound typeCompound = (Attribute.TypeCompound)object;
        return typeCompound;
    }

    private List<Pair<Symbol.MethodSymbol, Attribute>> attributeAnnotationValues(JCTree.JCAnnotation jCAnnotation, Type type, Env<AttrContext> env) {
        Type type2 = jCAnnotation.annotationType.type != null ? jCAnnotation.annotationType.type : this.attr.attribType(jCAnnotation.annotationType, env);
        jCAnnotation.type = this.chk.checkType(jCAnnotation.annotationType.pos(), type2, type);
        boolean bl = jCAnnotation.type.isErroneous();
        if (!jCAnnotation.type.tsym.isAnnotationType() && !bl) {
            this.log.error(jCAnnotation.annotationType.pos(), CompilerProperties.Errors.NotAnnotationType(jCAnnotation.type));
            bl = true;
        }
        List<JCTree.JCExpression> list = jCAnnotation.args;
        boolean bl2 = false;
        if (list.length() == 1 && !((JCTree.JCExpression)list.head).hasTag(JCTree.Tag.ASSIGN)) {
            list.head = this.make.at(((JCTree.JCExpression)list.head).pos).Assign(this.make.Ident(this.names.value), (JCTree.JCExpression)list.head);
            bl2 = true;
        }
        ListBuffer<Pair<Symbol.MethodSymbol, Attribute>> listBuffer = new ListBuffer<Pair<Symbol.MethodSymbol, Attribute>>();
        List<JCTree.JCExpression> list2 = list;
        while (list2.nonEmpty()) {
            Pair<Symbol.MethodSymbol, Attribute> pair = this.attributeAnnotationNameValuePair((JCTree.JCExpression)list2.head, jCAnnotation.type, bl, env, bl2);
            if (pair != null && !((Symbol.MethodSymbol)pair.fst).type.isErroneous()) {
                listBuffer.append(pair);
            }
            list2 = list2.tail;
        }
        return listBuffer.toList();
    }

    private Pair<Symbol.MethodSymbol, Attribute> attributeAnnotationNameValuePair(JCTree.JCExpression jCExpression, Type type, boolean bl, Env<AttrContext> env, boolean bl2) {
        Symbol symbol;
        if (!jCExpression.hasTag(JCTree.Tag.ASSIGN)) {
            this.log.error(jCExpression.pos(), CompilerProperties.Errors.AnnotationValueMustBeNameValue);
            jCExpression.type = this.syms.errType;
            this.attributeAnnotationValue(jCExpression.type, jCExpression, env);
            return null;
        }
        JCTree.JCAssign jCAssign = (JCTree.JCAssign)jCExpression;
        if (!jCAssign.lhs.hasTag(JCTree.Tag.IDENT)) {
            this.log.error(jCExpression.pos(), CompilerProperties.Errors.AnnotationValueMustBeNameValue);
            jCExpression.type = this.syms.errType;
            this.attributeAnnotationValue(jCExpression.type, jCExpression, env);
            return null;
        }
        JCTree.JCIdent jCIdent = (JCTree.JCIdent)jCAssign.lhs;
        jCIdent.sym = symbol = this.resolve.resolveQualifiedMethod(bl2 ? jCAssign.rhs.pos() : jCIdent.pos(), env, type, jCIdent.name, List.nil(), null);
        jCIdent.type = symbol.type;
        if (symbol.owner != type.tsym && !bl) {
            this.log.error(jCIdent.pos(), CompilerProperties.Errors.NoAnnotationMember(jCIdent.name, type));
        }
        Type type2 = symbol.type.getReturnType();
        Attribute attribute = this.attributeAnnotationValue(type2, jCAssign.rhs, env);
        jCExpression.type = type2;
        return symbol.type.isErroneous() ? null : new Pair<Symbol.MethodSymbol, Attribute>((Symbol.MethodSymbol)symbol, attribute);
    }

    private Attribute attributeAnnotationValue(Type type, JCTree.JCExpression jCExpression, Env<AttrContext> env) {
        try {
            type.tsym.complete();
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.log.error(jCExpression.pos(), CompilerProperties.Errors.CantResolve(Kinds.kindName(completionFailure.sym), completionFailure.sym.getQualifiedName(), null, null));
            type = this.syms.errType;
        }
        if (type.hasTag(TypeTag.ARRAY)) {
            return this.getAnnotationArrayValue(type, jCExpression, env);
        }
        if (jCExpression.hasTag(JCTree.Tag.NEWARRAY)) {
            if (!type.isErroneous()) {
                this.log.error(jCExpression.pos(), CompilerProperties.Errors.AnnotationValueNotAllowableType);
            }
            JCTree.JCNewArray jCNewArray = (JCTree.JCNewArray)jCExpression;
            if (jCNewArray.elemtype != null) {
                this.log.error(jCNewArray.elemtype.pos(), CompilerProperties.Errors.NewNotAllowedInAnnotation);
            }
            List<JCTree.JCExpression> list = jCNewArray.elems;
            while (list.nonEmpty()) {
                this.attributeAnnotationValue(this.syms.errType, (JCTree.JCExpression)list.head, env);
                list = list.tail;
            }
            return new Attribute.Error(this.syms.errType);
        }
        if (type.tsym.isAnnotationType()) {
            if (jCExpression.hasTag(JCTree.Tag.ANNOTATION)) {
                return this.attributeAnnotation((JCTree.JCAnnotation)jCExpression, type, env);
            }
            this.log.error(jCExpression.pos(), CompilerProperties.Errors.AnnotationValueMustBeAnnotation);
            type = this.syms.errType;
        }
        if (jCExpression.hasTag(JCTree.Tag.ANNOTATION)) {
            if (!type.isErroneous()) {
                this.log.error(jCExpression.pos(), CompilerProperties.Errors.AnnotationNotValidForType(type));
            }
            this.attributeAnnotation((JCTree.JCAnnotation)jCExpression, this.syms.errType, env);
            return new Attribute.Error(((JCTree.JCAnnotation)jCExpression).annotationType.type);
        }
        MemberEnter.InitTreeVisitor initTreeVisitor = new MemberEnter.InitTreeVisitor(){

            @Override
            public void visitTypeIdent(JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree) {
            }

            @Override
            public void visitTypeArray(JCTree.JCArrayTypeTree jCArrayTypeTree) {
            }
        };
        jCExpression.accept(initTreeVisitor);
        if (!initTreeVisitor.result) {
            this.log.error(jCExpression.pos(), CompilerProperties.Errors.ExpressionNotAllowableAsAnnotationValue);
            return new Attribute.Error(this.syms.errType);
        }
        if (type.isPrimitive() || this.types.isSameType(type, this.syms.stringType) && !type.hasTag(TypeTag.ERROR)) {
            return this.getAnnotationPrimitiveValue(type, jCExpression, env);
        }
        if (type.tsym == this.syms.classType.tsym) {
            return this.getAnnotationClassValue(type, jCExpression, env);
        }
        if (type.hasTag(TypeTag.CLASS) && (type.tsym.flags() & 0x4000L) != 0L) {
            return this.getAnnotationEnumValue(type, jCExpression, env);
        }
        if (!type.isErroneous()) {
            this.log.error(jCExpression.pos(), CompilerProperties.Errors.AnnotationValueNotAllowableType);
        }
        return new Attribute.Error(this.attr.attribExpr(jCExpression, env, type));
    }

    private Attribute getAnnotationEnumValue(Type type, JCTree.JCExpression jCExpression, Env<AttrContext> env) {
        Type type2 = this.attr.attribTree(jCExpression, env, this.annotationValueInfo(type));
        Symbol symbol = TreeInfo.symbol(jCExpression);
        if (symbol == null || TreeInfo.nonstaticSelect(jCExpression) || symbol.kind != Kinds.Kind.VAR || (symbol.flags() & 0x4000L) == 0L) {
            this.log.error(jCExpression.pos(), CompilerProperties.Errors.EnumAnnotationMustBeEnumConstant);
            return new Attribute.Error(type2.getOriginalType());
        }
        Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)symbol;
        return new Attribute.Enum(type, varSymbol);
    }

    private Attribute getAnnotationClassValue(Type type, JCTree.JCExpression jCExpression, Env<AttrContext> env) {
        Type type2 = this.attr.attribTree(jCExpression, env, this.annotationValueInfo(type));
        if (type2.isErroneous()) {
            if (TreeInfo.name(jCExpression) == this.names._class && ((JCTree.JCFieldAccess)jCExpression).selected.type.isErroneous()) {
                Name name = ((JCTree.JCFieldAccess)jCExpression).selected.type.tsym.flatName();
                return new Attribute.UnresolvedClass(type, this.types.createErrorType(name, this.syms.unknownSymbol, this.syms.classType));
            }
            return new Attribute.Error(type2.getOriginalType());
        }
        if (TreeInfo.name(jCExpression) != this.names._class) {
            this.log.error(jCExpression.pos(), CompilerProperties.Errors.AnnotationValueMustBeClassLiteral);
            return new Attribute.Error(this.syms.errType);
        }
        return new Attribute.Class(this.types, ((JCTree.JCFieldAccess)jCExpression).selected.type);
    }

    private Attribute getAnnotationPrimitiveValue(Type type, JCTree.JCExpression jCExpression, Env<AttrContext> env) {
        Type type2 = this.attr.attribTree(jCExpression, env, this.annotationValueInfo(type));
        if (type2.isErroneous()) {
            return new Attribute.Error(type2.getOriginalType());
        }
        if (type2.constValue() == null) {
            this.log.error(jCExpression.pos(), CompilerProperties.Errors.AttributeValueMustBeConstant);
            return new Attribute.Error(type);
        }
        if (jCExpression.type != null && jCExpression.type.tsym != null) {
            this.queueScanTreeAndTypeAnnotate(jCExpression, env, jCExpression.type.tsym, jCExpression.pos());
        }
        type2 = this.cfolder.coerce(type2, type);
        return new Attribute.Constant(type, type2.constValue());
    }

    private Attr.ResultInfo annotationValueInfo(Type type) {
        return this.attr.unknownExprInfo.dup(type, new AnnotationValueContext(this.attr.unknownExprInfo.checkContext));
    }

    private Attribute getAnnotationArrayValue(Type type, JCTree.JCExpression jCExpression, Env<AttrContext> env) {
        if (!jCExpression.hasTag(JCTree.Tag.NEWARRAY)) {
            jCExpression = this.make.at(jCExpression.pos).NewArray(null, List.nil(), List.of(jCExpression));
        }
        JCTree.JCNewArray jCNewArray = (JCTree.JCNewArray)jCExpression;
        if (jCNewArray.elemtype != null) {
            this.log.error(jCNewArray.elemtype.pos(), CompilerProperties.Errors.NewNotAllowedInAnnotation);
        }
        ListBuffer<Attribute> listBuffer = new ListBuffer<Attribute>();
        List<JCTree.JCExpression> list = jCNewArray.elems;
        while (list.nonEmpty()) {
            listBuffer.append(this.attributeAnnotationValue(this.types.elemtype(type), (JCTree.JCExpression)list.head, env));
            list = list.tail;
        }
        jCNewArray.type = type;
        return new Attribute.Array(type, listBuffer.toArray(new Attribute[listBuffer.length()]));
    }

    private <T extends Attribute.Compound> T processRepeatedAnnotations(List<T> list, AnnotationContext<T> annotationContext, Symbol symbol, boolean bl) {
        Object object;
        Object object2;
        Attribute.Compound compound = (Attribute.Compound)list.head;
        List<Attribute> list2 = List.nil();
        Type type = null;
        Type.ArrayType arrayType = null;
        Type type2 = null;
        Symbol.MethodSymbol methodSymbol = null;
        Assert.check(!list.isEmpty() && !list.tail.isEmpty());
        int n = 0;
        List list3 = list;
        while (!list3.isEmpty()) {
            Assert.check(++n > 1 || !list3.tail.isEmpty());
            object2 = (Attribute.Compound)list3.head;
            type = ((Attribute.Compound)object2).type;
            if (arrayType == null) {
                arrayType = this.types.makeArrayType(type);
            }
            boolean bl2 = n > 1;
            object = this.getContainingType((Attribute.Compound)object2, annotationContext.pos.get(object2), bl2);
            if (object != null) {
                Assert.check(type2 == null || object == type2);
                type2 = object;
                methodSymbol = this.validateContainer(type2, type, annotationContext.pos.get(object2));
                if (methodSymbol != null) {
                    list2 = list2.prepend((Attribute)object2);
                }
            }
            list3 = list3.tail;
        }
        if (!list2.isEmpty() && type2 == null) {
            this.log.error(annotationContext.pos.get(list.head), CompilerProperties.Errors.DuplicateAnnotationInvalidRepeated(type));
            return null;
        }
        if (!list2.isEmpty()) {
            boolean bl3;
            list2 = list2.reverse();
            list3 = annotationContext.pos.get(compound);
            object2 = this.make.at((JCDiagnostic.DiagnosticPosition)((Object)list3));
            Pair<Object, Attribute.Array> pair = new Pair<Object, Attribute.Array>(methodSymbol, new Attribute.Array((Type)arrayType, list2));
            if (annotationContext.isTypeCompound) {
                object = new Attribute.TypeCompound(type2, List.of(pair), ((Attribute.TypeCompound)list.head).position);
                JCTree.JCAnnotation jCAnnotation = ((TreeMaker)object2).TypeAnnotation((Attribute)object);
                if (!this.chk.validateAnnotationDeferErrors(jCAnnotation)) {
                    this.log.error(jCAnnotation.pos(), CompilerProperties.Errors.DuplicateAnnotationInvalidRepeated(type));
                }
                if (!this.chk.isTypeAnnotation(jCAnnotation, bl)) {
                    this.log.error((JCDiagnostic.DiagnosticPosition)((Object)list3), bl ? CompilerProperties.Errors.InvalidRepeatableAnnotationNotApplicable(type2, symbol) : CompilerProperties.Errors.InvalidRepeatableAnnotationNotApplicableInContext(type2));
                }
                ((Attribute.Compound)object).setSynthesized(true);
                Object object3 = object;
                return (T)object3;
            }
            object = new Attribute.Compound(type2, List.of(pair));
            JCTree.JCAnnotation jCAnnotation = ((TreeMaker)object2).Annotation((Attribute)object);
            boolean bl4 = bl3 = (symbol.flags_field & 0x2000000000000000L) != 0L || symbol.enclClass() != null && symbol.enclClass().isRecord();
            if (!this.chk.annotationApplicable(jCAnnotation, symbol) && (!bl3 || bl3 && (symbol.flags_field & 0x1000000L) == 0L)) {
                this.log.error(jCAnnotation.pos(), CompilerProperties.Errors.InvalidRepeatableAnnotationNotApplicable(type2, symbol));
            }
            if (!this.chk.validateAnnotationDeferErrors(jCAnnotation)) {
                this.log.error(jCAnnotation.pos(), CompilerProperties.Errors.DuplicateAnnotationInvalidRepeated(type));
            }
            object = this.attributeAnnotation(jCAnnotation, type2, annotationContext.env);
            ((Attribute.Compound)object).setSynthesized(true);
            Object object4 = object;
            return (T)object4;
        }
        return null;
    }

    private Type getContainingType(Attribute.Compound compound, JCDiagnostic.DiagnosticPosition diagnosticPosition, boolean bl) {
        Type type = compound.type;
        Symbol.TypeSymbol typeSymbol = type.tsym;
        Attribute.Compound compound2 = typeSymbol.getAnnotationTypeMetadata().getRepeatable();
        if (compound2 == null) {
            if (bl) {
                this.log.error(diagnosticPosition, CompilerProperties.Errors.DuplicateAnnotationMissingContainer(type));
            }
            return null;
        }
        return this.filterSame(this.extractContainingType(compound2, diagnosticPosition, typeSymbol), type);
    }

    private Type filterSame(Type type, Type type2) {
        if (type == null || type2 == null) {
            return type;
        }
        return this.types.isSameType(type, type2) ? null : type;
    }

    private Type extractContainingType(Attribute.Compound compound, JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol.TypeSymbol typeSymbol) {
        if (compound.values.isEmpty()) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.InvalidRepeatableAnnotation(typeSymbol));
            return null;
        }
        Pair pair = (Pair)compound.values.head;
        Name name = ((Symbol.MethodSymbol)pair.fst).name;
        if (name != this.names.value) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.InvalidRepeatableAnnotation(typeSymbol));
            return null;
        }
        Object b = pair.snd;
        if (!(b instanceof Attribute.Class)) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.InvalidRepeatableAnnotation(typeSymbol));
            return null;
        }
        Attribute.Class clazz = (Attribute.Class)b;
        return clazz.getValue();
    }

    private Symbol.MethodSymbol validateContainer(Type type, Type type2, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        AnnoConstruct annoConstruct2;
        Symbol.MethodSymbol methodSymbol = null;
        boolean bl = false;
        Scope.WriteableScope writeableScope = type.tsym.members();
        int n = 0;
        boolean bl2 = false;
        for (AnnoConstruct annoConstruct2 : writeableScope.getSymbolsByName(this.names.value)) {
            if (++n == 1 && annoConstruct2.kind == Kinds.Kind.MTH) {
                methodSymbol = (Symbol.MethodSymbol)annoConstruct2;
                continue;
            }
            bl2 = true;
        }
        if (bl2) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.InvalidRepeatableAnnotationMultipleValues(type, n));
            return null;
        }
        if (n == 0) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.InvalidRepeatableAnnotationNoValue(type));
            return null;
        }
        if (methodSymbol.kind != Kinds.Kind.MTH) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.InvalidRepeatableAnnotationInvalidValue(type));
            bl = true;
        }
        Type type3 = methodSymbol.type.getReturnType();
        annoConstruct2 = this.types.makeArrayType(type2);
        if (!this.types.isArray(type3) || !this.types.isSameType((Type)annoConstruct2, type3)) {
            this.log.error(diagnosticPosition, CompilerProperties.Errors.InvalidRepeatableAnnotationValueReturn(type, type3, (Type)annoConstruct2));
            bl = true;
        }
        return bl ? null : methodSymbol;
    }

    private <T extends Attribute.Compound> T makeContainerAnnotation(List<T> list, AnnotationContext<T> annotationContext, Symbol symbol, boolean bl) {
        ListBuffer listBuffer;
        T t = this.processRepeatedAnnotations(list, annotationContext, symbol, bl);
        if (t != null && (listBuffer = annotationContext.annotated.get(((Attribute.Compound)t).type.tsym)) != null) {
            this.log.error(annotationContext.pos.get(listBuffer.first()), CompilerProperties.Errors.InvalidRepeatableAnnotationRepeatedAndContainerPresent(((Attribute.Compound)listBuffer.first()).type.tsym));
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enterTypeAnnotations(List<JCTree.JCAnnotation> list, Env<AttrContext> env, Symbol symbol, JCDiagnostic.DiagnosticPosition diagnosticPosition, boolean bl) {
        Assert.checkNonNull(symbol, "Symbol argument to actualEnterTypeAnnotations is nul/");
        JavaFileObject javaFileObject = this.log.useSource(env.toplevel.sourcefile);
        JCDiagnostic.DiagnosticPosition diagnosticPosition2 = null;
        if (diagnosticPosition != null) {
            diagnosticPosition2 = this.deferredLintHandler.setPos(diagnosticPosition);
        }
        try {
            this.annotateNow(symbol, list, env, true, bl);
        }
        finally {
            if (diagnosticPosition2 != null) {
                this.deferredLintHandler.setPos(diagnosticPosition2);
            }
            this.log.useSource(javaFileObject);
        }
    }

    public void queueScanTreeAndTypeAnnotate(JCTree jCTree, Env<AttrContext> env, Symbol symbol, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        Assert.checkNonNull(symbol);
        this.normal(() -> jCTree.accept(new TypeAnnotate(env, symbol, diagnosticPosition)));
    }

    public void annotateTypeSecondStage(JCTree jCTree, List<JCTree.JCAnnotation> list, Type type) {
        this.typeAnnotation(() -> {
            List<Attribute.TypeCompound> list2 = this.fromAnnotations(list);
            Assert.check(list.size() == list2.size());
            type.getMetadataOfKind(TypeMetadata.Entry.Kind.ANNOTATIONS).combine(new TypeMetadata.Annotations(list2));
        });
    }

    public void annotateTypeParameterSecondStage(JCTree jCTree, List<JCTree.JCAnnotation> list) {
        this.typeAnnotation(() -> {
            List<Attribute.TypeCompound> list2 = this.fromAnnotations(list);
            Assert.check(list.size() == list2.size());
        });
    }

    public AnnotationTypeCompleter annotationTypeSourceCompleter() {
        return this.theSourceCompleter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attributeAnnotationType(Env<AttrContext> env) {
        Assert.check(((JCTree.JCClassDecl)env.tree).sym.isAnnotationType(), "Trying to annotation type complete a non-annotation type");
        JavaFileObject javaFileObject = this.log.useSource(env.toplevel.sourcefile);
        try {
            JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)env.tree;
            AnnotationTypeVisitor annotationTypeVisitor = new AnnotationTypeVisitor(this.attr, this.chk, this.syms, this.typeEnvs);
            annotationTypeVisitor.scanAnnotationType(jCClassDecl);
            jCClassDecl.sym.getAnnotationTypeMetadata().setRepeatable(annotationTypeVisitor.repeatable);
            jCClassDecl.sym.getAnnotationTypeMetadata().setTarget(annotationTypeVisitor.target);
        }
        finally {
            this.log.useSource(javaFileObject);
        }
    }

    public Attribute unfinishedDefaultValue() {
        return this.theUnfinishedDefaultValue;
    }

    public void newRound() {
        this.blockCount = 1;
    }

    public Queues setQueues(Queues queues) {
        Queues queues2 = new Queues(this.q, this.validateQ, this.typesQ, this.afterTypesQ);
        this.q = queues.q;
        this.typesQ = queues.typesQ;
        this.afterTypesQ = queues.afterTypesQ;
        this.validateQ = queues.validateQ;
        return queues2;
    }

    public static interface AnnotationTypeCompleter {
        public void complete(Symbol.ClassSymbol var1) throws Symbol.CompletionFailure;
    }

    private class AnnotationContext<T extends Attribute.Compound> {
        public final Env<AttrContext> env;
        public final Map<Symbol.TypeSymbol, ListBuffer<T>> annotated;
        public final Map<T, JCDiagnostic.DiagnosticPosition> pos;
        public final boolean isTypeCompound;

        public AnnotationContext(Env<AttrContext> env, Map<Symbol.TypeSymbol, ListBuffer<T>> map, Map<T, JCDiagnostic.DiagnosticPosition> map2, boolean bl) {
            Assert.checkNonNull(env);
            Assert.checkNonNull(map);
            Assert.checkNonNull(map2);
            this.env = env;
            this.annotated = map;
            this.pos = map2;
            this.isTypeCompound = bl;
        }
    }

    class AnnotationValueContext
    extends Check.NestedCheckContext {
        AnnotationValueContext(Check.CheckContext checkContext) {
            super(checkContext);
        }

        @Override
        public boolean compatible(Type type, Type type2, Warner warner) {
            return type.hasTag(TypeTag.NONE) || super.compatible(type, type2, warner);
        }
    }

    public static class AnnotationTypeMetadata {
        final Symbol.ClassSymbol metaDataFor;
        private Attribute.Compound target;
        private Attribute.Compound repeatable;
        private AnnotationTypeCompleter annotationTypeCompleter;
        private static final AnnotationTypeMetadata NOT_AN_ANNOTATION_TYPE = new AnnotationTypeMetadata(null, null){

            @Override
            public void complete() {
            }

            @Override
            public String toString() {
                return "Not an annotation type";
            }

            @Override
            public Set<Symbol.MethodSymbol> getAnnotationElements() {
                return new LinkedHashSet<Symbol.MethodSymbol>(0);
            }

            @Override
            public Set<Symbol.MethodSymbol> getAnnotationElementsWithDefault() {
                return new LinkedHashSet<Symbol.MethodSymbol>(0);
            }

            @Override
            public boolean isMetadataForAnnotationType() {
                return false;
            }

            @Override
            public Attribute.Compound getTarget() {
                return null;
            }

            @Override
            public Attribute.Compound getRepeatable() {
                return null;
            }
        };

        public AnnotationTypeMetadata(Symbol.ClassSymbol classSymbol, AnnotationTypeCompleter annotationTypeCompleter) {
            this.metaDataFor = classSymbol;
            this.annotationTypeCompleter = annotationTypeCompleter;
        }

        private void init() {
            while (!this.metaDataFor.isCompleted()) {
                this.metaDataFor.complete();
            }
            if (this.annotationTypeCompleter != null) {
                AnnotationTypeCompleter annotationTypeCompleter = this.annotationTypeCompleter;
                this.annotationTypeCompleter = null;
                annotationTypeCompleter.complete(this.metaDataFor);
            }
        }

        public void complete() {
            this.init();
        }

        public Attribute.Compound getRepeatable() {
            this.init();
            return this.repeatable;
        }

        public void setRepeatable(Attribute.Compound compound) {
            Assert.checkNull(this.repeatable);
            this.repeatable = compound;
        }

        public Attribute.Compound getTarget() {
            this.init();
            return this.target;
        }

        public void setTarget(Attribute.Compound compound) {
            Assert.checkNull(this.target);
            this.target = compound;
        }

        public Set<Symbol.MethodSymbol> getAnnotationElements() {
            this.init();
            LinkedHashSet<Symbol.MethodSymbol> linkedHashSet = new LinkedHashSet<Symbol.MethodSymbol>();
            Scope.WriteableScope writeableScope = this.metaDataFor.members();
            Iterable<Symbol> iterable = writeableScope.getSymbols(Scope.LookupKind.NON_RECURSIVE);
            for (Symbol symbol : iterable) {
                if (symbol.kind != Kinds.Kind.MTH || symbol.name == symbol.name.table.names.clinit || (symbol.flags() & 0x1000L) != 0L) continue;
                linkedHashSet.add((Symbol.MethodSymbol)symbol);
            }
            return linkedHashSet;
        }

        public Set<Symbol.MethodSymbol> getAnnotationElementsWithDefault() {
            this.init();
            Set<Symbol.MethodSymbol> set = this.getAnnotationElements();
            LinkedHashSet<Symbol.MethodSymbol> linkedHashSet = new LinkedHashSet<Symbol.MethodSymbol>();
            for (Symbol.MethodSymbol methodSymbol : set) {
                if (methodSymbol.defaultValue == null) continue;
                linkedHashSet.add(methodSymbol);
            }
            return linkedHashSet;
        }

        public String toString() {
            return "Annotation type for: " + this.metaDataFor;
        }

        public boolean isMetadataForAnnotationType() {
            return true;
        }

        public static AnnotationTypeMetadata notAnAnnotationType() {
            return NOT_AN_ANNOTATION_TYPE;
        }
    }

    public class AnnotationTypeVisitor
    extends TreeScanner {
        private Env<AttrContext> env;
        private final Attr attr;
        private final Check check;
        private final Symtab tab;
        private final TypeEnvs typeEnvs;
        private Attribute.Compound target;
        private Attribute.Compound repeatable;

        public AnnotationTypeVisitor(Attr attr, Check check, Symtab symtab, TypeEnvs typeEnvs) {
            this.attr = attr;
            this.check = check;
            this.tab = symtab;
            this.typeEnvs = typeEnvs;
        }

        public Attribute.Compound getRepeatable() {
            return this.repeatable;
        }

        public Attribute.Compound getTarget() {
            return this.target;
        }

        public void scanAnnotationType(JCTree.JCClassDecl jCClassDecl) {
            this.visitClassDef(jCClassDecl);
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            Env<AttrContext> env = this.env;
            this.env = this.typeEnvs.get(jCClassDecl.sym);
            try {
                this.scan(jCClassDecl.mods);
            }
            finally {
                this.env = env;
            }
        }

        @Override
        public void visitAnnotation(JCTree.JCAnnotation jCAnnotation) {
            Type type = jCAnnotation.annotationType.type;
            if (type == null) {
                type = this.attr.attribType(jCAnnotation.annotationType, this.env);
                jCAnnotation.annotationType.type = type = this.check.checkType(jCAnnotation.annotationType.pos(), type, this.tab.annotationType);
            }
            if (type == this.tab.annotationTargetType) {
                this.target = Annotate.this.attributeAnnotation(jCAnnotation, this.tab.annotationTargetType, this.env);
            } else if (type == this.tab.repeatableType) {
                this.repeatable = Annotate.this.attributeAnnotation(jCAnnotation, this.tab.repeatableType, this.env);
            }
        }
    }

    static class Queues {
        private final ListBuffer<Runnable> q;
        private final ListBuffer<Runnable> validateQ;
        private final ListBuffer<Runnable> typesQ;
        private final ListBuffer<Runnable> afterTypesQ;

        public Queues() {
            this(new ListBuffer<Runnable>(), new ListBuffer<Runnable>(), new ListBuffer<Runnable>(), new ListBuffer<Runnable>());
        }

        public Queues(ListBuffer<Runnable> listBuffer, ListBuffer<Runnable> listBuffer2, ListBuffer<Runnable> listBuffer3, ListBuffer<Runnable> listBuffer4) {
            this.q = listBuffer;
            this.validateQ = listBuffer2;
            this.typesQ = listBuffer3;
            this.afterTypesQ = listBuffer4;
        }
    }

    private class TypeAnnotate
    extends TreeScanner {
        private final Env<AttrContext> env;
        private final Symbol sym;
        private JCDiagnostic.DiagnosticPosition deferPos;

        public TypeAnnotate(Env<AttrContext> env, Symbol symbol, JCDiagnostic.DiagnosticPosition diagnosticPosition) {
            this.env = env;
            this.sym = symbol;
            this.deferPos = diagnosticPosition;
        }

        @Override
        public void visitAnnotatedType(JCTree.JCAnnotatedType jCAnnotatedType) {
            Annotate.this.enterTypeAnnotations(jCAnnotatedType.annotations, this.env, this.sym, this.deferPos, false);
            this.scan(jCAnnotatedType.underlyingType);
        }

        @Override
        public void visitTypeParameter(JCTree.JCTypeParameter jCTypeParameter) {
            Annotate.this.enterTypeAnnotations(jCTypeParameter.annotations, this.env, this.sym, this.deferPos, true);
            this.scan(jCTypeParameter.bounds);
        }

        @Override
        public void visitNewArray(JCTree.JCNewArray jCNewArray) {
            Annotate.this.enterTypeAnnotations(jCNewArray.annotations, this.env, this.sym, this.deferPos, false);
            for (List<JCTree.JCAnnotation> list : jCNewArray.dimAnnotations) {
                Annotate.this.enterTypeAnnotations(list, this.env, this.sym, this.deferPos, false);
            }
            this.scan(jCNewArray.elemtype);
            this.scan(jCNewArray.elems);
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
            this.scan(jCMethodDecl.mods);
            this.scan(jCMethodDecl.restype);
            this.scan(jCMethodDecl.typarams);
            this.scan(jCMethodDecl.recvparam);
            this.scan(jCMethodDecl.params);
            this.scan(jCMethodDecl.thrown);
            this.scan(jCMethodDecl.defaultValue);
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            JCDiagnostic.DiagnosticPosition diagnosticPosition = this.deferPos;
            this.deferPos = jCVariableDecl.pos();
            try {
                if (this.sym != null && this.sym.kind == Kinds.Kind.VAR) {
                    this.scan(jCVariableDecl.mods);
                    this.scan(jCVariableDecl.vartype);
                }
                this.scan(jCVariableDecl.init);
            }
            finally {
                this.deferPos = diagnosticPosition;
            }
        }

        @Override
        public void visitBindingPattern(JCTree.JCBindingPattern jCBindingPattern) {
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass jCNewClass) {
            this.scan(jCNewClass.encl);
            this.scan(jCNewClass.typeargs);
            if (jCNewClass.def == null) {
                this.scan(jCNewClass.clazz);
            }
            this.scan(jCNewClass.args);
        }
    }
}

