/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class Operators {
    protected static final Context.Key<Operators> operatorsKey = new Context.Key();
    private final Names names;
    private final Log log;
    private final Symtab syms;
    private final Types types;
    private Map<Name, List<UnaryOperatorHelper>> unaryOperators = new HashMap<Name, List<UnaryOperatorHelper>>(JCTree.Tag.getNumberOfOperators());
    private Map<Name, List<BinaryOperatorHelper>> binaryOperators = new HashMap<Name, List<BinaryOperatorHelper>>(JCTree.Tag.getNumberOfOperators());
    private Name[] opname = new Name[JCTree.Tag.getNumberOfOperators()];
    public final Symbol.OperatorSymbol noOpSymbol;

    public static Operators instance(Context context) {
        Operators operators = context.get(operatorsKey);
        if (operators == null) {
            operators = new Operators(context);
        }
        return operators;
    }

    protected Operators(Context context) {
        context.put(operatorsKey, this);
        this.syms = Symtab.instance(context);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.types = Types.instance(context);
        this.noOpSymbol = new Symbol.OperatorSymbol(this.names.empty, Type.noType, -1, (Symbol)this.syms.noSymbol);
        this.initOperatorNames();
        this.initUnaryOperators();
        this.initBinaryOperators();
    }

    Type unaryPromotion(Type type) {
        Type type2 = this.types.unboxedTypeOrType(type);
        switch (type2.getTag()) {
            case BYTE: 
            case SHORT: 
            case CHAR: {
                return this.syms.intType;
            }
        }
        return type2;
    }

    Type binaryPromotion(Type type, Type type2) {
        Type type3 = this.types.unboxedTypeOrType(type);
        Type type4 = this.types.unboxedTypeOrType(type2);
        if (type3.isNumeric() && type4.isNumeric()) {
            if (type3.hasTag(TypeTag.DOUBLE) || type4.hasTag(TypeTag.DOUBLE)) {
                return this.syms.doubleType;
            }
            if (type3.hasTag(TypeTag.FLOAT) || type4.hasTag(TypeTag.FLOAT)) {
                return this.syms.floatType;
            }
            if (type3.hasTag(TypeTag.LONG) || type4.hasTag(TypeTag.LONG)) {
                return this.syms.longType;
            }
            return this.syms.intType;
        }
        if (this.types.isSameType(type3, type4)) {
            return type3;
        }
        return this.syms.objectType;
    }

    Symbol.OperatorSymbol resolveUnary(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCTree.Tag tag, Type type) {
        return this.resolve(tag, this.unaryOperators, unaryOperatorHelper -> unaryOperatorHelper.test(type), unaryOperatorHelper -> unaryOperatorHelper.resolve(type), () -> this.reportErrorIfNeeded(diagnosticPosition, tag, type));
    }

    Symbol.OperatorSymbol resolveBinary(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCTree.Tag tag, Type type, Type type2) {
        return this.resolve(tag, this.binaryOperators, binaryOperatorHelper -> binaryOperatorHelper.test(type, type2), binaryOperatorHelper -> binaryOperatorHelper.resolve(type, type2), () -> this.reportErrorIfNeeded(diagnosticPosition, tag, type, type2));
    }

    private <O> Symbol.OperatorSymbol resolve(JCTree.Tag tag, Map<Name, List<O>> map, Predicate<O> predicate, Function<O, Symbol.OperatorSymbol> function, Supplier<Symbol.OperatorSymbol> supplier) {
        return map.get(this.operatorName(tag)).stream().filter(predicate).map(function).findFirst().orElseGet(supplier);
    }

    private Symbol.OperatorSymbol makeOperator(Name name, List<OperatorType> list, OperatorType operatorType2, int ... nArray) {
        Type.MethodType methodType = new Type.MethodType(list.stream().map(operatorType -> operatorType.asType(this.syms)).collect(List.collector()), operatorType2.asType(this.syms), List.nil(), this.syms.methodClass);
        return new Symbol.OperatorSymbol(name, methodType, this.mergeOpcodes(nArray), (Symbol)this.syms.noSymbol);
    }

    private int mergeOpcodes(int ... nArray) {
        int n = nArray.length;
        Assert.check(n == 1 || n == 2);
        return n == 1 ? nArray[0] : nArray[0] << 9 | nArray[1];
    }

    private Symbol.OperatorSymbol reportErrorIfNeeded(JCDiagnostic.DiagnosticPosition diagnosticPosition, JCTree.Tag tag, Type ... typeArray) {
        if (Stream.of(typeArray).noneMatch(type -> type.isErroneous() || type.hasTag(TypeTag.NONE))) {
            Name name = this.operatorName(tag);
            JCDiagnostic.Error error = typeArray.length == 1 ? CompilerProperties.Errors.OperatorCantBeApplied(name, typeArray[0]) : CompilerProperties.Errors.OperatorCantBeApplied1(name, typeArray[0], typeArray[1]);
            this.log.error(diagnosticPosition, error);
        }
        return this.noOpSymbol;
    }

    public Name operatorName(JCTree.Tag tag) {
        return this.opname[tag.operatorIndex()];
    }

    private void initUnaryOperators() {
        this.initOperators(this.unaryOperators, new UnaryOperatorHelper[]{new UnaryNumericOperator(JCTree.Tag.POS).addUnaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, 0).addUnaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, 0).addUnaryOperator(OperatorType.LONG, OperatorType.LONG, 0).addUnaryOperator(OperatorType.INT, OperatorType.INT, 0), new UnaryNumericOperator(JCTree.Tag.NEG).addUnaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, 119).addUnaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, 118).addUnaryOperator(OperatorType.LONG, OperatorType.LONG, 117).addUnaryOperator(OperatorType.INT, OperatorType.INT, 116), new UnaryNumericOperator(JCTree.Tag.COMPL, Type::isIntegral).addUnaryOperator(OperatorType.LONG, OperatorType.LONG, 131).addUnaryOperator(OperatorType.INT, OperatorType.INT, 130), new UnaryPrefixPostfixOperator(JCTree.Tag.POSTINC).addUnaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, 99).addUnaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, 98).addUnaryOperator(OperatorType.LONG, OperatorType.LONG, 97).addUnaryOperator(OperatorType.INT, OperatorType.INT, 96).addUnaryOperator(OperatorType.CHAR, OperatorType.CHAR, 96).addUnaryOperator(OperatorType.SHORT, OperatorType.SHORT, 96).addUnaryOperator(OperatorType.BYTE, OperatorType.BYTE, 96), new UnaryPrefixPostfixOperator(JCTree.Tag.POSTDEC).addUnaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, 103).addUnaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, 102).addUnaryOperator(OperatorType.LONG, OperatorType.LONG, 101).addUnaryOperator(OperatorType.INT, OperatorType.INT, 100).addUnaryOperator(OperatorType.CHAR, OperatorType.CHAR, 100).addUnaryOperator(OperatorType.SHORT, OperatorType.SHORT, 100).addUnaryOperator(OperatorType.BYTE, OperatorType.BYTE, 100), new UnaryBooleanOperator(JCTree.Tag.NOT).addUnaryOperator(OperatorType.BOOLEAN, OperatorType.BOOLEAN, 257), new UnaryReferenceOperator(JCTree.Tag.NULLCHK).addUnaryOperator(OperatorType.OBJECT, OperatorType.OBJECT, 276)});
    }

    private void initBinaryOperators() {
        this.initOperators(this.binaryOperators, new BinaryOperatorHelper[]{new BinaryStringOperator(JCTree.Tag.PLUS).addBinaryOperator(OperatorType.STRING, OperatorType.OBJECT, OperatorType.STRING, 256).addBinaryOperator(OperatorType.OBJECT, OperatorType.STRING, OperatorType.STRING, 256).addBinaryOperator(OperatorType.STRING, OperatorType.STRING, OperatorType.STRING, 256).addBinaryOperator(OperatorType.STRING, OperatorType.INT, OperatorType.STRING, 256).addBinaryOperator(OperatorType.STRING, OperatorType.LONG, OperatorType.STRING, 256).addBinaryOperator(OperatorType.STRING, OperatorType.FLOAT, OperatorType.STRING, 256).addBinaryOperator(OperatorType.STRING, OperatorType.DOUBLE, OperatorType.STRING, 256).addBinaryOperator(OperatorType.STRING, OperatorType.BOOLEAN, OperatorType.STRING, 256).addBinaryOperator(OperatorType.STRING, OperatorType.BOT, OperatorType.STRING, 256).addBinaryOperator(OperatorType.INT, OperatorType.STRING, OperatorType.STRING, 256).addBinaryOperator(OperatorType.LONG, OperatorType.STRING, OperatorType.STRING, 256).addBinaryOperator(OperatorType.FLOAT, OperatorType.STRING, OperatorType.STRING, 256).addBinaryOperator(OperatorType.DOUBLE, OperatorType.STRING, OperatorType.STRING, 256).addBinaryOperator(OperatorType.BOOLEAN, OperatorType.STRING, OperatorType.STRING, 256).addBinaryOperator(OperatorType.BOT, OperatorType.STRING, OperatorType.STRING, 256), new BinaryNumericOperator(JCTree.Tag.PLUS).addBinaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, OperatorType.DOUBLE, 99).addBinaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, OperatorType.FLOAT, 98).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.LONG, 97).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.INT, 96), new BinaryNumericOperator(JCTree.Tag.MINUS).addBinaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, OperatorType.DOUBLE, 103).addBinaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, OperatorType.FLOAT, 102).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.LONG, 101).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.INT, 100), new BinaryNumericOperator(JCTree.Tag.MUL).addBinaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, OperatorType.DOUBLE, 107).addBinaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, OperatorType.FLOAT, 106).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.LONG, 105).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.INT, 104), new BinaryNumericOperator(JCTree.Tag.DIV).addBinaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, OperatorType.DOUBLE, 111).addBinaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, OperatorType.FLOAT, 110).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.LONG, 109).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.INT, 108), new BinaryNumericOperator(JCTree.Tag.MOD).addBinaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, OperatorType.DOUBLE, 115).addBinaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, OperatorType.FLOAT, 114).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.LONG, 113).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.INT, 112), new BinaryBooleanOperator(JCTree.Tag.BITAND).addBinaryOperator(OperatorType.BOOLEAN, OperatorType.BOOLEAN, OperatorType.BOOLEAN, 126), new BinaryNumericOperator(JCTree.Tag.BITAND, Type::isIntegral).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.LONG, 127).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.INT, 126), new BinaryBooleanOperator(JCTree.Tag.BITOR).addBinaryOperator(OperatorType.BOOLEAN, OperatorType.BOOLEAN, OperatorType.BOOLEAN, 128), new BinaryNumericOperator(JCTree.Tag.BITOR, Type::isIntegral).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.LONG, 129).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.INT, 128), new BinaryBooleanOperator(JCTree.Tag.BITXOR).addBinaryOperator(OperatorType.BOOLEAN, OperatorType.BOOLEAN, OperatorType.BOOLEAN, 130), new BinaryNumericOperator(JCTree.Tag.BITXOR, Type::isIntegral).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.LONG, 131).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.INT, 130), new BinaryShiftOperator(JCTree.Tag.SL).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.INT, 120).addBinaryOperator(OperatorType.INT, OperatorType.LONG, OperatorType.INT, 270).addBinaryOperator(OperatorType.LONG, OperatorType.INT, OperatorType.LONG, 121).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.LONG, 271), new BinaryShiftOperator(JCTree.Tag.SR).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.INT, 122).addBinaryOperator(OperatorType.INT, OperatorType.LONG, OperatorType.INT, 272).addBinaryOperator(OperatorType.LONG, OperatorType.INT, OperatorType.LONG, 123).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.LONG, 273), new BinaryShiftOperator(JCTree.Tag.USR).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.INT, 124).addBinaryOperator(OperatorType.INT, OperatorType.LONG, OperatorType.INT, 274).addBinaryOperator(OperatorType.LONG, OperatorType.INT, OperatorType.LONG, 125).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.LONG, 275), new BinaryNumericOperator(JCTree.Tag.LT).addBinaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, OperatorType.BOOLEAN, 152, 155).addBinaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, OperatorType.BOOLEAN, 150, 155).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.BOOLEAN, 148, 155).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.BOOLEAN, 161), new BinaryNumericOperator(JCTree.Tag.GT).addBinaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, OperatorType.BOOLEAN, 151, 157).addBinaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, OperatorType.BOOLEAN, 149, 157).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.BOOLEAN, 148, 157).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.BOOLEAN, 163), new BinaryNumericOperator(JCTree.Tag.LE).addBinaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, OperatorType.BOOLEAN, 152, 158).addBinaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, OperatorType.BOOLEAN, 150, 158).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.BOOLEAN, 148, 158).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.BOOLEAN, 164), new BinaryNumericOperator(JCTree.Tag.GE).addBinaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, OperatorType.BOOLEAN, 151, 156).addBinaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, OperatorType.BOOLEAN, 149, 156).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.BOOLEAN, 148, 156).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.BOOLEAN, 162), new BinaryEqualityOperator(JCTree.Tag.EQ).addBinaryOperator(OperatorType.OBJECT, OperatorType.OBJECT, OperatorType.BOOLEAN, 165).addBinaryOperator(OperatorType.BOOLEAN, OperatorType.BOOLEAN, OperatorType.BOOLEAN, 159).addBinaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, OperatorType.BOOLEAN, 151, 153).addBinaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, OperatorType.BOOLEAN, 149, 153).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.BOOLEAN, 148, 153).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.BOOLEAN, 159), new BinaryEqualityOperator(JCTree.Tag.NE).addBinaryOperator(OperatorType.OBJECT, OperatorType.OBJECT, OperatorType.BOOLEAN, 166).addBinaryOperator(OperatorType.BOOLEAN, OperatorType.BOOLEAN, OperatorType.BOOLEAN, 160).addBinaryOperator(OperatorType.DOUBLE, OperatorType.DOUBLE, OperatorType.BOOLEAN, 151, 154).addBinaryOperator(OperatorType.FLOAT, OperatorType.FLOAT, OperatorType.BOOLEAN, 149, 154).addBinaryOperator(OperatorType.LONG, OperatorType.LONG, OperatorType.BOOLEAN, 148, 154).addBinaryOperator(OperatorType.INT, OperatorType.INT, OperatorType.BOOLEAN, 160), new BinaryBooleanOperator(JCTree.Tag.AND).addBinaryOperator(OperatorType.BOOLEAN, OperatorType.BOOLEAN, OperatorType.BOOLEAN, 258), new BinaryBooleanOperator(JCTree.Tag.OR).addBinaryOperator(OperatorType.BOOLEAN, OperatorType.BOOLEAN, OperatorType.BOOLEAN, 259)});
    }

    Symbol.OperatorSymbol lookupBinaryOp(Predicate<Symbol.OperatorSymbol> predicate) {
        return this.binaryOperators.values().stream().flatMap(Collection::stream).map(binaryOperatorHelper -> binaryOperatorHelper.doLookup(predicate)).distinct().filter(operatorSymbol -> operatorSymbol != this.noOpSymbol).findFirst().get();
    }

    @SafeVarargs
    private final <O extends OperatorHelper> void initOperators(Map<Name, List<O>> map, O ... OArray) {
        for (O o : OArray) {
            Name name = ((OperatorHelper)o).name;
            List<O> list = map.getOrDefault(name, List.nil());
            map.put(name, list.prepend(o));
        }
    }

    private void initOperatorNames() {
        this.setOperatorName(JCTree.Tag.POS, "+");
        this.setOperatorName(JCTree.Tag.NEG, "-");
        this.setOperatorName(JCTree.Tag.NOT, "!");
        this.setOperatorName(JCTree.Tag.COMPL, "~");
        this.setOperatorName(JCTree.Tag.PREINC, "++");
        this.setOperatorName(JCTree.Tag.PREDEC, "--");
        this.setOperatorName(JCTree.Tag.POSTINC, "++");
        this.setOperatorName(JCTree.Tag.POSTDEC, "--");
        this.setOperatorName(JCTree.Tag.NULLCHK, "<*nullchk*>");
        this.setOperatorName(JCTree.Tag.OR, "||");
        this.setOperatorName(JCTree.Tag.AND, "&&");
        this.setOperatorName(JCTree.Tag.EQ, "==");
        this.setOperatorName(JCTree.Tag.NE, "!=");
        this.setOperatorName(JCTree.Tag.LT, "<");
        this.setOperatorName(JCTree.Tag.GT, ">");
        this.setOperatorName(JCTree.Tag.LE, "<=");
        this.setOperatorName(JCTree.Tag.GE, ">=");
        this.setOperatorName(JCTree.Tag.BITOR, "|");
        this.setOperatorName(JCTree.Tag.BITXOR, "^");
        this.setOperatorName(JCTree.Tag.BITAND, "&");
        this.setOperatorName(JCTree.Tag.SL, "<<");
        this.setOperatorName(JCTree.Tag.SR, ">>");
        this.setOperatorName(JCTree.Tag.USR, ">>>");
        this.setOperatorName(JCTree.Tag.PLUS, "+");
        this.setOperatorName(JCTree.Tag.MINUS, this.names.hyphen);
        this.setOperatorName(JCTree.Tag.MUL, this.names.asterisk);
        this.setOperatorName(JCTree.Tag.DIV, this.names.slash);
        this.setOperatorName(JCTree.Tag.MOD, "%");
    }

    private void setOperatorName(JCTree.Tag tag, String string) {
        this.setOperatorName(tag, this.names.fromString(string));
    }

    private void setOperatorName(JCTree.Tag tag, Name name) {
        this.opname[tag.operatorIndex()] = name;
    }

    static enum OperatorType {
        BYTE(symtab -> symtab.byteType),
        SHORT(symtab -> symtab.shortType),
        INT(symtab -> symtab.intType),
        LONG(symtab -> symtab.longType),
        FLOAT(symtab -> symtab.floatType),
        DOUBLE(symtab -> symtab.doubleType),
        CHAR(symtab -> symtab.charType),
        BOOLEAN(symtab -> symtab.booleanType),
        OBJECT(symtab -> symtab.objectType),
        STRING(symtab -> symtab.stringType),
        BOT(symtab -> symtab.botType);

        final Function<Symtab, Type> asTypeFunc;

        private OperatorType(Function<Symtab, Type> function) {
            this.asTypeFunc = function;
        }

        Type asType(Symtab symtab) {
            return this.asTypeFunc.apply(symtab);
        }
    }

    abstract class UnaryOperatorHelper
    extends OperatorHelper
    implements Predicate<Type> {
        UnaryOperatorHelper(JCTree.Tag tag) {
            super(tag);
        }

        final Symbol.OperatorSymbol doLookup(Type type) {
            return this.doLookup((Symbol.OperatorSymbol operatorSymbol) -> this.isUnaryOperatorApplicable((Symbol.OperatorSymbol)operatorSymbol, type));
        }

        boolean isUnaryOperatorApplicable(Symbol.OperatorSymbol operatorSymbol, Type type) {
            return Operators.this.types.isSameType((Type)operatorSymbol.type.getParameterTypes().head, type);
        }

        final UnaryOperatorHelper addUnaryOperator(OperatorType operatorType, OperatorType operatorType2, int ... nArray) {
            this.operatorSuppliers = this.operatorSuppliers.prepend(() -> Operators.this.makeOperator(this.name, List.of(operatorType), operatorType2, nArray));
            return this;
        }

        abstract Symbol.OperatorSymbol resolve(Type var1);
    }

    class UnaryNumericOperator
    extends UnaryOperatorHelper {
        Predicate<Type> numericTest;

        UnaryNumericOperator(JCTree.Tag tag) {
            this(tag, Type::isNumeric);
        }

        UnaryNumericOperator(JCTree.Tag tag, Predicate<Type> predicate) {
            super(tag);
            this.numericTest = predicate;
        }

        @Override
        public boolean test(Type type) {
            return this.numericTest.test(Operators.this.unaryPromotion(type));
        }

        @Override
        public Symbol.OperatorSymbol resolve(Type type) {
            return this.doLookup(Operators.this.unaryPromotion(type));
        }
    }

    class UnaryPrefixPostfixOperator
    extends UnaryNumericOperator {
        UnaryPrefixPostfixOperator(JCTree.Tag tag) {
            super(tag);
        }

        @Override
        public Symbol.OperatorSymbol resolve(Type type) {
            return this.doLookup(Operators.this.types.unboxedTypeOrType(type));
        }
    }

    class UnaryBooleanOperator
    extends UnaryOperatorHelper {
        UnaryBooleanOperator(JCTree.Tag tag) {
            super(tag);
        }

        @Override
        public boolean test(Type type) {
            return Operators.this.types.unboxedTypeOrType(type).hasTag(TypeTag.BOOLEAN);
        }

        @Override
        public Symbol.OperatorSymbol resolve(Type type) {
            return this.doLookup(((Operators)Operators.this).syms.booleanType);
        }
    }

    class UnaryReferenceOperator
    extends UnaryOperatorHelper {
        UnaryReferenceOperator(JCTree.Tag tag) {
            super(tag);
        }

        @Override
        public boolean test(Type type) {
            return type.isNullOrReference();
        }

        @Override
        public Symbol.OperatorSymbol resolve(Type type) {
            return this.doLookup(((Operators)Operators.this).syms.objectType);
        }
    }

    abstract class OperatorHelper {
        final Name name;
        Optional<Symbol.OperatorSymbol[]> alternatives = Optional.empty();
        List<Supplier<Symbol.OperatorSymbol>> operatorSuppliers = List.nil();

        OperatorHelper(JCTree.Tag tag) {
            this.name = Operators.this.operatorName(tag);
        }

        final Symbol.OperatorSymbol doLookup(Predicate<Symbol.OperatorSymbol> predicate) {
            return Stream.of(this.alternatives.orElseGet(this::initOperators)).filter(predicate).findFirst().orElse(Operators.this.noOpSymbol);
        }

        private Symbol.OperatorSymbol[] initOperators() {
            Symbol.OperatorSymbol[] operatorSymbolArray = (Symbol.OperatorSymbol[])this.operatorSuppliers.stream().map(Supplier::get).toArray(Symbol.OperatorSymbol[]::new);
            this.alternatives = Optional.of(operatorSymbolArray);
            this.operatorSuppliers = null;
            return operatorSymbolArray;
        }
    }

    abstract class BinaryOperatorHelper
    extends OperatorHelper
    implements BiPredicate<Type, Type> {
        BinaryOperatorHelper(JCTree.Tag tag) {
            super(tag);
        }

        final Symbol.OperatorSymbol doLookup(Type type, Type type2) {
            return this.doLookup(operatorSymbol -> this.isBinaryOperatorApplicable((Symbol.OperatorSymbol)operatorSymbol, type, type2));
        }

        boolean isBinaryOperatorApplicable(Symbol.OperatorSymbol operatorSymbol, Type type, Type type2) {
            List<Type> list = operatorSymbol.type.getParameterTypes();
            return Operators.this.types.isSameType((Type)list.head, type) && Operators.this.types.isSameType((Type)list.tail.head, type2);
        }

        final BinaryOperatorHelper addBinaryOperator(OperatorType operatorType, OperatorType operatorType2, OperatorType operatorType3, int ... nArray) {
            this.operatorSuppliers = this.operatorSuppliers.prepend(() -> Operators.this.makeOperator(this.name, List.of(operatorType, operatorType2), operatorType3, nArray));
            return this;
        }

        abstract Symbol.OperatorSymbol resolve(Type var1, Type var2);
    }

    class BinaryStringOperator
    extends BinaryOperatorHelper {
        BinaryStringOperator(JCTree.Tag tag) {
            super(tag);
        }

        @Override
        public Symbol.OperatorSymbol resolve(Type type, Type type2) {
            return this.doLookup(this.stringPromotion(type), this.stringPromotion(type2));
        }

        @Override
        public boolean test(Type type, Type type2) {
            boolean bl = Operators.this.types.isSameType(type, ((Operators)Operators.this).syms.stringType) || Operators.this.types.isSameType(type2, ((Operators)Operators.this).syms.stringType);
            boolean bl2 = type.hasTag(TypeTag.VOID) || type2.hasTag(TypeTag.VOID);
            return bl && !bl2;
        }

        private Type stringPromotion(Type type) {
            if (type.isPrimitive()) {
                return Operators.this.unaryPromotion(type);
            }
            if (type.hasTag(TypeTag.VOID) || type.hasTag(TypeTag.BOT) || Operators.this.types.isSameType(type, ((Operators)Operators.this).syms.stringType)) {
                return type;
            }
            if (type.hasTag(TypeTag.TYPEVAR)) {
                return this.stringPromotion(type.getUpperBound());
            }
            return ((Operators)Operators.this).syms.objectType;
        }
    }

    class BinaryNumericOperator
    extends BinaryOperatorHelper {
        Predicate<Type> numericTest;

        BinaryNumericOperator(JCTree.Tag tag) {
            this(tag, Type::isNumeric);
        }

        BinaryNumericOperator(JCTree.Tag tag, Predicate<Type> predicate) {
            super(tag);
            this.numericTest = predicate;
        }

        @Override
        public Symbol.OperatorSymbol resolve(Type type, Type type2) {
            Type type3 = Operators.this.binaryPromotion(type, type2);
            return this.doLookup(type3, type3);
        }

        @Override
        public boolean test(Type type, Type type2) {
            return this.numericTest.test(Operators.this.unaryPromotion(type)) && this.numericTest.test(Operators.this.unaryPromotion(type2));
        }
    }

    class BinaryBooleanOperator
    extends BinaryOperatorHelper {
        BinaryBooleanOperator(JCTree.Tag tag) {
            super(tag);
        }

        @Override
        public Symbol.OperatorSymbol resolve(Type type, Type type2) {
            return this.doLookup(((Operators)Operators.this).syms.booleanType, ((Operators)Operators.this).syms.booleanType);
        }

        @Override
        public boolean test(Type type, Type type2) {
            return Operators.this.types.unboxedTypeOrType(type).hasTag(TypeTag.BOOLEAN) && Operators.this.types.unboxedTypeOrType(type2).hasTag(TypeTag.BOOLEAN);
        }
    }

    class BinaryShiftOperator
    extends BinaryOperatorHelper {
        BinaryShiftOperator(JCTree.Tag tag) {
            super(tag);
        }

        @Override
        public Symbol.OperatorSymbol resolve(Type type, Type type2) {
            return this.doLookup(Operators.this.unaryPromotion(type), Operators.this.unaryPromotion(type2));
        }

        @Override
        public boolean test(Type type, Type type2) {
            TypeTag typeTag = Operators.this.unaryPromotion(type).getTag();
            TypeTag typeTag2 = Operators.this.unaryPromotion(type2).getTag();
            return !(typeTag != TypeTag.LONG && typeTag != TypeTag.INT || typeTag2 != TypeTag.LONG && typeTag2 != TypeTag.INT);
        }
    }

    class BinaryEqualityOperator
    extends BinaryOperatorHelper {
        BinaryEqualityOperator(JCTree.Tag tag) {
            super(tag);
        }

        @Override
        public boolean test(Type type, Type type2) {
            return this.getKind(type, type2) != ComparisonKind.INVALID;
        }

        @Override
        public Symbol.OperatorSymbol resolve(Type type, Type type2) {
            ComparisonKind comparisonKind = this.getKind(type, type2);
            Type type3 = comparisonKind == ComparisonKind.NUMERIC_OR_BOOLEAN ? Operators.this.binaryPromotion(type, type2) : ((Operators)Operators.this).syms.objectType;
            return this.doLookup(type3, type3);
        }

        private ComparisonKind getKind(Type type, Type type2) {
            boolean bl = type.isPrimitive();
            boolean bl2 = type2.isPrimitive();
            if (bl && bl2) {
                return ComparisonKind.NUMERIC_OR_BOOLEAN;
            }
            if (bl) {
                return Operators.this.unaryPromotion(type2).isPrimitive() ? ComparisonKind.NUMERIC_OR_BOOLEAN : ComparisonKind.INVALID;
            }
            if (bl2) {
                return Operators.this.unaryPromotion(type).isPrimitive() ? ComparisonKind.NUMERIC_OR_BOOLEAN : ComparisonKind.INVALID;
            }
            return type.isNullOrReference() && type2.isNullOrReference() ? ComparisonKind.REFERENCE : ComparisonKind.INVALID;
        }
    }

    static enum ComparisonKind {
        NUMERIC_OR_BOOLEAN,
        REFERENCE,
        INVALID;

    }
}

