/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.List;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class TreeDiffer
extends TreeScanner {
    private JCTree parameter;
    private boolean result;
    private Map<Symbol, Symbol> equiv = new HashMap<Symbol, Symbol>();

    public TreeDiffer(Collection<? extends Symbol> collection, Collection<? extends Symbol> collection2) {
        this.equiv = TreeDiffer.equiv(collection, collection2);
    }

    private static Map<Symbol, Symbol> equiv(Collection<? extends Symbol> collection, Collection<? extends Symbol> collection2) {
        HashMap<Symbol, Symbol> hashMap = new HashMap<Symbol, Symbol>();
        Iterator<? extends Symbol> iterator = collection2.iterator();
        for (Symbol symbol : collection) {
            if (!iterator.hasNext()) break;
            hashMap.put(symbol, iterator.next());
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean scan(JCTree jCTree, JCTree jCTree2) {
        if (jCTree == null || jCTree2 == null) {
            return jCTree == null && jCTree2 == null;
        }
        jCTree = TreeInfo.skipParens(jCTree);
        jCTree2 = TreeInfo.skipParens(jCTree2);
        if (jCTree.type != null && jCTree.type.constValue() != null && jCTree2.type != null && jCTree2.type.constValue() != null) {
            return Objects.equals(jCTree.type.constValue(), jCTree2.type.constValue());
        }
        if (jCTree.getTag() != jCTree2.getTag()) {
            return false;
        }
        JCTree jCTree3 = this.parameter;
        boolean bl = this.result;
        try {
            this.parameter = jCTree2;
            jCTree.accept(this);
            boolean bl2 = this.result;
            return bl2;
        }
        finally {
            this.parameter = jCTree3;
            this.result = bl;
        }
    }

    private boolean scan(Iterable<? extends JCTree> iterable, Iterable<? extends JCTree> iterable2) {
        if (iterable == null || iterable2 == null) {
            return iterable == null && iterable2 == null;
        }
        Iterator<? extends JCTree> iterator = iterable.iterator();
        Iterator<? extends JCTree> iterator2 = iterable2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            if (this.scan(iterator.next(), iterator2.next())) continue;
            return false;
        }
        return !iterator.hasNext() && !iterator2.hasNext();
    }

    private boolean scanDimAnnotations(List<List<JCTree.JCAnnotation>> list, List<List<JCTree.JCAnnotation>> list2) {
        if (list == null || list2 == null) {
            return list == null && list2 == null;
        }
        Iterator<List<JCTree.JCAnnotation>> iterator = list.iterator();
        Iterator<List<JCTree.JCAnnotation>> iterator2 = list2.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            if (this.scan((Iterable<? extends JCTree>)iterator.next(), (Iterable<? extends JCTree>)iterator2.next())) continue;
            return false;
        }
        return !iterator.hasNext() && !iterator2.hasNext();
    }

    @Override
    public void visitIdent(JCTree.JCIdent jCIdent) {
        JCTree.JCIdent jCIdent2 = (JCTree.JCIdent)this.parameter;
        Symbol symbol = jCIdent.sym;
        Symbol symbol2 = jCIdent2.sym;
        if (symbol != null && symbol2 != null && Objects.equals(this.equiv.get(symbol), symbol2)) {
            this.result = true;
            return;
        }
        this.result = jCIdent.sym == jCIdent2.sym;
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
        JCTree.JCFieldAccess jCFieldAccess2 = (JCTree.JCFieldAccess)this.parameter;
        this.result = this.scan(jCFieldAccess.selected, jCFieldAccess2.selected) && jCFieldAccess.sym == jCFieldAccess2.sym;
    }

    @Override
    public void visitAnnotatedType(JCTree.JCAnnotatedType jCAnnotatedType) {
        JCTree.JCAnnotatedType jCAnnotatedType2 = (JCTree.JCAnnotatedType)this.parameter;
        this.result = this.scan(jCAnnotatedType.annotations, jCAnnotatedType2.annotations) && this.scan(jCAnnotatedType.underlyingType, jCAnnotatedType2.underlyingType);
    }

    @Override
    public void visitAnnotation(JCTree.JCAnnotation jCAnnotation) {
        JCTree.JCAnnotation jCAnnotation2 = (JCTree.JCAnnotation)this.parameter;
        this.result = this.scan(jCAnnotation.annotationType, jCAnnotation2.annotationType) && this.scan(jCAnnotation.args, jCAnnotation2.args);
    }

    @Override
    public void visitApply(JCTree.JCMethodInvocation jCMethodInvocation) {
        JCTree.JCMethodInvocation jCMethodInvocation2 = (JCTree.JCMethodInvocation)this.parameter;
        this.result = this.scan(jCMethodInvocation.typeargs, jCMethodInvocation2.typeargs) && this.scan(jCMethodInvocation.meth, jCMethodInvocation2.meth) && this.scan(jCMethodInvocation.args, jCMethodInvocation2.args) && jCMethodInvocation.polyKind == jCMethodInvocation2.polyKind;
    }

    @Override
    public void visitAssert(JCTree.JCAssert jCAssert) {
        JCTree.JCAssert jCAssert2 = (JCTree.JCAssert)this.parameter;
        this.result = this.scan(jCAssert.cond, jCAssert2.cond) && this.scan(jCAssert.detail, jCAssert2.detail);
    }

    @Override
    public void visitAssign(JCTree.JCAssign jCAssign) {
        JCTree.JCAssign jCAssign2 = (JCTree.JCAssign)this.parameter;
        this.result = this.scan(jCAssign.lhs, jCAssign2.lhs) && this.scan(jCAssign.rhs, jCAssign2.rhs);
    }

    @Override
    public void visitAssignop(JCTree.JCAssignOp jCAssignOp) {
        JCTree.JCAssignOp jCAssignOp2 = (JCTree.JCAssignOp)this.parameter;
        this.result = this.scan(jCAssignOp.lhs, jCAssignOp2.lhs) && this.scan(jCAssignOp.rhs, jCAssignOp2.rhs) && jCAssignOp.operator == jCAssignOp2.operator;
    }

    @Override
    public void visitBinary(JCTree.JCBinary jCBinary) {
        JCTree.JCBinary jCBinary2 = (JCTree.JCBinary)this.parameter;
        this.result = this.scan(jCBinary.lhs, jCBinary2.lhs) && this.scan(jCBinary.rhs, jCBinary2.rhs) && jCBinary.operator == jCBinary2.operator;
    }

    @Override
    public void visitBindingPattern(JCTree.JCBindingPattern jCBindingPattern) {
        JCTree.JCBindingPattern jCBindingPattern2 = (JCTree.JCBindingPattern)this.parameter;
        this.result = this.scan(jCBindingPattern.var, jCBindingPattern2.var);
        if (!this.result) {
            return;
        }
    }

    @Override
    public void visitRecordPattern(JCTree.JCRecordPattern jCRecordPattern) {
        JCTree.JCRecordPattern jCRecordPattern2 = (JCTree.JCRecordPattern)this.parameter;
        this.result = this.scan(jCRecordPattern.deconstructor, jCRecordPattern2.deconstructor) && this.scan(jCRecordPattern.nested, jCRecordPattern2.nested);
    }

    @Override
    public void visitBlock(JCTree.JCBlock jCBlock) {
        JCTree.JCBlock jCBlock2 = (JCTree.JCBlock)this.parameter;
        this.result = jCBlock.flags == jCBlock2.flags && this.scan(jCBlock.stats, jCBlock2.stats);
    }

    @Override
    public void visitBreak(JCTree.JCBreak jCBreak) {
        JCTree.JCBreak jCBreak2 = (JCTree.JCBreak)this.parameter;
        this.result = jCBreak.label == jCBreak2.label;
    }

    @Override
    public void visitYield(JCTree.JCYield jCYield) {
        JCTree.JCYield jCYield2 = (JCTree.JCYield)this.parameter;
        this.result = this.scan(jCYield.value, jCYield2.value);
    }

    @Override
    public void visitCase(JCTree.JCCase jCCase) {
        JCTree.JCCase jCCase2 = (JCTree.JCCase)this.parameter;
        this.result = this.scan(jCCase.labels, jCCase2.labels) && this.scan(jCCase.stats, jCCase2.stats);
    }

    @Override
    public void visitDefaultCaseLabel(JCTree.JCDefaultCaseLabel jCDefaultCaseLabel) {
        this.result = true;
    }

    @Override
    public void visitCatch(JCTree.JCCatch jCCatch) {
        JCTree.JCCatch jCCatch2 = (JCTree.JCCatch)this.parameter;
        this.result = this.scan(jCCatch.param, jCCatch2.param) && this.scan(jCCatch.body, jCCatch2.body);
    }

    @Override
    public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
        JCTree.JCClassDecl jCClassDecl2 = (JCTree.JCClassDecl)this.parameter;
        this.result = this.scan(jCClassDecl.mods, jCClassDecl2.mods) && jCClassDecl.name == jCClassDecl2.name && this.scan(jCClassDecl.typarams, jCClassDecl2.typarams) && this.scan(jCClassDecl.extending, jCClassDecl2.extending) && this.scan(jCClassDecl.implementing, jCClassDecl2.implementing) && this.scan(jCClassDecl.defs, jCClassDecl2.defs);
    }

    @Override
    public void visitConditional(JCTree.JCConditional jCConditional) {
        JCTree.JCConditional jCConditional2 = (JCTree.JCConditional)this.parameter;
        this.result = this.scan(jCConditional.cond, jCConditional2.cond) && this.scan(jCConditional.truepart, jCConditional2.truepart) && this.scan(jCConditional.falsepart, jCConditional2.falsepart);
    }

    @Override
    public void visitContinue(JCTree.JCContinue jCContinue) {
        JCTree.JCContinue jCContinue2 = (JCTree.JCContinue)this.parameter;
        this.result = jCContinue.label == jCContinue2.label;
    }

    @Override
    public void visitDoLoop(JCTree.JCDoWhileLoop jCDoWhileLoop) {
        JCTree.JCDoWhileLoop jCDoWhileLoop2 = (JCTree.JCDoWhileLoop)this.parameter;
        this.result = this.scan(jCDoWhileLoop.body, jCDoWhileLoop2.body) && this.scan(jCDoWhileLoop.cond, jCDoWhileLoop2.cond);
    }

    @Override
    public void visitErroneous(JCTree.JCErroneous jCErroneous) {
        JCTree.JCErroneous jCErroneous2 = (JCTree.JCErroneous)this.parameter;
        this.result = this.scan(jCErroneous.errs, jCErroneous2.errs);
    }

    @Override
    public void visitExec(JCTree.JCExpressionStatement jCExpressionStatement) {
        JCTree.JCExpressionStatement jCExpressionStatement2 = (JCTree.JCExpressionStatement)this.parameter;
        this.result = this.scan(jCExpressionStatement.expr, jCExpressionStatement2.expr);
    }

    @Override
    public void visitExports(JCTree.JCExports jCExports) {
        JCTree.JCExports jCExports2 = (JCTree.JCExports)this.parameter;
        this.result = this.scan(jCExports.qualid, jCExports2.qualid) && this.scan(jCExports.moduleNames, jCExports2.moduleNames);
    }

    @Override
    public void visitForLoop(JCTree.JCForLoop jCForLoop) {
        JCTree.JCForLoop jCForLoop2 = (JCTree.JCForLoop)this.parameter;
        this.result = this.scan(jCForLoop.init, jCForLoop2.init) && this.scan(jCForLoop.cond, jCForLoop2.cond) && this.scan(jCForLoop.step, jCForLoop2.step) && this.scan(jCForLoop.body, jCForLoop2.body);
    }

    @Override
    public void visitForeachLoop(JCTree.JCEnhancedForLoop jCEnhancedForLoop) {
        JCTree.JCEnhancedForLoop jCEnhancedForLoop2 = (JCTree.JCEnhancedForLoop)this.parameter;
        this.result = this.scan(jCEnhancedForLoop.var, jCEnhancedForLoop2.var) && this.scan(jCEnhancedForLoop.expr, jCEnhancedForLoop2.expr) && this.scan(jCEnhancedForLoop.body, jCEnhancedForLoop2.body);
    }

    @Override
    public void visitIf(JCTree.JCIf jCIf) {
        JCTree.JCIf jCIf2 = (JCTree.JCIf)this.parameter;
        this.result = this.scan(jCIf.cond, jCIf2.cond) && this.scan(jCIf.thenpart, jCIf2.thenpart) && this.scan(jCIf.elsepart, jCIf2.elsepart);
    }

    @Override
    public void visitImport(JCTree.JCImport jCImport) {
        JCTree.JCImport jCImport2 = (JCTree.JCImport)this.parameter;
        this.result = jCImport.staticImport == jCImport2.staticImport && this.scan(jCImport.qualid, jCImport2.qualid);
    }

    @Override
    public void visitIndexed(JCTree.JCArrayAccess jCArrayAccess) {
        JCTree.JCArrayAccess jCArrayAccess2 = (JCTree.JCArrayAccess)this.parameter;
        this.result = this.scan(jCArrayAccess.indexed, jCArrayAccess2.indexed) && this.scan(jCArrayAccess.index, jCArrayAccess2.index);
    }

    @Override
    public void visitLabelled(JCTree.JCLabeledStatement jCLabeledStatement) {
        JCTree.JCLabeledStatement jCLabeledStatement2 = (JCTree.JCLabeledStatement)this.parameter;
        this.result = jCLabeledStatement.label == jCLabeledStatement2.label && this.scan(jCLabeledStatement.body, jCLabeledStatement2.body);
    }

    @Override
    public void visitLambda(JCTree.JCLambda jCLambda) {
        JCTree.JCLambda jCLambda2 = (JCTree.JCLambda)this.parameter;
        this.result = this.scan(jCLambda.params, jCLambda2.params) && this.scan(jCLambda.body, jCLambda2.body) && jCLambda.paramKind == jCLambda2.paramKind;
    }

    @Override
    public void visitLetExpr(JCTree.LetExpr letExpr) {
        JCTree.LetExpr letExpr2 = (JCTree.LetExpr)this.parameter;
        this.result = this.scan(letExpr.defs, letExpr2.defs) && this.scan(letExpr.expr, letExpr2.expr);
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral jCLiteral) {
        JCTree.JCLiteral jCLiteral2 = (JCTree.JCLiteral)this.parameter;
        this.result = jCLiteral.typetag == jCLiteral2.typetag && Objects.equals(jCLiteral.value, jCLiteral2.value);
    }

    @Override
    public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
        JCTree.JCMethodDecl jCMethodDecl2 = (JCTree.JCMethodDecl)this.parameter;
        this.result = this.scan(jCMethodDecl.mods, jCMethodDecl2.mods) && jCMethodDecl.name == jCMethodDecl2.name && this.scan(jCMethodDecl.restype, jCMethodDecl2.restype) && this.scan(jCMethodDecl.typarams, jCMethodDecl2.typarams) && this.scan(jCMethodDecl.recvparam, jCMethodDecl2.recvparam) && this.scan(jCMethodDecl.params, jCMethodDecl2.params) && this.scan(jCMethodDecl.thrown, jCMethodDecl2.thrown) && this.scan(jCMethodDecl.body, jCMethodDecl2.body) && this.scan(jCMethodDecl.defaultValue, jCMethodDecl2.defaultValue);
    }

    @Override
    public void visitModifiers(JCTree.JCModifiers jCModifiers) {
        JCTree.JCModifiers jCModifiers2 = (JCTree.JCModifiers)this.parameter;
        this.result = jCModifiers.flags == jCModifiers2.flags && this.scan(jCModifiers.annotations, jCModifiers2.annotations);
    }

    @Override
    public void visitModuleDef(JCTree.JCModuleDecl jCModuleDecl) {
        JCTree.JCModuleDecl jCModuleDecl2 = (JCTree.JCModuleDecl)this.parameter;
        this.result = this.scan(jCModuleDecl.mods, jCModuleDecl2.mods) && this.scan(jCModuleDecl.qualId, jCModuleDecl2.qualId) && this.scan(jCModuleDecl.directives, jCModuleDecl2.directives);
    }

    @Override
    public void visitNewArray(JCTree.JCNewArray jCNewArray) {
        JCTree.JCNewArray jCNewArray2 = (JCTree.JCNewArray)this.parameter;
        this.result = this.scan(jCNewArray.elemtype, jCNewArray2.elemtype) && this.scan(jCNewArray.dims, jCNewArray2.dims) && this.scan(jCNewArray.annotations, jCNewArray2.annotations) && this.scanDimAnnotations(jCNewArray.dimAnnotations, jCNewArray2.dimAnnotations) && this.scan(jCNewArray.elems, jCNewArray2.elems);
    }

    @Override
    public void visitNewClass(JCTree.JCNewClass jCNewClass) {
        JCTree.JCNewClass jCNewClass2 = (JCTree.JCNewClass)this.parameter;
        this.result = this.scan(jCNewClass.encl, jCNewClass2.encl) && this.scan(jCNewClass.typeargs, jCNewClass2.typeargs) && this.scan(jCNewClass.clazz, jCNewClass2.clazz) && this.scan(jCNewClass.args, jCNewClass2.args) && this.scan(jCNewClass.def, jCNewClass2.def) && jCNewClass.constructor == jCNewClass2.constructor;
    }

    @Override
    public void visitOpens(JCTree.JCOpens jCOpens) {
        JCTree.JCOpens jCOpens2 = (JCTree.JCOpens)this.parameter;
        this.result = this.scan(jCOpens.qualid, jCOpens2.qualid) && this.scan(jCOpens.moduleNames, jCOpens2.moduleNames);
    }

    @Override
    public void visitPackageDef(JCTree.JCPackageDecl jCPackageDecl) {
        JCTree.JCPackageDecl jCPackageDecl2 = (JCTree.JCPackageDecl)this.parameter;
        this.result = this.scan(jCPackageDecl.annotations, jCPackageDecl2.annotations) && this.scan(jCPackageDecl.pid, jCPackageDecl2.pid) && jCPackageDecl.packge == jCPackageDecl2.packge;
    }

    @Override
    public void visitProvides(JCTree.JCProvides jCProvides) {
        JCTree.JCProvides jCProvides2 = (JCTree.JCProvides)this.parameter;
        this.result = this.scan(jCProvides.serviceName, jCProvides2.serviceName) && this.scan(jCProvides.implNames, jCProvides2.implNames);
    }

    @Override
    public void visitReference(JCTree.JCMemberReference jCMemberReference) {
        JCTree.JCMemberReference jCMemberReference2 = (JCTree.JCMemberReference)this.parameter;
        this.result = jCMemberReference.mode == jCMemberReference2.mode && jCMemberReference.kind == jCMemberReference2.kind && jCMemberReference.name == jCMemberReference2.name && this.scan(jCMemberReference.expr, jCMemberReference2.expr) && this.scan(jCMemberReference.typeargs, jCMemberReference2.typeargs);
    }

    @Override
    public void visitRequires(JCTree.JCRequires jCRequires) {
        JCTree.JCRequires jCRequires2 = (JCTree.JCRequires)this.parameter;
        this.result = jCRequires.isTransitive == jCRequires2.isTransitive && jCRequires.isStaticPhase == jCRequires2.isStaticPhase && this.scan(jCRequires.moduleName, jCRequires2.moduleName);
    }

    @Override
    public void visitReturn(JCTree.JCReturn jCReturn) {
        JCTree.JCReturn jCReturn2 = (JCTree.JCReturn)this.parameter;
        this.result = this.scan(jCReturn.expr, jCReturn2.expr);
    }

    @Override
    public void visitSwitch(JCTree.JCSwitch jCSwitch) {
        JCTree.JCSwitch jCSwitch2 = (JCTree.JCSwitch)this.parameter;
        this.result = this.scan(jCSwitch.selector, jCSwitch2.selector) && this.scan(jCSwitch.cases, jCSwitch2.cases);
    }

    @Override
    public void visitSwitchExpression(JCTree.JCSwitchExpression jCSwitchExpression) {
        JCTree.JCSwitchExpression jCSwitchExpression2 = (JCTree.JCSwitchExpression)this.parameter;
        this.result = this.scan(jCSwitchExpression.selector, jCSwitchExpression2.selector) && this.scan(jCSwitchExpression.cases, jCSwitchExpression2.cases);
    }

    @Override
    public void visitSynchronized(JCTree.JCSynchronized jCSynchronized) {
        JCTree.JCSynchronized jCSynchronized2 = (JCTree.JCSynchronized)this.parameter;
        this.result = this.scan(jCSynchronized.lock, jCSynchronized2.lock) && this.scan(jCSynchronized.body, jCSynchronized2.body);
    }

    @Override
    public void visitThrow(JCTree.JCThrow jCThrow) {
        JCTree.JCThrow jCThrow2 = (JCTree.JCThrow)this.parameter;
        this.result = this.scan(jCThrow.expr, jCThrow2.expr);
    }

    @Override
    public void visitTopLevel(JCTree.JCCompilationUnit jCCompilationUnit) {
        JCTree.JCCompilationUnit jCCompilationUnit2 = (JCTree.JCCompilationUnit)this.parameter;
        this.result = this.scan(jCCompilationUnit.defs, jCCompilationUnit2.defs) && jCCompilationUnit.modle == jCCompilationUnit2.modle && jCCompilationUnit.packge == jCCompilationUnit2.packge;
    }

    @Override
    public void visitTry(JCTree.JCTry jCTry) {
        JCTree.JCTry jCTry2 = (JCTree.JCTry)this.parameter;
        this.result = this.scan(jCTry.body, jCTry2.body) && this.scan(jCTry.catchers, jCTry2.catchers) && this.scan(jCTry.finalizer, jCTry2.finalizer) && this.scan(jCTry.resources, jCTry2.resources);
    }

    @Override
    public void visitTypeApply(JCTree.JCTypeApply jCTypeApply) {
        JCTree.JCTypeApply jCTypeApply2 = (JCTree.JCTypeApply)this.parameter;
        this.result = this.scan(jCTypeApply.clazz, jCTypeApply2.clazz) && this.scan(jCTypeApply.arguments, jCTypeApply2.arguments);
    }

    @Override
    public void visitTypeArray(JCTree.JCArrayTypeTree jCArrayTypeTree) {
        JCTree.JCArrayTypeTree jCArrayTypeTree2 = (JCTree.JCArrayTypeTree)this.parameter;
        this.result = this.scan(jCArrayTypeTree.elemtype, jCArrayTypeTree2.elemtype);
    }

    @Override
    public void visitTypeBoundKind(JCTree.TypeBoundKind typeBoundKind) {
        JCTree.TypeBoundKind typeBoundKind2 = (JCTree.TypeBoundKind)this.parameter;
        this.result = typeBoundKind.kind == typeBoundKind2.kind;
    }

    @Override
    public void visitTypeCast(JCTree.JCTypeCast jCTypeCast) {
        JCTree.JCTypeCast jCTypeCast2 = (JCTree.JCTypeCast)this.parameter;
        this.result = this.scan(jCTypeCast.clazz, jCTypeCast2.clazz) && this.scan(jCTypeCast.expr, jCTypeCast2.expr);
    }

    @Override
    public void visitTypeIdent(JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree) {
        JCTree.JCPrimitiveTypeTree jCPrimitiveTypeTree2 = (JCTree.JCPrimitiveTypeTree)this.parameter;
        this.result = jCPrimitiveTypeTree.typetag == jCPrimitiveTypeTree2.typetag;
    }

    @Override
    public void visitTypeIntersection(JCTree.JCTypeIntersection jCTypeIntersection) {
        JCTree.JCTypeIntersection jCTypeIntersection2 = (JCTree.JCTypeIntersection)this.parameter;
        this.result = this.scan(jCTypeIntersection.bounds, jCTypeIntersection2.bounds);
    }

    @Override
    public void visitTypeParameter(JCTree.JCTypeParameter jCTypeParameter) {
        JCTree.JCTypeParameter jCTypeParameter2 = (JCTree.JCTypeParameter)this.parameter;
        this.result = jCTypeParameter.name == jCTypeParameter2.name && this.scan(jCTypeParameter.bounds, jCTypeParameter2.bounds) && this.scan(jCTypeParameter.annotations, jCTypeParameter2.annotations);
    }

    @Override
    public void visitTypeTest(JCTree.JCInstanceOf jCInstanceOf) {
        JCTree.JCInstanceOf jCInstanceOf2 = (JCTree.JCInstanceOf)this.parameter;
        this.result = this.scan(jCInstanceOf.expr, jCInstanceOf2.expr) && this.scan(jCInstanceOf.pattern, jCInstanceOf2.pattern);
    }

    @Override
    public void visitTypeUnion(JCTree.JCTypeUnion jCTypeUnion) {
        JCTree.JCTypeUnion jCTypeUnion2 = (JCTree.JCTypeUnion)this.parameter;
        this.result = this.scan(jCTypeUnion.alternatives, jCTypeUnion2.alternatives);
    }

    @Override
    public void visitUnary(JCTree.JCUnary jCUnary) {
        JCTree.JCUnary jCUnary2 = (JCTree.JCUnary)this.parameter;
        this.result = this.scan(jCUnary.arg, jCUnary2.arg) && jCUnary.operator == jCUnary2.operator;
    }

    @Override
    public void visitUses(JCTree.JCUses jCUses) {
        JCTree.JCUses jCUses2 = (JCTree.JCUses)this.parameter;
        this.result = this.scan(jCUses.qualid, jCUses2.qualid);
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
        JCTree.JCVariableDecl jCVariableDecl2 = (JCTree.JCVariableDecl)this.parameter;
        boolean bl = this.result = this.scan(jCVariableDecl.mods, jCVariableDecl2.mods) && jCVariableDecl.name == jCVariableDecl2.name && this.scan(jCVariableDecl.nameexpr, jCVariableDecl2.nameexpr) && this.scan(jCVariableDecl.vartype, jCVariableDecl2.vartype) && this.scan(jCVariableDecl.init, jCVariableDecl2.init);
        if (!this.result) {
            return;
        }
        this.equiv.put(jCVariableDecl.sym, jCVariableDecl2.sym);
    }

    @Override
    public void visitWhileLoop(JCTree.JCWhileLoop jCWhileLoop) {
        JCTree.JCWhileLoop jCWhileLoop2 = (JCTree.JCWhileLoop)this.parameter;
        this.result = this.scan(jCWhileLoop.cond, jCWhileLoop2.cond) && this.scan(jCWhileLoop.body, jCWhileLoop2.body);
    }

    @Override
    public void visitWildcard(JCTree.JCWildcard jCWildcard) {
        JCTree.JCWildcard jCWildcard2 = (JCTree.JCWildcard)this.parameter;
        this.result = this.scan(jCWildcard.kind, jCWildcard2.kind) && this.scan(jCWildcard.inner, jCWildcard2.inner);
    }
}

