/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class TreeHasher
extends TreeScanner {
    private final Map<Symbol, Integer> symbolHashes;
    private int result = 17;

    public TreeHasher(Map<Symbol, Integer> map) {
        this.symbolHashes = Objects.requireNonNull(map);
    }

    public static int hash(JCTree jCTree, Collection<? extends Symbol> collection) {
        if (jCTree == null) {
            return 0;
        }
        HashMap<Symbol, Integer> hashMap = new HashMap<Symbol, Integer>();
        collection.forEach(symbol -> hashMap.put((Symbol)symbol, hashMap.size()));
        TreeHasher treeHasher = new TreeHasher(hashMap);
        jCTree.accept(treeHasher);
        return treeHasher.result;
    }

    private void hash(Object object) {
        this.result = 31 * this.result + Objects.hashCode(object);
    }

    @Override
    public void scan(JCTree jCTree) {
        Object object;
        if (jCTree == null) {
            return;
        }
        jCTree = TreeInfo.skipParens(jCTree);
        if (jCTree.type != null && (object = jCTree.type.constValue()) != null) {
            this.hash(object);
            return;
        }
        this.hash((Object)jCTree.getTag());
        jCTree.accept(this);
    }

    @Override
    public void visitLiteral(JCTree.JCLiteral jCLiteral) {
        this.hash(jCLiteral.value);
        super.visitLiteral(jCLiteral);
    }

    @Override
    public void visitIdent(JCTree.JCIdent jCIdent) {
        Integer n;
        Symbol symbol = jCIdent.sym;
        if (symbol != null && (n = this.symbolHashes.get(symbol)) != null) {
            this.hash(n);
            return;
        }
        this.hash(symbol);
    }

    @Override
    public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
        this.hash(jCFieldAccess.sym);
        super.visitSelect(jCFieldAccess);
    }

    @Override
    public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
        this.symbolHashes.computeIfAbsent(jCVariableDecl.sym, symbol -> this.symbolHashes.size());
        super.visitVarDef(jCVariableDecl);
    }
}

