/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.DeferredLintHandler;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Preview;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotations;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.comp.Todo;
import com.sun.tools.javac.comp.TypeEnvs;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.resources.CompilerProperties;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeCopier;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Abort;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Dependencies;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.BiConsumer;
import javax.tools.JavaFileObject;

public class TypeEnter
implements Symbol.Completer {
    protected static final Context.Key<TypeEnter> typeEnterKey = new Context.Key();
    static final boolean checkClash = true;
    private final Names names;
    private final Enter enter;
    private final MemberEnter memberEnter;
    private final Log log;
    private final Check chk;
    private final Attr attr;
    private final Symtab syms;
    private final TreeMaker make;
    private final Todo todo;
    private final Annotate annotate;
    private final TypeAnnotations typeAnnotations;
    private final Types types;
    private final DeferredLintHandler deferredLintHandler;
    private final Lint lint;
    private final TypeEnvs typeEnvs;
    private final Dependencies dependencies;
    private final JavaCompiler javaCompiler;
    private final Preview preview;
    boolean allowTypeAnnos;
    boolean allowDeprecationOnImport;
    boolean hasRecordRuntime;
    boolean completionEnabled = true;
    private final ImportsPhase completeClass = new ImportsPhase();
    private Phase topLevelPhase;

    public static TypeEnter instance(Context context) {
        TypeEnter typeEnter = context.get(typeEnterKey);
        if (typeEnter == null) {
            typeEnter = new TypeEnter(context);
        }
        return typeEnter;
    }

    protected TypeEnter(Context context) {
        context.put(typeEnterKey, this);
        this.names = Names.instance(context);
        this.enter = Enter.instance(context);
        this.memberEnter = MemberEnter.instance(context);
        this.log = Log.instance(context);
        this.chk = Check.instance(context);
        this.attr = Attr.instance(context);
        this.syms = Symtab.instance(context);
        this.make = TreeMaker.instance(context);
        this.todo = Todo.instance(context);
        this.annotate = Annotate.instance(context);
        this.typeAnnotations = TypeAnnotations.instance(context);
        this.types = Types.instance(context);
        this.deferredLintHandler = DeferredLintHandler.instance(context);
        this.lint = Lint.instance(context);
        this.typeEnvs = TypeEnvs.instance(context);
        this.dependencies = Dependencies.instance(context);
        this.javaCompiler = JavaCompiler.instance(context);
        this.preview = Preview.instance(context);
        Source source = Source.instance(context);
        Target target = Target.instance(context);
        this.allowTypeAnnos = Source.Feature.TYPE_ANNOTATIONS.allowedInSource(source, target);
        this.allowDeprecationOnImport = Source.Feature.DEPRECATION_ON_IMPORT.allowedInSource(source, target);
        this.hasRecordRuntime = target.hasRecordRuntime();
    }

    protected void ensureImportsChecked(List<JCTree.JCCompilationUnit> list) {
        for (JCTree.JCCompilationUnit jCCompilationUnit : list) {
            if (jCCompilationUnit.starImportScope.isFilled()) continue;
            Env<AttrContext> env = this.enter.topLevelEnv(jCCompilationUnit);
            this.finishImports(jCCompilationUnit, () -> this.completeClass.resolveImports(jCCompilationUnit, env));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void complete(Symbol symbol) throws Symbol.CompletionFailure {
        if (!this.completionEnabled) {
            Assert.check((symbol.flags() & 0x1000000L) == 0L);
            symbol.completer = this;
            return;
        }
        try {
            List<Env<AttrContext>> list;
            this.annotate.blockAnnotations();
            symbol.flags_field |= 0x10000000L;
            this.dependencies.push((Symbol.ClassSymbol)symbol, Dependencies.CompletionCause.MEMBER_ENTER);
            try {
                list = this.completeClass.completeEnvs(List.of(this.typeEnvs.get((Symbol.ClassSymbol)symbol)));
            }
            finally {
                this.dependencies.pop();
            }
            if (!list.isEmpty()) {
                HashSet<JCTree.JCCompilationUnit> hashSet = new HashSet<JCTree.JCCompilationUnit>();
                for (Env<AttrContext> env : list) {
                    if (!env.toplevel.defs.contains(env.enclClass) || !hashSet.add(env.toplevel)) continue;
                    this.finishImports(env.toplevel, () -> {});
                }
            }
        }
        finally {
            this.annotate.unblockAnnotations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void finishImports(JCTree.JCCompilationUnit jCCompilationUnit, Runnable runnable) {
        JavaFileObject javaFileObject = this.log.useSource(jCCompilationUnit.sourcefile);
        try {
            runnable.run();
            this.chk.checkImportsUnique(jCCompilationUnit);
            this.chk.checkImportsResolvable(jCCompilationUnit);
            this.chk.checkImportedPackagesObservable(jCCompilationUnit);
            jCCompilationUnit.namedImportScope.finalizeScope();
            jCCompilationUnit.starImportScope.finalizeScope();
        }
        catch (Symbol.CompletionFailure completionFailure) {
            this.chk.completionError(jCCompilationUnit.pos(), completionFailure);
        }
        finally {
            this.log.useSource(javaFileObject);
        }
    }

    private Symbol.MethodSymbol lookupMethod(Symbol.TypeSymbol typeSymbol, Name name, List<Type> list) {
        for (Symbol symbol2 : typeSymbol.members().getSymbolsByName(name, symbol -> symbol.kind == Kinds.Kind.MTH)) {
            if (!this.types.isSameTypes(symbol2.type.getParameterTypes(), list)) continue;
            return (Symbol.MethodSymbol)symbol2;
        }
        return null;
    }

    JCTree defaultConstructor(TreeMaker treeMaker, DefaultConstructorHelper defaultConstructorHelper) {
        JCTree jCTree;
        Type type = defaultConstructorHelper.constructorType();
        Symbol.MethodSymbol methodSymbol = defaultConstructorHelper.constructorSymbol();
        ListBuffer<JCTree.JCExpressionStatement> listBuffer = new ListBuffer<JCTree.JCExpressionStatement>();
        if (defaultConstructorHelper.owner().type != this.syms.objectType) {
            jCTree = !defaultConstructorHelper.enclosingType().hasTag(TypeTag.NONE) ? treeMaker.Select((JCTree.JCExpression)treeMaker.Ident((Symbol)methodSymbol.params.head), this.names._super) : treeMaker.Ident(this.names._super);
            List<JCTree.JCExpression> list = type.getTypeArguments().nonEmpty() ? treeMaker.Types(type.getTypeArguments()) : null;
            JCTree.JCExpressionStatement jCExpressionStatement = treeMaker.Exec(treeMaker.Apply(list, (JCTree.JCExpression)jCTree, defaultConstructorHelper.superArgs().map(treeMaker::Ident)));
            listBuffer.add(jCExpressionStatement);
        }
        jCTree = treeMaker.MethodDef(methodSymbol, treeMaker.Block(0L, listBuffer.toList()));
        return defaultConstructorHelper.finalAdjustment((JCTree.JCMethodDecl)jCTree);
    }

    public void markDeprecated(Symbol symbol, List<JCTree.JCAnnotation> list, Env<AttrContext> env) {
        this.attr.attribAnnotationTypes(list, env);
        this.handleDeprecatedAnnotations(list, symbol);
    }

    private void handleDeprecatedAnnotations(List<JCTree.JCAnnotation> list, Symbol symbol) {
        List<JCTree.JCAnnotation> list2 = list;
        while (!list2.isEmpty()) {
            JCTree.JCAnnotation jCAnnotation = (JCTree.JCAnnotation)list2.head;
            if (jCAnnotation.annotationType.type == this.syms.deprecatedType) {
                symbol.flags_field |= 0x40000000020000L;
                this.setFlagIfAttributeTrue(jCAnnotation, symbol, this.names.forRemoval, 0x80000000000000L);
            } else if (jCAnnotation.annotationType.type == this.syms.previewFeatureType) {
                symbol.flags_field |= 0x100000000000000L;
                this.setFlagIfAttributeTrue(jCAnnotation, symbol, this.names.reflective, 0x400000000000000L);
            }
            list2 = list2.tail;
        }
    }

    private void setFlagIfAttributeTrue(JCTree.JCAnnotation jCAnnotation, Symbol symbol, Name name, long l) {
        jCAnnotation.args.stream().filter(jCExpression -> jCExpression.hasTag(JCTree.Tag.ASSIGN)).map(jCExpression -> (JCTree.JCAssign)jCExpression).filter(jCAssign -> TreeInfo.name(jCAssign.lhs) == name).findFirst().ifPresent(jCAssign -> {
            JCTree.JCExpression jCExpression = TreeInfo.skipParens(jCAssign.rhs);
            if (jCExpression.hasTag(JCTree.Tag.LITERAL) && Boolean.TRUE.equals(((JCTree.JCLiteral)jCExpression).getValue())) {
                symbol.flags_field |= l;
            }
        });
    }

    abstract class Phase {
        private final ListBuffer<Env<AttrContext>> queue = new ListBuffer();
        private final Phase next;
        private final Dependencies.CompletionCause phaseName;

        Phase(Dependencies.CompletionCause completionCause, Phase phase) {
            this.phaseName = completionCause;
            this.next = phase;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final List<Env<AttrContext>> completeEnvs(List<Env<AttrContext>> list) {
            boolean bl = this.queue.isEmpty();
            Phase phase = TypeEnter.this.topLevelPhase;
            boolean bl2 = false;
            try {
                TypeEnter.this.topLevelPhase = this;
                this.doCompleteEnvs(list);
                bl2 = true;
            }
            finally {
                TypeEnter.this.topLevelPhase = phase;
                if (!bl2 && bl) {
                    this.queue.clear();
                }
            }
            if (bl) {
                List<Env<AttrContext>> list2 = this.queue.toList();
                this.queue.clear();
                return this.next != null ? this.next.completeEnvs(list2) : list2;
            }
            return List.nil();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doCompleteEnvs(List<Env<AttrContext>> list) {
            for (Env<AttrContext> env : list) {
                JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)env.tree;
                this.queue.add(env);
                JavaFileObject javaFileObject = TypeEnter.this.log.useSource(env.toplevel.sourcefile);
                JCDiagnostic.DiagnosticPosition diagnosticPosition = TypeEnter.this.deferredLintHandler.setPos(jCClassDecl.pos());
                try {
                    TypeEnter.this.dependencies.push(env.enclClass.sym, this.phaseName);
                    this.runPhase(env);
                }
                catch (Symbol.CompletionFailure completionFailure) {
                    TypeEnter.this.chk.completionError(jCClassDecl.pos(), completionFailure);
                }
                finally {
                    TypeEnter.this.dependencies.pop();
                    TypeEnter.this.deferredLintHandler.setPos(diagnosticPosition);
                    TypeEnter.this.log.useSource(javaFileObject);
                }
            }
        }

        protected abstract void runPhase(Env<AttrContext> var1);
    }

    private final class ImportsPhase
    extends Phase {
        Env<AttrContext> env;
        Scope.ImportFilter staticImportFilter;
        Scope.ImportFilter typeImportFilter;
        BiConsumer<JCTree.JCImport, Symbol.CompletionFailure> cfHandler;

        public ImportsPhase() {
            super(Dependencies.CompletionCause.IMPORTS_PHASE, new HierarchyPhase());
            this.cfHandler = (jCImport, completionFailure) -> TypeEnter.this.chk.completionError(jCImport.pos(), (Symbol.CompletionFailure)completionFailure);
        }

        @Override
        protected void runPhase(Env<AttrContext> env) {
            JCTree.JCClassDecl jCClassDecl = env.enclClass;
            Symbol.ClassSymbol classSymbol = jCClassDecl.sym;
            if (classSymbol.owner.kind == Kinds.Kind.PCK) {
                this.resolveImports(env.toplevel, env.enclosing(JCTree.Tag.TOPLEVEL));
                TypeEnter.this.todo.append(env);
            }
            if (classSymbol.owner.kind == Kinds.Kind.TYP) {
                classSymbol.owner.complete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void resolveImports(JCTree.JCCompilationUnit jCCompilationUnit, Env<AttrContext> env) {
            block10: {
                if (jCCompilationUnit.starImportScope.isFilled()) {
                    return;
                }
                Scope.ImportFilter importFilter = this.staticImportFilter;
                Scope.ImportFilter importFilter2 = this.typeImportFilter;
                JCDiagnostic.DiagnosticPosition diagnosticPosition = TypeEnter.this.deferredLintHandler.immediate();
                Lint lint = TypeEnter.this.chk.setLint(TypeEnter.this.lint);
                Env<AttrContext> env2 = this.env;
                try {
                    this.env = env;
                    Symbol.PackageSymbol packageSymbol = env.toplevel.packge;
                    this.staticImportFilter = (scope, symbol) -> symbol.isStatic() && TypeEnter.this.chk.importAccessible(symbol, packageSymbol) && symbol.isMemberOf((Symbol.TypeSymbol)scope.owner, TypeEnter.this.types);
                    this.typeImportFilter = (scope, symbol) -> symbol.kind == Kinds.Kind.TYP && TypeEnter.this.chk.importAccessible(symbol, packageSymbol);
                    Symbol.PackageSymbol packageSymbol2 = TypeEnter.this.syms.enterPackage(((TypeEnter)TypeEnter.this).syms.java_base, ((TypeEnter)TypeEnter.this).names.java_lang);
                    if (packageSymbol2.members().isEmpty() && !packageSymbol2.exists()) {
                        TypeEnter.this.log.error(CompilerProperties.Errors.NoJavaLang);
                        throw new Abort();
                    }
                    this.importAll(TypeEnter.this.make.at(jCCompilationUnit.pos()).Import(TypeEnter.this.make.QualIdent(packageSymbol2), false), packageSymbol2, env);
                    JCTree.JCModuleDecl jCModuleDecl = jCCompilationUnit.getModuleDecl();
                    if (jCCompilationUnit.getPackage() != null && jCModuleDecl == null) {
                        this.checkClassPackageClash(jCCompilationUnit.getPackage());
                    }
                    for (JCTree.JCImport jCImport : jCCompilationUnit.getImports()) {
                        this.doImport(jCImport);
                    }
                    if (jCModuleDecl == null) break block10;
                    JCDiagnostic.DiagnosticPosition diagnosticPosition2 = TypeEnter.this.deferredLintHandler.setPos(jCModuleDecl.pos());
                    try {
                        TypeEnter.this.markDeprecated(jCModuleDecl.sym, jCModuleDecl.mods.annotations, env);
                    }
                    finally {
                        TypeEnter.this.deferredLintHandler.setPos(diagnosticPosition2);
                    }
                    TypeEnter.this.annotate.annotateLater(jCModuleDecl.mods.annotations, env, env.toplevel.modle, jCModuleDecl.pos());
                }
                finally {
                    this.env = env2;
                    TypeEnter.this.chk.setLint(lint);
                    TypeEnter.this.deferredLintHandler.setPos(diagnosticPosition);
                    this.staticImportFilter = importFilter;
                    this.typeImportFilter = importFilter2;
                }
            }
        }

        private void checkClassPackageClash(JCTree.JCPackageDecl jCPackageDecl) {
            if (jCPackageDecl.pid != null) {
                Symbol symbol = this.env.toplevel.packge;
                while (symbol.owner != ((TypeEnter)TypeEnter.this).syms.rootPackage) {
                    symbol.owner.complete();
                    Symbol.PackageSymbol packageSymbol = TypeEnter.this.syms.lookupPackage(this.env.toplevel.modle, symbol.owner.getQualifiedName());
                    if (TypeEnter.this.syms.getClass(packageSymbol.modle, ((Symbol)symbol).getQualifiedName()) != null) {
                        TypeEnter.this.log.error(jCPackageDecl.pos, CompilerProperties.Errors.PkgClashesWithClassOfSameName(symbol));
                    }
                    symbol = symbol.owner;
                }
            }
            TypeEnter.this.annotate.annotateLater(jCPackageDecl.annotations, this.env, this.env.toplevel.packge, jCPackageDecl.pos());
        }

        private void doImport(JCTree.JCImport jCImport) {
            JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)jCImport.qualid;
            Name name = TreeInfo.name(jCFieldAccess);
            Env<AttrContext> env = this.env.dup(jCImport);
            Symbol.TypeSymbol typeSymbol = ((TypeEnter)TypeEnter.this).attr.attribImportQualifier((JCTree.JCImport)jCImport, env).tsym;
            if (name == ((TypeEnter)TypeEnter.this).names.asterisk) {
                TypeEnter.this.chk.checkCanonical(jCFieldAccess.selected);
                if (jCImport.staticImport) {
                    this.importStaticAll(jCImport, typeSymbol, this.env);
                } else {
                    this.importAll(jCImport, typeSymbol, this.env);
                }
            } else if (jCImport.staticImport) {
                this.importNamedStatic(jCImport, typeSymbol, name, env);
                TypeEnter.this.chk.checkCanonical(jCFieldAccess.selected);
            } else {
                Type type = this.attribImportType(jCFieldAccess, env);
                Type type2 = type.getOriginalType();
                Symbol.TypeSymbol typeSymbol2 = type2.hasTag(TypeTag.CLASS) ? type2.tsym : type.tsym;
                TypeEnter.this.chk.checkCanonical(jCFieldAccess);
                this.importNamed(jCImport.pos(), typeSymbol2, this.env, jCImport);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Type attribImportType(JCTree jCTree, Env<AttrContext> env) {
            Assert.check(TypeEnter.this.completionEnabled);
            Lint lint = TypeEnter.this.chk.setLint(TypeEnter.this.allowDeprecationOnImport ? TypeEnter.this.lint : TypeEnter.this.lint.suppress(Lint.LintCategory.DEPRECATION, Lint.LintCategory.REMOVAL, Lint.LintCategory.PREVIEW));
            try {
                TypeEnter.this.completionEnabled = false;
                Type type = TypeEnter.this.attr.attribType(jCTree, env);
                return type;
            }
            finally {
                TypeEnter.this.completionEnabled = true;
                TypeEnter.this.chk.setLint(lint);
            }
        }

        private void importAll(JCTree.JCImport jCImport, Symbol.TypeSymbol typeSymbol, Env<AttrContext> env) {
            env.toplevel.starImportScope.importAll(TypeEnter.this.types, typeSymbol.members(), this.typeImportFilter, jCImport, this.cfHandler);
        }

        private void importStaticAll(JCTree.JCImport jCImport, Symbol.TypeSymbol typeSymbol, Env<AttrContext> env) {
            Scope.StarImportScope starImportScope = env.toplevel.starImportScope;
            Symbol.TypeSymbol typeSymbol2 = typeSymbol;
            starImportScope.importAll(TypeEnter.this.types, typeSymbol2.members(), this.staticImportFilter, jCImport, this.cfHandler);
        }

        private void importNamedStatic(JCTree.JCImport jCImport, Symbol.TypeSymbol typeSymbol, Name name, Env<AttrContext> env) {
            if (typeSymbol.kind != Kinds.Kind.TYP) {
                TypeEnter.this.log.error(JCDiagnostic.DiagnosticFlag.RECOVERABLE, jCImport.pos(), CompilerProperties.Errors.StaticImpOnlyClassesAndInterfaces);
                return;
            }
            Scope.NamedImportScope namedImportScope = env.toplevel.namedImportScope;
            Scope.WriteableScope writeableScope = typeSymbol.members();
            jCImport.importScope = namedImportScope.importByName(TypeEnter.this.types, writeableScope, name, this.staticImportFilter, jCImport, this.cfHandler);
        }

        private void importNamed(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Env<AttrContext> env, JCTree.JCImport jCImport) {
            if (symbol.kind == Kinds.Kind.TYP) {
                jCImport.importScope = env.toplevel.namedImportScope.importType(symbol.owner.members(), symbol.owner.members(), symbol);
            }
        }
    }

    static interface DefaultConstructorHelper {
        public Type constructorType();

        public Symbol.MethodSymbol constructorSymbol();

        public Type enclosingType();

        public Symbol.TypeSymbol owner();

        public List<Name> superArgs();

        default public JCTree.JCMethodDecl finalAdjustment(JCTree.JCMethodDecl jCMethodDecl) {
            return jCMethodDecl;
        }
    }

    class RecordConstructorHelper
    extends BasicConstructorHelper {
        boolean lastIsVarargs;
        List<JCTree.JCVariableDecl> recordFieldDecls;

        RecordConstructorHelper(Symbol.ClassSymbol classSymbol, List<JCTree.JCVariableDecl> list) {
            super(classSymbol);
            this.recordFieldDecls = list;
            this.lastIsVarargs = classSymbol.getRecordComponents().stream().anyMatch(recordComponent -> recordComponent.isVarargs());
        }

        @Override
        public Type constructorType() {
            if (this.constructorType == null) {
                ListBuffer<Type> listBuffer = new ListBuffer<Type>();
                JCTree.JCVariableDecl jCVariableDecl = this.recordFieldDecls.last();
                for (JCTree.JCVariableDecl jCVariableDecl2 : this.recordFieldDecls) {
                    listBuffer.add(jCVariableDecl2 == jCVariableDecl && this.lastIsVarargs ? TypeEnter.this.types.elemtype(jCVariableDecl2.sym.type) : jCVariableDecl2.sym.type);
                }
                this.constructorType = new Type.MethodType(listBuffer.toList(), ((TypeEnter)TypeEnter.this).syms.voidType, List.nil(), ((TypeEnter)TypeEnter.this).syms.methodClass);
            }
            return this.constructorType;
        }

        @Override
        public Symbol.MethodSymbol constructorSymbol() {
            Symbol.MethodSymbol methodSymbol = super.constructorSymbol();
            methodSymbol.flags_field |= 0x8001000000000L;
            ListBuffer<Symbol.VarSymbol> listBuffer = new ListBuffer<Symbol.VarSymbol>();
            JCTree.JCVariableDecl jCVariableDecl = this.recordFieldDecls.last();
            for (JCTree.JCVariableDecl jCVariableDecl2 : this.recordFieldDecls) {
                listBuffer.add(new Symbol.VarSymbol(0x2000000201000000L | (jCVariableDecl2 == jCVariableDecl && this.lastIsVarargs ? 0x400000000L : 0L), jCVariableDecl2.name, jCVariableDecl2.sym.type, methodSymbol));
            }
            methodSymbol.params = listBuffer.toList();
            methodSymbol.flags_field |= 0x2000000000000000L;
            return methodSymbol;
        }

        @Override
        public JCTree.JCMethodDecl finalAdjustment(JCTree.JCMethodDecl jCMethodDecl) {
            List<JCTree.JCVariableDecl> list = this.recordFieldDecls;
            for (JCTree.JCVariableDecl jCVariableDecl : jCMethodDecl.params) {
                Symbol.RecordComponent recordComponent = ((Symbol.ClassSymbol)this.owner).getRecordComponent(jCVariableDecl.sym);
                TreeCopier treeCopier = new TreeCopier(TypeEnter.this.make.at(jCVariableDecl.pos));
                jCVariableDecl.mods.annotations = recordComponent.getOriginalAnnos().isEmpty() ? List.nil() : treeCopier.copy(recordComponent.getOriginalAnnos());
                jCVariableDecl.vartype = treeCopier.copy(((JCTree.JCVariableDecl)list.head).vartype);
                list = list.tail;
            }
            return jCMethodDecl;
        }
    }

    class AnonClassConstructorHelper
    extends BasicConstructorHelper {
        Symbol.MethodSymbol constr;
        Type encl;
        boolean based;

        AnonClassConstructorHelper(Symbol.TypeSymbol typeSymbol, Symbol.MethodSymbol methodSymbol, JCTree.JCExpression jCExpression) {
            super(typeSymbol);
            this.based = false;
            this.constr = methodSymbol;
            this.encl = jCExpression != null ? jCExpression.type : Type.noType;
        }

        @Override
        public Type constructorType() {
            if (this.constructorType == null) {
                Type type = TypeEnter.this.types.memberType(this.owner.type, this.constr);
                if (!this.enclosingType().hasTag(TypeTag.NONE)) {
                    type = TypeEnter.this.types.createMethodTypeWithParameters(type, type.getParameterTypes().prepend(this.enclosingType()));
                    this.based = true;
                }
                this.constructorType = type;
            }
            return this.constructorType;
        }

        @Override
        public Symbol.MethodSymbol constructorSymbol() {
            Symbol.MethodSymbol methodSymbol = super.constructorSymbol();
            methodSymbol.flags_field |= 0x20000000L | this.constr.flags() & 0x400000000L;
            methodSymbol.flags_field = methodSymbol.flags_field | (this.based ? 0x200000000000000L : 0L);
            ListBuffer<Symbol.VarSymbol> listBuffer = new ListBuffer<Symbol.VarSymbol>();
            List<Type> list = this.constructorType().getParameterTypes();
            if (!this.enclosingType().hasTag(TypeTag.NONE)) {
                list = list.tail;
                listBuffer = listBuffer.prepend(new Symbol.VarSymbol(0x200000000L, TypeEnter.this.make.paramName(0), this.enclosingType(), methodSymbol));
            }
            if (this.constr.params != null) {
                for (Symbol.VarSymbol varSymbol : this.constr.params) {
                    listBuffer.add(new Symbol.VarSymbol(0x200000000L | varSymbol.flags(), varSymbol.name, (Type)list.head, methodSymbol));
                    list = list.tail;
                }
            }
            methodSymbol.params = listBuffer.toList();
            return methodSymbol;
        }

        @Override
        public Type enclosingType() {
            return this.encl;
        }

        @Override
        public List<Name> superArgs() {
            List<JCTree.JCVariableDecl> list = TypeEnter.this.make.Params(this.constructorType().getParameterTypes(), this.constructorSymbol());
            if (!this.enclosingType().hasTag(TypeTag.NONE)) {
                list = list.tail;
            }
            return list.map(jCVariableDecl -> jCVariableDecl.name);
        }
    }

    class BasicConstructorHelper
    implements DefaultConstructorHelper {
        Symbol.TypeSymbol owner;
        Type constructorType;
        Symbol.MethodSymbol constructorSymbol;

        BasicConstructorHelper(Symbol.TypeSymbol typeSymbol) {
            this.owner = typeSymbol;
        }

        @Override
        public Type constructorType() {
            if (this.constructorType == null) {
                this.constructorType = new Type.MethodType(List.nil(), ((TypeEnter)TypeEnter.this).syms.voidType, List.nil(), ((TypeEnter)TypeEnter.this).syms.methodClass);
            }
            return this.constructorType;
        }

        @Override
        public Symbol.MethodSymbol constructorSymbol() {
            if (this.constructorSymbol == null) {
                long l = (this.owner().flags() & 0x4000L) != 0L && ((TypeEnter)TypeEnter.this).types.supertype((Type)this.owner().type).tsym == ((TypeEnter)TypeEnter.this).syms.enumSym ? 0x1000000002L : this.owner().flags() & 7L | 0x1000000000L;
                this.constructorSymbol = new Symbol.MethodSymbol(l, ((TypeEnter)TypeEnter.this).names.init, this.constructorType(), this.owner());
            }
            return this.constructorSymbol;
        }

        @Override
        public Type enclosingType() {
            return Type.noType;
        }

        @Override
        public Symbol.TypeSymbol owner() {
            return this.owner;
        }

        @Override
        public List<Name> superArgs() {
            return List.nil();
        }
    }

    private final class MembersPhase
    extends AbstractMembersPhase {
        public MembersPhase() {
            super(Dependencies.CompletionCause.MEMBERS_PHASE, null);
        }

        @Override
        protected void runPhase(Env<AttrContext> env) {
            JCTree.JCClassDecl jCClassDecl = env.enclClass;
            Symbol.ClassSymbol classSymbol = jCClassDecl.sym;
            Type.ClassType classType = (Type.ClassType)classSymbol.type;
            JCTree jCTree = null;
            DefaultConstructorHelper defaultConstructorHelper = this.getDefaultConstructorHelper(env);
            if (defaultConstructorHelper != null) {
                TypeEnter.this.chk.checkDefaultConstructor(classSymbol, jCClassDecl.pos());
                jCTree = TypeEnter.this.defaultConstructor(TypeEnter.this.make.at(jCClassDecl.pos), defaultConstructorHelper);
                jCClassDecl.defs = jCClassDecl.defs.prepend(jCTree);
            }
            if (!classSymbol.isRecord()) {
                this.enterThisAndSuper(classSymbol, env);
            }
            if (!jCClassDecl.typarams.isEmpty()) {
                for (JCTree.JCTypeParameter jCTypeParameter : jCClassDecl.typarams) {
                    TypeEnter.this.chk.checkNonCyclic((JCDiagnostic.DiagnosticPosition)jCTypeParameter, (Type.TypeVar)jCTypeParameter.type);
                }
            }
            this.finishClass(jCClassDecl, jCTree, env);
            if (TypeEnter.this.allowTypeAnnos) {
                TypeEnter.this.typeAnnotations.organizeTypeAnnotationsSignatures(env, (JCTree.JCClassDecl)env.tree);
                TypeEnter.this.typeAnnotations.validateTypeAnnotationsSignatures(env, (JCTree.JCClassDecl)env.tree);
            }
        }

        DefaultConstructorHelper getDefaultConstructorHelper(Env<AttrContext> env) {
            JCTree jCTree;
            JCTree.JCClassDecl jCClassDecl = env.enclClass;
            Symbol.ClassSymbol classSymbol = jCClassDecl.sym;
            BasicConstructorHelper basicConstructorHelper = null;
            boolean bl = (classSymbol.flags() & 0x200L) == 0L && !TreeInfo.hasConstructors(jCClassDecl.defs);
            boolean bl2 = classSymbol.isRecord();
            if (bl && !bl2) {
                basicConstructorHelper = new BasicConstructorHelper(classSymbol);
                if (classSymbol.name.isEmpty()) {
                    jCTree = (JCTree.JCNewClass)env.next.tree;
                    if (((JCTree.JCNewClass)jCTree).constructor != null) {
                        basicConstructorHelper = ((JCTree.JCNewClass)jCTree).constructor.kind != Kinds.Kind.ERR ? new AnonClassConstructorHelper(classSymbol, (Symbol.MethodSymbol)((JCTree.JCNewClass)jCTree).constructor, ((JCTree.JCNewClass)jCTree).encl) : null;
                    }
                }
            }
            if (bl2) {
                jCTree = null;
                if (bl || (jCTree = this.getCanonicalConstructorDecl(env.enclClass)) == null) {
                    basicConstructorHelper = new RecordConstructorHelper(classSymbol, TreeInfo.recordFields(jCClassDecl));
                }
                if (jCTree != null) {
                    jCTree.sym.flags_field |= 0x2000000000000000L;
                }
            }
            return basicConstructorHelper;
        }

        void finishClass(JCTree.JCClassDecl jCClassDecl, JCTree jCTree, Env<AttrContext> env) {
            if ((jCClassDecl.mods.flags & 0x4000L) != 0L && !jCClassDecl.sym.type.hasTag(TypeTag.ERROR) && (((TypeEnter)TypeEnter.this).types.supertype((Type)jCClassDecl.sym.type).tsym.flags() & 0x4000L) == 0L) {
                this.addEnumMembers(jCClassDecl, env);
            }
            boolean bl = (jCClassDecl.sym.flags_field & 0x2000000000000000L) != 0L;
            List<JCTree> list = null;
            if (bl) {
                list = List.convert(JCTree.class, TreeInfo.recordFields(jCClassDecl));
                list = list.prependList(jCClassDecl.defs.stream().filter(jCTree2 -> TreeInfo.isConstructor(jCTree2) && jCTree2 != jCTree).collect(List.collector()));
            }
            List<JCTree> list2 = bl ? jCClassDecl.defs.diff(list) : jCClassDecl.defs;
            TypeEnter.this.memberEnter.memberEnter(list2, env);
            if (bl) {
                this.addRecordMembersIfNeeded(jCClassDecl, env);
            }
            if (jCClassDecl.sym.isAnnotationType()) {
                Assert.check(jCClassDecl.sym.isCompleted());
                jCClassDecl.sym.setAnnotationTypeMetadata(new Annotate.AnnotationTypeMetadata(jCClassDecl.sym, TypeEnter.this.annotate.annotationTypeSourceCompleter()));
            }
        }

        private void addAccessor(JCTree.JCVariableDecl jCVariableDecl, Env<AttrContext> env) {
            Symbol.MethodSymbol methodSymbol = TypeEnter.this.lookupMethod(env.enclClass.sym, jCVariableDecl.sym.name, List.nil());
            Symbol.RecordComponent recordComponent = ((Symbol.ClassSymbol)jCVariableDecl.sym.owner).getRecordComponent(jCVariableDecl.sym);
            if (methodSymbol == null || (methodSymbol.flags_field & 0x1000000L) != 0L) {
                TreeCopier treeCopier = new TreeCopier(TypeEnter.this.make.at(jCVariableDecl.pos));
                List<JCTree.JCAnnotation> list = recordComponent.getOriginalAnnos().isEmpty() ? recordComponent.getOriginalAnnos() : treeCopier.copy(recordComponent.getOriginalAnnos());
                JCTree.JCVariableDecl jCVariableDecl3 = TreeInfo.recordFields((JCTree.JCClassDecl)env.tree).stream().filter(jCVariableDecl2 -> jCVariableDecl2.name == jCVariableDecl.name).findAny().get();
                JCTree.JCMethodDecl jCMethodDecl = TypeEnter.this.make.at(jCVariableDecl.pos).MethodDef(TypeEnter.this.make.Modifiers(0x1000001L, list), jCVariableDecl.sym.name, treeCopier.copy(jCVariableDecl3.vartype), List.nil(), List.nil(), List.nil(), null, null);
                TypeEnter.this.memberEnter.memberEnter(jCMethodDecl, env);
                recordComponent.accessor = jCMethodDecl.sym;
                recordComponent.accessorMeth = jCMethodDecl;
            } else if (methodSymbol != null) {
                recordComponent.accessor = methodSymbol;
            }
        }

        private void addEnumMembers(JCTree.JCClassDecl jCClassDecl, Env<AttrContext> env) {
            JCTree.JCExpression jCExpression = TypeEnter.this.make.Type(new Type.ArrayType(jCClassDecl.sym.type, ((TypeEnter)TypeEnter.this).syms.arrayClass));
            JCTree.JCMethodDecl jCMethodDecl = TypeEnter.this.make.MethodDef(TypeEnter.this.make.Modifiers(9L), ((TypeEnter)TypeEnter.this).names.values, jCExpression, List.nil(), List.nil(), List.nil(), null, null);
            TypeEnter.this.memberEnter.memberEnter(jCMethodDecl, env);
            JCTree.JCMethodDecl jCMethodDecl2 = TypeEnter.this.make.MethodDef(TypeEnter.this.make.Modifiers(9L), ((TypeEnter)TypeEnter.this).names.valueOf, TypeEnter.this.make.Type(jCClassDecl.sym.type), List.nil(), List.of(TypeEnter.this.make.VarDef(TypeEnter.this.make.Modifiers(0x200008000L), TypeEnter.this.names.fromString("name"), TypeEnter.this.make.Type(((TypeEnter)TypeEnter.this).syms.stringType), null)), List.nil(), null, null);
            TypeEnter.this.memberEnter.memberEnter(jCMethodDecl2, env);
        }

        JCTree.JCMethodDecl getCanonicalConstructorDecl(JCTree.JCClassDecl jCClassDecl) {
            List<Type> list = TypeEnter.this.types.erasure(TreeInfo.recordFields(jCClassDecl).map(jCVariableDecl -> jCVariableDecl.sym.type));
            JCTree.JCMethodDecl jCMethodDecl = null;
            for (JCTree jCTree : jCClassDecl.defs) {
                if (!TreeInfo.isConstructor(jCTree)) continue;
                JCTree.JCMethodDecl jCMethodDecl2 = (JCTree.JCMethodDecl)jCTree;
                if (!TypeEnter.this.types.isSameTypes(TypeEnter.this.types.erasure(jCMethodDecl2.params.stream().map(jCVariableDecl -> jCVariableDecl.sym.type).collect(List.collector())), list)) continue;
                jCMethodDecl = jCMethodDecl2;
                break;
            }
            return jCMethodDecl;
        }

        private void addRecordMembersIfNeeded(JCTree.JCClassDecl jCClassDecl, Env<AttrContext> env) {
            Object object;
            if (TypeEnter.this.lookupMethod(jCClassDecl.sym, ((TypeEnter)TypeEnter.this).names.toString, List.nil()) == null) {
                object = TypeEnter.this.make.MethodDef(TypeEnter.this.make.Modifiers(0x2000000001000011L), ((TypeEnter)TypeEnter.this).names.toString, TypeEnter.this.make.Type(((TypeEnter)TypeEnter.this).syms.stringType), List.nil(), List.nil(), List.nil(), null, null);
                TypeEnter.this.memberEnter.memberEnter((JCTree)object, env);
            }
            if (TypeEnter.this.lookupMethod(jCClassDecl.sym, ((TypeEnter)TypeEnter.this).names.hashCode, List.nil()) == null) {
                object = TypeEnter.this.make.MethodDef(TypeEnter.this.make.Modifiers(0x2000000001000011L), ((TypeEnter)TypeEnter.this).names.hashCode, TypeEnter.this.make.Type(((TypeEnter)TypeEnter.this).syms.intType), List.nil(), List.nil(), List.nil(), null, null);
                TypeEnter.this.memberEnter.memberEnter((JCTree)object, env);
            }
            if (TypeEnter.this.lookupMethod(jCClassDecl.sym, ((TypeEnter)TypeEnter.this).names.equals, List.of(((TypeEnter)TypeEnter.this).syms.objectType)) == null) {
                object = TypeEnter.this.make.MethodDef(TypeEnter.this.make.Modifiers(0x2000000001000011L), ((TypeEnter)TypeEnter.this).names.equals, TypeEnter.this.make.Type(((TypeEnter)TypeEnter.this).syms.booleanType), List.nil(), List.of(TypeEnter.this.make.VarDef(TypeEnter.this.make.Modifiers(0x200000000L), TypeEnter.this.names.fromString("o"), TypeEnter.this.make.Type(((TypeEnter)TypeEnter.this).syms.objectType), null)), List.nil(), null, null);
                TypeEnter.this.memberEnter.memberEnter((JCTree)object, env);
            }
            object = TreeInfo.recordFields(jCClassDecl);
            Iterator iterator = ((List)object).iterator();
            while (iterator.hasNext()) {
                JCTree.JCVariableDecl jCVariableDecl2 = (JCTree.JCVariableDecl)iterator.next();
                jCVariableDecl2.mods.flags &= 0xFFFFFFFBFFFFFFFFL;
                jCVariableDecl2.sym.flags_field &= 0xFFFFFFFBFFFFFFFFL;
            }
            object.stream().filter(jCVariableDecl -> TypeEnter.this.lookupMethod(((TypeEnter)TypeEnter.this).syms.objectType.tsym, jCVariableDecl.name, List.nil()) == null).forEach(jCVariableDecl -> this.addAccessor((JCTree.JCVariableDecl)jCVariableDecl, env));
        }
    }

    private final class RecordPhase
    extends AbstractMembersPhase {
        public RecordPhase() {
            super(Dependencies.CompletionCause.RECORD_PHASE, new MembersPhase());
        }

        @Override
        protected void runPhase(Env<AttrContext> env) {
            JCTree.JCClassDecl jCClassDecl = env.enclClass;
            Symbol.ClassSymbol classSymbol = jCClassDecl.sym;
            if ((classSymbol.flags_field & 0x2000000000000000L) != 0L) {
                List<JCTree.JCVariableDecl> list = TreeInfo.recordFields(jCClassDecl);
                TypeEnter.this.memberEnter.memberEnter(list, env);
                for (JCTree.JCVariableDecl jCTree : list) {
                    classSymbol.getRecordComponent(jCTree, true, jCTree.mods.annotations.isEmpty() ? List.nil() : new TreeCopier(TypeEnter.this.make.at(jCTree.pos)).copy(jCTree.mods.annotations));
                }
                this.enterThisAndSuper(classSymbol, env);
                for (JCTree jCTree : jCClassDecl.defs) {
                    if (!TreeInfo.isConstructor(jCTree)) continue;
                    TypeEnter.this.memberEnter.memberEnter(jCTree, env);
                }
            }
        }
    }

    private abstract class AbstractMembersPhase
    extends Phase {
        private boolean completing;
        private List<Env<AttrContext>> todo;

        public AbstractMembersPhase(Dependencies.CompletionCause completionCause, Phase phase) {
            super(completionCause, phase);
            this.todo = List.nil();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doCompleteEnvs(List<Env<AttrContext>> list) {
            this.todo = this.todo.prependList(list);
            if (this.completing) {
                return;
            }
            boolean bl = this.completing;
            this.completing = true;
            try {
                while (this.todo.nonEmpty()) {
                    Env env = (Env)this.todo.head;
                    this.todo = this.todo.tail;
                    super.doCompleteEnvs(List.of(env));
                }
            }
            finally {
                this.completing = bl;
            }
        }

        void enterThisAndSuper(Symbol.ClassSymbol classSymbol, Env<AttrContext> env) {
            Type.ClassType classType = (Type.ClassType)classSymbol.type;
            Symbol.VarSymbol varSymbol = new Symbol.VarSymbol(262160L, ((TypeEnter)TypeEnter.this).names._this, classSymbol.type, classSymbol);
            varSymbol.pos = 0;
            ((AttrContext)env.info).scope.enter(varSymbol);
            if ((classSymbol.flags_field & 0x200L) == 0L && classType.supertype_field.hasTag(TypeTag.CLASS)) {
                Symbol.VarSymbol varSymbol2 = new Symbol.VarSymbol(262160L, ((TypeEnter)TypeEnter.this).names._super, classType.supertype_field, classSymbol);
                varSymbol2.pos = 0;
                ((AttrContext)env.info).scope.enter(varSymbol2);
            }
        }
    }

    private final class HeaderPhase
    extends AbstractHeaderPhase {
        public HeaderPhase() {
            super(Dependencies.CompletionCause.HEADER_PHASE, new RecordPhase());
        }

        @Override
        protected void runPhase(Env<AttrContext> env) {
            JCTree.JCClassDecl jCClassDecl = env.enclClass;
            Symbol.ClassSymbol classSymbol = jCClassDecl.sym;
            Type.ClassType classType = (Type.ClassType)classSymbol.type;
            Env<AttrContext> env2 = this.baseEnv(jCClassDecl, env);
            if (jCClassDecl.extending != null) {
                TypeEnter.this.annotate.queueScanTreeAndTypeAnnotate(jCClassDecl.extending, env2, classSymbol, jCClassDecl.pos());
            }
            for (JCTree.JCExpression iterator : jCClassDecl.implementing) {
                TypeEnter.this.annotate.queueScanTreeAndTypeAnnotate(iterator, env2, classSymbol, jCClassDecl.pos());
            }
            TypeEnter.this.annotate.flush();
            this.attribSuperTypes(env, env2);
            HashSet hashSet = new HashSet();
            for (JCTree.JCExpression jCExpression : jCClassDecl.implementing) {
                Type type = jCExpression.type;
                if (!type.hasTag(TypeTag.CLASS)) continue;
                TypeEnter.this.chk.checkNotRepeated(jCExpression.pos(), TypeEnter.this.types.erasure(type), hashSet);
            }
            TypeEnter.this.annotate.annotateLater(jCClassDecl.mods.annotations, env2, classSymbol, jCClassDecl.pos());
            TypeEnter.this.attr.attribTypeVariables(jCClassDecl.typarams, env2, false);
            for (JCTree.JCTypeParameter jCTypeParameter : jCClassDecl.typarams) {
                TypeEnter.this.annotate.queueScanTreeAndTypeAnnotate(jCTypeParameter, env2, classSymbol, jCClassDecl.pos());
            }
            if (classSymbol.owner.kind == Kinds.Kind.PCK && classSymbol.owner != env.toplevel.modle.unnamedPackage && TypeEnter.this.syms.packageExists(env.toplevel.modle, classSymbol.fullname)) {
                TypeEnter.this.log.error(jCClassDecl.pos, CompilerProperties.Errors.ClashWithPkgOfSameName(Kinds.kindName(classSymbol), classSymbol));
            }
            if (classSymbol.owner.kind == Kinds.Kind.PCK && (classSymbol.flags_field & 1L) == 0L && !env.toplevel.sourcefile.isNameCompatible(classSymbol.name.toString(), JavaFileObject.Kind.SOURCE)) {
                classSymbol.flags_field |= 0x100000000000L;
            }
        }
    }

    private final class PermitsPhase
    extends AbstractHeaderPhase {
        public PermitsPhase() {
            super(Dependencies.CompletionCause.HIERARCHY_PHASE, new HeaderPhase());
        }

        @Override
        protected void runPhase(Env<AttrContext> env) {
            JCTree.JCClassDecl jCClassDecl = env.enclClass;
            if (!jCClassDecl.sym.isAnonymous() || jCClassDecl.sym.isEnum()) {
                for (Type type : TypeEnter.this.types.directSupertypes(jCClassDecl.sym.type)) {
                    if (type.tsym.kind != Kinds.Kind.TYP) continue;
                    Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)type.tsym;
                    Env<AttrContext> env2 = TypeEnter.this.enter.getEnv(classSymbol);
                    if (!classSymbol.isSealed() || classSymbol.isPermittedExplicit || env2 == null || env2.toplevel != env.toplevel) continue;
                    classSymbol.permitted = classSymbol.permitted.append(jCClassDecl.sym);
                }
            }
        }
    }

    private final class HierarchyPhase
    extends AbstractHeaderPhase
    implements Symbol.Completer {
        public HierarchyPhase() {
            super(Dependencies.CompletionCause.HIERARCHY_PHASE, new PermitsPhase());
        }

        @Override
        protected void doCompleteEnvs(List<Env<AttrContext>> list) {
            for (Env<AttrContext> env : list) {
                env.enclClass.sym.completer = this;
            }
            for (Env<AttrContext> env : list) {
                env.enclClass.sym.complete();
            }
        }

        @Override
        protected void runPhase(Env<AttrContext> env) {
            JCTree.JCClassDecl jCClassDecl = env.enclClass;
            Symbol.ClassSymbol classSymbol = jCClassDecl.sym;
            Type.ClassType classType = (Type.ClassType)classSymbol.type;
            Env<AttrContext> env2 = this.baseEnv(jCClassDecl, env);
            this.attribSuperTypes(env, env2);
            if (classSymbol.fullname == ((TypeEnter)TypeEnter.this).names.java_lang_Object) {
                if (jCClassDecl.extending != null) {
                    TypeEnter.this.chk.checkNonCyclic(jCClassDecl.extending.pos(), classType.supertype_field);
                    classType.supertype_field = Type.noType;
                } else if (jCClassDecl.implementing.nonEmpty()) {
                    TypeEnter.this.chk.checkNonCyclic(((JCTree.JCExpression)jCClassDecl.implementing.head).pos(), (Type)classType.interfaces_field.head);
                    classType.interfaces_field = List.nil();
                }
            }
            TypeEnter.this.markDeprecated(classSymbol, jCClassDecl.mods.annotations, env2);
            TypeEnter.this.chk.checkNonCyclicDecl(jCClassDecl);
        }

        @Override
        protected JCTree.JCExpression clearTypeParams(JCTree.JCExpression jCExpression) {
            switch (jCExpression.getTag()) {
                case TYPEAPPLY: {
                    return ((JCTree.JCTypeApply)jCExpression).clazz;
                }
            }
            return jCExpression;
        }

        @Override
        public void complete(Symbol symbol) throws Symbol.CompletionFailure {
            Assert.check(TypeEnter.this.topLevelPhase instanceof ImportsPhase || TypeEnter.this.topLevelPhase == this);
            if (TypeEnter.this.topLevelPhase != this) {
                symbol.completer = this;
                return;
            }
            Env<AttrContext> env = TypeEnter.this.typeEnvs.get((Symbol.ClassSymbol)symbol);
            super.doCompleteEnvs(List.of(env));
        }
    }

    private abstract class AbstractHeaderPhase
    extends Phase {
        public AbstractHeaderPhase(Dependencies.CompletionCause completionCause, Phase phase) {
            super(completionCause, phase);
        }

        protected Env<AttrContext> baseEnv(JCTree.JCClassDecl jCClassDecl, Env<AttrContext> env) {
            Iterable iterable;
            Scope.WriteableScope writeableScope = Scope.WriteableScope.create(jCClassDecl.sym);
            for (Symbol object2 : ((AttrContext)env.outer.info).scope.getSymbols(Scope.LookupKind.NON_RECURSIVE)) {
                if (!object2.isDirectlyOrIndirectlyLocal()) continue;
                writeableScope.enter(object2);
            }
            if (jCClassDecl.typarams != null) {
                iterable = jCClassDecl.typarams;
                while (((List)iterable).nonEmpty()) {
                    writeableScope.enter(((JCTree.JCTypeParameter)((List)iterable).head).type.tsym);
                    iterable = ((List)iterable).tail;
                }
            }
            iterable = env.outer;
            Env<AttrContext> env2 = iterable.dup(jCClassDecl, ((AttrContext)iterable.info).dup(writeableScope));
            env2.baseClause = true;
            env2.outer = iterable;
            ((AttrContext)env2.info).isSelfCall = false;
            return env2;
        }

        protected JCTree.JCExpression enumBase(int n, Symbol.ClassSymbol classSymbol) {
            JCTree.JCTypeApply jCTypeApply = TypeEnter.this.make.at(n).TypeApply(TypeEnter.this.make.QualIdent(((TypeEnter)TypeEnter.this).syms.enumSym), List.of(TypeEnter.this.make.Type(classSymbol.type)));
            return jCTypeApply;
        }

        protected JCTree.JCExpression recordBase(int n, Symbol.ClassSymbol classSymbol) {
            JCTree.JCExpression jCExpression = TypeEnter.this.make.at(n).QualIdent(((TypeEnter)TypeEnter.this).syms.recordType.tsym);
            return jCExpression;
        }

        protected Type modelMissingTypes(final Env<AttrContext> env, Type type, final JCTree.JCExpression jCExpression, final boolean bl) {
            if (!type.hasTag(TypeTag.ERROR)) {
                return type;
            }
            return new Type.ErrorType(type.getOriginalType(), type.tsym){
                private Type modelType;

                @Override
                public Type getModelType() {
                    if (this.modelType == null) {
                        this.modelType = new Synthesizer(env.toplevel.modle, this.getOriginalType(), bl).visit(jCExpression);
                    }
                    return this.modelType;
                }
            };
        }

        protected void attribSuperTypes(Env<AttrContext> env, Env<AttrContext> env2) {
            Type type;
            JCTree.JCExpression jCExpression;
            JCTree.JCClassDecl jCClassDecl = env.enclClass;
            Symbol.ClassSymbol classSymbol = jCClassDecl.sym;
            Type.ClassType classType = (Type.ClassType)classSymbol.type;
            if (jCClassDecl.extending != null) {
                jCExpression = this.clearTypeParams(jCClassDecl.extending);
                type = TypeEnter.this.attr.attribBase(jCExpression, env2, true, false, true);
                if (type == ((TypeEnter)TypeEnter.this).syms.recordType) {
                    TypeEnter.this.log.error(jCClassDecl, CompilerProperties.Errors.InvalidSupertypeRecord(type.tsym));
                }
            } else {
                Type type2;
                jCExpression = null;
                if ((jCClassDecl.mods.flags & 0x4000L) != 0L) {
                    jCExpression = this.enumBase(jCClassDecl.pos, classSymbol);
                    type2 = TypeEnter.this.attr.attribBase(jCExpression, env2, true, false, false);
                } else if (classSymbol.fullname == ((TypeEnter)TypeEnter.this).names.java_lang_Object) {
                    type2 = Type.noType;
                } else if (classSymbol.isRecord()) {
                    if (TypeEnter.this.hasRecordRuntime) {
                        jCExpression = this.recordBase(jCClassDecl.pos, classSymbol);
                        type2 = TypeEnter.this.attr.attribBase(jCExpression, env2, true, false, false);
                    } else {
                        switch (0) {
                            default: 
                        }
                        TypeEnter.this.javaCompiler.recompileForVersion(env.toplevel.sourcefile, Target.JDK1_16);
                        type2 = ((TypeEnter)TypeEnter.this).syms.objectType;
                    }
                } else {
                    type2 = ((TypeEnter)TypeEnter.this).syms.objectType;
                }
                type = type2;
            }
            classType.supertype_field = this.modelMissingTypes(env2, type, jCExpression, false);
            ListBuffer<Object> listBuffer = new ListBuffer<Object>();
            ListBuffer<Object> listBuffer2 = null;
            List<JCTree.JCExpression> list = jCClassDecl.implementing;
            for (JCTree.JCExpression jCExpression2 : list) {
                JCTree.JCExpression object22 = this.clearTypeParams(jCExpression2);
                Type type3 = TypeEnter.this.attr.attribBase(object22, env2, false, true, true);
                if (type3.hasTag(TypeTag.CLASS)) {
                    listBuffer.append(type3);
                    if (listBuffer2 == null) continue;
                    listBuffer2.append(type3);
                    continue;
                }
                if (listBuffer2 == null) {
                    listBuffer2 = new ListBuffer<Object>().appendList(listBuffer);
                }
                listBuffer2.append(this.modelMissingTypes(env2, type3, object22, true));
            }
            ListBuffer listBuffer3 = new ListBuffer();
            List<JCTree.JCExpression> list2 = jCClassDecl.permitting;
            for (JCTree.JCExpression jCExpression3 : list2) {
                Type type4 = TypeEnter.this.attr.attribBase(jCExpression3, env2, false, false, false);
                listBuffer3.append(type4.tsym);
            }
            if ((classSymbol.flags_field & 0x2000L) != 0L) {
                classType.interfaces_field = List.of(((TypeEnter)TypeEnter.this).syms.annotationType);
                classType.all_interfaces_field = classType.interfaces_field;
            } else {
                classType.interfaces_field = listBuffer.toList();
                List<Type> list3 = classType.all_interfaces_field = listBuffer2 == null ? classType.interfaces_field : listBuffer2.toList();
            }
            if (!listBuffer3.isEmpty()) {
                classSymbol.permitted = listBuffer3.toList();
            }
            classSymbol.isPermittedExplicit = !listBuffer3.isEmpty();
        }

        protected JCTree.JCExpression clearTypeParams(JCTree.JCExpression jCExpression) {
            return jCExpression;
        }

        private class Synthesizer
        extends JCTree.Visitor {
            Symbol.ModuleSymbol msym;
            Type originalType;
            boolean interfaceExpected;
            List<Symbol.ClassSymbol> synthesizedSymbols = List.nil();
            Type result;

            Synthesizer(Symbol.ModuleSymbol moduleSymbol, Type type, boolean bl) {
                this.msym = moduleSymbol;
                this.originalType = type;
                this.interfaceExpected = bl;
            }

            Type visit(JCTree jCTree) {
                jCTree.accept(this);
                return this.result;
            }

            List<Type> visit(List<? extends JCTree> list) {
                ListBuffer<Type> listBuffer = new ListBuffer<Type>();
                for (JCTree jCTree : list) {
                    listBuffer.append(this.visit(jCTree));
                }
                return listBuffer.toList();
            }

            @Override
            public void visitTree(JCTree jCTree) {
                this.result = ((TypeEnter)TypeEnter.this).syms.errType;
            }

            @Override
            public void visitIdent(JCTree.JCIdent jCIdent) {
                this.result = !jCIdent.type.hasTag(TypeTag.ERROR) ? jCIdent.type : this.synthesizeClass((Name)jCIdent.name, (Symbol)this.msym.unnamedPackage).type;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void visitSelect(JCTree.JCFieldAccess jCFieldAccess) {
                if (!jCFieldAccess.type.hasTag(TypeTag.ERROR)) {
                    this.result = jCFieldAccess.type;
                } else {
                    Type type;
                    boolean bl = this.interfaceExpected;
                    try {
                        this.interfaceExpected = false;
                        type = this.visit(jCFieldAccess.selected);
                    }
                    finally {
                        this.interfaceExpected = bl;
                    }
                    Symbol.ClassSymbol classSymbol = this.synthesizeClass(jCFieldAccess.name, type.tsym);
                    this.result = classSymbol.type;
                }
            }

            @Override
            public void visitTypeApply(JCTree.JCTypeApply jCTypeApply) {
                if (!jCTypeApply.type.hasTag(TypeTag.ERROR)) {
                    this.result = jCTypeApply.type;
                } else {
                    Type.ClassType classType = (Type.ClassType)this.visit(jCTypeApply.clazz);
                    if (this.synthesizedSymbols.contains(classType.tsym)) {
                        this.synthesizeTyparams((Symbol.ClassSymbol)classType.tsym, jCTypeApply.arguments.size());
                    }
                    final List<Type> list = this.visit(jCTypeApply.arguments);
                    this.result = new Type.ErrorType(jCTypeApply.type, classType.tsym){

                        @Override
                        public List<Type> getTypeArguments() {
                            return list;
                        }
                    };
                }
            }

            Symbol.ClassSymbol synthesizeClass(Name name, Symbol symbol) {
                int n = this.interfaceExpected ? 512 : 0;
                Symbol.ClassSymbol classSymbol = new Symbol.ClassSymbol(n, name, symbol);
                classSymbol.members_field = new Scope.ErrorScope(classSymbol);
                classSymbol.type = new Type.ErrorType(this.originalType, (Symbol.TypeSymbol)classSymbol){

                    @Override
                    public List<Type> getTypeArguments() {
                        return this.typarams_field;
                    }
                };
                this.synthesizedSymbols = this.synthesizedSymbols.prepend(classSymbol);
                return classSymbol;
            }

            void synthesizeTyparams(Symbol.ClassSymbol classSymbol, int n) {
                Type.ClassType classType = (Type.ClassType)classSymbol.type;
                Assert.check(classType.typarams_field.isEmpty());
                if (n == 1) {
                    Type.TypeVar typeVar = new Type.TypeVar(TypeEnter.this.names.fromString("T"), classSymbol, ((TypeEnter)TypeEnter.this).syms.botType);
                    classType.typarams_field = classType.typarams_field.prepend(typeVar);
                } else {
                    for (int i = n; i > 0; --i) {
                        Type.TypeVar typeVar = new Type.TypeVar(TypeEnter.this.names.fromString("T" + i), classSymbol, ((TypeEnter)TypeEnter.this).syms.botType);
                        classType.typarams_field = classType.typarams_field.prepend(typeVar);
                    }
                }
            }
        }
    }
}

