/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class FSInfo {
    private FileSystemProvider jarFSProvider;

    public static FSInfo instance(Context context) {
        FSInfo fSInfo = context.get(FSInfo.class);
        if (fSInfo == null) {
            fSInfo = new FSInfo();
        }
        return fSInfo;
    }

    protected FSInfo() {
    }

    protected FSInfo(Context context) {
        context.put(FSInfo.class, this);
    }

    public Path getCanonicalFile(Path path) {
        try {
            return path.toRealPath(new LinkOption[0]);
        }
        catch (IOException iOException) {
            return path.toAbsolutePath().normalize();
        }
    }

    public boolean exists(Path path) {
        return Files.exists(path, new LinkOption[0]);
    }

    public boolean isDirectory(Path path) {
        return Files.isDirectory(path, new LinkOption[0]);
    }

    public boolean isFile(Path path) {
        return Files.isRegularFile(path, new LinkOption[0]);
    }

    public List<Path> getJarClassPath(Path path) throws IOException {
        try (JarFile jarFile = new JarFile(path.toFile());){
            Manifest manifest = jarFile.getManifest();
            if (manifest == null) {
                List<Path> list = Collections.emptyList();
                return list;
            }
            Attributes attributes = manifest.getMainAttributes();
            if (attributes == null) {
                List<Path> list = Collections.emptyList();
                return list;
            }
            String string = attributes.getValue(Attributes.Name.CLASS_PATH);
            if (string == null) {
                List<Path> list = Collections.emptyList();
                return list;
            }
            ArrayList<Path> arrayList = new ArrayList<Path>();
            URL uRL = path.toUri().toURL();
            Object object = new StringTokenizer(string);
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string2 = ((StringTokenizer)object).nextToken();
                try {
                    URL uRL2 = FSInfo.tryResolveFile(uRL, string2);
                    if (uRL2 == null) continue;
                    arrayList.add(FSInfo.of(uRL2.toURI()));
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
            object = arrayList;
            return object;
        }
    }

    public static Path of(URI uRI) {
        String string = uRI.getScheme();
        if (string == null) {
            throw new IllegalArgumentException("Missing scheme");
        }
        if (string.equalsIgnoreCase("file")) {
            return FileSystems.getDefault().provider().getPath(uRI);
        }
        for (FileSystemProvider fileSystemProvider : FileSystemProvider.installedProviders()) {
            if (!fileSystemProvider.getScheme().equalsIgnoreCase(string)) continue;
            return fileSystemProvider.getPath(uRI);
        }
        throw new FileSystemNotFoundException("Provider \"" + string + "\" not installed");
    }

    public static Path of(String string, String ... stringArray) {
        return FileSystems.getDefault().getPath(string, stringArray);
    }

    static URL tryResolveFile(URL uRL, String string) throws MalformedURLException {
        URL uRL2 = new URL(uRL, string);
        if (string.indexOf(58) >= 0 && !"file".equalsIgnoreCase(uRL2.getProtocol())) {
            return null;
        }
        return uRL2;
    }

    public synchronized FileSystemProvider getJarFSProvider() {
        if (this.jarFSProvider != null) {
            return this.jarFSProvider;
        }
        for (FileSystemProvider fileSystemProvider : FileSystemProvider.installedProviders()) {
            if (!fileSystemProvider.getScheme().equals("jar")) continue;
            this.jarFSProvider = fileSystemProvider;
            return this.jarFSProvider;
        }
        return null;
    }
}

