/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import java.nio.file.FileSystem;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.JavaFileObject;

public abstract class RelativePath
implements Comparable<RelativePath> {
    protected final String path;

    protected RelativePath(String string) {
        this.path = string;
    }

    public abstract RelativeDirectory dirname();

    public abstract String basename();

    public Path resolveAgainst(Path path) throws InvalidPathException {
        String string = path.getFileSystem().getSeparator();
        return path.resolve(this.path.replace("/", string));
    }

    public Path resolveAgainst(FileSystem fileSystem) throws InvalidPathException {
        String string = fileSystem.getSeparator();
        Path path = fileSystem.getRootDirectories().iterator().next();
        return path.resolve(this.path.replace("/", string));
    }

    @Override
    public int compareTo(RelativePath relativePath) {
        return this.path.compareTo(relativePath.path);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof RelativePath)) return false;
        RelativePath relativePath = (RelativePath)object;
        if (!this.path.equals(relativePath.path)) return false;
        return true;
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return "RelPath[" + this.path + "]";
    }

    public String getPath() {
        return this.path;
    }

    public static class RelativeFile
    extends RelativePath {
        static RelativeFile forClass(CharSequence charSequence, JavaFileObject.Kind kind) {
            return new RelativeFile(charSequence.toString().replace('.', '/') + kind.extension);
        }

        public RelativeFile(String string) {
            super(string);
            if (string.endsWith("/")) {
                throw new IllegalArgumentException(string);
            }
        }

        public RelativeFile(RelativeDirectory relativeDirectory, String string) {
            this(relativeDirectory.path + string);
        }

        RelativeFile(RelativeDirectory relativeDirectory, RelativePath relativePath) {
            this(relativeDirectory, relativePath.path);
        }

        @Override
        public RelativeDirectory dirname() {
            int n = this.path.lastIndexOf(47);
            return new RelativeDirectory(this.path.substring(0, n + 1));
        }

        @Override
        public String basename() {
            int n = this.path.lastIndexOf(47);
            return this.path.substring(n + 1);
        }

        ZipEntry getZipEntry(ZipFile zipFile) {
            return zipFile.getEntry(this.path);
        }

        @Override
        public String toString() {
            return "RelativeFile[" + this.path + "]";
        }
    }

    public static class RelativeDirectory
    extends RelativePath {
        static RelativeDirectory forPackage(CharSequence charSequence) {
            return new RelativeDirectory(charSequence.toString().replace('.', '/'));
        }

        public RelativeDirectory(String string) {
            super(string.length() == 0 || string.endsWith("/") ? string : string + "/");
        }

        public RelativeDirectory(RelativeDirectory relativeDirectory, String string) {
            this(relativeDirectory.path + string);
        }

        @Override
        public RelativeDirectory dirname() {
            int n = this.path.length();
            if (n == 0) {
                return this;
            }
            int n2 = this.path.lastIndexOf(47, n - 2);
            return new RelativeDirectory(this.path.substring(0, n2 + 1));
        }

        @Override
        public String basename() {
            int n = this.path.length();
            if (n == 0) {
                return this.path;
            }
            int n2 = this.path.lastIndexOf(47, n - 2);
            return this.path.substring(n2 + 1, n - 1);
        }

        boolean contains(RelativePath relativePath) {
            return relativePath.path.length() > this.path.length() && relativePath.path.startsWith(this.path);
        }

        @Override
        public String toString() {
            return "RelativeDirectory[" + this.path + "]";
        }
    }
}

